/*
 * -- TRANSFO.H
 */

#ifndef TRANSFO_H
#define TRANSFO_H

#include "types.h"

/* -- ROTATE_COURBE
 */
extern void rotate_courbe(float anglex, float angley, float anglez,
                          Coords* courbe, int max);
/*
 * opere une rotation sur les coordonnees de la courbe.
 * le triaxe est le meme que dans pov :
 *          y^  z
 *           | /      le sens positif est indique par la main
 *           |/       gauche avec le pouce dans le sens de l'axe
 *           /--->x
 *
 *          ____\ angley > 0
 *         /    / 
 *         | y.
 */

/* -- ROTATE_NAPPE
 */
extern void rotate_nappe(float anglex, float angley, float anglez,
                         Paire* nappe, int max);
/*
 * opere une rotation sur les coordonnees de la nappe.
 * le triaxe est le meme que dans pov :
 *          y^  z
 *           | /      le sens positif est indique par la main
 *           |/       gauche avec le pouce dans le sens de l'axe
 *           /--->x
 *
 *          ____\ angley > 0
 *         /    / 
 *         | y.
 */

#endif
