
static define pine_map color_map (
   [0.000, 0.177, <1.000, 0.718, 0.416>, <1.000, 0.616, 0.332>]
   [0.177, 0.301, <1.000, 0.616, 0.332>, <1.000, 0.718, 0.416>]
   [0.301, 0.354, <1.000, 0.718, 0.416>, <1.000, 0.564, 0.280>]
   [0.354, 0.451, <1.000, 0.564, 0.280>, <0.850, 0.354, 0.132>]
   [0.451, 0.558, <0.860, 0.364, 0.142>, <0.960, 0.520, 0.272>]
   [0.558, 0.646, <0.960, 0.520, 0.272>, <0.780, 0.252, 0.154>]
   [0.646, 0.743, <0.780, 0.252, 0.154>, <0.840, 0.344, 0.152>]
   [0.743, 0.858, <0.840, 0.344, 0.152>, <1.000, 0.626, 0.332>]
   [0.858, 0.982, <1.000, 0.626, 0.332>, <1.000, 0.718, 0.416>]
   [0.982, 1.000, <1.000, 0.718, 0.416>, <1.000, 0.718, 0.416>])

static define noisy_wood_fn1
   sawtooth(|<x+0.6*dnoise(P,3)[0], y+0.6*dnoise(P,3)[1], 0>|)

static define pine
texture {
    special shiny {
       color pine_map[noisy_wood_fn1]
       diffuse 0.6
       specular white, 0.27
       microfacet Cook  9 }
   scale <0.5, 0.5, 0.5>
   }

define dirt_map
color_map (
   [0.0, 0.2, <0.55, 0.16, 0.16>, 0.3, <0.55, 0.16, 0.16>, 0.4]
   [0.2, 0.4, <0.25, 0.16, 0.16>, 0.4, <0.22, 0.08, 0.08>, 0.7]
   [0.4, 0.5, <0.32, 0.08, 0.08>, 0.7, <0.10, 0.05, 0.05>, 0.8]
   [0.5, 0.6, <0.10, 0.05, 0.05>, 0.8, <0.25, 0.25, 0.25>, 0.7]
   [0.6, 0.8, <0.25, 0.25, 0.25>, 0.7, <0.50, 0.40, 0.40>, 0.3]
   [0.7, 1.0, <0.45, 0.35, 0.35>, 0.3, <0.50, 0.40, 0.40>, 0.2])

define dirt
texture {
	special matte {
		color dirt_map[noise(3*P, 4)]
		}
	}

define wall_tex
texture {
	special matte {
		color <0.6, 0.6, 0.6>
		normal N + dnoise(6*P) - <0.5, 0.5, 0.5>
		}
	}

object {
   polygon 4, <10, 0, 25>, <10, 27, 25>,
   			  <-24.6, 27, 5>, <-24.6, 0, 5>
	texture {
		layered dirt, wall_tex }
   }
object {
   polygon 4, <10, 0, 25>, <10, 27, 25>,
   			  <33, 27, -15>, <33, 0, -15>
   texture {
   	layered dirt, wall_tex }
   }
object {
   polygon 4, <-24.6, 27, 5>, <-24.6, 0, 5>,
   			  <-1.6, 0, -35>, <-1.6, 27, -35>
	texture {
		layered dirt, wall_tex }
   }
object {
   polygon 4, <33, 27, -15>, <33, 0, -15>,
   			  <-1.6, 0, -35>, <-1.6, 27, -35>
	texture {
		layered dirt, wall_tex }
   }

object {
	box <-5, 0, 0>, <5, 18, 1>
	texture {
		layered dirt, pine
		}
	rotate <0, 60, 0>
	translate <-13, 0, -19.5>
	}

object {
	box <-25, 26, -35>, <33, 27, 25>
	matte_brown
	}

object {
	  object {
      box <0, -1, -25>, <1.9, 0, 30> }
	+ object {
		box <1.9, -1, -25>, <2, 0, 30>
		matte_black }
	+ object {
		box <2, -1, -25>, <3.9, 0, 30> }
	+ object {
		box <3.9, -1, -25>, <4, 0, 30>
		matte_black }
	+ object {
		box <4, -1, -25>, <5.9, 0, 30> }
	+ object {
		box <5.9, -1, -25>, <6, 0, 30>
		matte_black }
	+ object {
		box <6, -1, -25>, <7.9, 0, 30> }
	+ object {
		box <7.9, -1, -25>, <8, 0, 30>
		matte_black }
	+ object {
		box <8, -1, -25>, <9.9, 0, 30> }
	+ object {
		box <9.9, -1, -25>, <10, 0, 30>
		matte_black }
	+ object {
		box <10, -1, -25>, <11.9, 0, 30> }
	+ object {
		box <11.9, -1, -25>, <12, 0, 30>
		matte_black }
	+ object {
		box <12, -1, -25>, <13.9, 0, 30> }
	+ object {
		box <13.9, -1, -25>, <14, 0, 30>
		matte_black }
	+ object {
		box <14, -1, -25>, <15.9, 0, 30> }
	+ object {
		box <15.9, -1, -25>, <16, 0, 30>
		matte_black }
	+ object {
		box <-2, -1, -25>, <-0.1, 0, 30> }
	+ object {
		box <0, -1, -25>, <-0.1, 0, 30>
		matte_black }
	+ object {
		box <-4, -1, -25>, <-2.1, 0, 30> }
	+ object {
		box <-2, -1, -25>, <-2.1, 0, 30>
		matte_black }
	+ object {
		box <-6, -1, -25>, <-4.1, 0, 30> }
	+ object {
		box <-8, -1, -25>, <-6.1, 0, 30> }
	+ object {
		box <-10, -1, -25>, <-8.1, 0, 30> }
	+ object {
		box <-12, -1, -25>, <-10.1, 0, 30> }
	texture {
		layered dirt, pine }
	scale white * 1.5
	rotate <0, -30, 0>
	}

