
// Persistence of Vision Ray Tracer Scene Description File
// Auth: Daniel A.K. Halsey
// Mail: estragon@cc.gatech.edu
// Date: 21 Nov 1997
// ------
// Vers: 3.01
// File: POV-RC5_logo.pov
// Desc: ************


#include "colors.inc"
#include "textures.inc"
#include "METALS.INC"

//ANIMATION Settings::+F +KFI1 +KFF48 +KI0 +KF4 +KC +SF1 +EF48

#declare clocka = ( clock - 0.5 )

#switch ( clocka )

	#range ( -0.5, 0 )
	#declare MyClock = 0
	#break

	#range ( 0, 1 )
	#declare MyClock = clocka
	#break

	#range ( 1, 2 )
	#declare MyClock = 1
	#break

	#range ( 2, 3 )
	#declare MyClock = -clocka + 3
	#break

	#range ( 3, 3.5 )
	#declare MyClock = 0
	#break

	#else
	#declare MyClock = 0

#end


#default {
	pigment { Green }
}


camera
{
	location < 0.0, 0.0, -10.0 >
	look_at < 0.0, 0.0, 0.0 >
}

light_source
{
	0*x
	color rgb 1
	translate < 40, 80, -80 >
}

#declare PR =
union {

cylinder {
	< -1, -2, 0 >,
	< -1, 2, 0 >,
	0.5
}

sphere {
	< -1, -2, 0 >
	0.5
}

sphere {
	< -1, 2, 0 >
	0.5
}

cylinder {
	< -1, 2, 0 >,
	< 0, 2, 0 >,
	0.5
}

cylinder {
	< -1, 0, 0 >,
	< 0, 0, 0 >,
	0.5
}

torus {
	1,
	0.5
	rotate 90*x
	clipped_by {
		box {
			< 0, 1.51, -1>
			< 2, -1.51,  1>
		}
	}
	translate	< 0, 1, 0 >

}

cylinder {
	< 0.01, 0.01, 0.01 >,
	( < 1, -2, 0 > * < sin(MyClock*pi/2), sin(MyClock*pi/2), 0 > ),
	0.5
}

sphere {
	( < 1, -2, 0 > * < sin(MyClock*pi/2), sin(MyClock*pi/2), 0 > ),
	0.5
}

}

#declare OC =
union {

cylinder {
	< -1, -1, 0 >,
	< -1, 1, 0 >,
	0.5
}

torus {
	1,
	0.5
	rotate 90*x
	clipped_by {
		box {
			< -2, 1.5, -1>
			< 2, 0,  1>
		}
	}
	translate	< 0, 1, 0 >
}

torus {
	1,
	0.5
	rotate 90*x
	clipped_by {
		box {
			< -2, 0, -1>
			< 2, -1.5,  1>
		}
	}
	translate	< 0, -1, 0 >
}

cylinder {
	< 1, 1.01, 0 >,
	< 1, sin(MyClock*pi/2), 0 >,
	0.5
}

sphere {
	< 1, sin(MyClock*pi/2), 0 >,
	0.5
}

cylinder {
	< 1, -1.01, 0 >,
	< 1, -sin(MyClock*pi/2), 0 >
	0.5
}

sphere {
	< 1, -sin(MyClock*pi/2), 0 >,
	0.5
}

}

#declare V5 =
union {

cylinder {
	< 0, -2, 0 >,
	< -1, 2, 0 >,
	0.5
}
/*
sphere {
	< -1, 2, 0 >
	0.5
}
*/
cylinder {
	< 0, -2, 0 >,
	< 1, 2, 0 >,
	0.5
}
/*
sphere {
	< 1, 2, 0 >
	0.5
}

sphere {
	< 0, -2, 0 >
	0.5
}
*/
cylinder {
	< 1.01 + MyClock*0.65, 2, 0 >,
	< 1 - MyClock, 2, 0 >,
	0.5
}

sphere {
	< 1 + MyClock*0.65, 2, 0 >,
	0.5
}
sphere {
	< 1 - MyClock, 2, 0 >,
	0.5
}

cylinder {
	< -(1.01 + MyClock*0.65), 2, 0 >,
	< -(1 - MyClock), 2, 0 >,
	0.5
}

sphere {
	< -(1 + MyClock*0.65), 2, 0 >,
	0.5
}
sphere {
	< -(1 - MyClock), 2, 0 >,
	0.5
}

cylinder {
	< 2*(0.01 + MyClock*0.65), -2, 0 >,
	< 2*(-0.01 - MyClock*0.65), -2, 0 >,
	0.5
}

sphere {
	< 2*(0 + MyClock*0.65), -2, 0 >,
	0.5
}
sphere {
	< 2*(-0 - MyClock*0.65), -2, 0 >,
	0.5
}

}

object {
	PR
	translate -3.75*x
	texture {
		pigment {
			color < 1.25, 0, 0 >
		}
		finish {
			F_MetalC
		}
	}
}

object {
	OC
	texture {
		pigment {
			color < 0, 1, 0 >
		}
		finish {
			F_MetalC
		}
	}
}

object {
	V5
	translate 3.75*x
	texture {
		pigment {
			color < 0.25, 0.25, 1.25 >
		}
		finish {
			F_MetalC
		}
	}
}

cylinder {
	< 0, -200, 0 >,
	< 0, 200, 0 >,
	100
	texture {
	pigment {
		Blue_Sky2
		scale 600
	}
	}
	rotate y*((360*clock)/4)
	translate -200*z
}
