#include "colors.inc"

camera
{
  location  <0.0 , 1.0 ,-4.0>
  translate <b4camera_tx, b4camera_ty, b4camera_tz>
  rotate <0,camera_rotation,0>
  translate <aftercamera_tx, aftercamera_ty, aftercamera_tz>
  look_at   <0.0001 , 0.0001 , -0.1>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  shadowless
   translate <-5, 5, 5>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  shadowless
   translate <-5, 5, -5>
}
                                                                                    //Head
sphere { <0,0,0>, 1
       pigment{
      color Green}
      }
sphere { <0,0,0>, 0.6
       pigment{
      color Black}
      }
      

//Eyes(Whites)
//Left
sphere { <0,eye_height,0>, 0.35
      pigment {color White;}
      rotate < 0,0,25>
      }
//Right
sphere { <0,eye_height,0>, 0.35
      pigment {color White;}
      rotate < 0,0,-25>
      }
//Left(Black)
sphere { <0,0,-0.35>, 0.1
      pigment {color Black;}
      translate <0,eye_height,0>
      rotate < 0,0,25>
      translate <eye_endx,eye_endy,0>

      }
//Right(Black)
sphere { <0,0,-0.35>, 0.1
      pigment {color Black;}
      translate < 0,eye_height,0>
      rotate < 0,0,-25>
      translate <eye_endx,eye_endy,0>
      }

//Eyelids (eye_rotation=0=open
//Left
difference {
sphere { <0,0,0>, 0.46
      pigment {color Green;}
      }
box {<-1.46,-1,-1>, <1.46,-0.05,1>
      rotate <eye_rotation,0,0>}
      translate <0,eye_height,0>
      rotate < 0,0,25>
      translate <0,0,-.05>
}
//right
difference {
sphere { <0,0,0>, 0.46
      pigment {color Green;}
      }
box {<-1.46,-1,-1>, <1.46,-0.05,1>
      rotate <eye_rotation,0,0>}
      translate <0,eye_height,0>
      rotate < 0,0,-25>
      translate <0,0,-.05>
}// Difference

// Mouth
difference {
torus
{
  MouthAppear, 0.05
      pigment {color Black;}
}
box {<-2,-2,0>,<2,2,2>}
}// difference

// Hind Legs are the tail
cone {<0,0,0>, hip_thickness <0,thigh_length,0>, knee_thickness
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx, hip_ty, hip_tz>  // Upper Leg Translations
     pigment {color Green;}
}

sphere {<0,0,0>,hip_thickness
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}

cone {<0,0,0>, knee_thickness <0,shin_length,0>, knee_thickness
     rotate <knee_rx,knee_ry,knee_rz>            // knee rotations
     translate <knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}

sphere {<0,0,0>, knee_thickness
     rotate <knee_rx,knee_ry,knee_rz>            // knee rotations
     translate <knee_tx,knee_ty,knee_tz>         // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}
/////////////////////////////////////////////////FOOT
cone {<0,0,0>, knee_thickness <0,foot_length,0>, knee_thickness
     rotate <foot_rx,-foot_ry,foot_rz>            // knee rotations
     translate <foot_tx,foot_ty,foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,knee_ry,knee_rz>            // knee rotations
     translate <knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}

}

sphere {<0,0,0>, knee_thickness
     translate <foot_tx,foot_ty,foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,knee_ry,knee_rz>            // knee rotations
     translate <knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}

}


sphere {<0,foot_length,0>, knee_thickness
     rotate <foot_rx,-foot_ry,foot_rz>            // knee rotations
     translate <foot_tx,foot_ty,foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,knee_ry,knee_rz>            // knee rotations
     translate <knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,hip_ry,hip_rz>                 // Hip Rotations
     translate <hip_tx,hip_ty,hip_tz>
     pigment {color Green;}

}

//////////////////////////////////////////////////FRONT LEGS

cylinder {<0,0,0>, <0,fleg_length,0>, knee_thickness
     rotate <fleg_rx,fleg_ry,fleg_rz>
     translate <fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}

sphere {<0,0,0>, knee_thickness
     translate <fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}
sphere {<0,fleg_length,0>, knee_thickness
     rotate <fleg_rx,fleg_ry,fleg_rz>
     translate <fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}




///////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////Other Side//////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

cone {<0,0,0>, hip_thickness <0,thigh_length,0>, knee_thickness
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx, hip_ty, hip_tz>  // Upper Leg Translations
     pigment {color Green;}
}
sphere {<0,0,0>,hip_thickness
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}

cone {<0,0,0>, knee_thickness <0,shin_length,0>, knee_thickness
     rotate <knee_rx,-knee_ry,-knee_rz>            // knee rotations
     translate <-knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}

sphere {<0,0,0>, knee_thickness
     rotate <knee_rx,-knee_ry,-knee_rz>            // knee rotations
     translate <-knee_tx,knee_ty,knee_tz>         // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}
/////////////////////////////////////////////////FOOT
cone {<0,0,0>, knee_thickness <0,foot_length,0>, knee_thickness
     rotate <foot_rx,foot_ry,-foot_rz>            // knee rotations
     translate <-foot_tx,foot_ty,foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,-knee_ry,-knee_rz>            // knee rotations
     translate <-knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}

}

sphere {<0,0,0>, knee_thickness
     translate <-foot_tx,foot_ty,-foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,-knee_ry,-knee_rz>            // knee rotations
     translate <-knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}

}


sphere {<0,foot_length,0>, knee_thickness
     rotate <foot_rx,foot_ry,-foot_rz>            // knee rotations
     translate <-foot_tx,foot_ty,foot_tz>      // Translate to joint
//ATTACH TO KNEE
     rotate <knee_rx,-knee_ry,-knee_rz>            // knee rotations
     translate <-knee_tx,knee_ty,knee_tz>      // Translate to joint
// ATTACH TO UPPER LEG
     rotate <hip_rx,-hip_ry,-hip_rz>                 // Hip Rotations
     translate <-hip_tx,hip_ty,hip_tz>
     pigment {color Green;}
}

//////////////////////////////////////////////////FRONT LEGS

cylinder {<0,0,0>, <0,fleg_length,0>, knee_thickness
     rotate <fleg_rx,-fleg_ry,-fleg_rz>
     translate <-fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}

sphere {<0,0,0>, knee_thickness
     translate <-fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}
sphere {<0,fleg_length,0>, knee_thickness
     rotate <fleg_rx,-fleg_ry,-fleg_rz>
     translate <-fleg_tx,fleg_ty,fleg_tz>
     pigment {color Green;}
}

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////Pond On///////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////

#if (PondOn != 0)

// Lilly Pad
cylinder {<0,-1.2,0>, <0,-1,0> , 2.5
    translate <0,0,0.5>
    pigment {color DarkGreen;}
}
torus { 2.5, 0.2
    translate <0,-1.15,0.5>
    pigment {color DarkGreen;}
}

// pond ; I had problems with the ripples being seen in the back ground so I used a cylinder for the plane instead
cylinder { <0,-1.3,0>, <0,-1.2,0>, 13
     pigment {color Blue;}
      normal { ripples 0.5}
     finish { reflection 1.0 ambient 0 diffuse 0.4 }
}

///////////////////////////////
/////marshweeds decalred///////
///////////////////////////////
union // Marsh #1
{
cylinder { <0,0,0>, <0,1.6,0>, 0.1
         pigment {color Green}
         }
cylinder { <0,1.6,0>, <0,2.3,0>, 0.15
         pigment {color DarkGreen}
         }
sphere {<0,2.3,0>, 0.15
         pigment {color DarkGreen}
}
sphere {<0,1.6,0>, 0.15
         pigment {color DarkGreen}
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,180> // This is the line that flips the left and right leaf
         rotate <-90,0,0>
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,0> // This is the line!
         rotate <-90,0,0>
}

rotate <0,0,0>
translate <-5,0,6>

}// Marsh #1

union // Marsh #2
{
cylinder { <0,-1,0>, <0,1.6,0>, 0.1
         pigment {color Green}
         }
cylinder { <0,1.6,0>, <0,2.3,0>, 0.15
         pigment {color DarkGreen}
         }
sphere {<0,2.3,0>, 0.15
         pigment {color DarkGreen}
}
sphere {<0,1.6,0>, 0.15
         pigment {color DarkGreen}
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,180> // This is the line that flips the left and right leaf
         rotate <-90,0,0>
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,0> // This is the line!
         rotate <-90,0,0>
}

rotate <0,20,0>
translate <2,1,-3>

}// Marsh #2
union // Marsh #3
{
cylinder { <0,-1,0>, <0,1.6,0>, 0.1
         pigment {color Green}
         }
cylinder { <0,1.6,0>, <0,2.3,0>, 0.15
         pigment {color DarkGreen}
         }
sphere {<0,2.3,0>, 0.15
         pigment {color DarkGreen}
}
sphere {<0,1.6,0>, 0.15
         pigment {color DarkGreen}
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,180> // This is the line that flips the left and right leaf
         rotate <-90,0,0>
}
intersection {
torus { 2.3, 0.08}
box {<0.3,-2,0>, <10,10,10>}

         pigment {color Green }
         translate <-2.3,0,0>
         rotate <0,0,0> // This is the line!
         rotate <-90,0,0>
}

rotate <0,0,0>
translate <3,0,4>

}// Marsh #3

// TONGUE!!!
cylinder { <-0.1,0,-0.9>, <tongue_x, tongue_y, tongue_z>, 0.1
         pigment {color Red}
         }
sphere { <tongue_x, tongue_y, tongue_z>, 0.1
         pigment {color Red}
         }

#else
// No pond during metamorphasis
#end









