
//  File: JFMETA.pov
// Title: Definition
//  Desc: An animation that morphs the definition of the word METAMORPHOSIS into the word
//  Date: 01/05/97
//  Auth: Jim Figiel
//
//
//Metamorphosis
//Change of form, shape, structure, or substance
//A marked or complete change in
//Character, Appearance, or Condition.

#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

//////////////////////////////////////////////////////////////////////
// Animation variable definition 
//////////////////////////////////////////////////////////////////////

// defscale      - scaling factor for the definition text
// defheight     - height location of the definition text
// defrot        - rotation of the definition text
// sphereheight  - height location of sphere
// spherescale   - scaling factor for the sphere
// metheight     - height location of the metamorphosis text
// metscale      - scaling factor for the sphere
// tc            - pigment for all objects
// CameraHeight  - height location of the camera

//////////////////////////////////////////////////////////////////////
// Animation timing control
//////////////////////////////////////////////////////////////////////

#switch (clock)
   #range (0,4.999)
      #declare defscale = 1
      #declare defheight = 0
      #declare defrot = 0
      #declare sphereheight = -200
      #declare spherescale = 0.1
      #declare metheight = -200
      #declare metscale = 0.1
      #declare tc = pigment { color Green }
      #declare CameraHeight = 5
   #break
   #range (5,9.999)
      #declare defscale = 1
      #declare defheight = 0
      #declare defrot = 0
      #declare sphereheight = -200
      #declare spherescale = 0.1
      #declare metheight = -200
      #declare metscale = 0.1
      #declare tc = pigment { color Green }
      #declare CameraHeight = 5+(5-clock)
   #break
   #range (10,14.999)
      #declare defscale = 1
      #declare defheight = 0
      #declare defrot = 0
      #declare sphereheight = -200
      #declare spherescale = 0.1
      #declare metheight = -200
      #declare metscale = 0.1
      #declare tc = pigment { color Green }
      #declare CameraHeight = 0
   #break
   #range (15,19.999)
      #declare defscale = 1-((clock-15)/5)
      #declare defheight = 0
      #declare defrot = 72*clock
      #declare sphereheight = 0.5
      #declare spherescale = (clock-15)/3
      #declare metheight = -200
      #declare metscale = 0.1
      #declare tc = pigment { color Green }
      #declare CameraHeight = 0
   #break
   #range (20,24.999)
      #declare defscale = 0.01
      #declare defheight = -200
      #declare defrot = 72*clock
      #declare sphereheight = 0.5
      #declare spherescale = (25-clock)/3
      #declare metheight = 0
      #declare metscale = ((clock-20)/5.5)+0.1
      #declare tc = pigment { color Green }
      #declare CameraHeight = 0
   #break
   #range (25,35)
      #declare defscale = 0.01
      #declare defheight = -200
      #declare defrot = 72*clock
      #declare sphereheight = -200
      #declare spherescale = 0.1
      #declare metheight = 0
      #declare metscale = 1.0
      #declare tc = pigment { color Green }
      #declare CameraHeight = 0
   #break
#end

//////////////////////////////////////////////////////////////////////
// Description of camera 
//////////////////////////////////////////////////////////////////////

camera
{
  location  <0.0, CameraHeight + 1.5, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, CameraHeight + 1.0,  0.0>
}

//////////////////////////////////////////////////////////////////////
// Description of light source
//////////////////////////////////////////////////////////////////////

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  
  translate <-30, 30, -60>
}

//////////////////////////////////////////////////////////////////////
// Description of sky
//////////////////////////////////////////////////////////////////////

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

//////////////////////////////////////////////////////////////////////
// Discription of the Title text object
//////////////////////////////////////////////////////////////////////

text
{
  ttf
  "timrom.ttf",
  "DEFINITION",
  1,
  0.05
  pigment { color Green}
  scale < 1, 2 , 1>
  translate < -3.0, 5, 0>
}

//////////////////////////////////////////////////////////////////////
// Discriptions of the definituion text objects                     
//////////////////////////////////////////////////////////////////////

text
{
  ttf
  "timrom.ttf",
  "Change of form, shape, structure, or substance",
  0.1,
  0
  pigment { tc }
  translate < -9.5, defheight+0.25 +2*defscale, 0>
  scale< 0.34*defscale , defscale , 1>
  rotate < 0, defrot , 0 >
}

text
{
  ttf          
  "timrom.ttf",  
  "A marked or complete change in",  
  0.1,         
  0            
  pigment { tc }
  translate < -9.5 ,defheight+0.25 +defscale, 0>
  scale< 0.34*defscale , defscale , 1>
  rotate < 0, -defrot , 0 >

}

text
{
  ttf          
  "timrom.ttf",  
  "Character, Appearance, or Condition. ",  
  0.1,         
  0            
  pigment { tc }
  translate < -9.5, defheight+0.25, 0>
  scale< 0.34*defscale , defscale , 1>
  rotate < 0, defrot , 0 >

}


//////////////////////////////////////////////////////////////////////
// Discription of the metamorph sphere                     
//////////////////////////////////////////////////////////////////////
sphere
{
  <0, 0, 0> 
  spherescale
  pigment { tc }
  translate < 0 , sphereheight , 0 >
}

//////////////////////////////////////////////////////////////////////
// Discription of the text object METAMORPHOSIS
//////////////////////////////////////////////////////////////////////
text
{
  ttf          
  "timrom.ttf",
  "Metamorphosis", 
  0.25,           
  0            

  pigment { tc }

  translate < -3.25,metheight+0.25, 0>
  scale< 1*metscale , 2*metscale , 1>
  rotate < 0, defrot , 0 >

}
