// The Start

#include "colors.inc"
#include "textures.inc"

#if (clock < 121)
	camera {location <0,0,-5> look_at <0,0,0> rotate <0,-30 + (clock / 100*30),0> rotate <40-(clock/100*20),0,0> translate <0,1,0>}
#end
#if (clock > 120 & clock < 131)
	camera {location <0,0,-5> look_at <0,0,0> rotate <0,6+((clock - 120) * 0.3),0> rotate <40-(clock/100*20),0,0> translate <0,1,0>}
#end
#if (clock > 130 & clock < 201)
	camera {location <0,0,-5 + (sin(radians((clock - 130) / 100 * 90))*0.25)> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> rotate <14-((sin(radians((clock-130)/70*90))*14)),0,0> translate <0,1,0>}
#end
#if (clock > 200 & clock < 231)
	camera {location <0,0,-5 + (sin(radians((clock - 130) / 100 * 90))*0.25)> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> translate <0,1,0>}
#end
#if (clock > 230)
	camera {location <0,0,-4.75> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> translate <0,1,0>}
#end
#if (clock > 460 & clock < 476)
	camera {location <0,0,-4.125 - (cos(radians((clock-460)/15*90))*0.625)> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> translate <0,1,0>}
#end
#if (clock > 475 & clock < 491)
	camera {location <0,0,-4.125 + (cos(radians(90-((clock-475)/15*90)))*0.625)> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> translate <0,1,0>}
#end
#if (clock > 490)
	camera {location <0,0,-3.5> look_at <0,0,0> rotate <0,9+((clock - 130) * 0.3),0> translate <0,1,0>}
#end

#if (clock < 231)
	light_source {<5,5,-5> Gray70}
	light_source {<-5,5,-5> White}
#end
#if (clock > 230 & clock < 261)
	light_source {<5,5,-5> Gray70 rotate <0,sin(radians((clock-230)/30*90))*9,0>}
	light_source {<-5,5,-5> White rotate <0,sin(radians((clock-230)/30*90))*9,0>}
#end
#if (clock > 260)
	light_source {<5,5,-5> Gray70 rotate <0,9+((clock-260)*0.3),0>}
	light_source {<-5,5,-5> White rotate <0,9+((clock-260)*0.3),0>}
#end

#if (clock > 80)
#declare MorphingObject = lathe {
	cubic_spline
	13,
	#if (clock > 130)
		#declare BaseName="c:\TestVectors\Vectors"
		#if (clock < 231)
			#declare FrameNumber = clock - 130
		#end
		#if (clock > 230 & clock < 241)
			#declare FrameNumber = 100
		#end
		#if (clock > 240 & clock < 341)
			#declare FrameNumber = clock - 140
		#end
		#if (clock > 340 & clock < 351)
			#declare FrameNumber = 200
		#end
		#if (clock > 350 & clock < 451)
			#declare FrameNumber = clock - 150
		#end
		#if (clock > 450 & clock < 461)
			#declare FrameNumber = 300
		#end
		#if (clock > 460 & clock < 561)
			#declare FrameNumber = clock - 160
		#end
		#if (clock > 560)
			#declare FrameNumber = 400
		#end

		#if (FrameNumber < 10)
			#declare CorrectedNumber = str(FrameNumber,1,0)
		#else
			#if (FrameNumber < 100)
				#declare CorrectedNumber = str(FrameNumber,-2,0)
			#else
				#declare CorrectedNumber = str(FrameNumber,-3,0)
			#end
		#end

		#declare CorrectedIncludeFile = concat(BaseName,CorrectedNumber,".inc")
		#include CorrectedIncludeFile
	#else
		#include "c:\TestVectors\Vectors1.inc"
	#end

	translate <0,-1,0>
	scale 0.75
	translate <0,1,0>

	#if (clock < 130)
		texture {
			pigment {color rgb <0.6, 0.8196078431373, 0.9490196078431>}
			finish {Shiny}
		}
	#end
	#if (clock > 129 & clock < 231)
		texture {
			pigment {color rgb <0.6 + (((clock - 130)/100)*0.4), 0.8196078431373 * (1-((clock - 130)/100)), 0.9490196078431 * (1-((clock - 130)/100))>}
			finish {
				Shiny
				reflection (((clock - 130)/100)*0.4)
			}
		}
	#end
	#if (clock > 230 & clock < 241)
		texture {
			pigment {Red}
			finish {
				Shiny
				reflection 0.4
			}
		}
	#end
	#if (clock > 240 & clock < 341)
		texture {
			pigment {color rgb <1, 2/3 * ((clock - 240)/100), 1/3 * ((clock - 240)/100)>}
			finish {
				Shiny
				reflection 0.4
			}
		}
	#end
	#if (clock > 340 & clock < 351)
		texture {
			pigment {color rgb <1, 2/3, 1/3>}
			finish {
				Shiny
				reflection 0.4
			}
		}
	#end
	#if (clock > 350 & clock < 451)
		texture {
			pigment {color rgb <1, 2/3 + (0.1764705882353*((clock-350)/100)), 1/3+((2/3)*((clock-350)/100))>}
			finish {
				Shiny
				reflection 0.4 - ((clock-350)/400)
			}
		}
	#end
	#if (clock > 450 & clock < 461)
		texture {
			pigment {color rgb <1,0.8431372549017,1>} // 0.1568627450983
			finish {
				Shiny
				reflection 0.15
			}
		}
	#end
	#if (clock > 460 & clock < 561)
		texture {
			pigment {
				White
			}
			finish {
				ambient 1
				diffuse 0
			}
		}
		texture {
			pigment {color rgbf <1,0.8431372549017 + (0.1568627450983 * ((clock - 460)/100)),1,(clock-460)/100>}
			finish {
				Shiny
				reflection 0.15 * (1 - ((clock - 460) / 100))
			}
		}
	#end
	#if (clock > 560)
		pigment {
			White
		}
		finish {
			ambient 1
			diffuse 0
		}
	#end
}
#end

#if (clock > 530 & clock < 536)
	disc {<0,0.25,0> <0,1,0> 1000
		pigment {Green}
		finish {
			ambient 1
			diffuse 0
		}
	}
#end

#if (clock > 535 & clock < 561)
	disc {<0,0.25,0> <0,1,0> 1000
		pigment {
			color rgb <0,1-sin(radians(((clock-535)*3.6))),0>
		}
		finish {
			ambient 1
			diffuse 0
		}
	}
#end

#if (clock < 531)

#declare Height = 3

#declare ColText = texture {
	pigment {
		granite
		color_map {
			[0 White]
			[0.5 White]
			[0.5 Gray80]
			[0.55 Gray70]
			[0.56 White]
			[1 White]
		}
	}
	finish {
		Shiny
		crand 0.05
	}
}

#declare ColCut = union {
	cylinder {<0.6,1,0> <0.6,Height-1,0> 0.1}
	sphere {<0.6,1,0> 0.1}
	sphere {<0.6,Height-1,0> 0.1}
}

#declare Pillar = union {
	cylinder {<0,0,0> <0,0.1,0> 0.95}
	cylinder {<0,0.1,0> <0,0.2,0> 0.85}
	cylinder {<0,0.2,0> <0,0.3,0> 0.75}
	torus {0.95, 0.05 translate <0,0.05,0>}
	torus {0.85, 0.05 translate <0,0.15,0>}
	torus {0.75, 0.05 translate <0,0.25,0>}

	difference {
		cylinder {<0,0.3,0> <0,Height-0.3,0> 0.6}
		torus {0.6, 0.1 translate <0,0.7,0>}
		torus {0.6, 0.1 translate <0,Height-0.7,0>}
		object {ColCut}
		object {ColCut rotate <0,30,0>}
		object {ColCut rotate <0,60,0>}
		object {ColCut rotate <0,90,0>}
		object {ColCut rotate <0,120,0>}
		object {ColCut rotate <0,150,0>}
		object {ColCut rotate <0,180,0>}
		object {ColCut rotate <0,210,0>}
		object {ColCut rotate <0,240,0>}
		object {ColCut rotate <0,270,0>}
		object {ColCut rotate <0,300,0>}
		object {ColCut rotate <0,330,0>}
	}

	union {
		sphere {<0.6,0,0> 0.05}
		sphere {<0.6,0,0> 0.05 rotate <0,30,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,60,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,90,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,120,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,150,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,180,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,210,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,240,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,270,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,300,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,330,0>}
		translate <0,0.45,0>
	}

	union {
		sphere {<0.6,0,0> 0.05}
		sphere {<0.6,0,0> 0.05 rotate <0,30,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,60,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,90,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,120,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,150,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,180,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,210,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,240,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,270,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,300,0>}
		sphere {<0.6,0,0> 0.05 rotate <0,330,0>}
		translate <0,Height-0.45,0>
	}

	difference {
		box {<-0.6,0,-0.6> <0.6,0.1,0.6>}
		cylinder {<-0.6,-0.001,-0.6> <-0.6,1.001,-0.6> 0.2}
		cylinder {<0.6,-0.001,-0.6> <0.6,1.001,-0.6> 0.2}
		cylinder {<0.6,-0.001,0.6> <0.6,1.001,0.6> 0.2}
		cylinder {<-0.6,-0.001,0.6> <-0.6,1.001,0.6> 0.2}
		translate <0,Height-0.3,0>
	}
	difference {
		box {<-0.8,0,-0.8> <0.8,0.1,0.8>}
		cylinder {<-0.8,-0.001,-0.8> <-0.8,1.001,-0.8> 0.35}
		cylinder {<0.8,-0.001,-0.8> <0.8,1.001,-0.8> 0.35}
		cylinder {<0.8,-0.001,0.8> <0.8,1.001,0.8> 0.35}
		cylinder {<-0.8,-0.001,0.8> <-0.8,1.001,0.8> 0.35}
		translate <0,Height-0.2,0>
	}
	difference {
		box {<-1,0,-1> <1,0.1,1>}
		cylinder {<-1,-0.001,-1> <-1,1.001,-1> 0.5}
		cylinder {<1,-0.001,-1> <1,1.001,-1> 0.5}
		cylinder {<1,-0.001,1> <1,1.001,1> 0.5}
		cylinder {<-1,-0.001,1> <-1,1.001,1> 0.5}
		translate <0,Height-0.1,0>
	}
	bounded_by {
		union {
			cylinder {<0,0,0> <0,0.3,0> 1}
			cylinder {<0,0.3,0> <0,Height-0.3,0> 0.6}
			box {<-1,Height,-1> <1,Height-0.3,1>}
		}
	}
	texture {ColText}
}

object {Pillar translate <0,-3,0> scale 1.7}
#end

#declare ScannerWidth = 0

#if (clock < 121)

	#if (clock < 40)
		#declare ScannerHeight = clock / 20
	#end
	#if (clock = 40)
		#declare ScannerHeight = 2
	#end
	#if (clock > 40 & clock < 50)
		#declare ScannerHeight = 2
	#end
	#if (clock = 50)
		#declare ScannerHeight = 2
	#end
	#if (clock > 50 & clock < 70)
		#declare ScannerWidth = (clock - 50) / 10
		#declare ScannerHeight = 2
	#end
	#if (clock = 70)
		#declare ScannerWidth = 2
		#declare ScannerHeight = 2
	#end
	#if (clock > 70 & clock < 80)
		#declare ScannerWidth = 2
		#declare ScannerHeight = 2
	#end
	#if (clock = 80)
		#declare ScannerWidth = 2
		#declare ScannerHeight = 2
	#end
	#if (clock > 80)
		#declare ScannerWidth = 2
		#declare ScannerHeight = 2 - ((clock-80)/20)
		intersection {
			object {MorphingObject}
			box {<-0.8,2,-0.8> <0.8,ScannerHeight+0.0001,0.8>}
			bounded_by {
				sphere {<0,1,0> 0.8}
			}
		}
	#end

	#if (clock > 50)
		mesh {
			triangle {<-1,ScannerHeight+0.00001,1.001> <1,ScannerHeight+0.00001,1.001> <1,ScannerHeight+0.00001,1-ScannerWidth>}
			triangle {<-1,ScannerHeight+0.00001,1.001> <-1,ScannerHeight+0.00001,1-ScannerWidth> <1,ScannerHeight+0.00001,1-ScannerWidth>}
			#if (ScannerHeight > 0.25 & ScannerHeight < 1.75)
				#declare TempCos = cos(asin((ScannerHeight-1)*(1+(1/3))))*0.75
				texture {
					pigment {
						onion
						color_map {
							[0 color rgb <1,0,1>]
							[TempCos/3 color rgb <1,0,1>]
							[(TempCos/3)+0.075 color Green]
							[1 color Green]
						}
						scale 3
						translate <0,ScannerHeight,0>
					}
					finish {
						ambient 1
						diffuse 0
					}
				}
			#else
				texture {
					pigment {Green}
					finish {
						ambient 1
						diffuse 0
					}
				}
			#end
			no_shadow
		}

	#end

	mesh {
		triangle {<-1,0.1,1> <-1.05,0,1> <-1,0,-1>}
		triangle {<-1,0.1,1> <-0.95,0,1> <-1,0,-1>}
		triangle {<-1,-0.1,1> <-1.05,0,1> <-1,0,-1>}
		triangle {<-1,-0.1,1> <-0.95,0,1> <-1,0,-1>}

		triangle {<1,0.1,1> <1.05,0,1> <1,0,-1>}
		triangle {<1,0.1,1> <0.95,0,1> <1,0,-1>}
		triangle {<1,-0.1,1> <1.05,0,1> <1,0,-1>}
		triangle {<1,-0.1,1> <0.95,0,1> <1,0,-1>}

		triangle {<-1.05,0,1> <1,-0.1,1> <1.05,0,1>}
		triangle {<-1,-0.1,1> <1,-0.1,1> <-1.05,0,1>}
		triangle {<-1.05,0,1> <1,-0.1,1> <1.05,0,1>}
		triangle {<-1,-0.1,1> <1,-0.1,1> <-1.05,0,1>}

		triangle {<-1,0.1,1> <-1,0,0.95> <1,0,0.95>}
		triangle {<-1,0.1,1> <1,0,0.95> <1,0.1,1>}
		triangle {<-1,-0.1,1> <-1,0,0.95> <1,0,0.95>}
		triangle {<-1,-0.1,1> <1,0,0.95> <1,-0.1,1>}
		translate <0,ScannerHeight,0>
		texture {Chrome_Texture}
	}

	union {
		triangle {<-1.05,-0.01,1> <-0.95,ScannerHeight,1> <-0.95,-0.01,1>}
		triangle {<-1.05,-0.01,1> <-0.95,ScannerHeight,1> <-1.05,ScannerHeight,1>}
		triangle {<-1.05,ScannerHeight,1> <-1,ScannerHeight,0.95> <-1,-0.01,0.95>}
		triangle {<-0.95,ScannerHeight,1> <-1,ScannerHeight,0.95> <-1,-0.01,0.95>}
		triangle {<-1.05,ScannerHeight,1> <-1.05,-0.01,0.95> <-1,-0.01,0.95>}
		triangle {<-0.95,ScannerHeight,1> <-0.95,-0.01,0.95> <-1,-0.01,0.95>}

		triangle {<1.05,-0.01,1> <0.95,ScannerHeight,1> <0.95,-0.01,1>}
		triangle {<1.05,-0.01,1> <0.95,ScannerHeight,1> <1.05,ScannerHeight,1>}
		triangle {<1.05,ScannerHeight,1> <1,ScannerHeight,0.95> <1,-0.01,0.95>}
		triangle {<0.95,ScannerHeight,1> <1,ScannerHeight,0.95> <1,-0.01,0.95>}
		triangle {<1.05,ScannerHeight,1> <1.05,-0.01,0.95> <1,-0.01,0.95>}
		triangle {<0.95,ScannerHeight,1> <0.95,-0.01,0.95> <1,-0.01,0.95>}

		texture {Chrome_Texture}

	}
#else
	#declare ScannerHeight = 0
	#if (clock > 120 & clock < 131)
		#declare ScannerWidth = 2 - (clock - 120) / 5
		mesh {
			triangle {<-1,ScannerHeight+0.00001,1.001> <1,ScannerHeight+0.00001,1.001> <1,ScannerHeight+0.00001,1-ScannerWidth>}
			triangle {<-1,ScannerHeight+0.00001,1.001> <-1,ScannerHeight+0.00001,1-ScannerWidth> <1,ScannerHeight+0.00001,1-ScannerWidth>}
			texture {
				pigment {Green}
				finish {
					ambient 1
					diffuse 0
				}
			}
			no_shadow
		}
	#end

	#if (clock < 531)
	mesh {
		triangle {<-1,0.1,1> <-1.05,0,1> <-1,0,-1>}
		triangle {<-1,0.1,1> <-0.95,0,1> <-1,0,-1>}
		triangle {<-1,-0.1,1> <-1.05,0,1> <-1,0,-1>}
		triangle {<-1,-0.1,1> <-0.95,0,1> <-1,0,-1>}

		triangle {<1,0.1,1> <1.05,0,1> <1,0,-1>}
		triangle {<1,0.1,1> <0.95,0,1> <1,0,-1>}
		triangle {<1,-0.1,1> <1.05,0,1> <1,0,-1>}
		triangle {<1,-0.1,1> <0.95,0,1> <1,0,-1>}

		triangle {<-1.05,0,1> <1,-0.1,1> <1.05,0,1>}
		triangle {<-1,-0.1,1> <1,-0.1,1> <-1.05,0,1>}
		triangle {<-1.05,0,1> <1,-0.1,1> <1.05,0,1>}
		triangle {<-1,-0.1,1> <1,-0.1,1> <-1.05,0,1>}

		triangle {<-1,0.1,1> <-1,0,0.95> <1,0,0.95>}
		triangle {<-1,0.1,1> <1,0,0.95> <1,0.1,1>}
		triangle {<-1,-0.1,1> <-1,0,0.95> <1,0,0.95>}
		triangle {<-1,-0.1,1> <1,0,0.95> <1,-0.1,1>}
		translate <0,ScannerHeight,0>
		texture {Chrome_Texture}
	}

	union {
		triangle {<-1.05,-0.01,1> <-0.95,ScannerHeight,1> <-0.95,-0.01,1>}
		triangle {<-1.05,-0.01,1> <-0.95,ScannerHeight,1> <-1.05,ScannerHeight,1>}
		triangle {<-1.05,ScannerHeight,1> <-1,ScannerHeight,0.95> <-1,-0.01,0.95>}
		triangle {<-0.95,ScannerHeight,1> <-1,ScannerHeight,0.95> <-1,-0.01,0.95>}
		triangle {<-1.05,ScannerHeight,1> <-1.05,-0.01,0.95> <-1,-0.01,0.95>}
		triangle {<-0.95,ScannerHeight,1> <-0.95,-0.01,0.95> <-1,-0.01,0.95>}

		triangle {<1.05,-0.01,1> <0.95,ScannerHeight,1> <0.95,-0.01,1>}
		triangle {<1.05,-0.01,1> <0.95,ScannerHeight,1> <1.05,ScannerHeight,1>}
		triangle {<1.05,ScannerHeight,1> <1,ScannerHeight,0.95> <1,-0.01,0.95>}
		triangle {<0.95,ScannerHeight,1> <1,ScannerHeight,0.95> <1,-0.01,0.95>}
		triangle {<1.05,ScannerHeight,1> <1.05,-0.01,0.95> <1,-0.01,0.95>}
		triangle {<0.95,ScannerHeight,1> <0.95,-0.01,0.95> <1,-0.01,0.95>}

		texture {Chrome_Texture}
	}
	#end
	object {MorphingObject}

#end

#if (clock < 531)

#declare FloorTexture1 = texture {
	pigment {
		checker
		color Gray70
		color White
	}
	normal {
		bumps 0.5
		turbulence 0.5
	}
	scale 0.1
}

#declare FloorTexture2 = texture {
	pigment {Black}
}

disc {<0,0,0> <0,1,0> 10
	texture {
		onion
		texture_map {
			[0 FloorTexture1]
			[0.8 FloorTexture1]
			[1 FloorTexture2]
		}
		scale 10
	}
	translate <0,-3,0>
}

#end

// The End
