//final_clock=4.5
//100 frames

#include "colors.inc"


sky_sphere {
pigment {
gradient y
color_map {
[0 color rgb <0.8, 0.8, 1>]
[1 color rgb <0.2, 0.4, 1>]
}
}

}

plane {y, 1000
pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.95, 0.95, 0.95>
                   color rgb <0.9, 0.9, 0.9>]
          [0.1 0.5 color rgb <0.85, 0.85, 0.85>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale 10000*<0.2, 0.5, 0.2>
      translate <4400, 110, 1100>
      translate <400*clock, 10*clock, 100*clock>
    }
    //rotate -135*x
    finish {ambient 1}
    hollow
 }

height_field {
tga "ground.tga"
scale <1000, 100, 1000>
translate <-500, -150, -500>
smooth
pigment {
spotted
turbulence .05
color_map {
[0 color LightWood]
[1 color rgb <0.5, 0.76, 0.45>]
}
scale 30
}
finish {ambient .3 diffuse 1.2 phong .3 phong_size 30}
normal {crackle .7}
hollow
}

plane {y, -2500
pigment {color <0.7, 1, .9>}
finish {ambient .4 phong 1 phong_size 11}
normal {bumps 1 scale 400 }
no_shadow
hollow
}



fog {
    distance 100
    colour rgbt<0.95, 1, 1, .2>
    fog_type 2
    fog_offset 20
    fog_alt .5
    turbulence 0.2
    turb_depth 0.2
    }





#include "leaf4a.inc"

object {plant scale .25 rotate 90*y translate <2, -5, 9>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 rotate -45*y translate <-30, -5, -25>
pigment {color rgbt <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 translate <-40, -5, 55>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}

object {plant scale .25 rotate 180*y translate <55, -5, -30>
pigment {color rgbf <0.5, 0.7, 0.4, .1>}
finish {ambient .2 phong .5 phong_size 11 diffuse .8}
}


#if (clock <= 2.5)
camera { //location <0, 20, 0> look_at 0 }
location <20, 2, 0> look_at <0, 2, 0>
rotate 54*clock*y} //rotate -45*y*clock}
#end

#if (clock > 2.5 & clock <= 3.5)
#declare aclock = clock - 2.5
camera {
location <20, 2, 0>
look_at <0, 2, 0>
rotate 135*y
rotate 45*aclock*y
}
#end

#if (clock > 3.5 & clock <= 4.5)
#declare aclock = clock - 3.5
camera {
location <20, 2+(-7*aclock), 0>
look_at <0, 2+(-7*aclock), 0>
rotate 180*y
//rotate 45*aclock*y
}
#end

light_source {<30, 70, 20> color 0.2*White}

light_source { <20, 20, -40> color 0.9*White
	//spotlight
	//radius 20
	//falloff 40
	//tightness 6
	//area_light <2, 0, 0>, <0, 2, 0>, 3, 3

	//point_at 0}
    }

/*plane {z, 4
	pigment {hexagon color Silver, color 0.4*Silver, color 0.01*Silver
	rotate 90*x}
	finish {ambient .2 phong .5 phong_size 2 reflection 0.5}
	scale 5
}*/


#if (clock <= 1)

#declare Black = color 0.05*White

#declare cgold = texture {
pigment {color rgb <.888, .788, .500>}
finish {ambient <.3, .4, .2> diffuse 1 brilliance 3 phong .7 phong_size 50 reflection .1 metallic}
}

#declare c_orange = texture {
pigment {color <0.936, 0.652, 0.108> + clock*<-.490, .26, .512> }
finish {ambient 0.8-clock*.55 diffuse .5 phong .7 phong_size 1+clock*50}
}
#declare c_white = texture {
pigment {color <1, 1, 1> - clock*<0.56, 0.088, 0.38> }
finish {ambient 0.8-clock*.55 diffuse .5 phong .7 phong_size 1+clock*50}
}
#declare c_black = texture {
pigment {color <.01, .01, 0.01> + clock*<0.43, .902, .61> }
finish {ambient 0.8-clock*.55 diffuse .5 phong .7 phong_size 1+clock*50}
}

blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y texture {c_white}}
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y texture {c_black}}
sphere {<0, 0, 0>, 1+1*clock, 1 scale <1, .8, 1> translate 5.5*y texture {c_white}}
sphere {<0, 0, 0>, 1+1.2*clock, 1 scale <1, .8, 1> translate 5.15*y texture {c_black}}
sphere {<0, 0, 0>, 1+1.4*clock, 1 scale <1, .8, 1> translate 4.75*y texture {c_orange}}
sphere {<0, 0, 0>, 1+1.8*clock, 1 scale <1, .8, 1> translate 4.25*y texture {c_black}}
sphere {<0, 0, 0>, 1+2*clock, 1 scale <1, .8, 1> translate 3.75*y  texture {c_white}}
sphere {<0, 0, 0>, 1+2*clock, 1 scale <1, .8, 1> translate 3.25*y  texture {c_black}}
sphere {<0, 0, 0>, 1+2*clock, 1 scale <1, .88, 1> translate 2.8*y  texture {c_orange}}
sphere {<0, 0, 0>, 1+2*clock, 1 scale <1, .8, 1> translate 2.5*y  texture {c_black}}
sphere {<0, 0, 0>, 1+1.75*clock, 1 scale <1, .8, 1> translate <.25*clock, 2, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+1.7*clock, 1 scale <1, .8, 1> translate <.4*clock, 1.5, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.6*clock, 1 scale <1, .8, 1> translate <.5*clock, 1, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+1.55*clock, 1 scale <1, .8, 1> translate <.55*clock, .5, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.5*clock, 1 scale <1, .8, 1> translate <.6*clock, 0, 0> texture {c_orange}}
sphere {<0, 0, 0>, 1+1.5*clock, 1 scale <1, .8, 1> translate <.55*clock, -0.5, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.5*clock, 1 scale <1, .8, 1> translate <.5*clock, -1, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+1.55*clock, 1 scale <1, .8, 1> translate <.45*clock, -1.4, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.6*clock, 1 scale <1, .8, 1> translate <.4*clock, -1.75, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+1.5*clock, 1 scale <1, .8, 1> translate <.33*clock, -2.1, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.4*clock, 1 scale <1, .8, 1> translate <.25*clock, -2.4, 0> texture {c_orange}}
sphere {<0, 0, 0>, 1+1.3*clock, 1 scale <1, .8, 1> translate <.25*clock, -2.85, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+1.2*clock, 1 scale <1, .8, 1> translate <.25*clock, -3, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+1*clock, 1 scale <1, .7, 1> translate <.25*clock, -3.5, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+.75*clock, 1 scale <1, .6, 1> translate <.3*clock, -3.75, 0> texture {c_white}}
sphere {<0, 0, 0>, 1+.5*clock, 1 scale <1, .68, 1> translate <.35*clock, -4, 0> texture {c_black}}
sphere {<0, 0, 0>, 1+.25*clock, 1 scale <1, .6, 1> translate <.2*clock, -4.25, 0> texture {c_orange}}
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15*clock, -4.5, 0> texture {c_black}}
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1*clock, -4.8, 0> texture {c_white}}

//attempt to make fancy

sphere {<0, 3, -2.6*clock>, .27, 1.5 texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 10*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 20*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 30*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 40*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 50*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 60*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate -10*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 70*y texture {cgold}}
sphere {<0, 3, -2.6*clock>, .27, 1.5 rotate 80*y texture {cgold}}

sphere {<0, 3.5, -2.6*clock>, .20, 1.5 pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 2*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 4*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 6*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 8*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 10*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 12*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 14*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 16*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 18*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 20*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 22*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 24*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 26*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 28*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 30*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 32*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 34*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 36*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 38*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 40*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 42*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 44*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 46*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 48*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 50*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 52*y pigment {color Black}}
sphere {<0, 3.5, -2.6*clock>, .20, 1.5 rotate 54*y pigment {color Black}}

sphere {<0, -2.3, -2.2*clock>, .25, 1.5 translate .25*x texture {cgold}}
sphere {<0, -1, -2.2*clock>, .23, 1.5 rotate 45*y translate .5*x texture {cgold}}
sphere {<0, -1.7, -2.3*clock>, .21 1.5 rotate 27*y translate .5*x texture {cgold}}

}

#end

//******************************************************************************************************************

#if (clock > 1 & clock <= 1.5)



#declare Black = color 0.05*White

#declare cgold = texture {
pigment {color rgb <.888, .788, .500>}
finish {ambient <.3, .4, .2> diffuse 1 brilliance 3 phong .7 phong_size 50 reflection .1 metallic}
}

#declare c_orange = texture {
pigment {color <0.936, 0.652, 0.108> + clock*<-.490, .26, .512> }
finish {ambient 0.8-.55 diffuse .5 phong .7 phong_size 51}
}
#declare c_white = texture {
pigment {color <1, 1, 1> - clock*<0.56, 0.088, 0.38> }
finish {ambient 0.8-.55 diffuse .5 phong .7 phong_size 51}
}
#declare c_black = texture {
pigment {color <.01, .01, 0.01> + clock*<0.43, .902, .61> }
finish {ambient 0.8-.55 diffuse .5 phong .7 phong_size 51}
}

blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y }
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y }
sphere {<0, 0, 0>, 2, 1 scale <1, .8, 1> translate 5.5*y }
sphere {<0, 0, 0>, 2.22, 1 scale <1, .8, 1> translate 5.15*y }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate 4.75*y }
sphere {<0, 0, 0>, 2.8, 1 scale <1, .8, 1> translate 4.25*y }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.75*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.25*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .88, 1> translate 2.8*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 2.5*y  }
sphere {<0, 0, 0>, 2.75, 1 scale <1, .8, 1> translate <.25, 2, 0> }
sphere {<0, 0, 0>, 2.7, 1 scale <1, .8, 1> translate <.4, 1.5, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.5, 1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.55, .5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.6, 0, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.55, -0.5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.5, -1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.45, -1.4, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.4, -1.75, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.33, -2.1, 0> }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate <.25, -2.4, 0> }
sphere {<0, 0, 0>, 2.3, 1 scale <1, .8, 1> translate <.25, -2.85, 0> }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate <.25, -3, 0> }
sphere {<0, 0, 0>, 2, 1 scale <1, .7, 1> translate <.25, -3.5, 0> }
sphere {<0, 0, 0>, 1.75, 1 scale <1, .6, 1> translate <.3, -3.75, 0> }
sphere {<0, 0, 0>, 1.5, 1 scale <1, .68, 1> translate <.35, -4, 0> }
sphere {<0, 0, 0>, 1.25, 1 scale <1, .6, 1> translate <.2, -4.25, 0> }
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15, -4.5, 0> }
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1, -4.8, 0> }

//attempt to make fancy

sphere {<0, 3, -2.6>, .27, 1.5 texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 20*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 30*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 40*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 50*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 60*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate -10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 70*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 80*y texture {cgold}}

sphere {<0, 3.5, -2.6>, .20, 1.5 pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 2*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 4*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 6*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 8*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 10*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 12*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 14*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 16*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 18*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 20*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 22*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 24*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 26*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 28*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 30*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 32*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 34*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 36*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 38*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 40*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 42*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 44*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 46*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 48*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 50*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 52*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 54*y pigment {color Black}}

sphere {<0, -2.3, -2.2>, .25, 1.5 translate .25*x texture {cgold}}
sphere {<0, -1, -2.2>, .23, 1.5 rotate 45*y translate .5*x texture {cgold}}
sphere {<0, -1.7, -2.3>, .21 1.5 rotate 27*y translate .5*x texture {cgold}}

texture {
pigment {color rgb <.440, .912, .620> }
finish {
ambient 0.2
phong .6
phong_size 11
reflection 0
}
}

}
#end

//******************************************************************************************************************

#if (clock > 1.5 & clock <= 2.5 )

#declare aclock = clock - 1.5

#declare Black = color 0.05*White transmit 1

#declare cgold = texture {
pigment {color rgb <.888, .788, .500> transmit 1}
finish {ambient <.3, .4, .2> diffuse 1 brilliance 3 phong .7 phong_size 50 reflection .1 metallic}
}



blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y }
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y }
sphere {<0, 0, 0>, 2, 1 scale <1, .8, 1> translate 5.5*y }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate 5.15*y }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate 4.75*y }
sphere {<0, 0, 0>, 2.8, 1 scale <1, .8, 1> translate 4.25*y }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.75*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.25*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .88, 1> translate 2.8*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 2.5*y  }
sphere {<0, 0, 0>, 2.75, 1 scale <1, .8, 1> translate <.25, 2, 0> }
sphere {<0, 0, 0>, 2.7, 1 scale <1, .8, 1> translate <.4, 1.5, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.5, 1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.55, .5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.6, 0, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.55, -0.5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.5, -1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.45, -1.4, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.4, -1.75, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.33, -2.1, 0>}
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate <.25, -2.4, 0> }
sphere {<0, 0, 0>, 2.3, 1 scale <1, .8, 1> translate <.25, -2.85, 0> }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate <.25, -3, 0> }
sphere {<0, 0, 0>, 2, 1 scale <1, .7, 1> translate <.25, -3.5, 0> }
sphere {<0, 0, 0>, 1.75, 1 scale <1, .6, 1> translate <.3, -3.75, 0> }
sphere {<0, 0, 0>, 1.5, 1 scale <1, .68, 1> translate <.35, -4, 0> }
sphere {<0, 0, 0>, 1.25, 1 scale <1, .6, 1> translate <.2, -4.25, 0> }
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15, -4.5, 0> }
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1, -4.8, 0> }

//attempt to make fancy

sphere {<0, 3, -2.6>, .27, 1.5 texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 20*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 30*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 40*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 50*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 60*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate -10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 70*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 80*y texture {cgold}}

sphere {<0, 3.5, -2.6>, .20, 1.5 pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 2*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 4*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 6*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 8*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 10*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 12*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 14*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 16*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 18*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 20*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 22*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 24*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 26*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 28*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 30*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 32*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 34*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 36*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 38*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 40*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 42*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 44*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 46*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 48*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 50*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 52*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 54*y pigment {color Black}}

sphere {<0, -2.3, -2.2>, .25, 1.5 translate .25*x texture {cgold}}
sphere {<0, -1, -2.2>, .23, 1.5 rotate 45*y translate .5*x texture {cgold}}
sphere {<0, -1.7, -2.3>, .21 1.5 rotate 27*y translate .5*x texture {cgold}}

texture {
pigment {
image_map {
tga "monarch.tga"
once
}
scale <7, 14, 7> translate <-3, -7.5, 0>
}
}

texture {
pigment {color rgb <.440, .912, .620> transmit 1*aclock}
finish {
ambient 0.2
phong .6
phong_size 51-(aclock*40)
reflection 0
refraction 1
ior 1.002
}
}


}
#end





//*******************************************************************************************************



#if (clock > 2.5 & clock <3.5 )

#declare aclock = clock - 2.5


#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
//rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .1+(.1*aclock) phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate -60*y
scale <.1, 1, 1>

}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
//rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .1+(.1*aclock) phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate 60*y
scale <.1, 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
//rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .1+(.1*aclock) phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate -55*y
scale <.1, 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
//rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .1+(.1*aclock) phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate 55*y
scale <.1, 1, 1>
}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}
}


/*#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}


union {
object {antenae1}

object {antenae2}
*/

object {butterfly scale 1.4 rotate <180, 90, 0> translate 3.9*y}


//}



#declare Black = color 0.05*White transmit 1

#declare cgold = texture {
pigment {color rgb <.888, .788, .500> transmit 1}
finish {ambient <.3, .4, .2> diffuse 1 brilliance 3 phong .7 phong_size 50 reflection .1 metallic}
}



blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y }
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y }
sphere {<0, 0, 0>, 2, 1 scale <1, .8, 1> translate 5.5*y }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate 5.15*y }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate 4.75*y }
sphere {<0, 0, 0>, 2.8, 1 scale <1, .8, 1> translate 4.25*y }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.75*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.25*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .88, 1> translate 2.8*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 2.5*y  }
sphere {<0, 0, 0>, 2.75, 1 scale <1, .8, 1> translate <.25, 2, 0> }
sphere {<0, 0, 0>, 2.7, 1 scale <1, .8, 1> translate <.4, 1.5, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.5, 1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.55, .5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.6, 0, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.55, -0.5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.5, -1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.45, -1.4, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.4, -1.75, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.33, -2.1, 0>}
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate <.25, -2.4, 0> }
sphere {<0, 0, 0>, 2.3, 1 scale <1, .8, 1> translate <.25, -2.85, 0> }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate <.25, -3, 0> }
sphere {<0, 0, 0>, 2, 1 scale <1, .7, 1> translate <.25, -3.5, 0> }
sphere {<0, 0, 0>, 1.75, 1 scale <1, .6, 1> translate <.3, -3.75, 0> }
sphere {<0, 0, 0>, 1.5, 1 scale <1, .68, 1> translate <.35, -4, 0> }
sphere {<0, 0, 0>, 1.25, 1 scale <1, .6, 1> translate <.2, -4.25, 0> }
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15, -4.5, 0> }
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1, -4.8, 0> }

//attempt to make fancy

sphere {<0, 3, -2.6>, .27, 1.5 texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 20*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 30*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 40*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 50*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 60*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate -10*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 70*y texture {cgold}}
sphere {<0, 3, -2.6>, .27, 1.5 rotate 80*y texture {cgold}}

sphere {<0, 3.5, -2.6>, .20, 1.5 pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 2*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 4*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 6*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 8*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 10*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 12*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 14*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 16*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 18*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 20*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 22*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 24*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 26*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 28*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 30*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 32*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 34*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 36*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 38*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 40*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 42*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 44*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 46*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 48*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 50*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 52*y pigment {color Black}}
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 54*y pigment {color Black}}

sphere {<0, -2.3, -2.2>, .25, 1.5 translate .25*x texture {cgold}}
sphere {<0, -1, -2.2>, .23, 1.5 rotate 45*y translate .5*x texture {cgold}}
sphere {<0, -1.7, -2.3>, .21 1.5 rotate 27*y translate .5*x texture {cgold}}

/*texture {
pigment {
image_map {
tga "monarch.tga"
once
}
scale <7, 14, 7> translate <-3, -7.5, 0>
}
}
*/

/*
texture {
pigment {color rgb <.8, .912, .87> transmit .9}
finish {
ambient 0.2
phong .6
phong_size 30
reflection 0
refraction 1
ior 1.002
}
}
*/

texture {
pigment {color rgbt <1, 1, 1, 1>}
finish {phong .6 phong_size 30}
halo {
constant
attenuating
color_map {
[0 color rgb <0.1, 0.1, 0.1> transmit .2+(.8*aclock)]
[1 color rgb <0.1, 0.1, 0.1> transmit .2+(.8*aclock)]
}
samples 2
}
}
hollow
}

#end

//**************************************************************************************************************

#if (clock > 3.5 & clock <= 4.5)

#declare aclock = clock - 3.5


#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}


prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
//rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate 60*y*aclock
scale <.1+(.1*aclock), 1, 1>
}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
//rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate -60*y*aclock
scale <.1+(.1*aclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
//rotate 15*z
clipped_by {plane {-x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate 55*y*aclock
scale <.1+(.1*aclock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
//rotate -15*z
clipped_by {plane {x, 0}}
texture {
material_map {
gif "wingmap.gif"
texture {
pigment {
image_map {
tga "wing.tga"
}

//scale <20.2, 15.5, 1>
//translate <20.2*-.5, 15.5*-.5, 0>
//translate <0, 1.95, 0>

}
finish {ambient .2 phong .8 phong_size 30 metallic}
normal {wrinkles 1 scale <.02, .2, .2> turbulence 0.05}
}
texture {
pigment { color rgbt <1, 1, 1, 1> }
finish {ambient 0 phong 0}
}
}
scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>
}
//rotate -55*y*aclock
scale <.1+(.1*aclock), 1, 1>
}

}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*aclock*x rotate -make*z}

#declare make = make + .4
#end
translate <5*aclock, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*aclock*x rotate make*z}

#declare make = make + .4
#end
translate <-5*aclock, 5.5, 0>
pigment {color 0.3*White}
}

union {
object {antenae1}

object {antenae2}


object {butterfly }
scale 1.4 rotate <180, 90, 0> translate 8*y rotate (-180*aclock)*z translate -3.9*y 
}



blob {
threshold 0.05
sphere {<0, 0, 0>, .5, 1 scale <1, .75, 1> translate 6.5*y }
sphere {<0, 0, 0>, 1, 1 scale <1, .8, 1> translate 6*y }
sphere {<0, 0, 0>, 2, 1 scale <1, .8, 1> translate 5.5*y }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate 5.15*y }
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate 4.75*y }
sphere {<0, 0, 0>, 2.8, 1 scale <1, .8, 1> translate 4.25*y }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.75*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 3.25*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .88, 1> translate 2.8*y  }
sphere {<0, 0, 0>, 3, 1 scale <1, .8, 1> translate 2.5*y  }
sphere {<0, 0, 0>, 2.75, 1 scale <1, .8, 1> translate <.25, 2, 0> }
sphere {<0, 0, 0>, 2.7, 1 scale <1, .8, 1> translate <.4, 1.5, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.5, 1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.55, .5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.6, 0, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.55, -0.5, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.5, -1, 0> }
sphere {<0, 0, 0>, 2.55, 1 scale <1, .8, 1> translate <.45, -1.4, 0> }
sphere {<0, 0, 0>, 2.6, 1 scale <1, .8, 1> translate <.4, -1.75, 0> }
sphere {<0, 0, 0>, 2.5, 1 scale <1, .8, 1> translate <.33, -2.1, 0>}
sphere {<0, 0, 0>, 2.4, 1 scale <1, .8, 1> translate <.25, -2.4, 0> }
sphere {<0, 0, 0>, 2.3, 1 scale <1, .8, 1> translate <.25, -2.85, 0> }
sphere {<0, 0, 0>, 2.2, 1 scale <1, .8, 1> translate <.25, -3, 0> }
sphere {<0, 0, 0>, 2, 1 scale <1, .7, 1> translate <.25, -3.5, 0> }
sphere {<0, 0, 0>, 1.75, 1 scale <1, .6, 1> translate <.3, -3.75, 0> }
sphere {<0, 0, 0>, 1.5, 1 scale <1, .68, 1> translate <.35, -4, 0> }
sphere {<0, 0, 0>, 1.25, 1 scale <1, .6, 1> translate <.2, -4.25, 0> }
sphere {<0, 0, 0>, 1, 1 scale <1, .4, 1> translate <.15, -4.5, 0> }
sphere {<0, 0, 0>, .9, 1 scale <1, .3, 1> translate <.1, -4.8, 0> }

//attempt to make fancy

sphere {<0, 3, -2.6>, .27, 1.5 }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 10*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 20*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 30*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 40*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 50*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 60*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate -10*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 70*y }
sphere {<0, 3, -2.6>, .27, 1.5 rotate 80*y }

sphere {<0, 3.5, -2.6>, .20, 1.5 }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 2*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 4*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 6*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 8*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 10*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 12*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 14*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 16*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 18*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 20*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 22*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 24*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 26*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 28*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 30*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 32*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 34*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 36*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 38*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 40*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 42*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 44*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 46*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 48*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 50*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 52*y }
sphere {<0, 3.5, -2.6>, .20, 1.5 rotate 54*y }

sphere {<0, -2.3, -2.2>, .25, 1.5 translate .25*x }
sphere {<0, -1, -2.2>, .23, 1.5 rotate 45*y translate .5*x }
sphere {<0, -1.7, -2.3>, .21 1.5 rotate 27*y translate .5*x }
texture {
pigment {color rgbt <1, 1, 1, 1>}
finish {phong .6 phong_size 30}
}
hollow
}



#end


//***********************************************************************************************

/*
#if (clock > 4.5 & clock <= 5.5)
#declare nclock = clock - 4.5

//wrinkled to extended wings

#declare butterfly = union {
blob {
threshold .1
sphere {<0, 6, 0>, .5, 1}
sphere {<0, 5, 0>, .8, 1 }
sphere {<0, 4.5, 0>, 1, 1}
sphere {<0, 4, 0>, .8, 1}
sphere {<0, 3.5, 0>, .6, 1}
sphere {<0, 3, 0>, .5, 1}
sphere {<0, 2.5, 0>, .6, 1}
sphere {<0, 2, 0>, .7, 1}
sphere {<0, 1.5, 0>, .8, 1}
sphere {<0, 1, 0>, .8, 1 }
sphere {<0, .5, 0>, .7, 1}
sphere {<0, 0, 0>, .6, 1}
sphere {<0, -.5, 0>, .5, 1}
sphere {<0, -1, 0>, .4, 1}
sphere {<0, -1.125, 0>, .3, 1}
sphere {<0, -1.25, 0>, .2, 1}
sphere {<0, -1.275, 0>, .1, 1}
pigment {
image_map {
tga "body.tga"
map_type 2
}
scale <.2, 8, .2>
rotate -80*y
translate -2*y
}
/*spotted

color_map {
[0 color White]
[0.2 color White]
[0.3 color 0.01*White]
[1 color 0.01*White]
}
scale .4
}
*/
finish {ambient 1}
}

prism {
cubic_spline
-.1
.1
11

<-3, 4>, <0, 6>, <9.5, 3>, <9, 0>, <6, 0>, <4, -1>,
<2, -1>, <0, 3>, <-.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5*clock phong .8 phong_size 30}
normal {wrinkles 1-clock }
rotate 60*y*clock
scale <.2+(.8*clock), 1, 1>

}

prism {
cubic_spline
-.1
.1
11
<3, 4>, <0, 6>, <-9.5, 3>, <-9, 0>, <-6, 0>, <-4, -1>,
<-2, -1>, <0, 3>, <.1, 3>, <0, 6>, <0, 7>


rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5*clock phong .8 phong_size 30}
normal {wrinkles 1-clock}
rotate -60*y*clock
scale <.2+(.8*clock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<-2, 4>, <0, 3>, <4, 0>, <3, -2>, <1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>


rotate -90*x
rotate 15*z
clipped_by {plane {-x, 0}}
pigment {
image_map {
tga "wing.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5}
rotate 55*y*clock
scale <.2+(.8*clock), 1, 1>
}

prism {
cubic_spline
-.11
.09
9
<2, 4>, <0, 3>, <-4, 0>, <-3, -2>, <-1, -2>, <0, -1>,
<0, 0>, <0, 3>, <0, 4>

rotate -90*x
rotate -15*z
clipped_by {plane {x, 0}}
pigment {
image_map {
tga "wing.tga"
}

scale <20.2, 15.5, 1>
translate <20.2*-.5, 15.5*-.5, 0>
translate <0, 1.95, 0>

}
finish {ambient .5}
rotate -55*y*clock
scale <.2+(.8*clock), 1, 1>
}

#declare antenae1 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate -5*x rotate -make*z}

#declare make = make + .4
#end
translate <5, 5.5, 0>
pigment {color 0.3*White}
}

#declare antenae2 = blob {
threshold 0.05
#declare make = 0
#while (make < 45)
sphere {<0, 0, 0>, .04, 1 #if (make > 35 & make < 42) scale 1.8 #end translate 5*x rotate make*z}

#declare make = make + .4
#end
translate <-5, 5.5, 0>
pigment {color 0.3*White}
}
}


object {butterfly scale 1.4 rotate <180, 90, 0> translate 3.9*y}

*/



