//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 8 textures and 45 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/31/1997    (31.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//

// This is the end of the standard include file for POV-Ray.


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  < %camera translate% >
  direction <0.0,     0.0,  0.7555>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   < %lookat translate% >
}

// *******  L I G H T S *******
light_source {   // Light1
  <0.376, -6.266, 10.316>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "snail.inc"



// ********  REFERENCED OBJECTS  *******

#declare EmbossLeg1 = object {
  box { // EmbossLeg1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04228, 1.161532, 0.25>
    translate  <1.710088, 0.033863, 0.25>
  }
}




// ********  OBJECTS  *******

// Include contains 'BookBinding'
#include "snail.in1"

#declare BookBinding = object {
  BookBinding_Raw
  scale <1.0, 1.0, 9.561921>
  rotate <90.0, 0.0, -180.0>
  translate  <-3.75, -4.780978, -0.969>
}
#declare BookBtmCoverCSG = union {
  box { // BookTopCoverB1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 4.75, 0.031>
    translate  3.75*x
  }
  cylinder { // BookTopCvrEdg5
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 9.5>
    rotate -90.0*x
    translate  -4.75*y
  }
  cylinder { // BookTopCvrEdg6
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 9.5>
    rotate -90.0*x
    translate  <7.5, -4.75, 0.0>
  }
  cylinder { // BookTopCvrEdg7
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 7.5>
    rotate <-90.0, 0.0, -90.0>
    translate  -4.75*y
  }
  cylinder { // BookTopCvrEdg8
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 7.5>
    rotate <-90.0, 0.0, -90.0>
    translate  4.75*y
  }
  sphere { // BookTopCvrCrn5
    <0,0,0>,1
    scale 0.031
    translate  4.75*y
  }
  sphere { // BookTopCvrCrn6
    <0,0,0>,1
    scale 0.031
    translate  <7.5, 4.75, 0.0>
  }
  sphere { // BookTopCvrCrn7
    <0,0,0>,1
    scale 0.031
    translate  <7.5, -4.75, 0.0>
  }
  sphere { // BookTopCvrCrn8
    <0,0,0>,1
    scale 0.031
    translate  -4.75*y
  }
  translate  <-3.75, 0.0, -0.938>
}
#declare Pages = difference {
  box { // BookPagesBox
    <-1, -1, -1>, <1, 1, 1>
    scale <3.910142, 1.5, 0.433884>
    translate  <-0.218887, 0.0, -0.469425>
  }
  cylinder { // PagesCut1
    <0,0,1>, <0,0,0>, 1 
    scale <0.134824, 0.111608, 3.2>
    rotate -90.0*x
    translate  <-3.91451, -1.618472, 0.01451>
  }
  cylinder { // PagesCut2
    <0,0,1>, <0,0,0>, 1 
    scale <0.134824, 0.111608, 3.2>
    rotate -90.0*x
    translate  <-3.931922, -1.601017, -0.965176>
  }
  cylinder { // PagesCut3
    <0,0,1>, <0,0,0>, 1 
    scale <0.289777, 0.538584, 3.2>
    rotate -90.0*x
    translate  <3.841774, -1.589739, -0.46722>
  }
  texture {
    txtPages
    scale <1.0, 1.0, 0.336636>
  }
  scale <1.0, 3.108382, 1.0>
}
// Include contains 'EmbossSnail'
#include "snail.in2"

#declare EmbossSnail = object {
  EmbossSnail_Raw
  texture {
    txtEmboss
  }
  scale <2.48868, 2.48868, 0.01>
  translate  <3.33817, 0.585831, 0.022372>
}
#declare BookTopCvrUnion = union {
  box { // BookTopCoverBx
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 4.75, 0.031>
    translate  3.75*x
  }
  cylinder { // BookTopCvrEdge1
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 9.5>
    rotate -90.0*x
    translate  -4.75*y
  }
  cylinder { // BookTopCvrEdg2
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 9.5>
    rotate -90.0*x
    translate  <7.5, -4.75, 0.0>
  }
  cylinder { // BookTopCvrEdg3
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 7.5>
    rotate <-90.0, 0.0, -90.0>
    translate  -4.75*y
  }
  cylinder { // BookTopCvrEdg4
    <0,0,1>, <0,0,0>, 1 
    scale <0.031, 0.031, 7.5>
    rotate <-90.0, 0.0, -90.0>
    translate  4.75*y
  }
  sphere { // BookTopCvrCrnr1
    <0,0,0>,1
    scale 0.031
    translate  4.75*y
  }
  sphere { // BookTopCvrCrn2
    <0,0,0>,1
    scale 0.031
    translate  <7.5, 4.75, 0.0>
  }
  sphere { // BookTopCvrCrn3
    <0,0,0>,1
    scale 0.031
    translate  <7.5, -4.75, 0.0>
  }
  sphere { // BookTopCvrCrn4
    <0,0,0>,1
    scale 0.031
    translate  -4.75*y
  }
  object { EmbossSnail }
}
#declare EmbossCylCSG = difference {
  cylinder { // EmbossCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.526146, 1.526146, 0.5>
  }
  cylinder { // EmbossCylCut
    <0,0,1>, <0,0,0>, 1 
    scale <1.458544, 1.458544, 0.5>
    translate  -0.269177*z
  }
}
#declare EmbossCSG = union {
  object { EmbossLeg1 }
  object { EmbossCylCSG }
  object { // EmbossLeg2->EmbossLeg1
    EmbossLeg1
    rotate -30.0*z
    translate  0.0*x
  }
  object { // EmbossLeg3->EmbossLeg1
    EmbossLeg1
    rotate -60.0*z
  }
  object { // EmbossLeg4->EmbossLeg1
    EmbossLeg1
    rotate -90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg5->EmbossLeg1
    EmbossLeg1
    rotate -120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg6->EmbossLeg1
    EmbossLeg1
    rotate -150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg7->EmbossLeg1
    EmbossLeg1
    rotate 180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg8->EmbossLeg1
    EmbossLeg1
    rotate 150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg9->EmbossLeg1
    EmbossLeg1
    rotate 120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg10->EmbossLeg1
    EmbossLeg1
    rotate 90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg11->EmbossLeg1
    EmbossLeg1
    rotate 60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // EmbossLeg12->EmbossLeg1
    EmbossLeg1
    rotate 30.0*z
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    txtEmboss
  }
  translate  <3.75, 0.776526, 0.026705>
}
#declare BookTopCvrCSG = difference {
  object { BookTopCvrUnion }
  object { EmbossCSG }
  box { // BookMap1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBookMap1
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <3.0, 0.5, 0.016778>
    translate  <3.75, 3.70061, 0.014231>
  }
  rotate < %bookcover rotate% >
  translate  -3.75*x
}
union { // Book
  object { BookBinding }
  object { BookBtmCoverCSG }
  object { Pages }
  object { BookTopCvrCSG }
  cylinder { // BookBindString
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBindString
      scale <1.502894, 1.502894, 0.075339>
    }
    scale <0.021638, 0.021638, 0.862543>
    translate  <-4.129588, -4.662577, -0.896808>
  }
  cylinder { // BookBindStrin1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBindString
      scale <1.502894, 1.502894, 0.075339>
    }
    scale <0.021638, 0.021638, 0.862543>
    translate  <-4.129588, 4.663573, -0.896808>
  }
  box { // InnerPicture
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBookPic
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <3.0, 1.875, 0.01>
    translate  <0.0, 0.680498, -0.042103>
  }
  box { // BookMap2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBookMap2
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <3.0, 0.5, 0.01>
    translate  <0.0, 3.70061, -0.042132>
  }
  box { // BookMap3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBookMap3
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <3.0, 0.5, 0.01>
    translate  <0.0, -2.105925, -0.042132>
  }
  texture {
    txtBook
  }
}




