#declare Radius = .05	// Radius of the cylinder.  This parameter can be
			// used to modify the roundness of each link.
#declare PI = 3.14159265358979323846
#declare Endpoint = (.5-Radius)
#declare CylAngleEnd = (.5-Radius-2*Radius*cos(PI/4))
#declare TangentAngleEnd = (.5-Radius-Radius*cos(PI/4))

#declare CylPoint1 = <Endpoint,Endpoint,CylAngleEnd>
#declare CylPoint2 = <-Endpoint,Endpoint,CylAngleEnd>
#declare CylPoint3 = <-Endpoint,Endpoint,-Endpoint>
#declare CylPoint4 = <Endpoint,Endpoint,-Endpoint>
#declare CylPoint5 = <Endpoint,-CylAngleEnd,-Endpoint>
#declare CylPoint6 = <-Endpoint,-CylAngleEnd,-Endpoint>

#declare Link = union {
	// Square Top
	cylinder {
		CylPoint4
		CylPoint1
		Radius
	}
	cylinder {
		CylPoint1
		CylPoint2
		Radius
	}
	cylinder {
		CylPoint2
		CylPoint3
		Radius
	}
	cylinder {
		CylPoint3
		CylPoint4
		Radius
	}
	// Square Back
	cylinder {
		CylPoint3
		CylPoint6
		Radius
	}
	cylinder {
		CylPoint4
		CylPoint5
		Radius
	}
	cylinder {
		CylPoint5
		CylPoint6
		Radius
	}
	// Angled Edge
	cylinder {
		CylPoint5
		CylPoint1
		Radius
	}
	cylinder {
		CylPoint6
		CylPoint2
		Radius
	}

	sphere {
		CylPoint1
		Radius
	}
	sphere {
		CylPoint2
		Radius
	}
	sphere {
		CylPoint3
		Radius
	}
	sphere {
		CylPoint4
		Radius
	}
	sphere {
		CylPoint5
		Radius
	}
	sphere {
		CylPoint6
		Radius;
	}
		
	// Top
	polygon {
		5,
		CylPoint1,CylPoint2,CylPoint3,CylPoint4,CylPoint1
		translate <0,Radius,0>
		pigment { color rgb <.2,.2,.2> }
	}
	// Left
	polygon {
		5,
		CylPoint3,CylPoint4,CylPoint5,CylPoint6,CylPoint3
		translate <0,0,-Radius>
		pigment { color rgb <.2,.2,.2> }
	}
	// Angled Bottom
	polygon {
		5
		CylPoint1,CylPoint2,CylPoint6,CylPoint5,CylPoint1
		translate <0,-(Radius*cos(PI/4)),Radius*cos(PI/4)>
		pigment { color rgb <0,0,.8> }
	}
	// Front
	polygon {
		4
		CylPoint1,CylPoint4,CylPoint5,CylPoint1
		translate <Radius,0,0>
		pigment {color rgb <.65,.01,0> }
	}
	// Back
	polygon {
		4
		CylPoint2,CylPoint3,CylPoint6,CylPoint2
		translate <-Radius,0,0>
		pigment { color rgb <.65,.01,0> }
	}
/*
	polygon {
		5,
		<Endpoint,Endpoint+Radius,-Endpoint>, // 4
		<-Endpoint,Endpoint+Radius,-Endpoint>, // 3
		<-Endpoint,Endpoint+Radius,CylAngleEnd2>, // 2
		<Endpoint,Endpoint+Radius,CylAngleEnd2>, // 1
		<Endpoint,Endpoint+Radius,-Endpoint> //4
		pigment { color rgb <0,1,0> }
	}	

	// Left	
	polygon {
		5,
		<-Endpoint,Endpoint,-(Endpoint+Radius)>, // 3
		<Endpoint,Endpoint,-(Endpoint+Radius)>, // 4
		<Endpoint,-CylAngleEnd,-(Endpoint+Radius)>, // 5
		<-Endpoint,-CylAngleEnd,-(Endpoint+Radius)>, // 6
		<-Endpoint,Endpoint,-(Endpoint+Radius)> // 3
		pigment { color rgb <1,0,0> }
	}
	// Angled bottom	
       	polygon {
		5
		<-Endpoint,-TangentAngleEnd,-TangentAngleEnd> // 6
		<Endpoint,-TangentAngleEnd,-TangentAngleEnd> // 5
		<Endpoint,TangentAngleEnd,TangentAngleEnd> // 1
		<-Endpoint,TangentAngleEnd,TangentAngleEnd> // 2
		<-Endpoint,-TangentAngleEnd,-TangentAngleEnd> // 6
		pigment { color rgb <0,0,1> }
	}
	// Front
	polygon {
		4
		<Endpoint+Radius,Endpoint,-Endpoint> // 4
		<Endpoint+Radius,-TangentAngleEnd,-TangentAngleEnd> // 5
		<Endpoint+Radius,Endpoint,TangentAngleEnd2> // 1
		<Endpoint+Radius,Endpoint,-TangentAngleEnd> // 4
		pigment { color rgb <1,1,0> }
	}
	// Back
	polygon {
		4
		<-(Endpoint+Radius),Endpoint,-TangentAngleEnd>
		<-(Endpoint+Radius),-TangentAngleEnd,-TangentAngleEnd>
		<-(Endpoint+Radius),Endpoint,TangentAngleEnd2>
		<-(Endpoint+Radius),Endpoint,-TangentAngleEnd>
		pigment { color rgb <1,1,0> }
	}
*/
	pigment { color rgb <1,1,1> }
	finish { ambient 0.1 diffuse 0.8 phong 0.5 phong_size 100 }
}
