// Julia fractal changing color and rotating as 3D slice goes from -1.25 - 1.25

#version 3.0
global_settings { assumed_gamma 2.2 }

#declare Pi = 3.1415926535898

julia_fractal {
	<0.465, 0.2654, 0.289465, -0.92634>
        max_iteration 6
        precision 20
	sqr
	quaternion
	slice <0,0,1,2>, (2.5*clock-1.25)
	texture {  pigment { color rgb <(cos((12*Pi*clock)-(2*Pi/3))),(cos(12*Pi*clock)),(cos((12*Pi*clock)+(2*Pi/3)))> } 
		   finish { phong .9 phong_size 20 }
	}
        rotate <(1800*clock),-30,10>
}

background { color rgb <0.4,0.4,0.4> }

light_source { <4,3.99,10> color rgb <.9,.95,.9> }

camera { location <0,3,2>
         up       <0,1.4,0>
         right    <1.4,0,0>
	 sky	  <0,0,1>
         look_at  <0,0,0>
}
