// Glenn's POV-Ray Textures File -- Animation Version
// created 7-Mar-98
// last update 31-Mar-98
// copyright Glenn McCarter

//------------- Colors -------------------

#declare White = rgb<1,1,1>
#declare Black = rgb<0,0,0>
#declare Red = rgb<1,0,0>
#declare Green = rgb<0,1,0>
#declare Blue = rgb<0,0,1>
#declare Yellow = rgb<1,1,0>
#declare LightGrey = rgb<.66,.66,.66>

//------------- Simple Textures -------------------

#declare ClearTex = texture { pigment { color rgbt<1,1,1,1> } }
#declare WhiteTex = texture { pigment { color rgb<1,1,1> } normal { bumps .4} }
#declare BlackTex = texture { pigment { color rgb<0,0,0> } normal { bumps .4} }
#declare RedTex = texture { pigment { color rgb<1,0,0> } normal { bumps .4} }
#declare GreenTex = texture { pigment { color rgb<0,1,0> } normal { bumps .4} }
#declare BlueTex = texture { pigment { color rgb<0,0,1> } normal { bumps .4} }
#declare YellowTex = texture { pigment { color rgb<1,1,0> } normal { bumps .4} }
#declare LightGreyTex = texture { pigment { color rgb<.66,.66,.66> } normal { bumps .4} }

//------------- White Textures -------------------

#declare AmbientWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient 1.0 phong .6 }
    }

#declare BrightWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .8 phong .6 }
    }
#declare FreshWhite =
    texture {
      pigment { color <1,1,1> }
      finish { ambient .6 phong .6 }
    }

#declare WhitePaint =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .2 specular .7 roughness .005 }
	}


//------------- Black Textures -------------------

#declare BlackPaint =
	texture {
		pigment { Black }
		finish { ambient .2 specular .7 roughness .005 }
	}
#declare FlatBlack = // does not illuminate
	texture {
		pigment { Black }
		finish { ambient 0 specular 0 roughness .005 }
	}
#declare DullBlack = // illuminates dimly (via engine glow)
	texture {
		pigment { Black }
		finish { ambient 0  diffuse .1 specular 0.15 roughness .5 }
	}

//------------- Grey Textures -------------------

#declare Grey30Paint =
	texture {
		pigment { color rgb<.3,.3,.33> }
		finish { ambient .12 specular .7 roughness .005 }
	}
#declare Grey50Paint =
	texture {
		pigment { color rgb<.52,.52,.5> }
		finish { ambient .12 specular .7 roughness .005 }
	}
#declare Grey80Paint =
	texture {
		pigment { color rgb<.8,.83,.81> }
		finish { ambient .12 specular .7 roughness .005 }
	}



//------------- Color Textures -------------------

#declare BrightBlue =
    texture {
      pigment { color <.1,.1,1> }
      finish { ambient .8 phong .6 }
    }
#declare RedPlastic =
    texture {
      pigment { color <.8,.08,.08> }
      finish { ambient .4 phong .6 }
    }
#declare GreenGrass =
    texture {
      pigment {
				bozo
				color_map {
					[ 0.0 color rgb<.06,.84,.38> ]
					[ 1.0 color rgb<.26,.56,.17> ]
//					[ 1.0 color rgb<.026,.0076,.027> ]
				}
				scale 18
			}
      finish { ambient .1 phong .6 }
    }
#declare DarkBrownTex = // propeller and engine
    texture {
      pigment { color <.3,.16,.05> }
      finish { ambient .1 phong .6 }
    }
#declare BlueLightTex =
	texture {
		pigment { color rgb<.7,.73,.91> }
		normal { bumps .1 scale 3 }
		finish { ambient .7 diffuse .7 specular .8 roughness .05 }
	}

//------------- MultiColor Textures -------------------

#declare BlackYellowStripes =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 color rgb<0,0,0> ]
				[ 0.5 color rgb<0,0,0> ]
				[ 0.5 color rgb<1,1,0> ]
				[ 0.5 color rgb<1,1,0> ]
			}
		}
		normal { bumps .12 scale 3 }
		finish { ambient .1 diffuse .7 specular .8 roughness .04 }
	}


//------------- Chrome Textures -------------------

#declare MirrorTex =
	texture {
		pigment { Black }
		finish { ambient .00 reflection 1.0 }
	}
#declare VChromeTex = // robot arm
	texture {
		pigment { rgb<1,1,1> }
		normal { bumps .05 scale <3,3,20> }
		finish { ambient .05 reflection .93 }
	}
#declare ChromeTex = // big engine ring
	texture {
		pigment { rgb<.84,.84,.84> }
		finish { ambient .23 diffuse .3 brilliance 7.5
			phong .7 phong_size 10 roughness .9 reflection .54 }
	}

//------------- Metal Textures -------------------

#declare SteelTex =
	texture {
		pigment { White }
		normal { bumps .12 scale 4 }
		finish { ambient .05 specular .95 roughness .003 metallic reflection 0.13 }
	}
#declare BrightMetal = // alignment pins
	texture {
		pigment { rgb<.84,.84,.84> }
		finish { ambient .18 diffuse .3 brilliance 7.5 metallic
			phong .7 phong_size 10 roughness .9 reflection .24 }
	}
#declare DullMetal =
	texture {
		pigment { color rgb<.5,.5,.56> }
		normal { bumps .2 scale .4 }
		finish { ambient .12 specular .5 roughness .14 metallic }
	}
#declare DarkMetal =
	texture {
		pigment { color rgb<.23,.25,.28> }
		normal { bumps .3 scale 1.4 }
		finish { ambient .12 specular .5 roughness .14 metallic }
	}
#declare CastMetalTex =
	texture {
		pigment { color rgb<.44,.48,.46> }
		normal { bumps .2 scale 1.4 }
		finish { ambient .18 specular .7 roughness .14 metallic }
	}

//------------- Glass Textures -------------------
#declare AFGlass1 = // SkyTrain open car
      texture {
//        pigment { color rgbf<.75,.75,.95,.82> }
        pigment { color rgbf<.75,.75,.95,.98> }
        finish {phong .6 phong_size 200
          refraction 1
          ior 1.05
          reflection .32
        }
      }

#declare AFClearGlass = // old truck windshield
      texture {
//        pigment { color rgbf<.75,.75,.95,.88> }
        pigment { color rgbf<.95,.95,.75,.88> }
        finish {phong .6 phong_size 200
          refraction 1
          ior 1.5
          reflection .12
        }
      }

#declare ConnectorGlass = // platform walkway
      texture {
//        pigment { color rgbf<.75,.75,.95,.88> }
        pigment { color rgbf<.92,.97,.88,.92> }
        finish {phong .6 phong_size 200
          refraction 1
          ior 1.02
          reflection .22
        }
      }
#declare BigGlass = // rose garden
      texture {
        pigment {
					crackle
					color_map {
						[ 0.00 rgbf<.92,1.27,.93,.5> ]
						[ 0.07 rgbf<.92,.97,.88,.92> ]
						[ 1.00 rgbf<.92,.97,.88,.92> ]
					}
					scale 120
				}
        finish {phong .6 phong_size 200
          refraction 1
          ior 1.001
          reflection .12
        }
      }
#declare GBlueGlass =
      texture {
        pigment { color rgbf<.88,.82,.98,.9> }
        finish {
          specular .85
          roughness .002
          refraction 1
          ior 1.5
          reflection .24
        }
      }

#declare AFGoldGlass =
      texture {
        pigment { color rgbf<.88,.88,.68,.9> }
        finish {
          specular .8
          roughness .02
          refraction 1
          ior 1.5
          reflection .2
        }
      }

//------------- Rock Textures -------------------

#declare BrownRock =
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgb<.45,.32,.08> ]
				[0.0 color rgb<.54,.42,.12> ]
				[0.0 color rgb<.50,.48,.16> ]
			}
		}
		normal { bumps .5 scale 3 }
		finish { ambient .1 specular .4 roughness .08 }
	}
#declare LtGreyRock =
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgb<.75,.85,.68> ]
				[0.0 color rgb<.84,.72,.82> ]
				[0.0 color rgb<.70,.68,.76> ]
			}
		}
		normal { bumps .5 scale 20 }
		finish { ambient .1 specular .6 roughness .02 }
	}
#declare MedGreyRock =
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgb<.45,.35,.48> ]
				[0.0 color rgb<.54,.42,.42> ]
				[0.0 color rgb<.50,.48,.56> ]
			}
		}
		normal { bumps .5 scale 20 }
		finish { ambient .1 specular .6 roughness .02 }
	}
