
// Glenn's POV-Ray Animation File - Air Freight Opening Credits
// created 16-Mar-98
// last update 21-Mar-98
// copyright 1998 Glenn McCarter

//#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================


#if ( clock <= 150 )
	#declare Sclock = clock/150 // scene clock goes from 0 to 1 within scene
	#include "Scene0.pov"
#end
