
// Glenn's Earth POV-Ray Object File
// This file does not render.  #include "BigEarth.inc" in another .pov file
// created 21-Mar-98  updated 21-Mar-98
// copyright 1998 Glenn McCarter

// A flat plane world, with clouds in sky, fog,
// and a Sun definition
// Intended scale is English system (inches), ground is +Z
// Origin in the middle of the ground plane


//===============================================
//             Textures
//===============================================

#declare GroundTex =
	texture {
		pigment { color rgb<.51,.43,.40>*.7 }
		normal { bumps .7 scale 1/20 }
		finish { ambient .6 specular .2 roughness .2 }
	}
#declare SeaTex =
	texture {
		pigment { color rgb<.36,.44,.65> }
		normal { bumps .2 scale 30 }
		finish { ambient .1 specular 1 roughness .02 reflection .1 }
	}
#declare EarthTex =
	texture {
		bozo
		texture_map {
			[ 0.0 GroundTex ]
			[ 0.40 GroundTex ]
			[ 0.45 SeaTex ]
			[ 1.0 SeaTex ]
		}
		translate -1
		scale 5*Miles
		turbulence .7
		translate <2*Miles,2*Miles,0>
	}
#declare CloudTex =
	texture {
		pigment {
			bozo
			color_map
			{
				[ 0.1  color rgbt<.4,.4,.4,1.0> ]
				[ 0.4  color rgbt<.5,.5,.5,1.0> ] // clear
				[ 0.7  color rgbt<.86,.86,.96,.7> ]
				[ 1.0  color rgbt<.76,.76,.84,.5> ]
			} // color_map
			scale 10000
			turbulence .5
		}
		normal { bumps .13 scale 400 }
		finish { ambient .75 diffuse .7 specular .2 roughness .05 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }
#declare Sun =
  light_source {
 	  <0,0,0>
//   	colour rgb <5.0, 4.0, 3.0> // blindingly bright
//   	colour rgb <3.7, 2.8, 2.0> // pretty darn bright
   	colour rgb <1.5, 1.2, .9> // fairly bright
//   	colour rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}



//===============================================
//             Environment
//===============================================

#declare Plain =
	plane {
		z,0
		texture { EarthTex }
	}

#declare Clouds =
	plane {
		-z,0
		texture { CloudTex }
	}
#declare FadeOut =
	box {
		<-.1*Miles,-28.0*Miles,-5*Miles>,<.1*Miles,68.0*Miles,5*Miles>
		texture {
			pigment {
				gradient z
				color_map {
					[ 0.00 color rgbt<1.0,1.0,1.3,1> ]
					[ 0.10 color rgbt<1.0,1.0,1.3,1> ] // clear
					[ 0.34 color rgbt<0.8,0.8,1.3,.7> ] // nearly clear
					[ 0.40 color rgbt<0.8,0.8,1.2,.3> ]
					[ 0.42 color rgbt<1.5,1.6,1.8,.3> ] // white stripe
					[ 0.45 color rgbt<1.3,1.3,1.8,.3> ] // blue stripe
					[ 0.50 color rgbt<1.0,1.0,1.3,.1> ]
					[ 0.70 color rgbt<1.0,1.0,1.3,1> ] // clear
					[ 1.00 color rgbt<1.0,1.0,1.3,1> ]
				}
				scale <1,1,10*Miles>
				translate <0,0,5*Miles>
			}
			finish { ambient .4 }
		}
		no_shadow
	}

#ifndef (NoFog) #declare NoFog=0 #end
#if (NoFog=0)
fog {
	fog_type 1 // general fog adds distance
//		distance 12000*Feet
		distance 333000*Feet
		color rgbt<.980,.980,.998,.06> // transmittance (lower trans dulls out sky)
		turbulence .001
	}
#end


