
// Glenn's BigPlatform POV-Ray Object File
// This file does not render.  #include "BigPlatform.inc" in another .pov file
// created 21-Mar-98  updated 2-Apr-98
// copyright 1998 Glenn McCarter

// An orbital space station
// Intended scale is English system (inches)
// Platform sits on +Z plane

//===============================================
//             Textures
//===============================================

#declare PanelColor = color rgb<.28,.30,.84>
#declare DarkColor = color rgb<.08,.22,.54>
#declare PanelTex =
	texture {
		pigment { PanelColor }
		normal { bumps .1 scale 4 }
		finish { ambient .14 diffuse .7  specular .93 roughness .012 }
	}
#declare PanelCellTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.06 color DarkColor ]
				[ 0.06 color PanelColor ]
				[ 0.50 color PanelColor ]
				[ 0.50 color DarkColor ]
				[ 0.52 color DarkColor ]
				[ 0.52 color PanelColor ]
			}
			translate y*20
			scale 2600
		}
		normal { bumps .1 scale 4 }
		finish { ambient .14 diffuse .7  specular .93 roughness .012 }
	}
#declare FakeWindows =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.0 color rgb<1,1,1> ]
				[ 0.7 color rgb<1,1,1> ]
				[ 0.7 color rgbt<1,1,1,1> ]
			}
		}
		finish { ambient 1 }
	}

#declare GreyMetalTex =
	texture {
		pigment { color rgb<.48,.40,.44> } // too pasty
		pigment { color rgb<.78,.68,.72>*1.6 }
		normal { bumps .1 scale 4 }
		finish { ambient .05 diffuse .7 specular .3 roughness .12 }
	}

//===============================================
//             Objects
//===============================================

//------------------ FlightPanels ---------------------
#declare SRHWingAssy =
	union {
		box { // main
			<0,2*Feet,-5*Feet>,<200*Feet,1000*Feet,5*Feet>
			texture { PanelCellTex }
		}
		box {
			<-30*Feet,0,-7*Feet>,<230*Feet,33*Feet,7*Feet>
			texture { PanelTex }
		}
	} // end union
#declare SLHWingAssy = object { SRHWingAssy scale <1,-1,1> }
#declare RHWingAssy =
	union {
		box { // main
			<0,2*Feet,-5*Feet>,<200*Feet,1000*Feet,5*Feet>
			texture { PanelCellTex }
		}
		cylinder { // front edge
			<0,2*Feet,0>,<0,1000*Feet,0>,5*Feet
			texture { PanelTex }
		}
		box { // inboard attach
			<-30*Feet,0,-7*Feet>,<230*Feet,33*Feet,7*Feet>
			texture { PanelTex }
		}

	} // end union
#declare LHWingAssy = object { RHWingAssy scale <1,-1,1> }

#declare SElevatorPanel =
	box {
			<0,-250*Feet,-2*Feet>,<90*Feet,250*Feet,2*Feet>
			texture { PanelTex scale .3 }
		}
#declare ElevatorPanel =
	union {
		box { // main
			<0,-250*Feet,-2*Feet>,<90*Feet,250*Feet,2*Feet>
			texture { PanelCellTex scale .3 }
		}
		box { // end
			<-4*Feet,-248*Feet,-4*Feet>,<94*Feet,-252*Feet,4*Feet>
			texture { PanelTex scale .3 }
		}
		box { // end
			<-4*Feet, 248*Feet,-4*Feet>,<94*Feet, 252*Feet,4*Feet>
			texture { PanelTex scale .3 }
		}
	} // end union
#declare SRudderPanel =
	box {
		<0,-2*Feet,-240*Feet>,<100*Feet,2*Feet,200*Feet>
		texture { PanelTex scale .3 }
	}

//------------------ Supports ---------------------
#declare RoseGarden =
	union {
		cylinder { // grass
			<0,0,0>,<0,0,2*Feet>,28*Feet
			texture { GreenGrass scale 6 }
		}
		cylinder { // ring
			<0,0,0>,<0,0,1.2*Feet>,29.3*Feet
			texture { BrightWhite }
		}
		box { // something inside
			<-6*Feet,0,0>,<14*Feet,3*Feet,5*Feet>
			rotate z*40
			translate <8*Feet,-2*Feet,0>
			texture { LtGreyRock }
		}
		cylinder { // something inside
			<0,0,0>,<0,0,11*Feet>,3*Feet
			translate <-12*Feet,-3*Feet,0>
			texture { BrownRock }
		}
		sphere {
			<0,0,0>,28*Feet
			texture { BigGlass }
		}
	}
#declare FrontSupport =
	union {
		object { RoseGarden translate <160*Feet,0,36*Feet> }
		box { // main
			<-50*Feet,-40*Feet,0>,<300*Feet,40*Feet,32*Feet>
		}
		box { //windows
			<100*Feet,-40.1*Feet,16*Feet>,<200*Feet,-40*Feet,20*Feet>
			texture { FakeWindows scale <400,1,1> }
		}
		box {
			<-68*Feet,-4*Feet,-50*Feet>,<-24*Feet,4*Feet,48*Feet>
		}
		texture { GreyMetalTex }
	}

#declare RearSupport =
	box {
		<0,-20*Feet,0>,<430*Feet,20*Feet,16*Feet>
		texture { GreyMetalTex }
	}
#declare WingSupport =
	box {
		<0,-14*Feet,0>,<68*Feet,14*Feet,82*Feet>
		texture { GreyMetalTex }
	}

#declare ConnectorTube =
	union {
		cylinder {
			<0,-62*Feet,0>,<0,62*Feet,0>,21*Feet
			texture { ConnectorGlass }
		}
		box { // walkway
			<-20*Feet,-62*Feet,-2*Feet>,<20*Feet,62*Feet,2*Feet>
			texture { GreyMetalTex }
		}
	}

#declare Pontoon =
	union {
		cylinder { // long
			<0,0,0>,<150*Feet,0,0>,4*Feet
			texture { PanelTex }
		}
		cylinder { // wide
			<0,0,0>,<10*Feet,0,0>,8*Feet
			texture { PanelTex }
		}
		sphere {
			<0,0,0>,6*Feet
			texture { GreyMetalTex }
		}
	} // end union
		
//------------------ Main Structure ---------------------
#declare WindowCutout =
		box { // window
			<0,-70*Feet,0>,<20*Feet,70*Feet,6*Feet>
			texture { BrightWhite }
		}
#declare SWallTex =
texture {
	material_map{
		gif "QuikWall1.gif"
		texture { Grey30Paint }
		texture { Grey50Paint }
		texture { GreyMetalTex scale 1/120*Feet}
		texture { Grey80Paint }
		texture { WhitePaint }
		texture { Grey50Paint }
		texture { Grey30Paint }
	}
}

#declare SWall =
	height_field {
		gif "QuikWall1.gif"
		smooth
		rotate -90*x
		texture { SWallTex }      // maping the material_map on to the height_field
		rotate <90,0,90>
		translate <0,-0.5,0>
		scale <-400*Feet,2*60*Feet,56*Feet>
 }

#declare MainBody =
	union {
		difference { // cutout windows
			box { // main
				<0,-60*Feet,-60*Feet>,<300*Feet,60*Feet,60*Feet>
				texture { GreyMetalTex }
			}
			box { // inner space
				<10*Feet,-56*Feet,-56*Feet>,<290*Feet,66*Feet,56*Feet>
				texture { BrightWhite }
			}
			object { WindowCutout translate <20*Feet,0,22*Feet> }
			object { WindowCutout translate <91*Feet,0,22*Feet> }
		} // end difference
		box { // long windows
			<0,-60.1*Feet,0>,<120*Feet,-60*Feet,4*Feet>
			texture { FakeWindows scale <200,1,1> }
			translate <160*Feet,0,-35*Feet>
		}
		box { // a window
			<0,-60.1*Feet,0>,<12*Feet,-60*Feet,4*Feet>
			texture { FakeWindows scale <200,1,1> }
			translate <36*Feet,0,-42*Feet>
		}
		box { // a window
			<0,-60.1*Feet,0>,<16*Feet,-60*Feet,3*Feet>
			texture { FakeWindows scale <100,1,1> }
			translate <166*Feet,0,43*Feet>
		}
		object { SWall translate <-6*Feet,0,0> }
		object { SWall translate <-6*Feet,0,-56*Feet> }
	} // end union

//===============================================
//             Assemblies
//===============================================

#declare SBigPlatform = // simple
	union {
		object { SRHWingAssy translate <0, 50*Feet,-90*Feet> }
		object { SLHWingAssy translate <0,-50*Feet,-90*Feet> }
		object { SRHWingAssy translate <0, 50*Feet,140*Feet> }
		object { SLHWingAssy translate <0,-50*Feet,140*Feet> }
		object { MainBody translate <0, 120*Feet,0> }
		object { MainBody translate <0,-120*Feet,0> }
		object { SElevatorPanel translate <-250*Feet,0, -50*Feet> }
		object { SElevatorPanel translate <-250*Feet,0,  50*Feet> }
		object { SRudderPanel translate <460*Feet, 70*Feet,100*Feet> }
		object { SRudderPanel translate <460*Feet,-70*Feet,100*Feet> }
	}
#declare BigPlatform =
	union {
		object { RHWingAssy translate <0, 70*Feet,-90*Feet> }
		object { LHWingAssy translate <0,-70*Feet,-90*Feet> }
		object { RHWingAssy translate <0, 70*Feet,140*Feet> }
		object { LHWingAssy translate <0,-70*Feet,140*Feet> }
		object { Pontoon translate <-160*Feet,-500*Feet,140*Feet> }
		object { Pontoon translate <-160*Feet, 500*Feet,140*Feet> }
		object { MainBody translate <0, 120*Feet,0> }
		object { MainBody translate <0,-120*Feet,0> }
		object { ConnectorTube translate <30*Feet,0*Feet,-10*Feet> }
		object { ConnectorTube translate <93*Feet,0*Feet,50*Feet> }
		object { WingSupport translate <20*Feet,-110*Feet,59*Feet> }
		object { WingSupport translate <20*Feet, 110*Feet,59*Feet> }
		object { FrontSupport translate <-200*Feet,-80*Feet,-40*Feet> }
		object { FrontSupport translate <-200*Feet, 80*Feet,-40*Feet> }
		object { RearSupport translate <120*Feet,-50*Feet,90*Feet> }
		object { RearSupport translate <120*Feet, 50*Feet,90*Feet> }
		object { ElevatorPanel translate <-280*Feet,0, -80*Feet> }
		object { ElevatorPanel translate <-280*Feet,0,  10*Feet> }
		object { SRudderPanel translate <490*Feet, 70*Feet,100*Feet> }
		object { SRudderPanel translate <490*Feet,-70*Feet,100*Feet> }
	}


