
// Glenn's City POV-Ray Object File
// This file does not render.  #include "City.inc" in another .pov file
// created 9-Mar-98  updated 9-Mar-98
// copyright 1998 Glenn McCarter

// A distant small city
// Intended scale is English system (inches)
// City sits on +Z plane, origin at ground level

//===============================================
//             Textures
//===============================================

#declare CityTex =
	texture {
		pigment { color rgb<.99,.99,.99> }
		normal { bumps .13 scale 40 }
		finish { ambient .3 diffuse .7 specular .8 roughness .05 }
	}
#declare RoadTex =
	texture {
		pigment { color rgb<.8,.8,.8> }
		normal { bumps .13 scale 40 }
		finish { ambient .2 diffuse .7 specular .8 roughness .05 }
	}

//===============================================
//             Buildings
//===============================================

#declare TallBuilding =
	box {
		<-30*Feet,-35*Feet,0>,<30*Feet,30*Feet,200*Feet>
		texture { CityTex }
	}

#declare ShortBuilding =
	box {
		<-20*Feet,-20*Feet,0>,<20*Feet,30*Feet,100*Feet>
		texture { CityTex }
	}

#declare DomeHouse =
	union {
		box {
			<-30*Feet,-30*Feet,0>,<30*Feet,30*Feet,15*Feet>
		}
		sphere {
			<0,0,0>,22*Feet
			translate <0,0,15*Feet>
		}
		texture { CityTex }
	}

//===============================================
//             Roads
//===============================================

#declare RadialRoad =
	box {
		<0,-50*Feet,0>,<2*Miles,50*Feet,8>
		texture { RoadTex }
	}
#declare RingRoadInner =
	torus {
		.1*Miles,60*Feet
		rotate x*90
		scale <1,1,.01>
		translate z*8
		texture { RoadTex }
	}
#declare RingRoadOuter =
	torus {
		.3*Miles,60*Feet
		rotate x*90
		scale <1,1,.01>
		translate z*8
		texture { RoadTex }
	}

#declare Roads =
	union {
		object { RadialRoad rotate z*20 }
		object { RadialRoad rotate z*50 }
		object { RadialRoad rotate z*110 }
		object { RadialRoad rotate z*200 }
		object { RadialRoad rotate z*250 }
		object { RadialRoad rotate z*300 }
		object { RadialRoad rotate z*320 }
		object { RingRoadInner }
		object { RingRoadOuter }
	}

#declare City =
	union {
		object { Roads translate z*0 }
		object { TallBuilding rotate z*0 translate <60*Feet,-60*Feet,0> } // main center

		object { DomeHouse rotate z*0 translate <50*Feet,5*Feet,0> }
		object { TallBuilding rotate z*-10 translate <90*Feet,130*Feet,-60*Feet> }
		object { ShortBuilding rotate z*-10 translate <130*Feet,90*Feet,0> }

		object { TallBuilding translate <-140*Feet,-140*Feet,-50*Feet> }
		object { ShortBuilding translate <-80*Feet,-90*Feet,0> }
		object { ShortBuilding rotate z*50 translate <150*Feet,220*Feet,-20*Feet> }
		object { ShortBuilding rotate z*-20 translate <-280*Feet,120*Feet,-40*Feet> }
		object { ShortBuilding rotate z*-120 translate <-120*Feet,-320*Feet,-60*Feet> }
		object { DomeHouse rotate z*0 translate <-300*Feet,-140*Feet,0> }
		object { DomeHouse rotate z*0 translate <-180*Feet,200*Feet,0> }
		object { DomeHouse rotate z*20 translate <-350*Feet,10*Feet,0> }
		object { DomeHouse rotate z*-60 translate <-240*Feet,-270*Feet,0> }
		object { DomeHouse rotate z*0 translate <-140*Feet,-330*Feet,0> }
	}
