// Glenn's Container POV-Ray Object File
// This file does not render.  #include "Container.inc" in another .pov file
// created 7-Mar-98  updated 31-Mar-98
// copyright 1998 Glenn McCarter

// A metal shipping crate with large, separate lid
//
// Lid
// Base
// ContainerAssy
//
// Intended scale is English system (inches)
// Container sits on +X+Z plane, origin at ground level


//===============================================
//             Textures
//===============================================

#declare OuterTex =
	texture {
		pigment { color rgb<.38,.40,.64> }
		normal { bumps .13 scale 40 }
		finish { ambient .1 diffuse .7 specular .8 roughness .05 }
	}

#declare InnerLightTex =
	texture {
		pigment { color rgb<.7,.73,.91> }
		normal { bumps .1 scale 3 }
		finish { ambient .7 diffuse .7 specular .8 roughness .05 }
	}

#declare InnerTex = // test
	texture {
		pigment {
			gradient z
			color_map {
//				[ 0.0 color rgb<.3,.3,.3> ]
//				[ 0.3 color rgb<.31,.31,.31> ]
				[ 0.0 color rgb<.50,.50,.50> ]
				[ 0.3 color rgb<.51,.53,.60> ]
				[ 0.6 color rgb<.83,.85,.91> ]
				[ 1.0 color rgb<.83,.85,.91> ]
			}
			translate z*-2.6
			scale 14
		}
		normal { bumps .1 scale 3 }
		finish { ambient .4 diffuse .7 specular .8 roughness .05 }
	}

//===============================================
//             Objects
//===============================================



#declare BoxWidth = 14*Feet
#declare BoxHeight = 9*Feet
#declare BoxLength = 36*Feet
#declare CrossWidth = 20*Feet
#declare CrossLength = 11*Feet
#declare RidgeWidth = 12
#declare RidgeHeight = 6
#declare SplitLine = 3*Feet
#declare SplitGap = 1.0
#declare SimpleBase =
	difference {
		union {
			box { // main
				<-BoxLength/2,-BoxWidth/2,6>,<BoxLength/2,BoxWidth/2,SplitLine>
			}
			box { // cross
				<-CrossLength/2,-CrossWidth/2,6>,<CrossLength/2,CrossWidth/2,SplitLine>
			}
			box {
				<-BoxLength/2+RidgeWidth,-BoxWidth/2-6,0>,<-BoxLength/2+2*RidgeWidth,BoxWidth/2+6,SplitLine>
			}
			box {
				<-9*Feet,-BoxWidth/2-6,0>,<-8*Feet,BoxWidth/2+6,SplitLine>
			}
			box {
				<8*Feet,-BoxWidth/2-6,0>,<9*Feet,BoxWidth/2+6,SplitLine>
			}
			box {
				<BoxLength/2-2*RidgeWidth,-BoxWidth/2-6,0>,<BoxLength/2-RidgeWidth,BoxWidth/2+6,SplitLine>
			}
			texture { OuterTex }
		} // end union
		union {
			box {
				<-BoxLength/2+.5*Feet,-BoxWidth/2+6,1*Feet>,<BoxLength/2-.5*Feet,BoxWidth/2-6,6*Feet>
			}
			box {
				<-CrossLength/2+6,-CrossWidth/2+6,1*Feet+.1>,<CrossLength/2-6,CrossWidth/2-6,6*Feet>
			}
			texture { InnerTex }
		} // end union
	} // end difference

#declare LiftingHole =
	cylinder {
		<3,0,0>,<-3,0,0>,4.6
		texture { OuterTex }
	}
#declare HoleRing =
	cylinder {
		<.5,0,0>,<-.5,0,0>,7
		texture { OuterTex }
	}
#declare SimpleLid =
	difference {
		union {
			box { // main
				<-BoxLength/2,-BoxWidth/2,SplitLine+SplitGap>,<BoxLength/2,BoxWidth/2,BoxHeight>
			}
			difference { // subtract the holes
				union {
					box { // cross
						<-CrossLength/2,-CrossWidth/2,SplitLine+SplitGap>,<CrossLength/2,CrossWidth/2,BoxHeight>
					}
					object { HoleRing translate<-CrossLength/2,-CrossWidth/2+18,SplitLine+25> }
					object { HoleRing translate<-CrossLength/2, CrossWidth/2-18,SplitLine+25> }
					object { HoleRing translate< CrossLength/2,-CrossWidth/2+18,SplitLine+25> }
					object { HoleRing translate< CrossLength/2, CrossWidth/2-18,SplitLine+25> }
				} // end union
				object { LiftingHole translate <-CrossLength/2,-CrossWidth/2+18,SplitLine+25> }
				object { LiftingHole translate <-CrossLength/2, CrossWidth/2-18,SplitLine+25> }
				object { LiftingHole translate < CrossLength/2,-CrossWidth/2+18,SplitLine+25> }
				object { LiftingHole translate < CrossLength/2, CrossWidth/2-18,SplitLine+25> }
				} // end difference
			box {
				<-BoxLength/2+RidgeWidth,-BoxWidth/2-6,SplitLine+SplitGap>,<-BoxLength/2+2*RidgeWidth,BoxWidth/2+6,RidgeHeight+BoxHeight>
			}
			box {
				<-9*Feet,-BoxWidth/2-6,SplitLine+SplitGap>,<-8*Feet,BoxWidth/2+6,RidgeHeight+BoxHeight>
			}
			box {
				<8*Feet,-BoxWidth/2-6,SplitLine+SplitGap>,<9*Feet,BoxWidth/2+6,RidgeHeight+BoxHeight>
			}
			box {
				<BoxLength/2-2*RidgeWidth,-BoxWidth/2-6,SplitLine+SplitGap>,<BoxLength/2-RidgeWidth,BoxWidth/2+6,RidgeHeight+BoxHeight>
			}
			texture { OuterTex translate <140,130,120> }
		} // end union
		union {
			box {
				<-BoxLength/2+.5*Feet,-BoxWidth/2+6,1*Feet>,<BoxLength/2-.5*Feet,BoxWidth/2-6,BoxHeight-1*Feet>
			}
			box {
				<-CrossLength/2+.5*Feet,-CrossWidth/2+6,1*Feet-.1>,<CrossLength/2-.5*Feet,CrossWidth/2-6,BoxHeight-1*Feet+.1>
			}
			texture { InnerTex }
		} // end union
	} // end difference

#declare AlignmentPin =
	union {
		cylinder { // main
			<0,0,0>,<0,0,2*Feet>,1.8
		}
		sphere {
			<0,0,0>,1.3
			scale <1,1,.15>
		}
//		texture { BlackYellowStripes } // test
//		texture { ChromeTex }
		texture { BrightMetal }
	}

#declare RoofRib =
	box {
		<-BoxLength/2+3,-4,0>,<BoxLength/2-3,4,8>
		texture { InnerLightTex }
	}
#declare SupportBlocks =
	union {
		box { // main
			<-40,-50,0>,<40,50,12>
			translate <0,0,12>
		}
		box { // wing
			<-4,-30,0>,<4,30,27>
			translate <-15*Feet,0,12>
		}
		box { // wing
			<-4,-30,0>,<4,30,27>
			translate <15*Feet,0,12>
		}
		texture { InnerTex }
	} // end union

//------------ Decorations ------------------
#declare WarningSign =
	box {
		<0,-1.6*Feet,0>,<.2,1.6*Feet,0.8*Feet>
		texture { BlackYellowStripes translate y*5*Feet scale 5 rotate x*45 }
	}
#declare WideLoadSign =
	union  {
		box {
			<0,-6*Feet,0>,<.7,6*Feet,1.4*Feet>
			texture { Grey80Paint }
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"WIDE    LOAD",
			.05,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BlackPaint }
			scale <18,14,1>
			rotate <90,0,-90>
			translate <-.1,5*Feet,3>
		}
	} // end union

//------------ Assemblies ------------------

#declare Base =
	union {
		object { SimpleBase }
//		object { WideLoadSign translate <-BoxLength/2-1,0,9> }
		object { WarningSign translate <-BoxLength/2-1,5.2*Feet,1.9*Feet> } // rear
		object { WarningSign rotate z*180 translate <-BoxLength/2-1,-5.2*Feet,1.9*Feet> } // rear
		object { WarningSign translate <-CrossLength/2-1,8.2*Feet,1.9*Feet> } // side
		object { WarningSign rotate z*180 translate <-CrossLength/2-1,-8.2*Feet,1.9*Feet> } // side
	}
#declare Lid =
	union {
		object { SimpleLid }
		object { AlignmentPin translate <-BoxLength/2+1.5*RidgeWidth,-BoxWidth/2-2,SplitLine+SplitGap-9> }
		object { AlignmentPin translate <-BoxLength/2+1.5*RidgeWidth, BoxWidth/2+2,SplitLine+SplitGap-9> }
		object { AlignmentPin translate < BoxLength/2-1.5*RidgeWidth,-BoxWidth/2-2,SplitLine+SplitGap-9> }
		object { AlignmentPin translate < BoxLength/2-1.5*RidgeWidth, BoxWidth/2+2,SplitLine+SplitGap-9> }
		object { AlignmentPin translate <-8.5*Feet,-BoxWidth/2-4,SplitLine+SplitGap-9> }
		object { AlignmentPin translate <-8.5*Feet, BoxWidth/2+4,SplitLine+SplitGap-9> }
		object { AlignmentPin translate < 8.5*Feet,-BoxWidth/2-4,SplitLine+SplitGap-9> }
		object { AlignmentPin translate < 8.5*Feet, BoxWidth/2+4,SplitLine+SplitGap-9> }
		object { RoofRib translate <0,-2*Feet,BoxHeight-1*Feet-7> }
		object { RoofRib translate <0, 2*Feet,BoxHeight-1*Feet-7> }
		object { WarningSign translate <-BoxLength/2-1,5.2*Feet,3.4*Feet> } // rear
		object { WarningSign rotate z*180 translate <-BoxLength/2-1,-5.2*Feet,3.4*Feet> } // rear
		object { WarningSign translate <-CrossLength/2-1,8.2*Feet,3.4*Feet> } // side
		object { WarningSign rotate z*180 translate <-CrossLength/2-1,-8.2*Feet,3.4*Feet> } // side
	}

#declare ContainerAssy =
	union {
		object { Base }
		object { SimpleLid }
		object { WarningSign translate <-BoxLength/2-1,5.2*Feet,3.4*Feet> } // rear
		object { WarningSign rotate z*180 translate <-BoxLength/2-1,-5.2*Feet,3.4*Feet> } // rear
		object { WarningSign translate <-CrossLength/2-1,8.2*Feet,3.4*Feet> } // side
		object { WarningSign rotate z*180 translate <-CrossLength/2-1,-8.2*Feet,3.4*Feet> } // side

	}

