// Glenn's POV-Ray Lights File
// created 20-June-96 last update 27-May-97
// copyright 1997 Glenn McCarter

// using English coordinate system -- basic unit is Inches
#declare Foot = 12
#declare Feet = 12
#declare Mile = 12*5280
#declare Miles = 12*5280

//-----------------------------------------------
//        Light Bulbs
//-----------------------------------------------

// Standard Lights, no fading --------------------

#declare StdBulb100Watt =
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdBulb75Watt =
  light_source {
    <0,0,0>
    colour rgb <.74, .73, .78>
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdBulb60Watt =
  light_source {
    <0,0,0>
    colour rgb <.64, .58, .60>
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdBulb50Watt =
  light_source {
    <0,0,0>
    colour rgb <.5, .5, .5>
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare StdBulb35Watt =
  light_source {
    <0,0,0>
    colour rgb <.35, .35, .35>
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

// Standard Lights, with fading --------------------

#declare FadeBulb100Watt =
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare FadeBulb75Watt =
  light_source {
    <0,0,0>
    colour rgb <.74, .73, .78>
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare FadeBulb60Watt =
  light_source {
    <0,0,0>
    colour rgb <.64, .58, .60>
		fade_distance 5*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare FadeBulb50Watt =
  light_source {
    <0,0,0>
    colour rgb <.5, .5, .5>
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare FadeBulb35Watt =
  light_source {
    <0,0,0>
    colour rgb <.35, .35, .35>
		fade_distance 10*Feet
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }


// Spot Lights ------------------------

#declare Spot10Deg100Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
    spotlight
    point_at <0,-10,0>
    radius 5    // degrees fully lit (*2)
    falloff 12   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot10Deg75Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.78, .75, .71>
    spotlight
    point_at <0,-10,0>
    radius 5    // degrees fully lit (*2)
    falloff 12   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot10Deg50Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.53, .5, .47>
    spotlight
    point_at <0,-10,0>
    radius 5    // degrees fully lit (*2)
    falloff 12   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot20Deg100Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
    spotlight
    point_at <0,-10,0>
    radius 13    // degrees fully lit (*2)
    falloff 28   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot20Deg75Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.78, .75, .71>
    spotlight
    point_at <0,-10,0>
    radius 13    // degrees fully lit (*2)
    falloff 28   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot20Deg50Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.53, .5, .47>
    spotlight
    point_at <0,-10,0>
    radius 13    // degrees fully lit (*2)
    falloff 28   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot40Deg100Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1

    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot40Deg75Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.78, .75, .71>
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot40Deg50Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.53, .5, .47>
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot40Deg35Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.38, .35, .30>
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot60Deg100Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
    spotlight
    point_at <0,-10,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot60Deg75Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.78, .75, .71>
    spotlight
    point_at <0,-10,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot60Deg50Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.53, .5, .47>
    spotlight
    point_at <0,-10,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Spot60Deg35Watt = // points straight down
  light_source {
    <0,0,0>
    colour rgb <.38, .35, .30>
    spotlight
    point_at <0,-10,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

//-----------------------------------------------
//        Area Lights
//-----------------------------------------------

#declare AreaSpot40Deg50Watt = // points straight down
  light_source {
    <0,0,0> // center
    colour rgb <.53, .5, .47>
    area_light <4,0,0>, <0,0,4>, 4, 4
    adaptive 1
//    jitter 4
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare AreaSpot40Deg75Watt = // points straight down
  light_source {
    <0,0,0> // center
    colour rgb <.78, .75, .71>
    area_light <4,0,0>, <0,0,4>, 4, 4
    adaptive 1
//    jitter 4
    spotlight
    point_at <0,-10,0>
    radius 48    // degrees fully lit (*2)
    falloff 70   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare AreaSpot60Deg75Watt = // points straight down
  light_source {
    <0,0,0> // center
    colour rgb <.78, .75, .71>
    area_light <4,0,0>, <0,0,4>, 4, 4
    adaptive 1
//    jitter 4
    spotlight
    point_at <0,-10,0>
    radius 24    // degrees fully lit (*2)
    falloff 44   // degrees no lighting (*2)
    tightness 1
    looks_like {
      sphere {
        <0,0,0>, .4
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }

#declare Fluor48Tube50Watt = // single tube, 48 points
    light_source {
      <0,0,0>
      color rgb<.48,.51,.55>
      area_light <48,0,0>, <0,0,1>, 24, 2
      adaptive 1
//    jitter 4
      looks_like {
        cylinder {
          <0,0,0>, <48,0,0>, .5
          texture {
            pigment { color rgb<1,1,1> }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }
#declare Fluor48Tube35Watt = // single tube, 48 points
    light_source {
      <0,0,0>
      color rgb<.32,.33,.35>
      area_light <48,0,0>, <0,0,1>, 24, 2
      adaptive 1
//    jitter 4
      looks_like {
        cylinder {
          <0,0,0>, <48,0,0>, .5
          texture {
            pigment { color rgb<1,1,1> }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }
#declare Fluor4Tube50Watt = // single tube, 4 points
    light_source {
      <0,0,0>
      color rgb<.48,.51,.55>
      area_light <48,0,0>, <0,0,1>, 24, 2
      adaptive 1
//    jitter 4
      looks_like {
        cylinder {
          <0,0,0>, <48,0,0>, .5
          texture {
            pigment { color rgb<1,1,1> }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }
#declare Fluor4Tube35Watt = // single tube, 4 points
    light_source {
      <0,0,0>
      color rgb<.32,.33,.35>
      area_light <48,0,0>, <0,0,1>, 24, 2
      adaptive 1
      looks_like {
        cylinder {
          <0,0,0>, <48,0,0>, .5
          texture {
            pigment { color rgb<1,1,1> }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }

//-----------------------------------------------
//        Light Fixtures
//-----------------------------------------------

#declare FluorescentLightFixture = // for a single tube
  union {
    object { torus { // inner shield
      4,.1
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .7 diffuse .2 }}
      rotate z*90 scale <250,1,1> translate <24,-1,0>
      }
      clipped_by {plane{-y,1}}
    }
    object { box { // the near inner end
      <-.1,-1,-5>,<.1,5,5>
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .8 diffuse .2 }}
      clipped_by { cylinder { <-2,0,0>,<2,0,0>,3.4}}
      translate <-1,0,0>
      }
    }
    object { box { // the far inner end
      <-.1,-1,-5>,<.1,5,5>
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .8 diffuse .2 }}
      clipped_by { cylinder { <-2,0,0>,<2,0,0>,3.4 }}
      translate <49,0,0>
      }
    }
    object { torus { // outer shield
      4.5,.1
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .2 diffuse .2 }}
      rotate z*90 scale <250,1,1> translate <24,-1,0>
      }
      clipped_by {plane{-y,1}}
    }
    object { box { // the near outer end
      <-.1,-1,-5>,<.1,5,5>
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .2 diffuse .2 }}
      clipped_by { cylinder { <-2,0,0>,<2,0,0>,4 }}
      translate <-1.1,0,0>
      }
    }
    object { box { // the far outer end
      <-.1,-1,-5>,<.1,5,5>
      texture { pigment { color rgb<1,1,1> }
            finish { ambient .2 diffuse .2 }}
      clipped_by { cylinder { <-2,0,0>,<2,0,0>,4 }}
      translate <49.1,0,0>
      }
    }
  }

#declare HangingLightFixture =
   union {
     cone {
       <0,-2,0>,8.5,<0,3,0>,2
       open
       texture { pigment { color rgb<1,1,1> }
          finish { ambient .5 diffuse .2 }}
     }
     cone {
       <0,-2,0>,8.49,<0,2.98,0>,2
       open
       texture { pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }}
     }
   }

