
// Glenn's BigPlatform POV-Ray Object File
// This file does not render.  #include "BigPlatform.inc" in another .pov file
// created 21-Mar-98  updated 31-Mar-98
// copyright 1998 Glenn McCarter

// A robotic lifting arm
// Intended scale is English system (inches)
//
// RobotArmLH, RH (these have no clamp)
// ClampCyl (for animated scenes)
// RobotArmRetractedLH, RH
// RobotArmClampedLH, RH


//===============================================
//             Test
//===============================================
/*
#include "GIncludeRH.inc"
#include "AFTextures.inc"
#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
  location <-26*Feet, -18*Feet, 6*Feet> // render view
  look_at <0*Feet,0,5*Feet>
  location <-26*Feet, -5*Feet, 6*Feet> // side
  look_at <0*Feet,0,5*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
  Special_Cam
//  Render_Cam
  }
object {StdBulb100Watt translate <-30*Feet,-48*Feet,30*Feet> }
*/

//===============================================
//             Objects
//===============================================

#declare RobotArmLH =
	union {
		cylinder { // main
			<0,0,1>,<0,0,50*Feet>,5.5
			texture { VChromeTex }
		}
		cylinder { // aux
			<0,0,1>,<0,0,50*Feet>,1.5
			texture { VChromeTex }
			translate <12,0,0>
		}
		superellipsoid {
			.3
			scale <15,9,5>
			translate <5,0,2>
			texture { CastMetalTex }
		}
/*
		box { // main
			<-7,-8,0>,<21,8,8>
			texture { CastMetalTex }
		}
*/
		box { // top ridge
			<-5,-3,8>,<15,3,11>
			texture { CastMetalTex }
		}
		cylinder { // bottom casing
			<-4,0,0>,<20,0,0>,3
			translate <0,0,-4>
			texture { CastMetalTex }
		}
		sphere {
			<0,0,0>,3
			scale <.4,1,1>
			translate <-4,0,-4>
			texture { CastMetalTex }
		}
		sphere {
			<0,0,0>,3
			scale <.4,1,1>
			translate <20,0,-4>
			texture { CastMetalTex }
		}
	}
#declare RobotArmRH = object { RobotArmLH scale <-1,1,1> }

#declare ClampCyl =
	cylinder {
		<-8,0,0>,<20,0,0>,3
		texture { VChromeTex }
	}

#declare RobotArmClampedLH =
	union {
		object { RobotArmLH }
		object { ClampCyl translate <-15,0,2> }
	}
#declare RobotArmClampedRH = object { RobotArmClampedLH scale <-1,1,1> }

#declare RobotArmRetractedLH =
	union {
		object { RobotArmLH }
		object { ClampCyl translate <0,0,2> }
	}
#declare RobotArmRetractedRH = object { RobotArmRetractedLH scale <-1,1,1> }


//object { RobotArmRH }
