
// Glenn's POV-Ray Animation File - Air Freight Scene 1, "The Crane"
// created 6-Mar-98
// last update 19-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
#include "TinyPeople.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = 1.0 // 0 to 1.0 for testing


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

//#declare LookPoint = <13*Feet, (-Sclock*Sclock*3*Feet), 8*Feet >
#declare LookPoint = <13*Feet, (-Sclock*Sclock*2*Feet), 8.6*Feet >

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location  <3*Feet, -2*Feet, 5*Feet>
  look_at   LookPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location <-15, -16, 11>
  look_at <0, 0, 0>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

object {FadeBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
object {FadeBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
//object {StdBulb100Watt translate <-10*Feet,2*Feet,8*Feet> }

//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFBuildings.inc"

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Cranes.inc"
#include "Buildings.inc"
#include "TinyFlyers.inc"

#declare MovingStuff =
	union {
		object { Cab }
		object { CEngine scale 1.6 translate <0,-7*Feet,5*Feet> }
		object { CEngine scale 1.6 translate <0, 7*Feet,5*Feet> }
		object { Boom rotate y*-60 translate <3*Feet,0,6*Feet> }
		object { Cable translate <42.8*Feet,0,16*Feet-1> }
		object { Cable translate <42*Feet,6,16*Feet-1> }
		object { Cable translate <42*Feet,-6,16*Feet-1> }
		object { Cable rotate y*38 translate <-10*Feet,-3,23*Feet-1> } // backboom
		object { Cable rotate y*38 translate <-10*Feet, 3,23*Feet-1> } // backboom
		object { Lid rotate z*200 translate <42*Feet,0,7*Feet> }
	}
#declare GrassPlot =
	box {
		<-26*Feet,-25*Feet,0>,<26*Feet,25*Feet,1>
		texture { GreenGrass }
	}

//===============================================
//             Object Placement
//===============================================

object { CraneBase rotate z*150 translate x*74*Feet }
object { MovingStuff rotate z*(Sclock*60-50) rotate z*180 translate x*74*Feet }

object { Bldg1B rotate z*12 translate <130*Feet,80*Feet,0> }
object { GrassPlot rotate z*12 translate <120*Feet,56*Feet,0> }
object { Bldg2B rotate z*12 translate <150*Feet,-50*Feet,0> }
object { Bldg2B rotate z*12 translate <150*Feet,-50*Feet,16*Feet> }
object { Bldg2B rotate z*12 translate <220*Feet,-20*Feet,0> }
object { GrassPlot rotate z*12 translate <100*Feet,-40*Feet,0> }
object { SquareEnd rotate z*12 translate <69*Feet,-24*Feet,0> }
object { CastIronFence rotate z*(12+180) translate <69*Feet,-24*Feet,0> }
object { CastIronFence rotate z*(12+180) translate <70*Feet,-42*Feet,0> }
object { CastIronFence rotate z*(102+180) translate <69*Feet,-24*Feet,0> }
object { CastIronFence rotate z*(102+180) translate <89*Feet,-22*Feet,0> }
object { SquareEnd rotate z*12 translate <70*Feet,-40*Feet,0> }
object { SquareEnd rotate z*12 translate <99*Feet,-20*Feet,0> }

object { GrassPlot rotate z*12 translate <120*Feet,-40*Feet,0> }
object { SmokeStack translate <1200*Feet,400*Feet,0> }
object { SmokeStack translate <1380*Feet,750*Feet,0> }
object { Bldg2B rotate z*102 translate <240*Feet,120*Feet,0> }
object { Fence rotate z*-75 translate <180*Feet,50*Feet,0> }
object { Fence rotate z*-145 translate <50*Feet,180*Feet,0> }

object { DBldg1 scale 2 translate <300*Feet,-250*Feet,0> }
object { Bldg2B rotate z*82 translate <300*Feet,75*Feet,16*Feet> }
object { Bldg2B rotate z*82 translate <300*Feet,75*Feet,0> }

object { TallPole translate <250*Feet,-140*Feet,0> } // rh
object { Tower translate <310*Feet,146*Feet,0> } // lh
object { Tower translate <1030*Feet,-140*Feet,0> } // rh far
object { CylFlyer scale 1.
	rotate z*180 translate <58*Feet+Sclock*80*Feet,0,254*Feet>
	rotate z*140 translate <310*Feet,156*Feet,0>
}
object { VFlyer scale 2
	rotate z*0 translate <400*Feet-Sclock*280*Feet,0,254*Feet>
	rotate z*200 translate <1030*Feet,-146*Feet,0>
}


object { HardWorker rotate z*26 translate <66*Feet,10*Feet,60> } // center
object { HardWorker2 rotate z*60 translate <52*Feet,23*Feet,60> }
object { SuitGuy rotate z*50 translate <54*Feet,22*Feet,60> }

object { JustaGuy rotate z*-5 translate <74*Feet,43*Feet,60> } // far
object { SuitGuy rotate z*-20 translate <72*Feet,40*Feet,60> } // far

object { CopMan rotate z*-60 translate <64*Feet,-27*Feet,60> } // rh


