
// Glenn's POV-Ray Animation File - Air Freight Scene 11, "Credits"
// created 25-Mar-98
// last update 12-Apr-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = .0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================

#declare CameraPos = <-2018*Feet,-2028*Feet,812*Feet>

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>

	angle (29)
//  location <
//		-34*Feet-Sclock*Sclock*2000*Feet,
//		-38*Feet-Sclock*Sclock*2000*Feet,
//		 12*Feet+Sclock*Sclock*800*Feet
//	>
	location CameraPos
  look_at <0,0*Feet,6*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
  location <-26*Feet, -5*Feet, 6*Feet> // side
  look_at <0*Feet,0,5*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {StdBulb100Watt translate <-30*Feet,-48*Feet,30*Feet> }
//object {FadeBulb60Watt translate <-20*Feet,-5*Feet,12*Feet> }
#include "HangarLights.inc"

#declare Sun =
  light_source {
 	  <0,0,0>
//   	color rgb <5.0, 4.0, 3.0> // blindingly bright
//   	color rgb <3.7, 2.8, 2.0> // pretty darn bright
//   	color rgb <1.5, 1.2, .9> // fairly bright - original
   	color rgb <1.3, 1.2, 1.1>*.9 // fairly bright - whiter
//   	color rgb <1, .8, .6> // rather dimmish
//		area_light <.2*Miles,0,0>,<0,.2*Miles,0> 3, 3
	}


//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "BigEarth.inc"
#declare HighView =
	union {
		object { Plain scale 5 rotate y*12 rotate z*45 translate <4*Miles,2*Miles,-6*Miles>+<Sclock*4/7*4*Miles,Sclock*4/7*2*Miles,0> }
		object { Clouds scale 20 rotate y*12 rotate z*45 translate <4*Miles,2*Miles,-6*Miles+1200*Feet>+<Sclock*4/7*4*Miles,Sclock*4/7*2*Miles,0> }
		object { FadeOut rotate z*45 translate <46*Miles,46*Miles,-16*Miles>}
	}
object { HighView rotate <0,-5,0> }


//===============================================
//             Objects
//===============================================

#include "BigPlatform.inc"
#declare OrbitalStation =
	union {
		object { BigPlatform translate <-150*Feet,120*Feet,0> }
	}

#declare FadeBoard =
	box {
		<0,-2.5*Feet,-2*Feet>,<1,2.5*Feet,2*Feet>
		texture {
			pigment { color rgbt<1,1,1,1-Sclock*.5> }
			finish { ambient 0 }
		}
	}
#declare CreditText =
	union {
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Concept, Models, and Animation",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,0>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"by",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-2>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-4>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"For the",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-8>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Internet Raytracing Competition",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-10>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"special thanks to",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-13>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Jamie Vives",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-15>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Scott McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-17>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"and the POV-Ray Team",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-19>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"Glenn McCarter's",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-22>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"AIR",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightBlue }
			scale <2.9,2.5,1>
			rotate <90,0,-90>
//			translate <0,3,-26>
			translate <0,11,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"FREIGHT",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <2.2,1.9,1>
			rotate <90,0,-90>
//			translate <0,-3,-26>
			translate <0,5.5,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"is a subOrbital production",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11,-36>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"copyright 1998",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11,-38>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"all rights reserved",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { BrightWhite }
			scale <1.0,0.9,1>
			rotate <90,0,-90>
			translate <0,11,-39.5>
		}
	} // end union
#declare BackText =
	union {
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Concept, Models, and Animation",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,0>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"by",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-2>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Glenn McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-4>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"For the",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-8>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Internet Raytracing Competition",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-10>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"special thanks to",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-13>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Jamie Vives",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-15>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"Scott McCarter",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-17>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"and the POV-Ray Team",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-19>
		}
/*
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"Glenn McCarter's",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.3,1.2,1>
			rotate <90,0,-90>
			translate <0,11,-22>
		}
*/
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"AIR",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <2.9,2.5,1>
			rotate <90,0,-90>
//			translate <0,3,-26>
			translate <0,11,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"FREIGHT",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <2.2,1.9,1>
			rotate <90,0,-90>
//			translate <0,-3,-26>
			translate <0,5.5,-22.5>
		}
		text {
			ttf "c:\Windows\Fonts\ARIALBD.TTF",
			"is a subOrbital production",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11+.01,-36+.1>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"copyright 1998",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.1,1.0,1>
			rotate <90,0,-90>
			translate <0,11+.01,-38+.1>
		}
		text {
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"all rights reserved",
			.01,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { FlatBlack }
			scale <1.0,0.9,1>
			rotate <90,0,-90>
			translate <0,11+.01,-39.5+.1>
		}
	} // end union

#declare ScrollingCreditsBoard =
	union {
//		object { FadeBoard }
		object { CreditText translate <0,0,sin(Sclock*pi/2)*41> }
		object { BackText translate <.26,-0.03,sin(Sclock*pi/2)*41>-.2 }
	}

#declare ShadeBoard = // shades FadeBoard from the sun
	box {
		<0,-20*Feet,-20*Feet>,<1,20*Feet,20*Feet>
		texture {
			pigment { color rgb<1,.2,.2> }
			finish { ambient 0 }
		}
	}

//===============================================
//             Object Placement
//===============================================


object { OrbitalStation }
object { ScrollingCreditsBoard rotate <0,8,45> translate CameraPos+<3*Feet,3*Feet,-26> }
object { ShadeBoard rotate <0,0,0> translate CameraPos+<-8*Feet,6*Feet,0> }
