
// Glenn's POV-Ray Animation File - Air Freight Scene 2, "The Tease"
// created 6-Mar-98
// last update 7-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = .005 // 0 to 1.0 // early
//#declare Sclock = .595 // 0 to 1.0 // just before contact
//#declare Sclock = .605 // 0 to 1.0 //just after contact
//#declare Sclock = .795 // 0 to 1.0 // just before bottom
//#declare Sclock = .805 // 0 to 1.0 //just after bottom
//#declare Sclock = 1.000 // 0 to 1.0 //end

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location  <-6*Feet, -13*Feet, 6*Feet>
  look_at   <13*Feet, 0, 10*Feet >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location  <2*Feet, -10*Feet, 4*Feet>
  look_at   <13*Feet, 0, -2*Feet >
  }

camera { // special cameras declared in GCamerasRH.inc
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

object {FadeBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }
//object {StdBulb100Watt translate <-20*Feet,-24*Feet,14*Feet> }

//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Truck1.inc"
#include "WrightFlyer.inc"

#declare DBldg1 =
	box {
		<0,0,0>,<60*Feet,50*Feet,22*Feet>
		texture { BrownRock }
	}
#declare DBldg2 =
	box {
		<0,0,0>,<160*Feet,90*Feet,17*Feet>
		texture { LtGreyRock }
	}
#declare DBldg3 =
	box {
		<0,0,0>,<50*Feet,70*Feet,33*Feet>
		texture { WhitePaint }
	}
#declare TallPole =
	cone {
		<0,0,0>,21,<0,0,60*Feet>,14
		texture { WhitePaint }
	}
#declare Tower =
	union {
		cone {
			<0,0,0>,18*Feet,<0,0,360*Feet>,3*Feet
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,240*Feet>
		}
		cylinder {
			<0,0,0>,<0,0,11*Feet>,33*Feet
			translate <0,0,255*Feet>
		}
		texture { WhitePaint }
	}
#declare CraneBase =
	union {
		box {
			<-6*Feet,-8*Feet,0>,<6*Feet,8*Feet,3*Feet>
		}
		cylinder {
			<0,0,3*Feet>,<0,0,4*Feet>,26
		}
		texture { SteelTex }
	}

#declare Boom =
	union {
		box {
			<0,-10,-10>,<80*Feet,10,10>
			texture { BlackPaint }
			translate <0,16,0>
		}
		box {
			<0,-10,-10>,<80*Feet,10,10>
			texture { BlackPaint }
			translate <0,-16,0>
		}
	}
#declare Cab =
	union {
		box {
			<-6*Feet,-6*Feet,0>,<6*Feet,6*Feet,7*Feet>
		}
		box {
			<-6.7*Feet,-6.7*Feet,6.95*Feet>,<6.7*Feet,6.7*Feet,7.2*Feet>
		}
		texture { SteelTex }
		translate <0,0,4*Feet>
	}
#declare Cable =
	cylinder {
		<0,0,0>,<0,0,65*Feet>,.58
		texture { BlackPaint }
	}
#declare MovingStuff =
	union {
		object { Cab }
		object { Boom rotate y*-60 translate <3*Feet,0,6*Feet> }
		object { Cable translate <42.8*Feet,0,13*Feet> }
		object { Cable translate <42*Feet,6,13*Feet> }
		object { Cable translate <42*Feet,-6,13*Feet> }
		object { Lid rotate z*20 translate <42*Feet,0,6*Feet> }
	}

#declare LidwithCables =
	union {
		object { Lid }
		object { Cable translate <.8*Feet,0,9*Feet-1> }
		object { Cable translate <0,6,9*Feet-1> }
		object { Cable translate <0,-6,9*Feet-1> }
	}

#declare TruckwithBase =
	union {
		object { Truck }
		object { Base translate <-18*Feet,0,6*Feet+4.5> }
		object { WrightFlyer rotate z*90 translate <-18*Feet,-18,6*Feet+4.5+24> }
	}

#declare AllMovingStuff =
	union {
		object { LidwithCables translate <-18*Feet,0,7*Feet-7> }
		object { TruckwithBase }
	}

//===============================================
//             Object Placement
//===============================================


#declare SX = (Sclock-.8)/.2   // from 0 to 1 within .8 to 1.0
#declare Bounce = (sin( (SX*2.5*pi/2)+(3*pi/2) )+1) /2 *3  // from 0 to 3
#if ( Sclock < 0.8 ) // going down
	#if (Sclock < 0.6 ) // hasn't hit base yet
		object { TruckwithBase translate <46*Feet,0,0> }
		object { LidwithCables translate <28*Feet,0,9*Feet-(sin(Sclock/.8*pi/2)*2*Feet)-9> }
	#else // everything moving down until hit bottom
		object { AllMovingStuff translate <46*Feet,0,2*Feet-(sin(Sclock/.8*pi/2)*2*Feet)-3> }
	#end
#else // bouncing back up
	object { AllMovingStuff translate <46*Feet,0,Bounce-3> }
#end
object { DBldg1 rotate z*0 translate <350*Feet,360*Feet,0> }
object { DBldg2 rotate z*0 translate <350*Feet,520*Feet,0> }
object { DBldg3 rotate z*30 translate <300*Feet,720*Feet,0> }
object { TallPole translate <340*Feet,520*Feet,0> }
object { TallPole translate <450*Feet,740*Feet,0> }
object { Tower translate <1280*Feet,2440*Feet,0> }
object { DBldg3 scale <2,2,.7> rotate z*-30 translate <560*Feet,1220*Feet,0> }

object { DBldg3 scale <2,2,.7> rotate z*-16 translate <600*Feet,72*Feet,0> }
object { DBldg1 scale <2,2,.7> rotate z*-16 translate <600*Feet,02*Feet,0> }

