
// Glenn's POV-Ray Animation File - Air Freight Scene 4a, "Cruising"
// created 6-Mar-98
// last update 29-Mar-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
#include "AFTextures.inc"
//#include "GRuler.inc"
#declare NoFog = 0
//#declare Sclock = 1.0 // 0 to 1.0


#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

// 176 feet/sec = 120 mph, 3 sec shot
#declare FlyPoint = <(Sclock*176*Feet*3),1,8*Feet>

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 45
  location FlyPoint-<180*Feet,-1,-10*Feet>
  look_at FlyPoint
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location <-2000*Feet, -20*Feet, 4600*Feet> //up very high
//  location <-600*Feet, -20*Feet, 600*Feet> //up fairly high
  location <-60*Feet, -20*Feet, 60*Feet> //slightly high
//  location <-12*Miles, -12*Miles, 6*Miles>
//  location <-120*Miles, -120*Miles, 60*Miles>
//  location <-140*Miles, -140*Miles, 80*Miles>
//  look_at <0, 0, 100*Feet>
//  location FlyPoint-<60*Feet,0,-10*Feet>
//  location FlyPoint-<1200*Feet, 1200*Feet, -600*Feet>
  location FlyPoint-<180*Feet,-1,-100*Feet> // high render
  location FlyPoint-<580*Feet,-1,-300*Feet> // medhigh render
  location FlyPoint-<1280*Feet,-1,-700*Feet> // medhigh render
//  location FlyPoint-<2800*Feet,-1,-1300*Feet> // veryhigh render
  location FlyPoint-<180*Feet,-1,-10*Feet> // render
  look_at FlyPoint

  }

camera { // special cameras declared in GCamerasRH.inc
  Render_Cam
//  Special_Cam
  }

//===============================================
//             Textures
//===============================================



//===============================================
//             Lighting
//===============================================

//object {Fadeulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {FadeBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }



//===============================================
//             Environment
//===============================================

#include "AFEnviron.inc"
object { NearbyMountains rotate z*185 translate <500*Feet,700*Feet,0> texture { EarthTex } }
object { NearbyMountains translate <500*Feet,-700*Feet,0>  texture { EarthTex } }

object { Sun rotate <0,0,40> translate <-20000*Miles,7000*Miles,24000*Miles> }
#include "AFCity.inc"
object { City translate <2*Miles,0,0> }

//===============================================
//             Objects
//===============================================

#include "Container.inc"
#include "Truck1.inc"


#declare LoadedTrailer =
	union {
		object { Trailer }
		object { Base translate <-16*Feet,0,6*Feet+4.5> }
		object { Lid translate <-16*Feet,0,7*Feet-7> }
	}

#declare MovingTruck =
	union {
		object { LoadedTrailer translate <0,0,2*Feet> }
		object { Tractor translate <0,0,2*Feet> }
	}

//===============================================
//             Object Placement
//===============================================

//object { World scale 1 }
//object { LoadedTrailer translate <46*Feet+(Sclock*Sclock*16*Feet),0,2*Feet> }
//object { Tractor rotate z*(Sclock*-24) translate <46*Feet+(Sclock*Sclock*16*Feet),0,2*Feet> }
//object { CraneBase rotate z*150 translate x*74*Feet }
//object { MovingTruck translate y*100*Feet translate <0,0,0> }

