
// Glenn's SkyTrain POV-Ray Object File
// This file does not render.  #include "SkyTrain.inc" in another .pov file
// created 10-Mar-98  updated 29-Mar-98
// copyright 1998 Glenn McCarter

// An orbital transfer vehicle with LEO boosters and standard agrav
//
// SkyTrain (includes container)
// EmptyTrain
//
// Intended scale is English system (inches)
// Train sits on +Z plane, front at origin, extending into +X

//===============================================
//             Textures
//===============================================

#declare TrainTex =
	texture {
		pigment { color rgb<.84,.84,.99> }
		normal { bumps .1 scale 20 }
		finish { ambient .1 diffuse .7 specular .8 roughness .016 reflection .18 }
	}

//===============================================
//             Transformations
//===============================================

#declare ShearXZ03 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
            .3, 0, 1,
             0, 0, 0 >
	}

#declare ShearXZ06 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
            .6, 0, 1,
             0, 0, 0 >
	}


//===============================================
//             Objects
//===============================================

#declare SmallDrive =
	union {
		sphere {
			<0,0,0>,11
			scale <6,1,1>
			texture { TrainTex }
			clipped_by { box{<-5*Feet,-30,-30>,<5*Feet,30,30>}}
		}
		cylinder {
			<-5.3*Feet,0,0>,<5.3*Feet,0,0>,5
			texture { FlatBlack }
		}
		scale 1.6
	}
#declare Booster =
	object { SmallDrive scale 1.6 }
#declare SmallSupportFin =
	cylinder {
		<0,0,0>,<0,0,80>,24
		scale <1,.1,1>
		texture { TrainTex }
	}
#declare BigSupportFin = object { SmallSupportFin scale 1.6 }

#declare LocomotiveBody =
	union {
		cylinder { <6*Feet,0,0>,<60*Feet,0,0>,6*Feet }
		sphere { <0,0,0>,6*Feet scale <.6,1,1> translate <6*Feet,0,0> }
		sphere { <0,0,0>,6*Feet scale <.6,1,1> translate <60*Feet,0,0> }
		sphere { <0,0,0>,5*Feet scale <3,1,1> translate <6*Feet,0,-1*Feet> } // nose
		box { <0,-2,0>,<4*Feet,2,48> transform ShearXZ03 translate <54*Feet,0,5.0*Feet> }
		box { <0,-2,0>,<4*Feet,2,48> transform ShearXZ06 translate <52*Feet,0,5.0*Feet> }
		texture { TrainTex }
	}

#declare Locomotive =
	union {
		object { LocomotiveBody scale <1,1,.8> translate <0,0,4*Feet> }
		object { Booster translate <12*Feet,-12*Feet,0> }
		object { Booster translate <12*Feet,12*Feet,0> }
		object { BigSupportFin rotate x*-60 translate <12*Feet,-12*Feet,0> }
		object { BigSupportFin rotate x*60 translate <12*Feet,12*Feet,0> }
		}

#declare CarBody =
	union {
		cylinder { <0*Feet,0,0>,<50*Feet,0,0>,6*Feet scale <1,1,.8> }
		sphere { <0,0,0>,6*Feet scale <.2,1,.8> }
		sphere { <0,0,0>,6*Feet scale <.2,1,.8> translate <50*Feet,0,0> }
		box { <0,-2,0>,<4*Feet,2,40> transform ShearXZ03 translate <44*Feet,0,4.0*Feet> }
		box { <0,-2,0>,<4*Feet,2,40> transform ShearXZ06 translate <42*Feet,0,4.0*Feet> }
		texture { TrainTex }
	}
#declare Connector =
	cylinder {
		<-6*Feet,0,0>,<0,0,0>,4*Feet
		scale <1,1,.8>
		texture { TrainTex }
	}
#declare CabooseBody =
		sphere {
			<0,0,0>,6*Feet scale <3,1,.8>
			texture { TrainTex }
	}
#declare Caboose =
	union {
		object { CabooseBody translate <0,0,4*Feet> }
		object { SmallDrive scale <.7,1,1> translate <3*Feet,12*Feet,1*Feet> }
		object { SmallDrive scale <.7,1,1> translate <3*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*-75 translate <3*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*75 translate <3*Feet,12*Feet,1*Feet> }
		object { Connector translate <0,0,4*Feet> }
	}


#declare ClearCarBody =
	union {
		difference {
			object { CarBody }
			cylinder { <4*Feet,0,0>,<46*Feet,0,0>,6*Feet scale <1,1,.8> translate <0,0,32> texture { Grey80Paint }}
		} // end difference

		difference { // this is the glass
			cylinder { // outer
				<3.9*Feet,0,0>,<46.1*Feet,0,0>,6*Feet-1
				scale <1,1,.8>
				texture { AFGlass1}
			}
/*
			cylinder { // inner
				<3.8*Feet,0,0>,<46.2*Feet,0,0>,6*Feet-2
				scale <1,1,.8>
				texture { AFGlass1}
			}
*/
			box { // cut off bottom
				<3.7*Feet,-7*Feet,-7*Feet>,<46.3*Feet,7*Feet,0>
				texture { Grey80Paint }
			}
		} // end difference

/*
		cylinder {
			<3.9*Feet,0,0>,<46.1*Feet,0,0>,6*Feet-1
			scale <1,1,.8>
			texture { AFGlass1}
		}
*/
	} // end union
#declare OpenLidCarBody =
	union {
		difference {
			object { CarBody }
			cylinder { <4*Feet,0,0>,<46*Feet,0,0>,6*Feet scale <1,1,.8> translate <0,0,32> texture { Grey80Paint }}
		} // end difference
		difference { // this is the glass
			cylinder { // outer
				<3.9*Feet,0,0>,<46.1*Feet,0,0>,6*Feet-1
				scale <1,1,.8>
				texture { AFGlass1}
			}
			cylinder { // inner
				<3.8*Feet,0,0>,<46.2*Feet,0,0>,6*Feet-2
				scale <1,1,.8>
				texture { AFGlass1}
			}
			box { // cut off bottom
				<3.7*Feet,-7*Feet,-7*Feet>,<46.3*Feet,7*Feet,0>
				texture { Grey80Paint }
			}
			translate y*6*Feet rotate x*110 translate y*-6*Feet
		} // end difference
	} // end union

#declare TrainCar =
	union {
		object { CarBody translate <0,0,4*Feet> }
		object { SmallDrive translate <12*Feet,12*Feet,1*Feet> }
		object { SmallDrive translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*-75 translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*75 translate <12*Feet,12*Feet,1*Feet> }
		object { Connector translate <0,0,4*Feet> }
	}
#declare ClearTrainCar =
	union {
		object { ClearCarBody translate <0,0,4*Feet> }
		object { SmallDrive translate <12*Feet,12*Feet,1*Feet> }
		object { SmallDrive translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*-75 translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*75 translate <12*Feet,12*Feet,1*Feet> }
		object { Connector translate <0,0,4*Feet> }
	}
#declare OpenLidTrainCar =
	union {
		object { OpenLidCarBody translate <0,0,4*Feet> }
		object { SmallDrive translate <12*Feet,12*Feet,1*Feet> }
		object { SmallDrive translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*-75 translate <12*Feet,-12*Feet,1*Feet> }
		object { SmallSupportFin rotate x*75 translate <12*Feet,12*Feet,1*Feet> }
		object { Connector translate <0,0,4*Feet> }
	}

#include "Container.inc"

#declare SkyTrain =
	union {
		object { Locomotive }
		object { ClearTrainCar translate <65*Feet,0,0> }
		object { Base scale .5 translate <120*Feet,0,2*Feet> }
		object { Lid scale .5 translate <90*Feet,0,2*Feet> }
		object { TrainCar translate <120*Feet,0,0> }
		object { TrainCar translate <175*Feet,0,0> }
		object { TrainCar translate <230*Feet,0,0> }
		object { TrainCar translate <285*Feet,0,0> }
		object { Caboose translate <340*Feet,0,0> }
	}

#declare LoadingTrain =
	union {
		object { Locomotive }
		object { OpenLidTrainCar translate <65*Feet,0,0> }
//		object { Base scale .5 translate <120*Feet,0,2*Feet> }
//		object { Lid scale .5 translate <90*Feet,0,2*Feet> }
		object { TrainCar translate <120*Feet,0,0> }
		object { TrainCar translate <175*Feet,0,0> }
		object { TrainCar translate <230*Feet,0,0> }
		object { TrainCar translate <285*Feet,0,0> }
	}
