
// Glenn's Tiny People POV-Ray Object File
// This file does not render.  #include "TinyPeople.inc" in another .pov file
// created 7-Apr-98  updated 12-Apr-98
// copyright 1998 Glenn McCarter

// Various tiny people -- not much detail, only render at a distance!
// Intended scale is English system (inches)
//
// People stand at origin, looking towards -X
// JustaGuy
// CopMan
// HardWorker
// HardWorker2
// SuitGuy

#include "Accessories.inc"


//================================================================
//      Remove this section -- only used for test renders!
//================================================================

/*
#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
  location  <-33, -0, 7> // head front view
  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -136, -15> // overall side view
//  look_at   <0, 0, -21>
//  location  <-136, 0, -15> // overall front view
//  look_at   <0, 0, -21>
  location  <-52, -58, 8> // 3/4 chest overall view
  look_at   <0, 0, -8>
//  location  <-18, -55, 8> // good render view
//  look_at   <-8, 0, -4>
	angle 40
}
camera { Render_Cam }
//object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb60Watt translate <40,-80,70> }
object {StdBulb100Watt translate <-100,-40,80> }
*/


//===============================================
//             Variable Declarations
//===============================================

#ifndef ( Pose )

// RightHand Pose Angles ( in order )
#end


//===============================================
//             Textures
//===============================================

#declare SkinTex =
	texture {
		pigment { color rgb<.9,.8,.5> }
		finish { ambient .12 specular .1 roughness .1 }
	}
#declare HairTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.0  color rgbt<0.3,0.15,0.05,.2> ]
				[ 0.5  color rgbt<0.1,0.04,0.04,.6> ]
				[ 1.0  color rgbt<0.3,0.15,0.05,.2> ]
			}
			turbulence .8
			scale <.15,.15,.15>
		}
		normal { granite .6 scale <.5,.5,.5> }
		finish { ambient .2 specular .1 roughness .05 }
	}

#declare ShoeTex =
	texture {
		pigment { color rgb<.5,.4,.3> }
		finish { ambient .08 specular .9 roughness .01 }
	}
//#declare ClothTex = texture { SuitTex }

//===============================================
//             JustaGuy
//===============================================
#declare Pose = 1
// Pose Angles ( in order )
#declare HPan     = -6   // head, positive = towards his left
#declare HTiltFwd = 15   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = 20   // twists the hand, positive = palms up
#declare REAng    = 128  // elbow
#declare RAFwd    = 3   // total arm
#declare RARot    = 48   // claps hands
#declare RAOut    = 2   // opens underarm
#declare RAFwd2   = -1    // total arm
#declare RARot2   = 38    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 5    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = 140  // twists the hand, positive = palms up
#declare LEAng    = 146   // elbow
#declare LAFwd    = -18   // total arm
#declare LARot    = 42   // claps hands
#declare LAOut    = 3    // opens underarm
#declare LAFwd2   = 0    // total arm
#declare LARot2   = -20  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 5    // spread eagle
#declare ShirtTex = // white
	texture {
		pigment {color rgb<1.15,1.15,1.0>*.8 }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .18 specular .2 roughness .06 }
	}
#declare PantsTex = // Blue
	texture {
		pigment {color rgb<.25,.25,.65> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .2 roughness .05 }
	}

#include "TinyBody.inc"

#declare JustaGuy = //center at base of neck
	union {
		object { MHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso texture { ShirtTex } rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			texture { ShirtTex }
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-6,-1> // hang it on the shoulder
		}
		object { RightArm
			texture { ShirtTex }
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,6,-1> // hang it on the shoulder
		}
		object { LowerTorso
			texture { PantsTex }
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}

//===============================================
//             CopMan
//===============================================

// Pose Angles ( in order )
#declare Pose = 1
#declare HPan     = 32   // head, positive = towards his left
#declare HTiltFwd = 15   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = -30   // twists the hand, positive = palms up
#declare REAng    = 80  // elbow
#declare RAFwd    = -44   // total arm
#declare RARot    = 42   // claps hands
#declare RAOut    = 0   // opens underarm
#declare RAFwd2   = -3    // total arm
#declare RARot2   = 12    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 10    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = -30  // twists the hand, positive = palms up
#declare LEAng    = 50   // elbow
#declare LAFwd    = -26   // total arm
#declare LARot    = 42   // claps hands
#declare LAOut    = -4    // opens underarm
#declare LAFwd2   = -3    // total arm
#declare LARot2   = -20  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 10    // spread eagle

#declare ShirtTex = // Police Blue
	texture {
		pigment {color rgb<.15,.15,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .18 specular .3 roughness .03 }
	}
#declare PantsTex = // Police Blue
	texture {
		pigment {color rgb<.15,.15,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}
#include "TinyBody.inc"

#declare CopMan = //center at base of neck
	union {
		union  {
			object { PoliceHat rotate <0,12,0> translate <0,0,9> } // set it on the head
			object { MHead }
				rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0>
		}
		object { Torso texture { ShirtTex } rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			texture { ShirtTex }
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			texture { ShirtTex }
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}
		object { LowerTorso
			texture { PantsTex }
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
		object { PoliceBadge scale 1.1 translate <-3.6,-5,-1.5> } // on breast
	}

//===============================================
//             HardHatWorker
//===============================================
#declare Pose = 1
// Pose Angles ( in order )
#declare HPan     = 6   // head, positive = towards his left
#declare HTiltFwd = 15   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = 20   // twists the hand, positive = palms up
#declare REAng    = 28  // elbow
#declare RAFwd    = 3   // total arm
#declare RARot    = 12   // claps hands
#declare RAOut    = 12   // opens underarm
#declare RAFwd2   = -18    // total arm
#declare RARot2   = 0    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 5    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = 140  // twists the hand, positive = palms up
#declare LEAng    = 26   // elbow
#declare LAFwd    = -18   // total arm
#declare LARot    = 12   // claps hands
#declare LAOut    = 10    // opens underarm
#declare LAFwd2   = 0    // total arm
#declare LARot2   = -20  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 5    // spread eagle
#declare ShirtTex = // light blue
	texture {
		pigment {color rgb<.55,.75,1.0> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .18 specular .3 roughness .03 }
	}
#declare PantsTex = // Police Blue
	texture {
		pigment {color rgb<.35,.35,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}

#include "TinyBody.inc"

#declare HardWorker = //center at base of neck
	union {
		object { MHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { HardHat rotate <0,12,0> translate <0,0,9> } // set it on the head
		object { Torso texture { ShirtTex } rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			texture { ShirtTex }
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-6,-1> // hang it on the shoulder
		}
		object { RightArm
			texture { ShirtTex }
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,6,-1> // hang it on the shoulder
		}
		object { LowerTorso
			texture { PantsTex }
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}
//===============================================
//             HardHatWorker2
//===============================================
#declare Pose = 1
// Pose Angles ( in order )
#declare HPan     = -13   // head, positive = towards his left
#declare HTiltFwd = 45   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = 20   // twists the hand, positive = palms up
#declare REAng    = 128  // elbow
#declare RAFwd    = 3   // total arm
#declare RARot    = 12   // claps hands
#declare RAOut    = 12   // opens underarm
#declare RAFwd2   = -18    // total arm
#declare RARot2   = 0    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 3    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = 140  // twists the hand, positive = palms up
#declare LEAng    = 96   // elbow
#declare LAFwd    = -18   // total arm
#declare LARot    = 12   // claps hands
#declare LAOut    = 10    // opens underarm
#declare LAFwd2   = 0    // total arm
#declare LARot2   = -20  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 3    // spread eagle
#declare ShirtTex = // light blue
	texture {
		pigment {color rgb<.55,.75,1.0> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .18 specular .3 roughness .03 }
	}
#declare PantsTex = // Police Blue
	texture {
		pigment {color rgb<.35,.35,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}

#include "TinyBody.inc"

#declare HardWorker2 = //center at base of neck
	union {
		object { MHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { HardHat rotate <0,-12,0> translate <-5,0,6> } // set it on the head
		object { Torso texture { ShirtTex } rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			texture { ShirtTex }
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-6,-1> // hang it on the shoulder
		}
		object { RightArm
			texture { ShirtTex }
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,6,-1> // hang it on the shoulder
		}
		object { LowerTorso
			texture { PantsTex }
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}
//===============================================
//             SuitGuy
//===============================================
#declare Pose = 1
// Pose Angles ( in order )
#declare HPan     = -26   // head, positive = towards his left
#declare HTiltFwd = 5   // head forward tilt
#declare HCock    = 0    // head right/left tilt, positive = to the left
#declare TTwist   = 0    // torso twist, positive = right hip fwd
#declare HipTude  = 0    // hip attitude, positive = right hip up
#declare RWCock   = 0    // wrist side-to-side (golf)
#declare RWAng    = 0    // wrist angle
#declare RETwist  = 20   // twists the hand, positive = palms up
#declare REAng    = 11  // elbow
#declare RAFwd    = -38   // total arm
#declare RARot    = 72   // claps hands
#declare RAOut    = -18   // opens underarm
#declare RAFwd2   = 0    // total arm
#declare RARot2   = -10    // claps hands
#declare RKnee    = 0
#declare RLTwist  = 0    // leg twist
#declare RLAng    = 0    // leg angle
#declare RLOut    = 2    // spread eagle
#declare LWCock   = 20   // wrist side-to-side (golf)
#declare LWAng    = 0    // wrist angle
#declare LETwist  = 140  // twists the hand, positive = palms up
#declare LEAng    = 46   // elbow
#declare LAFwd    = -38   // total arm
#declare LARot    = 72   // claps hands
#declare LAOut    = -18    // opens underarm
#declare LAFwd2   = 0    // total arm
#declare LARot2   = -10  // claps hands
#declare LKnee    = 0
#declare LLTwist  = 0    // leg twist
#declare LLAng    = 0    // leg angle fwd
#declare LLOut    = 2    // spread eagle
#declare ShirtTex = // grey
	texture {
		pigment {color rgb<.45,.45,.35> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .18 specular .1 roughness .03 }
	}
#declare PantsTex = // matches
	texture {
		pigment {color rgb<.45,.45,.35> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .1 roughness .03 }
	}

#include "TinyBody.inc"

#declare SuitGuy = //center at base of neck
	union {
		object { MHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso texture { ShirtTex } rotate <0,0,0> translate <0,0,0> }
		object { Tie translate <-4,0,0> }
		object { LeftArm
			texture { ShirtTex }
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-6,-1> // hang it on the shoulder
		}
		object { RightArm
			texture { ShirtTex }
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,6,-1> // hang it on the shoulder
		}
		object { LowerTorso
			texture { PantsTex }
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}

//object { JustaGuy }
//object { CopMan }
//object { HardWorker }
//object { HardWorker2 }
//object { SuitGuy }


