#include "colors.inc"
#include "finish.inc"
#include "skies.inc"

#declare Leather = texture {
pigment {
	granite
	color_map {
		[0.00 color Brown]
		[0.60 color rgbf <0.60, 0.11, 0.11, 0>] // was 0.7
		[0.80 color rgbf <0.68, 0.18, 0.15, 0>] // was 0.9
		[1.00 color rgbf <0.70, 0.20, 0.17, 0>] // was 0.7
		}
	}
finish { specular 0.1 roughness 0.5 }
}


#declare Cover = superellipsoid
{
	<0.05, 0.05>
	scale <2.4, 3, 0.1>
	texture { Leather }
}
#declare PlainCover = superellipsoid
{
	<0.05, 0.05>
	scale <2.4, 3, 0.1>
}

#declare Bind_proto =
difference {
cylinder { <0, 1, 0>, <0, -1, 0>, 0.5 }
box { <0, 1.5, 1.5>, <1, -1.5, -1.5> }
}

#declare Bind = object { Bind_proto
	texture { Leather}
	scale <1, 3, 1>
	translate <-2.4, 0, 0.5>
}

#declare Pages = box
{
	<-2.4, 2.85, 0.1>, <2.25, -2.85, 0.9>
	texture {
		pigment {
			granite
			frequency 10
			color_map {
				[0.25 color White*0.85 transmit min(Clock4*50/35, 1) ]
				[0.5 color rgb <0.65, 0.65, 0.55> transmit min(Clock4*50/35, 1) ]
				[0.75 color White*0.75 transmit min(Clock4*50/35, 1) ]
				[1.00 color rgb <0.75, 0.75, 0.7> transmit min(Clock4*50/35, 1) ]
				}
			}
		finish { diffuse 0.4 roughness 0.01 ambient 0.6}
		//normal { granite scale 0.1 }
		}
}


#declare Book = union {
	object { Bind }
	object { Cover}
	object { Cover translate z*1 }
	object { Pages}
}

#declare ImageTitle =
union {
	text { ttf "timrom.ttf" "Transportation" 1, 0
		pigment { BrightGold }
		finish { Glossy ambient 0.9 diffuse 0.5 }
		translate <-3.4, 2.25, -0.7>
		scale <0.5, 0.7, 1>
	     }
	text { ttf "timrom.ttf" "Aaron Gage" 1, 0
		pigment { BrightGold }
		finish { Glossy ambient 0.9 diffuse 0.5 }
		translate <-2.675, -2.25, -0.7>
		scale <0.55, 0.6, 1>
	     }
}

#declare BookText =
union {
	text { ttf "crystal.ttf" "   The morning sky was dark with clouds over" 0.25, 0
		translate y*5 }
	text { ttf "crystal.ttf" "the fields.  As the sun rose, the grey land-" 0.25, 0
		translate y*4 }
	text { ttf "crystal.ttf" "scape remained grey, and the air held scents" 0.25, 0
		translate y*3 }
	text { ttf "crystal.ttf" "of the coming storm.  The rain began quietly" 0.25, 0
		translate y*2 }
	text { ttf "crystal.ttf" "as it always did, as countless drops glinted" 0.25, 0
		translate y*1 }
	text { ttf "crystal.ttf" "in the weak light.  The rushing hiss of each" 0.25, 0 }
	text { ttf "crystal.ttf" "new drop bending a blade of grass or wetting" 0.25, 0
		translate y*-1 }
	text { ttf "crystal.ttf" "the soil soon filled the air, conjuring from" 0.25, 0
		translate y*-2  }
	text { ttf "crystal.ttf" "the earth a subtle music.                   " 0.25, 0
		translate y*-3  }
	text { ttf "crystal.ttf" "   A gradual cascade of thunder, crashing as" 0.25, 0
		translate y*-4  }
	text { ttf "crystal.ttf" "an avalanche inspired by a flash of lightning" 0.25, 0
		translate y*-5  }

	// approx dimens: 45/2*X 11*Y 0.25*Z

	no_shadow
	texture {
		pigment { color White*0.01 }
		finish { specular 0.25 roughness 0.15 }  //Dull
		}

	translate <-45/4, -0.5, 0.0995>
	scale <4.25/22.5, 5.5/11, 1>
	scale 0.85
	}

#declare Book1 =
union {
  difference {
	object { Cover}
	object { ImageTitle translate z*-0.25 }
	finish { ambient 0.3 }
	}
	object { Bind }
	object { Cover translate z*1 }
	object { Pages}
}

#declare PlainBook =
union {
  difference {
	object { PlainCover pigment { Brown }}
	object { ImageTitle }
	}
  object { ImageTitle translate z*0.68 }
}

#declare Book2 = union {
        object { Bind }
        difference { object { Cover }
		     object { ImageTitle translate z*-0.25 }
		     translate x*2.4
		     rotate y*(sin(Clock2*pi/2) * 125)
		     translate x*-2.4
		   }
        object { Cover translate z*1 }
        object { Pages }
	object { BookText }
	finish { ambient 0.3 }
}

#declare Book3 = union {
	object { Bind }
        difference { object { Cover }
		     object { ImageTitle translate z*-0.25 }
		     translate x*2.4
		     rotate y*125
		     translate x*-2.4
		   }
        //object { Cover translate z*1 }
        object { Pages }
	object { BookText
			pigment { color red max(0.85*(min(Clock4*50/35, 1)), 0.01)
				 green max(0.85*(min(Clock4*50/35, 1)), 0.01)
				 blue max(0.10*(min(Clock4*50/35, 1)), 0.01) }
			finish { reflection 0.35*(min(Clock4*50/35, 1))
				 ambient 0.5*(min(Clock4*50/35, 1)) }
		}
	finish { ambient 0.3 }
}

#declare CloudPlanes = union
{
	plane { z*1, 5 hollow
		texture { T_Cloud3 } }

	plane { z*1, 15 hollow texture { T_Cloud2 rotate z*-30 } }
}


#declare Cloud1 = //box { -1, 1
sphere { 0, 1
	texture {
		pigment { color Clear }
		    halo {
		      attenuating
		      spherical_mapping
		      linear
		      turbulence 1
		      color_map {
			[ 0 color rgbt <1, 1, 1,  1> ]
			[ 1 color rgbt <0.9, 0.9, 0.9, -1> ]
		      }
		      samples 10
		      scale 0.75
		    }
		}
    hollow
    scale <1.5, 0.75, 1>
}

#declare Cloud2 = //box { -1, 1
sphere { 0, 1
        texture {
                pigment { color Clear }
                    halo {
                      attenuating
                      spherical_mapping
                      linear
                      turbulence 1.25
                      color_map {
                        [ 0 color rgbt <1, 1, 1,  1> ]
                        [ 1 color rgbt <0.7, 0.7, 0.7, -1> ]
                      }
                      samples 10
                      scale 0.75
                    }
                }
    hollow
    scale <1.5, 0.75, 1>
}

#declare Cloud3 = //box { -1, 1
sphere { 0, 1
        texture {
                pigment { color Clear }
                    halo {
                      attenuating
                      spherical_mapping
                      linear
                      turbulence 1.5
                      color_map {
                        [ 0 color rgbt <1, 1, 1,  1> ]
                        [ 1 color rgbt <0.6, 0.6, 0.6, -1> ]
                      }
                      samples 10
                      scale 0.75
                    }
                }
    hollow
    scale <1.5, 0.75, 1>
}

#declare Cloud4 = //box { -1, 1
sphere { 0, 1
        texture {
                pigment { color Clear }
                    halo {
                      attenuating
                      spherical_mapping
                      linear
                      turbulence 0.75
                      color_map {
                        [ 0 color rgbt <1, 1, 1,  1> ]
                        [ 1 color rgbt <0.8, 0.8, 0.8, -1> ]
                      }
                      samples 10
		      rotate y*90
                      scale 0.75
                    }
                }
    hollow
    scale <1.5, 0.75, 1>
}

#declare Cloud5 =
object { Cloud4 rotate y*90 }
