//book.pov -- file for generating entire amgtrans.mpg animation
//Copyright (C) 1998  Aaron Gage

#declare Frame = clock*1000
#declare Clock1 = max(min((clock)/0.1000, 1), 0)   	  //range 0-0.1
#declare Clock2 = max(min((clock - 0.1010)/0.0500, 1), 0) //range 0.1-0.15
#declare Clock3 = max(min((clock - 0.1510)/0.0650, 1), 0) //range 0.15-0.215
#declare Clock4 = max(min((clock - 0.2160)/0.0500, 1), 0) //range 0.215-0.265
#declare Clock5 = max(min((clock - 0.2660)/0.0300, 1), 0) //range 0.266-0.295
#declare Clock6 = max(min((clock - 0.2960)/0.0400, 1), 0) //range 0.296-0.335
#declare Clock7 = max(min((clock - 0.3360)/0.0240, 1), 0)
#declare Clock8 = max(min((clock - 0.6000)/0.3600, 1), 0)
#declare Clock9 = max(min((clock - 0.9500)/0.0100, 1), 0)
#declare Clock10 =  max(min((clock - 0.9600)/0.0200, 1), 0)
#declare Clock11 =  max(min((clock - 0.9800)/0.0200, 1), 0)

#include "book.inc"

#switch (clock)

   #range (0.0000, 0.1009)   // Stage 1: zoom into closed book
	  camera {
	    location <0, 0, -100>
	    look_at 0
	    translate z*90*(sin(pi*Clock1 - (pi/2)))
	  }

	light_source { <-60, 40, -100> color White }
	background { color White*0.01 }

	object { Book1
    		rotate <5*cos(Clock1*10*pi), 5*sin(Clock1*10*pi),
				5*sin(Clock1*10*pi + pi/2)> } //reverse the sign of this z rotate
   #break

   #range (0.1010, 0.1509)  // Stage 2: book straightens, cover opens
		camera { location <0, 0, -10> look_at 0 }
		light_source { <-60, 40, -100> color White }
		background { color White*0.01 }

		object { Book2
			rotate <5*(1-Clock2), 0, 5*(1-Clock2)> }
   #break

   #range (0.1510, 0.2159)  // Stage 3: Approach book (normal)
		camera { location <0, 0, -10>
			 look_at 0
			 translate z*(6.5*sin(pi*0.5*Clock3))
			}
		light_source { <-60, 40, -100> color White }
		background { color White*0.01 }

		object { Book2 }
   #break

   #range (0.2160, 0.2659)
		camera { location <0, 0, -3.5>
			 look_at 0
			 translate z*5.0*Clock4
			}
		light_source { <-60, 40, -100> color White }
		background { color White*0.01 }

		object { Book3 }

		#if (Clock4 > 0.0999)
			background { color SkyBlue*0.5 }
			object { CloudPlanes }
		#end
   #break

   #range (0.2660, 0.2959)
		camera { location <0, 0, 0> look_at z*100
			 rotate x*(120*Clock5) translate z*1.5
			 translate z*(sin(pi*(2/3)*Clock5)*3.0)
			 translate y*(-sin(pi*(2/3)*Clock5)*3.0)
			}

		light_source { <-1000, 1000, 1000> color White }
		global_settings { max_trace_level 10 }

		background { color SkyBlue*0.5 }
		object { CloudPlanes }
		// Add a big cloud here
		object { Cloud1 scale 4 rotate x*90 translate <0, -8, 1.51> }
		object { Cloud4 scale 4 rotate x*90 translate <-3, -16.001, 1.51> }
		object { Cloud5 scale 4 rotate x*90 translate <-6.01, -16.001, 1.51> }
		object { Cloud2 scale 4 rotate y*90
			rotate x*90 translate <0, -8, -4.5> }
		object { Cloud3 scale 4 rotate y*-90 rotate x*90
			translate <3.1, -8.001, -4.5> }
		object { Cloud3 scale 4 rotate y*90 rotate x*90
			translate <0, -8.001, -4.5> }
		object { Cloud3 scale 4 rotate y*-90 rotate x*90
			translate <0, -16.001, -4.5> }

		plane { z*-1, 10 hollow
			pigment {
				bozo
				color_map {
					[0 color rgbt <0.8, 0.8, 0.8, 0> ]
					[0.8 color rgbt <0.9, 0.9, 0.9, 0.25> ]
					[1 color Clear ] }
				}
			finish { ambient 0.45 }
			normal { bumps scale 3 }
			}
		plane { z*-1 15 hollow
			pigment { color White*0.5 }
			finish { ambient 0.45 }
			normal { granite scale 2 }
			}
   #break

   #range (0.2960, 0.3359)
		camera { location <0, 0, 0> look_at z*100
			 rotate x*(120) translate z*1.5
			 translate z*(sin(pi*(2/3))*3.0)
			 translate y*(-sin(pi*(2/3))*3.0)

			 //translate z*(-9.95*Clock6)
			 //translate z*(-14*Clock6)
			 translate z*(-16*Clock6)
			 translate y*(-17.32*Clock6)
			}

		light_source { <-1000, 1000, 1000> color White }
		global_settings { max_trace_level 10 }

		background { color SkyBlue*0.5 }
		object { CloudPlanes }
		// Add a big cloud here
		object { Cloud1 scale 4 rotate x*90 translate <0, -8, 1.51> }
		object { Cloud4 scale 4 rotate x*90 translate <-3, -16.001, 1.51> }
		object { Cloud5 scale 4 rotate x*90 translate <-6.01, -16.001, 1.51> }
		object { Cloud2 scale 4 rotate y*90
			rotate x*90 translate <0, -8, -4.5> }
		object { Cloud3 scale 4 rotate y*-90 rotate x*90
			translate <3.1, -8.001, -4.5> }
		object { Cloud3 scale 4 rotate y*90 rotate x*90
			translate <0, -8.001, -4.5> }
		object { Cloud3 scale 4 rotate y*-90 rotate x*90
			translate <0, -16.001, -4.5> }

		plane { z*-1, 10 hollow
			pigment {
				bozo
				color_map {
					[0 color rgbt
						<0.8-0.3*Clock6, 0.8-0.3*Clock6, 0.8-0.3*Clock6, 0> ]
					[0.8 color rgbt <0.9-0.4*Clock6, 0.9-0.4*Clock6, 0.9-0.4*Clock6, 0.25-0.25*Clock6> ]
					[1 color rgbt <1-Clock6*0.5, 1-Clock6*0.5, 1-Clock6*0.5, 1-Clock6> ] }
				}
			finish { ambient 0.45 }
			normal { bumps scale 3 }
                        }
                plane { z*-1 15 hollow
                        pigment { color White*0.5 }
                        finish { ambient 0.45 }
                        normal { granite scale 2 }
                        }
   #break

   #range (0.3360, 0.3599)

	camera { location <50, 50, -350+(Clock7*50)> look_at -20 }

	background { color White*0.6 }

	light_source { <-1000, 1000, -1000>, color White
		//atmospheric_attenuation on
		atmosphere off }

	#declare Atmos = atmosphere {
	  type 1
	  samples 20        // Number of samples in first distance interval
	  distance 1000      // Atmosphere density, similar to fog
	  scattering 0.3    // Reflectivity of atmosphere, determines brightness
	  aa_level 8        // Level of binary subdivision in case of aa
	  aa_threshold 0.1  // Threshold for aa to push in
	  jitter 0.2        // Amount of sample jittering
	  color rgbft <0.2, 0.2, 0.2, 0.25, 0.35>
	}

	atmosphere { Atmos }

	plane { z*-1, 300 hollow
		pigment {color rgbt <0.5, 0.5, 0.5, Clock7> }
		finish { ambient 0.45 }
		normal {granite scale 2} }

	difference
		{
		plane { y*1, 0 hollow pigment { color Green*0.6 }
			finish { ambient 0.4 }
			normal { bumps } }
		plane { z*-1, -256 pigment { color Green*0.6 } }
		}
		
	height_field {
		gif "book.ghf"
		smooth
		pigment { color Green*0.6 }
		normal { bumps }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <512, 40, 512>
		}

	height_field {
		gif "book1.ghf"
		smooth
		pigment { color Brown*0.7 }
		normal { granite }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <512, 40, 512>
		translate y*0.01
	}

	height_field {
		gif "book2.ghf"
		smooth
		pigment { color Green*0.3 + Brown*0.3 }
		normal { bumps }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <1750, 100, 1500>
		translate <0, -10, 1100>
		}

	height_field {
		gif "book3.ghf"
		smooth
		pigment { color Green*0.6 }
		normal { bumps }
		finish { ambient 0.4 }
		translate -0.5
		scale <512, 40, 512>
		translate x*-490
		}

	height_field {
		gif "book4.ghf"
		smooth
		pigment { 
			gradient y
			pigment_map {
				[0 color Green*0.1 + White*0.3]
				[0.6 color Green*0.1 + White*0.3]
				[0.8 color White ]
				[1 color White ]
				}
			//scale 0.5
			}
		normal { granite scale 100 }
		finish { ambient 0.4 }
		translate -0.5
		scale <8000, 1000, 8000>
		translate <-500, 400, 6000>
	}
	#break

	#range (0.3600, 0.9599)

	camera { location <50, 50, -300> look_at -20 }

	background { color White*0.6 }

	light_source { <-1000, 1000, -1000>, color White
		//atmospheric_attenuation on
		atmosphere off }

	#declare Atmos = atmosphere {
	  type 1
	  samples 20        // Number of samples in first distance interval
	  distance 1000      // Atmosphere density, similar to fog
	  scattering 0.3    // Reflectivity of atmosphere, determines brightness
	  aa_level 8        // Level of binary subdivision in case of aa
	  aa_threshold 0.1  // Threshold for aa to push in
	  jitter 0.2        // Amount of sample jittering
	  color rgbft <0.2, 0.2, 0.2, 0.25, 0.35>
	}

	atmosphere { Atmos }

	height_field {
		gif "book.ghf"
		smooth
		pigment { color Green*0.6 - Green*0.2*Clock8 + Brown*0.1*Clock8}
		normal { bumps }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <512, 40, 512>
		}

	height_field {
		gif "book1.ghf"
		smooth
		pigment { color Brown*0.7 }
		normal { granite }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <512, 40, 512>
		translate y*0.01
	}

	height_field {
		gif "book2.ghf"
		smooth
		pigment { color Green*0.3 + Brown*0.3 }
		normal { bumps }
		finish { ambient 0.4 }
		translate <-0.5, -0.5, -0.5>
		scale <1750, 100, 1500>
		translate <0, -10, 1100>
		}

	height_field {
		gif "book3.ghf"
		smooth
		pigment { color Green*0.6 }
		normal { bumps }
		finish { ambient 0.4 }
		translate -0.5
		scale <512, 40, 512>
		translate x*-490
		}

	height_field {
		gif "book4.ghf"
		smooth
		pigment { 
			gradient y
			pigment_map {
				[0 color Green*0.1 + White*0.3]
				[0.6 color Green*0.1 + White*0.3]
				[0.8 color White ]
				[1 color White ]
				}
			//scale 0.5
			}
		normal { granite scale 100 }
		finish { ambient 0.4 }
		translate -0.5
		scale <8000, 1000, 8000>
		translate <-500, 400, 6000>
	}
	#include "rain.inc"
	object { RainStorm scale 2 translate y*-10 }


difference {
	plane { y*1, -13 + 0.775*Clock8 hollow
                pigment { color rgbf <0.8, 0.8, 1, 1> }
                finish { ambient 0.7 reflection 0.65 refraction 1 ior 1.33 }
                normal { ripples } }
	plane { z*-1, -256 pigment { color rgbf <0.8, 0.8, 1, 1> } hollow }
	}

#declare Tube = cylinder { x*-1, x*1, 0.5
                pigment { color rgbt <0.8, 0.7, 0.9, 0> }
                finish { ambient 2 } no_shadow }

	#switch (clock)
		#range (0.7000, 0.7009)

	light_source { <-25, 660, 3000> color White*0.5
		looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

		#break

		#range (0.7010, 0.7019)
	light_source { <-25, 660, 3000> color White
		looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <175, 550, 3000> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7020, 0.7029)
	light_source { <-25, 660, 3000> color White*0.5
		looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <175, 550, 3000> color White looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <350, 560, 3000> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7030, 0.7039)
	light_source { <175, 550, 3000> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <350, 560, 3000> color White looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7040, 0.7049)

	light_source { <-25, 660, 3000> color White*0.5
		looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <350, 560, 3000> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7510, 0.7519)
	light_source { <-1000, 325, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1100, 335, 2500> color White looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1200, 435, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7520, 0.7529)
	light_source { <-1000, 325, 2500> color White looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1100, 335, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1200, 435, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7530, 0.7539)
	light_source { <-1000, 325, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1100, 335, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}

	light_source { <-1200, 435, 2500> color White looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.7540, 0.7549)
	light_source { <-1100, 335, 2500> color White*0.5 looks_like { Tube scale 250 }
		fade_distance 25 fade_power 2}
		#break

		#range (0.8550, 0.8589)

		#include "light.inc"
	object  { Bolt scale <2, 1, 2> translate <-200, 0, 500>
		pigment { color rgb <0.95, 0.95, 1> }
		finish { ambient 5 } }

	object { BoltFlash scale <2, 1, 2> translate <-200, 0, 500> }
		#break

                #range (0.8590, 0.8629)

		#declare S1 = 7
		#declare S2 = 3
                #include "light.inc"
        object  { Bolt scale <2, 1, 2> translate <-200, 0, 500>
                pigment { color rgb <0.95, 0.95, 1> }
                finish { ambient 5 } }

        object { BoltFlash scale <2, 1, 2> translate <-200, 0, 500> }
                #break

                #range (0.8630, 0.8649)

                #declare S1 = 5
                #declare S2 = 11
                #include "light.inc"
        object  { Bolt scale <2, 1, 2> translate <-200, 0, 500>
                pigment { color rgb <0.95, 0.95, 1> }
                finish { ambient 5 } }

        object { BoltFlash scale <2, 1, 2> translate <-200, 0, 500> }
                #break

		#range (0.9400, 0.9429)
	#include "light.inc"
	object  { Bolt scale <2, 1, 2> translate <0, 0, -100>
		pigment { color rgb <0.95, 0.95, 1> }
		finish { ambient 5 } }

	object { BoltFlash scale <2, 1, 2> translate <0, 0, -100> }

		#break

		#range (0.9500, 0.9599)
	#declare S1 = 23
	#declare S2 = 41
	#include "light.inc"
	object  { Bolt scale <2, 1, 2> translate <20, 0, -250>
		pigment { color rgb <0.95, 0.95, 1> }
		finish { ambient 5 } }

	object { BoltFlash scale <2, 1, 2> translate <20, 0, -250> }
		#break

		#end
	#break

	#range (0.9599, 1)

#include "paneling.inc"
#include "table.inc"

camera { location <0, 4.5, -5.5> look_at y*2 }
background { color White*0.1 }

	#switch (clock)
		#range (0.9599, 0.9809)

	box { <-5, 5, -5.4>, <5, 4, -5.6>
		pigment { color White transmit Clock10 }
		finish { ambient 1 } no_shadow }

		#break

		#range (0.9810, 1)

	box { <-5, 5, -5.4>, <5, 4, -5.6>
		pigment { color White*0.01 transmit (1-Clock11) }
		finish { ambient 1 } no_shadow }

		#break
		#end

light_source { <-50, 100, -40> color White*0.6
	spotlight
	point_at <0, 3, 0>
	radius 1.5
	falloff 3
	fade_distance 100
	fade_power 2
	tightness 10
	}

light_source { <-50, 100, -40> color rgb <1, 1, 0.9>*0.8 shadowless
	atmosphere off }

object { Book1 scale 0.35 rotate x*90 rotate y*10 translate y*3.36 }
object { Table }

union {
	object { PanelWall translate <-10, 0, 7> }
	box { <-10, 5, 6.95>, <10, 6.75, 7.25> texture { T_Wood19 } }
	finish { ambient 1 }
	scale x*1.15
}

plane { y*1, 0 pigment { hexagon
		pigment { White*0.1 }
		pigment { White*0.35 }
		pigment { White*0.6 }
		}
	finish { reflection 0.35 roughness 0.0001 specular 0.25 } 
	//normal { granite scale <0.5, 0.05, 0.5> }
	} //floor

plane { z*1, 7.25 pigment { color White*0.6 } normal { dents scale 0.25 } }

	#break

#end
