    Rainsim version 1.0 for creation of particle-like rain objects
    Copyright (C) 1998  Aaron Gage

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include <stdio.h>
#include <signal.h>

#define X_WIDTH	512
#define Z_WIDTH	512	/* One meg total space needed */

#define MAX(a, b) ((a > b)?a:b)

/* total of 67 million positions drops can be in */

#define SEED	119

#define NUM_SCALES	4
#define UNUSED		0
#define SCALE_TINY	1
#define SCALE_SMALL	2
#define SCALE_NORM	3
#define SCALE_BIG	4

int scales[5] = { 0.01, 2, 3, 4, 5 };  /* scale of 4 is to normal size */
int velocity[5] = { 100, 8, 10, 14, 17 };

typedef unsigned char byte;
void signal_handler();

struct drop_data
{
	byte scale;
	byte height;
};

struct drop_data Cloud[Z_WIDTH][X_WIDTH];
int to_disk;

void update_rain()
{
   FILE *output;
   static int frame = 1;
   int i, num_of_drops;   /* num_of_drops is number added PER FRAME */
   int X, Z;


   if(to_disk && !(output = fopen("rain.inc", "w")))  
	{
	fprintf(stderr, "Cannot open rain.inc for writing new rain pattern.\n\r");
	exit(1);
	}

   /* Here's where we'll determine the number of drops per frame to create,
      based on the frame number.  This is arbitrary, to show the beginning of
      the storm. */

   /* This setup will cause one drop per frame, or 10/second, at the start */

   if(frame < 30) num_of_drops = 1;
   else if(frame < 60) num_of_drops = 10;
   else if(frame < 90) num_of_drops = 50;
   else if(frame < 120) num_of_drops = 100;
   else if(frame < 240) num_of_drops = 150;
   else if(frame < 400) num_of_drops = 200;
   else num_of_drops = 250;

   /* A total of 107,830 drops possible at once */

   /* Advance the old drops first, might free up some space */
   for(Z = 0; Z < Z_WIDTH; Z++)
	for(X = 0; X < X_WIDTH; X++)
		if(Cloud[Z][X].scale != UNUSED)
			{
			Cloud[Z][X].height =
				MAX(0, Cloud[Z][X].height - velocity[Cloud[Z][X].scale]);
			if(Cloud[Z][X].height == 0)
				{
				Cloud[Z][X].scale = 0;  /* it's gone */
				Cloud[Z][X].height = 255; /* so reset */
				}
			}
		

   for(i = 0; i < num_of_drops; i++)
	{
	do {
		X = rand()%X_WIDTH;
		Z = rand()%Z_WIDTH;
	   }
	while(Cloud[Z][X].scale != UNUSED);

	Cloud[Z][X].scale = rand()%NUM_SCALES + 1;
	}

   /* Now write out the entire thing */

if(to_disk)
{
   fprintf(output, "//Rain object created by rainmaker 1.0 (Aaron Gage)\n");
   fprintf(output, "//The object is bounded by <-256, 0, -256>, <256, 255, 256>.\n");
   fprintf(output, "#include \"raindrop.inc\"\n");
   fprintf(output, "#declare RainStorm = union {\n");

   for(Z = 0; Z < Z_WIDTH; Z++)
	for(X = 0; X < X_WIDTH; X++)
		if(Cloud[Z][X].scale)
			fprintf(output, "object{RD scale %d translate<%d,%d,%d>}\n",
				scales[Cloud[Z][X].scale], X, Cloud[Z][X].height,
				Z);
   fprintf(output, "translate <-%1.2f, 0, -%1.2f>\n", X_WIDTH/2.0, Z_WIDTH/2.0);
   fprintf(output, "} //end of union");
   fclose(output);
}
   frame++;
   signal_handler();
}

void signal_handler()
{
   signal(SIGUSR1, update_rain);
}

void main(int argc, char *argv[])
{
   int i, j, loop;
   int first_frame;

   srand(SEED);

   if(argc < 2)
	{
	fprintf(stderr, "Usage: %s <first frame # to output>\n\r", argv[0]);
	exit(1);
	}

   for(i = 0; i < Z_WIDTH; i++)
	for(j = 0; j < X_WIDTH; j++)
		{
		Cloud[i][j].scale = UNUSED;
		Cloud[i][j].height = 255;
		}

   /* Begin propagation of drops.  If this has been restarted, iterate up to
      the given frame. */

   first_frame = atoi(argv[1]);

   to_disk = 0;
   for(loop = 1; loop < first_frame; loop++)
	update_rain();

   /* Now sleep.  The program will be interrupted by signals which will
      cause each update. */

   to_disk = 1;
   signal_handler();
   while(1) pause();
}
