#declare FRAMES = 16

#declare MP = array [14]
#declare Temp_Counter = 0
#while (Temp_Counter < 14)
	#declare MP[Temp_Counter] = array [FRAMES]
#declare Temp_Counter = Temp_Counter +1
#end

#declare LCR	= 0
#declare LQR	= 1
#declare LFAR	= 2
#declare LUAR	= 3
#declare RCR	= 4
#declare RQR	= 5
#declare RFAR	= 6
#declare RUAR	= 7
#declare UBR	= 8
#declare HR		= 9
#declare MR		= 10
#declare MS		= 11
#declare MT		= 12
#declare TIMES	= 13

#declare Frame_Count = 0
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <-120,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-55>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 0

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <-120,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-55>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 1

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	-120>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-150>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 2

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	-130>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-150>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 2.25

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	-120>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-150>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 2.5

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	-130>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-150>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 2.75

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	-120>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-150>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 3

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <90,	0,	0>
#declare MP[LQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[LFAR] [Frame_Count]= <-120,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-55>
#declare MP[RCR]  [Frame_Count]= <90,	0,	0>
#declare MP[RQR]  [Frame_Count]= <-90,	0,	0>
#declare MP[RFAR] [Frame_Count]= <-30,	0,	-40>
#declare MP[RUAR] [Frame_Count]= <-70,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 5

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-90>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	90>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <1080,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 10

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-90>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	90>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 10

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	-90>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	90>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 11

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	90>
#declare MP[LUAR] [Frame_Count]= <30,	0,	0>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	-90>
#declare MP[RUAR] [Frame_Count]= <-30,	0,	0>
#declare MP[UBR]  [Frame_Count]= <90,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 12.5

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	0>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 14

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	0>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <0,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	0,	0>
#declare MP[TIMES][Frame_Count]= 14.715

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	0>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <90,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	-4,	0>
#declare MP[TIMES][Frame_Count]= 15

#declare Frame_Count = Frame_Count + 1
#declare MP[LCR]  [Frame_Count]= <0,	0,	0>
#declare MP[LQR]  [Frame_Count]= <0,	0,	0>
#declare MP[LFAR] [Frame_Count]= <0,	0,	0>
#declare MP[LUAR] [Frame_Count]= <0,	0,	0>
#declare MP[RCR]  [Frame_Count]= <0,	0,	0>
#declare MP[RQR]  [Frame_Count]= <0,	0,	0>
#declare MP[RFAR] [Frame_Count]= <0,	0,	0>
#declare MP[RUAR] [Frame_Count]= <0,	0,	0>
#declare MP[UBR]  [Frame_Count]= <0,	0,	0>
#declare MP[HR]   [Frame_Count]= <0,	0,	0>
#declare MP[MR]   [Frame_Count]= <90,	180,	0>
#declare MP[MS]   [Frame_Count]= <1,	1,	1>
#declare MP[MT]   [Frame_Count]= <0,	-4,	0>
#declare MP[TIMES][Frame_Count]= 16




#declare LOWER = 0
#declare HIGHER= 1
#declare Count = 0
#while (Count < FRAMES -1)
	#if (MP[TIMES][Count]<clock)
		#if (MP[TIMES][Count]>=MP[TIMES][LOWER])
			#declare LOWER = Count
			#declare ITEM = Count
			#declare HIGHER = Count + 1
		#end
	#else
	#end
#declare Count = Count + 1
#end
#declare Count = (clock - MP[TIMES][LOWER]) / (MP[TIMES][HIGHER] - MP[TIMES][LOWER])
#debug concat("Lower: ",str(LOWER,0,0),",",str(MP[TIMES][LOWER],0,1),", Higher: ",str(HIGHER,0,0),",",str(MP[TIMES][HIGHER],0,1),", Count: ",str(Count,0,3),",",str(MP[TIMES][Count],0,1),", Clock:",str(clock,0,3),"\n")

#declare Left_Calf_Rotate		= (MP[LCR][HIGHER]-MP[LCR][LOWER])*Count+MP[LCR][LOWER]
#declare Left_Quad_Rotate		= (MP[LQR][HIGHER]-MP[LQR][LOWER])*Count+MP[LQR][LOWER]
#declare Left_Fore_Arm_Rotate		= (MP[LFAR][HIGHER]-MP[LFAR][LOWER])*Count+MP[LFAR][LOWER]
#declare Left_Upper_Arm_Rotate	= (MP[LUAR][HIGHER]-MP[LUAR][LOWER])*Count+MP[LUAR][LOWER]
#declare Right_Calf_Rotate		= (MP[RCR][HIGHER]-MP[RCR][LOWER])*Count+MP[RCR][LOWER]
#declare Right_Quad_Rotate		= (MP[RQR][HIGHER]-MP[RQR][LOWER])*Count+MP[RQR][LOWER]
#declare Right_Fore_Arm_Rotate	= (MP[RFAR][HIGHER]-MP[RFAR][LOWER])*Count+MP[RFAR][LOWER]
#declare Right_Upper_Arm_Rotate	= (MP[RUAR][HIGHER]-MP[RUAR][LOWER])*Count+MP[RUAR][LOWER]
#declare Upper_Body_Rotate		= (MP[UBR][HIGHER]-MP[UBR][LOWER])*Count+MP[UBR][LOWER]
#declare Head_Rotate			= (MP[HR][HIGHER]-MP[HR][LOWER])*Count+MP[HR][LOWER]
#declare Man_Rotate			= (MP[MR][HIGHER]-MP[MR][LOWER])*Count+MP[MR][LOWER]
#declare Man_Scale			= (MP[MS][HIGHER]-MP[MS][LOWER])*Count+MP[MS][LOWER]
#declare Man_Translate			= (MP[MT][HIGHER]-MP[MT][LOWER])*Count+MP[MT][LOWER]
