// Persistence of Vision Ray Tracer Scene Description File
// File: bctrans.pov
// Vers: 3
// Desc: First: Man in car.  Car crashes into another car.  Man goes flying.
// 2nd: Man lands running.  Plane tries to land on man.
// 3rd: Man runs across railroad tracks.  Man gets hit by train.  Pieces go flying.
// Auth: Ben Chambers

global_settings { assumed_gamma 1.0 }

#declare sky_vect = y

#include "car.inc"

#include "bctrans.inc"

#if (clock<=5)

	#if (clock<2)
		#declare POS = 25*clock*clock
	#else
		#declare POS = 100+(clock-2)*50
	#end // At 5, POS = 250

object {Car translate -z*POS}
object {Car rotate y*-90 translate <40*clock-200,0,-259>}
#declare Man_Translate = Man_Translate + <.75,-2,-POS>
#include "man.inc"
camera {location <6,6,-15-POS*1.05> look_at <0,4,-2-POS>}

#else // clock >5
	#if (clock<10)
	object {Car rotate y*-90 rotate x*(clock-5)*180 translate <0,32.25-5*(clock-7.5)*(clock-7.5),-259-(clock-5)*10>}
	object {Car rotate x*(clock-5)*270 translate <0,125-5*(clock-10)*(clock-10),-250-(clock-5)*20>}
	#declare Man_Translate = Man_Translate + <0,25-4*(clock-7.5)*(clock-7.5),-250-(clock-5)*40>
	#include "man.inc"
	#declare cam_loc = <6,6,-277.5-(clock-5)*28.5>
	#declare lookat = <0,25-4*(clock-7.5)*(clock-7.5),-252-(clock-5)*40>
	#if (lookat.y<4)
		#declare lookat = <lookat.x,4,lookat.z>
	#end
	camera {location cam_loc look_at lookat}

	#declare light_loc = <0,3,-256>
	#declare source_size = (clock-5)/5
	#declare source_color = <1,1,.25>
	#declare show_flare_source = yes
	#declare spot_dist = .1

	#include "nkflare.inc"

	#end
#end

#if (clock>=10)
	#if (clock<15)
	object {Car rotate y*90 translate -z*259}
	#declare Car_Pos = <0,125-5*(clock-10)*(clock-10),-250-(clock-5)*20>
		#if (Car_Pos.y < 3)
		#declare Car_Pos = <Car_Pos.x,3,Car_Pos.z>
		#end
	object {Car rotate x*(clock-5)*270 translate Car_Pos}
	#declare Man_Translate = Man_Translate + <0,0,-450>
	#include "man.inc"
	#declare cam_loc = <6,6,-420>
	#declare lookat = <0,4,-452>
	#end
	#if (clock>=15)
	object {Car rotate y*90 translate -z*259}
	object {Car rotate x*270*10 translate <0,3,-450>}
	#declare Man_Translate = Man_Translate - <0,0,450>
	#include "man.inc"
	#declare cam_loc = <6,6,-420>
	#declare lookat = <0,4,-452> 
	#end
	camera {location cam_loc look_at lookat}

#end

difference {
	plane {y,0 pigment {bozo color_map{[0 color green .5][1 color green 1]}}}
	intersection {
		plane {x,16}
		plane {-x,10}
	}
}
intersection {
	plane {y,0}
	plane {x,16}
	plane {-x,10}
	pigment {
		granite
		color_map {
			[0 color rgb .25]
			[1 color rgb .75]
		}
		scale .1
	}
}

union {
	intersection {
		plane {y,.01}
		plane {x,15}
		plane {-x,-14}
	}
	intersection {
		plane {y,.01}
		plane {-x,9}
		plane {x,-8}
	}
	pigment {color rgb 3}
}

intersection {
	plane {y,.01}
	plane {x,3.25}
	plane {-x,-2.75}
	pigment {
		gradient z
		color_map {
			[0 color rgb <3,3,0>]
			[.25 color rgb <3,3,0>]
			[.25 color transmit 1]
			[1 color transmit 1]
		}
		scale 20
	}
}

#declare light_loc = <-300,200,-1000>
light_source {
	light_loc
	color rgb 1
}
plane {-y,-1000
	pigment {
		bozo
		color_map {
			[0 color rgb <.75,.75,1>]
			[.025 color rgb <.25,.25,1>]
			[1 color blue 1]
		}
		scale 1000
	}
	finish {ambient 1}
}

#declare source_size = .1
#declare source_color = <1,1,.25>
#declare show_flare_source = yes
#declare spot_dist = .1

#include "nkflare.inc"
