#ifndef (Man_Include)
#declare Man_Include = true

#declare Foot = union {
	sphere {z*3/4,1/6}
	cone {z*3/4,1/6,0,1/5}
	sphere {0,1/5}
}

#declare Calf = union {
	cone {0,1/3,y*-2,1/5}
	sphere {0,1/3}
}

#declare Quad = union {
	cone {0,1/2,y*-2,1/3}
	sphere {0,1/2}
}

#declare Torso = union {
	box {<-2/3,0,-.5>,<2/3,2,.5>}
	cylinder {<-2/3,0,0>,<-2/3,2,0>,.5}
	cylinder {<2/3,0,0>,<2/3,2,0>,.5}
	cylinder {<-2/3,0,0>,<2/3,0,0>,.5}
	cylinder {<-4/3,2,0>,<4/3,2,0>,.5}
	sphere {<-2/3,0,0>,.5}
	sphere {<2/3,0,0>,.5}
}

#declare Upper_Arm = union {
	cone {0,1/2,y*-3/2,1/3}
	sphere {0,1/2}
}

#declare Fore_Arm = union {
	cone {0,1/3,y*-3/2,1/4}
	sphere {0,1/3}
}

#declare Head = sphere {y,1/2}

#end

#ifndef (Left_Calf_Rotate) 		#declare Left_Calf_Rotate = <0,0,0>			#end
#ifndef (Left_Quad_Rotate)		#declare Left_Quad_Rotate = <0,0,0>			#end
#ifndef (Left_Fore_Arm_Rotate) 	#declare Left_Fore_Arm_Rotate = <0,0,0>		#end
#ifndef (Left_Upper_Arm_Rotate) 	#declare Left_Upper_Arm_Rotate = <0,0,0>	#end
#ifndef (Right_Calf_Rotate) 		#declare Right_Calf_Rotate = <0,0,0>		#end
#ifndef (Right_Quad_Rotate) 		#declare Right_Quad_Rotate = <0,0,0>		#end
#ifndef (Right_Fore_Arm_Rotate) 	#declare Right_Fore_Arm_Rotate = <0,0,0>	#end
#ifndef (Right_Upper_Arm_Rotate)	#declare Right_Upper_Arm_Rotate = <0,0,0>	#end
#ifndef (Upper_Body_Rotate)		#declare Upper_Body_Rotate = <0,0,0>		#end
#ifndef (Head_Rotate)			#declare Head_Rotate = <0,0,0>				#end
#ifndef (Man_Rotate)			#declare Man_Rotate = <0,0,0>				#end
#ifndef (Man_Scale)			#declare Man_Scale = <1,1,1>				#end
#ifndef (Man_Translate)			#declare Man_Translate = <0,0,0>			#end


union {
	union { // Lower Body
		union { // Entire Left Leg
			union {
				object { Foot translate y*-2}
				object { Calf }
				rotate Left_Calf_Rotate translate <0,-2,0>
			}
			object { Quad }
			rotate Left_Quad_Rotate translate <-2/3,0,0>
		}
		union { // Entire Right Leg
			union {
				object { Foot translate y*-2}
				object { Calf }
				rotate Right_Calf_Rotate translate <0,-2,0>
			}
			object { Quad }
			rotate Right_Quad_Rotate translate <2/3,0,0>
		}
	}
	union { // Entire Upper Body
		object { Torso }
		union { // Left Arm
			union { // Left Fore Arm
				sphere {y*-3/2,1/3}
				object { Fore_Arm }
				rotate Left_Fore_Arm_Rotate translate <0,-3/2,0>
			}
			object { Upper_Arm }
			rotate Left_Upper_Arm_Rotate translate <-4/3,2,0>
		}
		union { // Right Arm
			union { // Right Fore Arm
				sphere {y*-3/2,1/3}
				object { Fore_Arm }
				rotate Right_Fore_Arm_Rotate translate <0,-3/2,0>
			}
			object { Upper_Arm }
			rotate Right_Upper_Arm_Rotate translate <4/3,2,0>
		}
		object { Head rotate Head_Rotate translate <0,2,0> }
	rotate Upper_Body_Rotate
	}
	rotate Man_Rotate
	scale Man_Scale
	translate Man_Translate+y*4*Man_Scale
	texture {
		pigment {color rgb 1}
		finish {specular 1}
	}
}
