// Compelete re-write of bug.pov
// An animated walking bug (6 legs)
// By Doug Partridge <dpartrid@lawson.appcomp.utas.edu.au>

#include "colors.inc"

#declare steps_per_movie = 1

#declare body_scaling = < 1, 0.5, 2>
#declare hip_socket_radius = 0.3
#declare hip_radius = 0.2
#declare thigh_length = 0.75
#declare initial_thigh_rotation = z * 15
#declare knee_radius = 0.15
#declare shin_length = 1
#declare initial_shin_rotation = 20
#declare foot_radius = 0.1

#declare body =
difference
	{
	sphere
		{
		0, 1
		scale body_scaling
		}
	
	#declare loop = 1
	#while (loop < 4)
	sphere
		{
		vrotate(-z, y * loop * 45) * body_scaling, hip_socket_radius
		}

	sphere
		{
		vrotate(-z, -y * loop * 45) * body_scaling, hip_socket_radius
		}
	#declare loop = loop + 1
	#end
	}

#declare y_knee_height = -vrotate(x * thigh_length, initial_thigh_rotation).y
#declare y_shin_height = vrotate(y * shin_length, z * initial_shin_rotation).y

#declare single_leg1 =
union
	{
	#declare knee_position1 = vrotate(vrotate(x * thigh_length, initial_thigh_rotation), -x * 360 * clock * steps_per_movie)
	#declare foot_position1 = knee_position1 - vrotate(y * shin_length, z * initial_shin_rotation)
	//Hip
	sphere
		{
		0, hip_radius
		}

	//Thigh
	cone
		{
		0, hip_radius
		knee_position1, knee_radius
		}

	//Knee
	sphere
		{
		knee_position1, knee_radius
		}

	//Shin
	cone
		{
		knee_position1, knee_radius
		foot_position1, foot_radius
		}

	//Foot
	sphere
		{
		foot_position1, foot_radius
		}
	}

#declare single_leg2 =
union
	{
	#declare knee_position2 = vrotate(vrotate(x * thigh_length, initial_thigh_rotation), -x * 360 * (clock + 0.5) * steps_per_movie)
	#declare foot_position2 = knee_position2 - vrotate(y * shin_length, z * initial_shin_rotation)
	//Hip
	sphere
		{
		0, hip_radius
		}

	//Thigh
	cone
		{
		0, hip_radius
		knee_position2, knee_radius
		}

	//Knee
	sphere
		{
		knee_position2, knee_radius
		}

	//Shin
	cone
		{
		knee_position2, knee_radius
		foot_position2, foot_radius
		}

	//Foot
	sphere
		{
		foot_position2, foot_radius
		}
	}

#declare bug =
union
	{
	object
		{
		body
		}

	object
		{
		single_leg1
		translate vrotate(z, y * 1 * 45) * body_scaling
		}

	object
		{
		single_leg2
		translate vrotate(z, y * 2 * 45) * body_scaling
		}

	object
		{
		single_leg1
		translate vrotate(z, y * 3 * 45) * body_scaling
		}

	object
		{
		single_leg2
		translate vrotate(z, y * 1 * 45) * body_scaling
		scale < -1, 1, 1>
		}

	object
		{
		single_leg1
		translate vrotate(z, y * 2 * 45) * body_scaling
		scale < -1, 1, 1>
		}

	object
		{
		single_leg2
		translate vrotate(z, y * 3 * 45) * body_scaling
		scale < -1, 1, 1>
		}

	#if (knee_position1.y < 0)
		translate -y * knee_position1.y
	#else
		translate -y * knee_position2.y
	#end
	}

plane
	{
	y, 0
	translate -y * (y_knee_height + y_shin_height + 2 * foot_radius)
	pigment
		{
		checker White, Red
		scale y_knee_height * 2
		translate -z * y_knee_height * 4 * clock * steps_per_movie
		}
	}

object
	{
	bug
	pigment
		{
		colour White
		}
	}



light_source
	{
	< -100, 100, -200>
	colour White
	}


camera
	{
	location < -2, 5, -3>
	look_at -y * 0.5
	}
