// this file assumes you have declared:
// yLim = number of units in the y direction
// yOffset = spacing in the y direction
// yStart = starting value for y
// xLim = number of unit in the x direction
// xOffset = spacing in the x direction
// xStart = starting value for x
// elevation = distance above the plane y=0
// GridObject = object to be 'gridded'

#declare xoff = xStart
#declare xCount=0
#while (xCount < xLim)
  #declare yoff = yStart
  #declare yCount=0
  #while (yCount < yLim)
    //#debug concat(str(xoff,3,1), " , ")
    //#debug concat(str(yoff,3,1), "\n")

    object { GridObject translate < xoff , elevation, yoff > }
    #declare yoff=yoff+yOffset
    #declare yCount=yCount+1
  #end
  #declare xoff=xoff+xOffset
  #declare xCount=xCount+1
#end
