
// Bidrag till IRTC:s tredje animationsomgng 15 april - 15 juli 1998
// 1 lngdenhet <=> 1 dm
// 1 tidsenhet <=> 1 s

//--SWITCHAR----------------------------------------------------------------

#declare VHand = 1
#declare HHand = 1
#declare Persienn = 1
#declare SLampa = 1
#declare Duk = 1
#declare Skap = 1
#declare Polisbil = 1
#declare Polis = 1
#declare Trike = 1
#declare Stol = 1

//--DEKLARATIONER-----------------------------------------------------------

background
 {rgb <.5, .7, .9>}

#declare CarClock   = max(-.00001, clock-4)             //clock-4
#declare TrikeClock = max(-.00001, CarClock-5)          //clock-9
#declare PolisClock = max(-.00001, TrikeClock-4.5)      //clock-13.5
#declare DrakClock  = max(-.00001, PolisClock-9.5)      //clock-23


#declare R1 = seed(102)                      //Persienn och polisskjorta
#declare R2 = seed((2+clock)*20)             //Gnistor
#declare R3 = seed(100)                      //Polisbilshjul
#declare R4 = seed(int(clock*2)*100+14)      //Polismannen hoppar framt
#declare testest=rand(R4)
//#debug concat("R4: ", str(testest, 0, 3), "\n")
//#debug concat("clock*2: ", str(int(clock*2), 0, 3), "\n")

#declare Org = <1.4, 0, 8.3>  //<1, 0, 7.5>                                   //Fr fnstret...
#declare FWidth = 8
#declare FHeight = 13
#declare xA = 0.2
#declare xB = 0.2
#declare zA = 0.3
#declare zB = 0.2
#declare RWidth = 0.55

#declare RutWidth = FWidth - xA - xB - 2*RWidth
#declare RutHeight = FHeight - zA - zB - 2*RWidth
#declare RutThick = 0.35


//-Polisbilen patrullerar----

#switch (CarClock)
 #range (-1, 3)
  #declare CarRot = <0, 0, 0>
  #declare CarTrans = <4.7+pi*.09*2.4*CarClock, -5.2, 6.79+.168>
 #break
 #range (3, 4)
  //6,736
  #declare CarRot = <0, 0, 40 - 40*cos((CarClock-3)*pi)>
  //translate <7.6, -4.55, 6.89+.168>
  #declare CarTrans = <4.7+pi*.09*2.4*3 + .87/2 - .87/2*cos((CarClock-3)*pi), -5.2 + .65/2 - .65/2*cos((CarClock-3)*pi), 6.79+.168 + .2*sin((CarClock-3)*pi)>
 #break
 #range (4, 999)
  #declare CarRot = <0, 0, 80>
  #declare CarTrans = <4.7+pi*.09*2.4*3 + .87/2 - .87/2*cos((4-3)*pi), - 5.2 + .65/2 - .65/2*cos((4-3)*pi), 6.79+.168 + .2*sin((4-3)*pi)>
#end

//-Trikens frd--------------

#declare TrikeSnurraRot = <0, 0, 0>
#declare TrikeTravelRot = -15
#declare TrikeRotFactor = <cos(radians(TrikeTravelRot)), sin(radians(TrikeTravelRot)), 0>
#declare TWExtraRot = <0, 0, 0>

#switch (TrikeClock)
 #range (-1, 1)
  #declare TrikeTrans = <4.3, -2.2, 7.018> + TrikeRotFactor * (.75-.75*sin((TrikeClock*2-1)*pi/2))
  #declare TrikeBackWheelRot = <0, degrees((-.75*sin((TrikeClock*2-1)*pi/2)) / (2*pi*.118)), 0>
  #declare TrikeFrontWheelRot = <0, degrees((-.75*sin((TrikeClock*2-1)*pi/2)) / (2*pi*.108)), 0>
 #break
 #range (1, 2)
  #declare TrikeTrans = <4.3, -2.2, 7.018> + TrikeRotFactor * ((TrikeClock-1)*1.7)*((TrikeClock-1)*1.7)
  #declare TrikeBackWheelRot = <0, degrees((((TrikeClock-1)*1.7)*((TrikeClock-1)*1.7)) / (2*pi*.118)), 0>
  #declare TrikeFrontWheelRot = <0, degrees((((TrikeClock-1)*1.7)*((TrikeClock-1)*1.7)) / (2*pi*.108)), 0>
 #break
 #range (2, 999)
  #declare TrikeTrans = <4.3, -2.2, 7.018> + TrikeRotFactor * (2.89+(TrikeClock-2)*3.4)
  #declare TrikeBackWheelRot = <0, degrees(((TrikeClock-2)*3.4) / (2*pi*.118)), 0>
  #declare TrikeFrontWheelRot = <0, 0/*((TrikeClock-2)*3.4) / (2*pi*.108)*/, 0>
#end

#if (TrikeClock > 3.275)  //Hjulen stannar
 #declare TrikeBackWheelRot = <0, 0, 0>
 //#declare TWExtraRot = <0, degrees(((TrikeClock-2)*3.4) / (2*pi*.118))  -  (TrikeClock-3.275)*(TrikeClock-3.275)*6 , 0>
#end

#if (TrikeTrans.x > (vrotate(2*<.5, .30, 0>, <0, 0, 80>)+<7.6, -4.55, 6.89+.068>).x)
  #declare CarCollisionTime = (((vrotate(2*<.5, .30, 0>, <0, 0, 80>)+<7.6, -4.55, 6.89+.068>).x-4.3)/cos(radians(TrikeTravelRot))-2.89)/3.2+2
#end

#switch (TrikeClock)
 #range (-1, 1)
  #declare TrikeStegraRot = <0, 0, 0>
 #break
 #range (1, 1.5)
  #declare TrikeStegraRot = <0, -57 + 57*sin((1.5-TrikeClock)*pi), 0>
 #break
 #range (1.5, 1.75)
  #declare TrikeStegraRot = <0, -57 + 12*sin((TrikeClock-1.5)*4*pi), 0>
 #break
 #range (1.75, 999)
  #declare TrikeStegraRot = <0, -57, 0>
 #break
#end

//#if (TrikeTrans.x > (vrotate(2*<.5, .27, 0>, <0, 0, 80>)+<7.6, -4.5, 6.79+.068>).x)
#ifdef (CarCollisionTime)
 #declare TrikeSnurraRot = <-sin((TrikeClock-CarCollisionTime)*pi)*35, 0, 0>
 #declare TrikeRotFactorOld = <cos(radians(TrikeTravelRot)), sin(radians(TrikeTravelRot)), 0>
 //#declare TrikeTravelRot = TrikeTravelRot-7
 #declare TrikeRotFactor = <cos(radians(TrikeTravelRot)), sin(radians(TrikeTravelRot)), 0>
 #declare TrikeTrans = <4.3, -2.2, 7.018> + TrikeRotFactorOld * (2.89+(CarCollisionTime-2)*3.4) + TrikeRotFactor * ((TrikeClock-CarCollisionTime)*3.4)
 #declare TrikeStegraRot = <0, -57+30-30*sin(.5-(TrikeClock-CarCollisionTime)/2), 0>
#end

//#debug concat("TrikeTrans1: ",str(TrikeTrans.x, 0, 3), "\n")

#declare TableCollisionPoint = <.17, .097, -.026>
#declare TableCollisionPointReal = TrikeTrans+vrotate(vrotate(vrotate(TableCollisionPoint, TrikeStegraRot)-y*.18, TrikeSnurraRot)+y*.18, z*TrikeTravelRot)
#if (TrikeTrans.x > 9.07)  //(TableCollisionPointReal.x > 9.20)

//ca .339 frn TCtime tills den slr i bordet igen, 1/.339=2.95

 #declare TableCollisionTime = /*2.61*/(9.07-4.3-cos(radians(TrikeTravelRot))*(2.89+(CarCollisionTime-2)*3.4))/(cos(radians(TrikeTravelRot))*3.4)+CarCollisionTime

 //! #declare TrikeStegraRot = <0, -57+30-30*sin(.5-(TableCollisionTime-CarCollisionTime)/2), 0>
 #declare TrikeStegraRot = <0, max(0, sin(pi/2-(TrikeClock-TableCollisionTime)/.339*pi/2))*(-57+30-30*sin(.5-(TableCollisionTime-CarCollisionTime)/2))
                             + min(1, sin(-pi/2+(TrikeClock-TableCollisionTime)/.339*pi/2)+1)*20
                            , 0>

 #declare TrikeTrans = <4.3, -2.2, 7.018> + TrikeRotFactorOld * (2.89+(CarCollisionTime-2)*3.4) + TrikeRotFactor * ((TableCollisionTime-CarCollisionTime)*3.4)

 //!#declare TrikeSnurraRot = <-sin((TableCollisionTime-CarCollisionTime)*pi)*35, 0, 0>
 //!                        - <35-sin((.5+TrikeClock-TableCollisionTime)*pi)*35, 0, 0>
 #declare TrikeSnurraRot =  x*(max(0, sin(pi/2-(TrikeClock-TableCollisionTime)/.339*pi/2))*(-sin((TableCollisionTime-CarCollisionTime)*pi)*35)
                             + min(1, sin(-pi/2+(TrikeClock-TableCollisionTime)/.339*pi/2)+1)*(-90) )

//- #declare TrikeSnurraRot2 = <0, (TrikeClock-TableCollisionTime)*360, 0>
    #declare TrikeSnurraRot2 = <0, 0, 0>
 #debug "Table-Collision\n"
 //#debug concat("C-TIME: ", str(TableCollisionTime, 0, 3), "\n")
 //#debug concat("TrikeTrans2: ",str(TrikeTrans.x, 0, 3), "\n")
//-#end

//-#if (TrikeClock > 2.679) //Bara empiriskt...
//- #declare TrikeSnurraRot2 = <0, (2.679-TableCollisionTime)*360, 0>
 //!#declare TrikeSnurraRot3 = <0, sin((TrikeClock-TableCollisionTime)*pi*2.7)*40, 0>
 #declare TrikeSnurraRot3 = <0, //max(0, (.339-(TrikeClock-TableCollisionTime))/.339)*sin((TrikeClock-TableCollisionTime)*pi*2.7)*40
                                max(0, sin(pi/2-(TrikeClock-TableCollisionTime)/.339*pi/2))*sin((TrikeClock-TableCollisionTime)*pi*2.7)*40
                              //+ min(1, (TrikeClock-TableCollisionTime)/.339)*10 , 0>
                              + min(1, sin(-pi/2+(TrikeClock-TableCollisionTime)/.339*pi/2)+1)*10  , 0>
 #if (TrikeClock <= 2.949)
  #declare TrikeTrans = TrikeTrans + TrikeRotFactor * ((TrikeClock-TableCollisionTime)*2.75) + z*max(0, sin((TrikeClock-TableCollisionTime)*pi/.339))*.025 //Bromsar med 'hlften'
 //#else
 // #declare TrikeTrans = TrikeTrans + TrikeRotFactor * ((TrikeClock-TableCollisionTime)*2.75)
 #end
#end

#ifdef(TrikeSnurraRot2)
 #declare FrontRotPoint = <.34047, 0, -.118>
 #declare FrontRotPointReal = vrotate(vrotate(vrotate(vrotate(FrontRotPoint, TrikeStegraRot)-y*.18, TrikeSnurraRot)+y*.18, z*TrikeTravelRot), TrikeSnurraRot2)
#end

#ifdef (TrikeSnurraRot3)
// #declare ACollisionPoint = <-.01, .238, -.108>  //ingen TrikeSnurraRot2 -v
// #declare ACollisionPointReal = TrikeTrans+vrotate(vrotate(vrotate(vrotate(TableCollisionPoint, TrikeStegraRot)-y*.18, TrikeSnurraRot)+y*.18, z*TrikeTravelRot)-(FrontRotPointReal-TrikeTrans), TrikeSnurraRot3)+(FrontRotPointReal-TrikeTrans)
 #if (TrikeClock > 2.949)  //#if (ACollisionPointReal.z < 7)
  #declare TrikeTrans = TrikeTrans + TrikeRotFactor * ((2.949-TableCollisionTime)*2.75) + TrikeRotFactor* (min(3.275,TrikeClock)-2.949)*2.75*(1-(min(3.275,TrikeClock)-2.949))*(1-(min(3.275,TrikeClock)-2.949))
  //#declare TrikeTrans = <11, -4, 7>
  #declare TrikeStegraRot  = <0, 20+(min(3.275,TrikeClock)-2.949)*45, 0>
  #declare TrikeSnurraRot  = <-90, 0, 0>
  #declare TrikeSnurraRot3 = <0, 10, 0>                 //Triken stannar nr TrikeClock=3.275 !
  #declare FrontRotPointReal = vrotate(vrotate(vrotate(vrotate(FrontRotPoint, TrikeStegraRot)-y*.18, TrikeSnurraRot)+y*.18, z*TrikeTravelRot), TrikeSnurraRot2)
 #end
#end


//-Polisen kollar lget------

//#declare PolisRot = z*90
//#declare PolisTrans = <5.2, -5, 6.9>

#declare PolisClock2 = (PolisClock*2-int(PolisClock*2))*1.3
#if (PolisClock2 > 1)
 #declare PolisClock2 = 1
#end

#switch (PolisClock)
 #range (-1, 0)
  #declare PolisRot = -z*9
  #declare PolisTrans = Org + <2, -1, -.12>
 #break
 #range (0, 1)
  #declare PolisRot = z*90
  #declare PolisTrans = <4.6+cos(pi/2-min(1, PolisClock*2)*pi/2)*.6, -5, 6.9+max(0, sin(pi/2-PolisClock*pi)*1.5)>
 #break
 #range (1, 2)
  #declare PolisRot = z*(90-min(1, (PolisClock-1)*2)*40)
  #declare PolisTrans = <5.2, -5, 6.9+sin(min(1, (PolisClock-1)*2)*pi)*.2>
 #break
 #range (2, 3)
  #declare PolisRot = z*(50+min(1, (PolisClock-2)*1.8)*80)
  #declare PolisTrans = <5.2, -5, 6.9+sin(min(1, (PolisClock-2)*1.8)*pi)*.2>
 #break
 #range (3, 3.5)
  #declare PolisRot = z*130-z*(PolisClock-3)*2*40
  #declare PolisTrans = <5.2+PolisClock2*.45+int((PolisClock-3)*2)*.45, -5, 6.9+sin(PolisClock2*pi)*(.2+testest*.3)>
 #break
 #range (3.5, 7)
  #declare PolisRot = z*90
  #declare PolisTrans = <5.2+PolisClock2*.45+int((PolisClock-3)*2)*.45, -5, 6.9+sin(PolisClock2*pi)*(.2+testest*.3)>
 #break
 #range (7, 7.5)    //Upp ver kanten
  #declare PolisRot = z*90 + z*(PolisClock-7)*90
  #declare PolisTrans = <5.2+(PolisClock-3)*.90, -5, 6.9+sin((PolisClock-7)*(2-asin(.1))*pi)*.5>
 #break
 #range (7.5, 7.7)
  #declare PolisRot = z*135
  #declare PolisTrans = <5.2+(7.5-3)*.90, -5, 7>
 #break
 #range (7.7, 8.5)
  #declare PolisRot = z*135
  #declare PolisTrans = <5.2+(7.5-3)*.9 + cos(pi/4)*(PolisClock-7.7)/.8*1.0, -5 + sin(pi/4)*(PolisClock-7.7)/.8*1.0, 7+sin((PolisClock-7.7)/.8*pi)*(.2+testest*.4)>
 #break
 #range (8.5, 13.5)
  #declare PolisRot = z*135
  #declare PolisTrans = <5.2+(7.5-3)*.9 + cos(pi/4)*(8.5-7.7)/.8*1.0, -5 + sin(pi/4)*(8.5-7.7)/.8*1.0, 7+0>
 #break
 #range (13.5, 999)
  #declare PolisRot = z*135 - <(DrakClock-4)*10, (DrakClock-4)*5, -(DrakClock-4)*15>
  #declare PolisTrans = //<-.75+cos((min(5.0, DrakClock)-4)*pi)*.75, -1+cos((min(5.0, DrakClock)-4)*1.1*pi)*1, sin((min(5.0, DrakClock)-4)*1.1*pi)*1.5>
                        <-2*(DrakClock-4)/.72, -2*(DrakClock-4)/.72, (DrakClock-4)*7.0-9.75*(DrakClock-4)*(DrakClock-4)>
                      * <-cos(radians(135)), sin(radians(135)), 1>
                      + <5.2+(7.5-3)*.9 + cos(pi/4)*(8.5-7.7)/.8*1.0, -5 + sin(pi/4)*(8.5-7.7)/.8*1.0, 7+0>
 #break
#end

//-Draken gr entr----------------

#switch (DrakClock)
 #range (-1, 0)
  #declare DrakRot = 40
  #declare DrakTrans = <13, -2, 7>
 #break
 #range (0, 1)
  #declare DrakRot = 40
  #declare DrakRotFactor = -<cos(radians(DrakRot)), sin(radians(DrakRot)), 0>
  #declare DrakTrans = <13, -2, 7> + DrakRotFactor * .4*.4*DrakClock*DrakClock
  #declare Gnistor = min(15, DrakClock*DrakClock*16)
 #break
 #range (1, 3)
  #declare DrakRot = 40
  #declare DrakRotFactor = -<cos(radians(DrakRot)), sin(radians(DrakRot)), 0>
  #declare DrakTrans = <13, -2, 7> + DrakRotFactor*.4*.4 + DrakRotFactor*(DrakClock-1)*.8
  #if (DrakClock < 2.55)  #declare Gnistor = 16  #end
 #break
 #range (3, 999)
  #declare DrakRot = 40
  #declare DrakRotFactor = -<cos(radians(DrakRot)), sin(radians(DrakRot)), 0>
  #declare DrakTrans = <13, -2, 7> + DrakRotFactor*.4*.4 + DrakRotFactor*(3-1)*.8
 #break
#end


#debug concat("clock: ",str(clock, 0, 4), "\n")
#debug concat("CarClock: ",str(CarClock, 0, 4), "\n")
#debug concat("TrikeClock: ",str(TrikeClock, 0, 4), "\n")
#debug concat("PolisClock: ",str(PolisClock, 0, 4), "\n")
#debug concat("DrakClock: ",str(DrakClock, 0, 4), "\n")
#debug concat("testest: ", str(testest, 0, 4), "\n")


//--KAMERA------------------------------------------------------------------

camera
 {direction <0, 0, 2.488>
  sky <0, 0, 1>  // Use right handed-system!
  up <0,0,1.0> right <1.3333,0,0>

  #switch (clock)
   #range (0, 3.5)
    location -y*3+z*1 + <14-7.75/2-sin(-pi/2+clock/3.5*pi)*7.75/2, -26+19/2+sin(-pi/2+clock/3.5*pi)*19/2, 11-3.5/2-sin(-pi/2+clock/3.5*pi)*3.5/2>
    look_at CarTrans + <1.5+1.75-sin(-pi/2+clock/3.5*pi)*1.75, 0, .2+3.5/2-sin(-pi/2+clock/3.5*pi)*3.5/2>
   #break
   #range (3.5, 4)
    location <6.25+0*.6, -7-0*.5, 7.5+0*.5>
    look_at CarTrans + <1.5-0*.25, 0, .2>
   #break
  #end

  #switch (CarClock)
   #range (0, 2.5)
    location <6.25+CarClock*.6, -7-CarClock*.5, 7.5+CarClock*.5>
    look_at CarTrans + <1.5-CarClock*.25, 0, .2>
   #break
   #range (2.5, 4)
    location <5.0+CarClock*.5, -.5, 7.5+CarClock*.0> //<11, -7, 8> //
    look_at CarTrans + x*.4
   #break
   #range (4, 999)
    location <5.0+4*.5, -.5, 7.5+4*.0>
   // #ifdef (TableCollisionTime)
     //location <0.5+TrikeTrans.x, -6, 10+7.7>
   //    location TrikeTrans + <-.6, -1, .25>
   // #end
    look_at (CarTrans+x*.4)*(max(0, 1-(CarClock-4)*2)) + (TrikeTrans+x*.2+y*.3+z*.2)*(min(1, (CarClock-4)*2)) -z*.0
   #break
  #end

//  #if (TrikeClock > 3.275)
//   location TrikeTrans + <-.5, -1, .35>
//   look_at (CarTrans+x*.4)*(max(0, 1-(CarClock-4)*2)) + (TrikeTrans+x*.3+y*.3+z*.3)*(min(1, (CarClock-4)*2)) -z*.0
//  #end

  #switch (PolisClock)
   #range (0, 3)
    location <6.3, -8, 7>
    look_at <5.8, -4.6, 8>
   #break
   #range (3, 4)
    location <6.3+(PolisClock-3)*(PolisClock-3)*1.8, -8, 7+.45+sin((PolisClock-4)*pi/2)*.45>  //
    look_at <5.8+(PolisClock-3)*.9, -4.6, 8>
   #break
   #range (4, 7)
    location <6.3+(PolisClock-3)*1.8, -8, 7+.45+sin(min(1, (PolisClock-4))*pi/2)*.45>
    look_at <5.8+(PolisClock-3)*.9, -4.6, 8>
   #break
   #range (7, 8)  //8.5
    location <6.3+(PolisClock-3)*1.8-(PolisClock-7)*(PolisClock-7)*1.8, -8, 7+.45*2>  //<6.3+(7-3)*1.8-(PolisClock-7)*(PolisClock-7)*(1-(PolisClock-7))*1.8, -8, 7.7>
    look_at <5.8+(PolisClock-3)*.9, -4.6, 8>   //8-.15-(sin(PolisClock*2-15)*pi/2)*.15>
   #break
   #range (8, 999)
    location <6.3+(8-3)*1.8-1.8, -8, 7+.45*2>  //<6.3+(7-3)*1.8-(PolisClock-7)*(PolisClock-7)*(1-(PolisClock-7))*1.8, -8, 7.7>
    look_at <5.8+(8-3)*.9, -4.6, 8>
   #break
  #end

  #switch (DrakClock)
   #range (0, 1)
    location <12, -6.5, 8> + <2, 1, 0>/2 + <2, 1, 0>/2*sin(-pi/2+DrakClock/3*pi)
    look_at <13, -2, 7> + <-.5, 0, .5>
   #break
   #range (1, 3)
    location <12, -6.5, 8> + <2, 1, 0>/2 + <2, 1, 0>/2*sin(-pi/2+DrakClock/3*pi)
    look_at <13, -2, 7> + <-.5, 0, .5> + ((DrakRotFactor*3)+z*.4)/2 + ((DrakRotFactor*3)+z*.4)/2*sin(-pi/2+(DrakClock-1)/2*pi)
   #break
   #range (3, 4)
    location <12, -6.5, 8> + <2, 1, 0>
    look_at <13, -2, 7> + <-.5, 0, .5> + (DrakRotFactor*3)+z*.4
   #break
   #range (4, 5.5)
    location <12, -6.5, 8> + <2, 1, 0>
    look_at <13, -2, 7> + <-.5, 0, .5> + (DrakRotFactor*3)+z*.4
          + <-1+cos((DrakClock-4)*pi)*1, -1+cos((DrakClock-4)*pi)*1, sin((DrakClock-4)*pi)*1.0>
          * <-cos(radians(135)), sin(radians(135)), 1>
   #break
   #range (5.5, 6.5)
    location <10, -7, 7.2>
           + <.5+sin(-pi/2+(DrakClock-5.5)*pi)*.5, -2-sin(-pi/2+(DrakClock-5.5)*pi)*2, 2+sin(-pi/2+(DrakClock-5.5)*pi)*2>
    look_at DrakTrans + z*.4 + x*.3
   #break
  #end

//location TrikeTrans + <-.6, -1, .35>
//look_at (CarTrans+x*.4)*(max(0, 1-(CarClock-4)*2)) + (TrikeTrans+x*.2+y*.3+z*.3)*(min(1, (CarClock-4)*2)) -z*.0

 }

/* #switch (clock)        //Fade
  #range (0, 1)
   sphere
    {<14-7.75/2-sin(-pi/2+clock/3.5*pi)*7.75/2, -26+19/2+sin(-pi/2+clock/3.5*pi)*19/2, 11-3.5/2-sin(-pi/2+clock/3.5*pi)*3.5/2> , .1
     pigment {rgbt clock}  finish {ambient 0  specular 0}
     no_shadow
     hollow
    }
  #break
 #end
 #switch (DrakClock)
  #range (5.55, 6.55)
   sphere
    {<10, -7, 7.2>
     + <.5+sin(-pi/2+(DrakClock-5.5)*pi)*.5, -2-sin(-pi/2+(DrakClock-5.5)*pi)*2, 2+sin(-pi/2+(DrakClock-5.5)*pi)*2> , .1
     pigment {rgbt 6.55-DrakClock}  finish {ambient 0  specular 0}
     no_shadow
     hollow
    }
  #break
 #end
*/
//--LJUS--------------------------------------------------------------------

light_source                         //Solen
 {<-5000, 10000, 8500>
  rgb<.8, .8, 1>*1.5
  //area_light <55, 1, 1>, <1, 1, 65>, 3, 4  //<350, 1, 1>, <1, 1, 350>, 7, 7
 }

light_source                         //Taklampan
 {<12, -20, 22.5>
  rgb<1, .95, .8>*0.7*1
  //area_light <2, 0, 0>, <0, 2, 0>, 3, 3 //<4, 0, 0>, <0, 4, 0>, 3, 4
 }

light_source                         //Taklampa utan skuggor
 {<12.01, -20.01, 22.5>
  rgb<1, .95, .8>*0.2
  shadowless
 }

light_source                         //Taklampans motsats
 {-<12, -20, 22.5>
  rgb<1, .95, .8>*0.1
  shadowless
 }

//--INKLUDERAS--------------------------------------------------------------

#include "colors.inc"
#include "textures.inc"

//--TEXTURER----------------------------------------------------------------

#declare Tapet=
texture
 {pigment
   {bozo
    turbulence 2
    scale .5
    color_map
     {[0 rgb <.4, .5, .9>]
      [1 rgb <.5, .6,  1>]
     }
   }
  normal
   {gradient x
    scale 5
    slope_map
     {[0   <0,  0>]
      [.95 <0, .2>]
      [1   <.3, 0>]
     }
    //turbulence <0, .05, 0>
   }
 }

#declare DukTex=
texture
 {pigment
   {image_map
     {gif "dukimage2.gif"}
   }
  normal
   {bump_map
     {gif "dukbump.gif"
      bump_size 2}
    scale 1
   }
 }

#declare HandtagsTex=
texture
 {pigment
   {bozo
    color_map
     {[0 rgb <1, 1, 1>]
      [1 rgb <1, 1, .85>]
     }
   }
 }

#declare VitPlast= //(persiennprylar)
texture
 {pigment
   {bozo
    scale .25
    color_map
     {[0 rgb 0]
      [0.1 rgb <1, 1, .9>]
      [.5 rgb 1]
      [1 rgb 1]
     }
   }
  finish {specular .4 roughness .025}
  normal {bumps}
 }

#declare Metall=
texture
 {pigment {rgb .75}
  finish {specular .6  roughness .001 metallic reflection .45}
  normal {bumps .1 scale .01}
 }

#declare FWood =
   texture  // txt_99
   {pigment
      {bozo
         color_map
         {  [ 0.0     rgbft <0.3528, 0.217, 0.0546, 0.0, 0.0> ]
            [ 0.25    rgbft <0.4248, 0.26, 0.072, 0.0, 0.0> ]
            [ 0.4     rgbft <0.2735, 0.1665, 0.045, 0.0, 0.0> ]
            [ 0.5     rgbft <0.3024, 0.186, 0.045, 0.0, 0.0> ]
            [ 0.7     rgbft <0.2236, 0.1288, 0.0408, 0.0, 0.0> ]
            [ 0.98    rgbft <0.2124, 0.13, 0.0344, 0.0, 0.0> ]
            [ 1.0     rgbft <0.3528, 0.217, 0.0546, 0.0, 0.0> ]
         }
         turbulence 0.04
         scale  <0.05, 0.05, 1.0>
      }
   }
   texture  // txt_100
   {pigment
      {wood
         color_map
         {  [ 0.0     rgbft <0.404, 0.21, 0.078, 0.2, 0.0> ]
            [ 0.25    rgbft <0.431, 0.225, 0.09, 0.8, 0.0> ]
            [ 0.4     rgbft <0.447, 0.233, 0.09, 0.2, 0.0> ]
            [ 0.5     rgbft <0.404, 0.21, 0.075, 0.6, 0.0> ]
            [ 0.7     rgbft <0.459, 0.222, 0.102, 0.2, 0.0> ]
            [ 0.98    rgbft <0.431, 0.225, 0.086, 0.4, 0.0> ]
            [ 1.0     rgbft <0.404, 0.21, 0.078, 0.1, 0.0> ]
         }
         turbulence 0.04
         scale  <0.2, 0.2, 1.0>
         rotate    <358.0, 2.0, 0.0>
      }
    //normal
    // {wood .065  turbulence 0.04  scale <.05, .05, 1>}
    finish
     {specular .15  roughness .2}
   }

#declare TakTex =
texture
 {pigment
   {bozo
    pigment_map
     {[0 rgb 1]
      [.4 rgb 1]
      [.6 rgb <1, 1, .95>]
      [.75 rgb 1]
      [.999 rgb .95]
      [1 rgb .92]
     }
    turbulence 1
    scale <3, 2, 2>*2
   }
  finish  {ambient .45}
  normal  {granite .05  scale <.1, .2, .2>}
 }

#declare FingerTex =
texture
 {pigment
   {spotted  scale .06
    color_map
     {[0  rgb <0.820, 0.682, 0.616>] //<0.920, 0.662, 0.6>]
      [.5 rgb <0.820, 0.682, 0.616>]
      [1  rgb <0.820, 0.612, 0.606>]
     }
   }
  normal
   {crackle
    scale <.3, .05, .3>*2
    slope_map
     {[.0 <.0, .3>]
      [.05 <.2, .3>]
      [.05 <.2, 0>]
      [1  <.2, 0>]
     }
    bump_size .10  //.15, .2
   }
  finish
   {specular .12  roughness .08} //s.15
  //translate -.4
  scale .25
 }

#declare LedTex =
texture
 {FingerTex
  //pigment{rgb <0,.8,0>}
  normal
   {gradient y
    turbulence .15
    scale .3
    slope_map
     {[0  <0, 0>]
      [.9 <0, -1>]
      [.95 <-1, 1>]
      [1 <0, 0>]
     }
    bump_size 15
   }
 }

#declare ToppTex =
texture
 {FingerTex
  pigment {rgb <0.870, 0.657, 0.585>*.9}
 }

#declare NagelTex =
texture
 {pigment
  // {rgb <0.880, 0.682, 0.676>*1}
   {image_map
     {gif "fingerbase2.gif"
      //transmit all .2
     }
    rotate z*90
    scale <.48, .43*2.1, 1>
    translate <-.251, -0.69, 0>
   }
  finish
  {specular .175  roughness .08}
 }

#declare DrakTex =
texture
 {pigment
   {gradient x
    color_map
     {[0 rgb <1, 1, 0>]
      [1 rgb <.1, .9, .1>]
     }
    translate -.15
    scale 1.2
   }
  finish {specular .15 roughness .025}
  normal {bumps .12 scale .010}
 }

#declare GnistTex =
texture
 {pigment
   {gradient x
    color_map
     {[0 rgbf 1]
      [1 rgb <1, 1, .7>*1.5 filter .8]
     }
    }
  finish {ambient 1.3 diffuse 0}
 }

#declare Aluminum =
texture
 {pigment {rgb <0.7604, 0.7604, 0.7604>}
  normal
   {bumps  1.2
    scale  0.002
   }
  finish
   {ambient 0.1
    diffuse 0.65
    brilliance 1.5
    specular 0.410067
    roughness 0.025
   }
 }


#include "polisbil.inc"
#declare NavTex =
texture
 {gradient y
  turbulence <0, .10, 0>
  texture_map
   {[0  WindowTex normal{bumps 0}]
    [.070 WindowTex normal{bumps 0}]
    [.070 MetallBil]
    [1  MetallBil]
   }
 }

#declare Black_White_Cow =
 texture
  {pigment
    {bozo
     color_map
      {[ 0.0     rgb .9 ]
       [ 0.5     rgb .9 ]
       [ 0.5     rgb .1 ]
       [ 1.0     rgb .1 ]
       }
     turbulence 0.9
    }
   normal
    {
         bumps , 0.4
         scale  0.0001
    }
  /*  finish
      {
         ambient 0.4
         phong_size 0.0
         roughness 0.0
      }*/
   }


//--VGGAR OCH TAK----------------------------------------------------------

intersection
 {box                                        //Yttervggen
   {<0, 0, 0>, <22, 1.5, 23>
    texture {Tapet}
   }
  box
   {Org+<0, -.1, 0>, Org+<FWidth, 1.6, FHeight> //<1, -.1, 9-1.5>, <10, 1.6, 20>
    pigment {rgb 1}
    inverse
   }
  box
   {Org + <0, .01, 0>, Org + <FWidth, -.1, -Org.z>
    pigment {rgb 1}
    inverse
   }
 }

box                                         //Vggen mot Lilja
 {<22, 1, 0>, <23, -40, 23>
  texture {Tapet rotate z*90}
 }

box                                         //Vggen mot Lars
 {<0, 1, 0>, <-1, -40, 23>
  texture {Tapet rotate z*90}
 }

intersection
 {box                                         //Vggen mot hallen
  {<0, -40, 0>, <22, -41, 23>}
 box
  {<0, -39, 0>, <8.4, -42, 21.2>  inverse}
 texture {Tapet}
 }

//-Drr och lysknapp---------

union                                        //Drren...
 {box                          //Drrlist 1
   {<0, -39.9, 0>, <.25, -41, 21.2>}
  box                          //Drrlist 2
   {<.27, -39.9, 20.7>, <7.88, -41, 21.2>}
  box                          //Drrlist 3
   {<7.9, -39.9, 0>, <8.4, -41, 21.2>}
  intersection                 //Innerlist
   {box {<0, -41, 0>, <8, -40, 21>}
    box {<.4, -42, 0>, <7.75, -39, 20.55>  inverse}
   }
  pigment {rgb 1}
 }
box         //Sjlvaste drren
 {<.43, -40, 0>, <7.72, -41, 20.52>
  pigment
   {bozo
    scale 3
    color_map
     {[0 rgb .97]
      [.5 rgb .97]
      [1 rgb <0.65416, 0.606759, 0.54584>+.90*(.97-<0.65416, 0.606759, 0.54584>)]
     }
   }
 }
difference      //Ls
 {cylinder
   {<7.27, -40, 10.7>, <7.27, -39.95, 10.7>, .25
    pigment {rgb .92}
   }
  box
   {<-.07, 0.001, -.07>, <.07, 1, .07>
    rotate y*45
    translate <7.27, -40, 10.7>
   }
 }
superellipsoid    //Handtag...
 {<1, .2>
  scale <.25, .25, .05>
  rotate x*90
  translate <7.27, -40, 10.0>
  texture {Aluminum}  normal {bumps 0}
 }
cylinder
 {<7.27, -40, 10>, <7.27, -39.6, 10>, .08
  texture {Aluminum}  normal {bumps 0}
 }
intersection
 {torus
   {.15, .08
    rotate x*90
   }
  box
   {<0, 0, -1>, <1, 1, 1>}
  translate <7.27-.15, -39.6, 10>
  texture {Aluminum}  normal {bumps 0}
 }
superellipsoid
 {<.5, .5>
  scale <.47, .06, .1>
  rotate -y*3
  translate <7.27-.15-.47, -39.6+.15, 10>
  pigment
   {bozo
    scale .5
    color_map
     {[0 rgb .92]
      [.5 rgb .92]
      [1 rgb <0.65416, 0.606759, 0.54584>+.70*(.92-<0.65416, 0.606759, 0.54584>)]
     }
   }
 }

intersection
 {superellipsoid          //Lysknapp..
   {<.1, 1>
    scale <.45, .45, .1>
    rotate x*90
    pigment {rgb 1}
   }
  box
   {<-.12, 0, -.12>, <.12, 1, .12>  inverse}
  rotate y*3
  translate <8.85+.45, -40, 10>
  finish {specular .3  roughness .04}
 }
box
 {<-.11, 0, -.11>, <.11, .1, .11>
  rotate y*3
  translate <8.85+.45, -40, 10>
  pigment {rgb 1}
  finish {specular .3  roughness .04}
 }

//---------------------------

box                                         //Golvet
 {<0, 0, 0>, <22, -40, -1>
  pigment {rgb .7}
  normal {granite .05 scale .5}
  finish {specular .7 roughness .02}
 }

intersection
 {box                                         //Taket
   {<0, 0, 23>, <22, -40, 24>}
  #declare varv = 0
  #while (varv < 6)
   box
    {<-.04, 1, -.04>, <.04, -45, .04>
     rotate y*45
     inverse
     translate x*4*varv
    }
   #declare varv = varv+1
  #end
  texture {TakTex}
 }
intersection
 {box
   {<0, 0, 0>, <20, -42, 1>}
  #declare varv = 0
  #while (varv < 6)
   box
    {<-.04, 1, -.04>, <.04, -45, .04>
     rotate y*45
     inverse
     translate x*4*varv
    }
   #declare varv = varv+1
  #end
  texture {TakTex}
  rotate y*49
  translate <12, 0, 23>
 }

//--PRYLAR I RUMMET---------------------------------------------------------

//-Plansch-------------------

/*superellipsoid
 {<.5, .5>
  pigment
   {image_map
     {png "hornland.png"}
    scale 2 translate -2 rotate y*90 rotate x*90 rotate z*0
   }
  finish {specular .25 roughness .25}
  rotate z*90
  scale <.2, 4, 3>
  translate <22, -18, 8>
 }*/
box
 {0, 1
  pigment
   {image_map
     {png "hornland.png"}
    rotate y*90 rotate x*90 rotate z*180
   }
  finish {ambient .15  specular .35  roughness .25}
  scale <.005, 8, 6>
  translate <21.99, -32, 5>
  normal {bumps .3 scale <1, 1, 4>}
 }

#declare Needle=
union
 {cylinder
   {0, <-.2, 0, 0>, .005
    texture {Aluminum}  normal {bumps 0}
   }
  sphere
   {<-.23, 0, 0>, .04
    pigment {rgb <.6, .65, .9>}
    finish {specular .25  roughness .04}
   }
 }

object
 {Needle  rotate y*75  rotate -x*5  translate <22, -21.7, 10.8>}
object
 {Needle  rotate y*80  rotate -x*8  translate <22, -14.3, 10.8>}
object
 {Needle  rotate y*80  rotate x*15  translate <22, -21.9, 5.1>}
object
 {Needle  rotate y*75  translate <22, -14.15, 5.1>}

//-Stol----------------------
#ifdef (Stol)

union{
#declare bend_object =   //Ryggstvd
 superellipsoid
  {<.4, .7>
   scale <1.5, .12, 1>
   /*pigment
    {brick rgb .1, rgb .6
     scale <.01, .005, .01>*2
     rotate x*90  rotate y*90
     translate z*10
    }
   pigment
    {bozo
     color_map
      {[0 rgb <1, 1, 1> ]
       [0.5 rgb <1, 1, 1> ]
       [0.5 rgb .15 ]
       [1.0 rgb .15 ]
      }
     turbulence 0.85
    }*/
   //normal {bumps .4  scale  0.0001}
   texture {Black_White_Cow}
   finish {phong 0  specular 0}
   //normal
    //{quilted .5  scale .004  rotate 0*z*45/8}
    //{bumps .25 scale .0015}
  }
#declare object_axis1 = -x
#declare object_axis2 = +x
#declare bend_smoothness = 100
#declare bend_direction = y
object
 {#include "Bend.inc"
  rotate -z*45/2
 }

superellipsoid          //Pinne
 {<.15, .05>
  scale <.125, .065, 1>
  translate <0, -.25, -1>
  pigment {rgb .9}
  finish {reflection .8  metallic 1  specular .5  roughness .002}
 }

superellipsoid          //Sits
 {<.8, .4>
  scale <2.2, 1.6, .4>
  translate <0, 1.6, -2>
  texture {Black_White_Cow}
  finish {phong 0  specular 0}
 }

rotate z*20
translate x*3.5 + <12, -9.5, 6.6>
}

#end //ifdef Stol

//-Sng----------------------

box                           //botten
 {<22, -40, 2.1>, <13.5, -20, 4.4>
  pigment {color rgb .1}
 }
box                             //lakan
 {<21.8, -39.7, 4.4>, <13.7, -20.4, 4.5>
  pigment {color rgb 1}
  normal {wrinkles 1 scale 1}
 }
superellipsoid              //tcke
 {<.2, .2>
  pigment
   {checker rgb 0, rgb 1
    scale .15
    rotate z*45
   }
  scale <3.7, 8, .1>
  rotate z*4
  translate <16.5, -28.5, 4.6>
  normal {wrinkles 1 scale 1}
 }
superellipsoid
 {<.2, .8>
  scale <3.5, 2, .5>
  pigment
   {checker rgb <.9, .1, .1>, rgb 1
    scale <1, 100, 1>
   }
  rotate <-10, 0, -8>
  translate <16, -37.4, 4.9>
  normal {wrinkles 1.05 scale .8}
 }


//--ELEMENTET---------------------------------------------------------------

union
 {/*superellipsoid
   {<.1, .013>
    scale <FWidth/2+.2, .05, 3>
    pigment {rgb <.95, .92, .87>}
    finish  {specular .2   metallic}
   }*/
  box
   {<-FWidth/2-.2, -.05, -3>, <FWidth/2+.2, .05, 3>
    pigment {rgb <.95, .92, .87>}
    finish  {specular .2   metallic}
   }
  intersection
   {merge
     {superellipsoid
       {<.1, .1>  scale <.15, .1, .2>}
      superellipsoid
       {<.1, .1>  scale <.15, .2, .2>
        rotate x*45
        translate <0, .175, .19>
       }
      superellipsoid
       {<.1, .1>  scale <.15, .2, .2>
        rotate x*45
        translate <0, .175, -.19>
       }
     }
    merge
     {superellipsoid
       {<.1, .1>  scale <.15, .1, .2>}
      superellipsoid
       {<.1, .1>  scale <.15, .2, .2>
        rotate x*45
        translate <0, .175, .19>
       }
      superellipsoid
       {<.1, .1>  scale <.15, .2, .2>
        rotate x*45
        translate <0, .175, -.19>
       }
      inverse
      scale .9
     }
    pigment {rgb .85  filter .75}
    finish {specular .25 refraction 1 ior 1.5}
    translate <FWidth/2-.5, -.1, 2.0>
   }
  translate <Org.x+FWidth/2, -.3, 4.35>
 }

//--FNSTRET----------------------------------------------------------------
/*
plane                                     //Utanfr fnstret, alt. 1
 {-y, -200
  no_shadow
  pigment
   {image_map
     {png "c980428.png"}
    rotate x*90
    scale <3.73, 1, 4.93>*30
    translate <-40, 0, -100>
   }
  finish {ambient 1.6  diffuse 0}
 }
*/
plane                                   //Utanfr fnstret, alt. 2
 {z,.1
  no_shadow
  pigment
   {gradient y
    color_map
     {[0 color rgb<.84,.89,.97>]
      [1 color rgb<.8,.8,.97>/1.2]
     }
    scale 100
   }
  finish {ambient 1 diffuse 0}
  rotate -x*45
  translate y*100
 }
plane
 {z,0
  no_shadow
  rotate -x*45
  translate y*100
 texture{
  pigment
   {spotted
    color_map
     {[0 color rgbf<1,1,1,.15>] //rgb 1-<.2,.2,.03>*clock]
      [.5 color rgbf 1]  //<.8,.8,.97>]
      [1 color rgbf 1]}
    turbulence .1 //Ny!
    scale <10,10,5>
    translate <-clock*.01,clock*.01,0>+2
   }
   finish {ambient 1 diffuse 0}
        }
 texture{
  pigment
   {bozo
    color_map
     {[0 color rgbf<1,1,1,.15>]
      [.5 color rgbf 1]
      [1 color rgbf 1]}
    turbulence 1
    scale <12,10,5>
    translate <-clock*.01,clock*.01,0>+2
   }
   finish {ambient 1 diffuse 0}
        }
  }


superellipsoid                            //Vit ram runt fnstret
 {<.15, .15>
  scale <.1, .1, FHeight/2 + .2>
  translate Org + <-.1, 0, FHeight/2>
  pigment {White}
  finish {reflection .01 specular .1 roughness .1}
 }
superellipsoid
 {<.15, .15>
  scale <.1, .1, FHeight/2 + .2>
  translate Org + <FWidth+.1, 0, FHeight/2>
  pigment {White}
  finish {reflection .01 specular .1 roughness .1}
 }
superellipsoid
 {<.15, .15>
  scale <FWidth/2 + .2, .1, .1>
  translate Org + <FWidth/2, 0, -.1>
  pigment {White}
  finish {reflection .01 specular .1 roughness .1}
 }
superellipsoid
 {<.15, .15>
  scale <FWidth/2 + .2, .1, .1>
  translate Org + <FWidth/2, 0, FHeight+.1>
  pigment {White}
  finish {reflection .01 specular .1 roughness .1}
 }


intersection                              //Frlngning av vggen
 {box
   {<0, .8, Org.z+.37>, <22, 1.7, 22>}
  box
   {Org+<xA+.1, -.1, zA>, Org+<FWidth-xB-.1, 1.9, FHeight-zB> //{<1.5, -.1, 9.5-1.5>, <9.5, 1.6, 19.5>
    inverse
   }
  texture {FWood}
 }
box
 {<0, .7, Org.z+.36>, <22, 1.7, 6>
  texture {FWood  rotate y*90}
 }

/*intersection                              //Fnsterramen
 {box
   {Org+<xA, .5, zA>, Org+<FWidth-xB, 1.2, FHeight-zB>} //{<1.2, .5, 9.2-1.5>, <9.8, 1.2, 19.8>}
  box
   {Org+<xA+RWidth, -.1, zA+RWidth>, Org+<FWidth-xB-RWidth, 2, FHeight-zB-RWidth> //{<1.7, -.1, 9.7-1.5>, <9.3, 2, 19.3>
    inverse
   }
  texture {FWood rotate 1}
 }*/
superellipsoid  //insida
 {<.2, .015>
  rotate z*90
  scale <RWidth/2, .17, (FHeight-zA-zB)/2>
  texture {FWood}
  translate Org + <xA+RWidth/2, .65+.17, zA+(FHeight-zA-zB)/2>
 }
superellipsoid  //utsida
 {<.14, .015>
  rotate z*90
  scale <RWidth/2, .1, (FHeight-zA-zB)/2>
  texture {FWood}
  translate Org + <xA+RWidth/2, .65+.17+.27+.1, zA+(FHeight-zA-zB)/2>
 }
superellipsoid  //insida
 {<.15, .015>
  rotate z*90
  scale <RWidth/2, .17, (FHeight-zA-zB)/2>
  texture {FWood}
  translate Org + <FWidth-xB-RWidth/2, .65+.17, zA+(FHeight-zA-zB)/2>
 }
superellipsoid  //utsida
 {<.15, .015>
  rotate z*90
  scale <RWidth/2, .1, (FHeight-zA-zB)/2>
  texture {FWood}
  translate Org + <FWidth-xB-RWidth/2, .65+.17+.27+.1, zA+(FHeight-zA-zB)/2>
 }
superellipsoid //insida
 {<.14, .015>
  rotate z*90
  rotate y*90
  scale <(FWidth-xA-xB-2*RWidth)/2, .17, RWidth/2>
  texture {FWood  rotate y*90}
  translate Org + <xA+RWidth+(FWidth-xA-xB-2*RWidth)/2, .65+.17, zA+RWidth/2>
 }
superellipsoid  //utsida
 {<.14, .015>
  rotate z*90
  rotate y*90
  scale <(FWidth-xA-xB-2*RWidth)/2, .1, RWidth/2>
  texture {FWood  rotate y*90}
  translate Org + <xA+RWidth+(FWidth-xA-xB-2*RWidth)/2, .65+.17+.27+.1, zA+RWidth/2>
 }

union                                                               //Gngjrn nere
 {cylinder
   {<0, 0, .005>, <0, 0, .4>, .075}
  cylinder
   {<0, 0, -.005>, <0, 0, -.4>, .075}
  intersection
   {sphere
     {<0, 0, .41>, .075}
    box
     {<-.1, -.1, .41>, <.1, .1, .5>}
   }
  intersection
   {sphere
     {<0, 0, -.41>, .075}
    box
     {<-.1, -.1, -.41>, <.1, .1, -.5>}
   }
  box
   {<0, .07, -.38>, <.5, .1, .38>}
  texture
   {spotted
    scale .02
    texture_map
     {[0   pigment {rgb .9}  finish {specular .35 roughness .005 metallic 1  reflection .1}]
      [0.4 pigment {rgb .9}  finish {specular .35 roughness .005 metallic 1  reflection .1}]
      [1   pigment {rgb <0.459, 0.222, 0.102>/2+.7} ]
     }
   }
  translate Org + <.09, .8-.09, 2.3>
 }

superellipsoid                                                              //Fnsterbrde
 {<.05, .1>
  scale <FWidth/2, .55, .1>
  translate Org+<FWidth/2, -.75, -.12> //<5.5, -.6, 8.9-1.5>
  texture
   {bozo
    scale .25
    turbulence .5
    texture_map
     {[0 bozo scale 1 texture_map
                         {[0 pigment {rgb <.2, .24, .2>} finish {phong 0 specular 0} ]
                          [1 pigment {rgb <.2, .24, .2>} finish {phong .15} ]     }]
      [.9 bozo scale 1 texture_map
                         {[0 pigment {rgb <.2, .24, .2>} finish {phong 0 specular 0} ]
                          [1 pigment {rgb <.2, .24, .2>} finish {phong .15} ]     }]
      [1 pigment {rgb <.6, .58, .56>}]
     }
   }
 }
#declare FBHallare=
union
 {intersection
   {box
     {<0, 0, 0>, <.3, .75, -.1>}
    box
     {<.02, -.1, -.02>, <.28, .8, -.15>  inverse}
   }
  sphere
   {<.15, .2, -.02>, .02}
  cylinder
   {<.15, 2, -.05>, <.15, .45, -.05>, .05}
  torus
   {.1, .05
    rotate z*90
    clipped_by
     {box {<-.5, -.5, 0>, <.5, 0, .5>}}
    //pigment{rgb<2,1,1>}
    translate <.15, .45, -.05-.1>
   }
  cylinder
   {<.15, .45-.1, -.05-.1>, <.15, .45-.1, -.4>, .05}
  torus
   {.1, .05
    rotate z*90
    clipped_by
     {box {<-.5, -.5, 0>, <.5, 0, -.5>}}
    translate <.15, .45, -.4>
   }
  cylinder
   {<.15, .45, -.4-.1>, <.15, 2, -.4-.1>, .05}
  cylinder
   {<.15, .9, -.5>, <.15, 2, -.5>, .1}
  cylinder
   {<.15, 1.2, -.5>, <.15, 2, -.5>, .18}
  translate <2.5, -1.25, Org.z-.12-.1>
  pigment {rgb <.95, .92, .87>}
  finish  {specular .2   metallic}
 }

 object
  {FBHallare}
 object
  {FBHallare  translate x*(FWidth-2.5)}


union                                                           //Fnsterspak
 {#include "fspak.pov"
  translate <8, .8, Org.z+.225>
 }

union{
blob                                                           //Stngningshake
 {threshold .5
  cylinder
   {<0, 0, 0>, <0, -.15, 0>, .2, 1}
  cylinder
   {<0, 0, 0>, <0, -.4, 0>, .1, 1}
  cylinder
   {<0.1, 0, 0>, <.22, 0, 0>, .1, .9
    scale <1, .4, 1>
    translate <0, -.12, 0>
   }
  sphere
   {<0, 0, 0>, .2, 1
    scale <1, .25, 2.5>
    translate <0, -.5, 0>
    texture {Texture3 scale <1, 2, 2>}
   }
  sphere
   {<0, 0, 0>, .005, .1
    scale <1.25, 200, 200>
   }
  rotate -y*4
  texture {Texture1}
 }
#include "hake.pov"
translate Org + <FWidth-xB-RWidth/3, .65, zA+2>
}

box                                                             //Sjlva fnstret
 {Org + <2*xA, .75, 2*zA>, Org + <FWidth-2*xB, 1.24, FHeight-2*zB>
  /*texture
   {bozo
    scale <.2, .01, .2>
    texture_map
     {[0  pigment {rgbt <1, 1, 1, .98>}]
      [.999 pigment {rgbt <1, 1, 1, .98>}]
      [1  pigment {rgbt <1, 1, 1, .85>}  finish {ambient .7}]
     }
   }*/
  pigment {rgbt<1, 1, 1, .95>}
 }

//--PERSIENNEN--------------------------------------------------------------

#ifdef (Persienn)

#declare Persiennblad=
intersection
 {cylinder
   {<0, 0, 0>, <RutWidth, 0, 0>, 1.0
    translate <0, 0, -1.0>
   }
  cylinder
   {<0, 0, 0>, <RutWidth, 0, 0>, .99
    translate <0, 0, -1.0>
    inverse
   }
  superellipsoid
   {<.1, .1>
    scale <RutWidth/2, .11, 1>  //<,.14,>
    translate <RutWidth/2, 0, .95>
   }
  superellipsoid
   {<.15, .1>
    scale <.02, .08, 1> //scale <.015, .1, 1>
    translate <.7, 0, 0>
    inverse
   }
  superellipsoid
   {<.15, .1>
    scale <.02, .08, 1> //scale <.015, .1, 1>
    translate <RutWidth-.7, 0, 0>
    inverse
   }
  pigment {rgbt <.95, .92, .87, .0>}
  finish
   {specular .2   metallic}
 }


#declare varv = 0
#while (varv < 40)
 object
  {Persiennblad
   rotate x*(degrees(atan2(100,83))+rand(R1)*2)        //23 deg
   translate Org + <xA+RWidth, 1.09, zA+RWidth+(varv+.6)*.22>   // ...*.3>
  }
 #declare varv = varv + 1
#end


intersection                //Lngst upp     Behvs mer detaljer?
 {superellipsoid
   {<.1, .05>
    scale <RutWidth/2, RutThick/2, 1.2>
    translate <RutWidth/2, 0, 1.2>
   }
  box
   {<.7-.06, .1, -.1>, <.7+.08, -.1, .1>
    inverse
   }
  box
   {<RutWidth-.7-.06, .1, -.1>, <RutWidth-.7+.08, -.1, .1>
    inverse
   }
  pigment {rgb 1}
  finish {specular .2   metallic}
  translate Org + <xA+RWidth, 1, zA+RWidth+RutHeight-.2>
 }

cylinder                    //Snren till Vnster
 {Org + <xA+RWidth+.7, .98+.09, zA+RWidth+.3>, Org + <xA+RWidth+.7, .98+.09, zA+RWidth+.3+RutHeight>, .01
  pigment {rgb .97}
  normal {bumps scale .01}
 }
cylinder
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal {bumps scale .01}
  translate Org + <xA+RWidth+.7, .86+.09, zA+RWidth>
 }
cylinder
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal {bumps scale .01}
  translate Org + <xA+RWidth+.7, 1.14+.09, zA+RWidth>
 }

cylinder                    //Snren i Mitten
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal {bumps scale .01}
  translate Org + <xA+RWidth+.7, .86+.09, zA+RWidth>
 }
cylinder
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal {bumps scale .01}
  translate Org + <xA+RWidth+.7, 1.14+.09, zA+RWidth>
 }

cylinder                    //Snren till Hger
 {Org + <xA+RWidth+RutWidth-.7, .98+.09, zA+RWidth+.3>, Org + <xA+RWidth+RutWidth-.7, .98+.09, zA+RWidth+.3+RutHeight>, .01
  pigment {rgb .97}
  normal {bumps scale .01}
 }
cylinder
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal {bumps scale .01}
  translate Org + <xA+RWidth+RutWidth-.7, .86+.09, zA+RWidth>
 }
cylinder
 {<0, 0, 0>, <0, 0, RutHeight>, .015
  scale <.33, 1, 1>
  pigment {rgb .97}
  normal { bumps scale .01}
  translate Org + <xA+RWidth+RutWidth-.7, 1.14+.09, zA+RWidth>
 }

torus                                   //Snrhllare
 {.075, .025
  translate Org + <xA+RWidth/2, .49, 5>
  texture {VitPlast}
 }
cylinder
 {<0, 0, 0>, <0, -.07, 0>, .03
  translate Org + <xA+RWidth/2, .5, 5>
  texture {VitPlast}
 }
torus
 {.075, .015
  translate Org + <xA+RWidth/2, .415, 5>
  texture {VitPlast}
 }
cylinder
 {<0, -.09, 0>, <0, -.07, 0>, .075
  translate Org + <xA+RWidth/2, .5, 5>
  texture {VitPlast}
 }
cylinder
 {<0, -.09, 0>, <0, -.1, 0>, .07
  translate Org + <xA+RWidth/2, .5, 5>
  texture {Metall}
 }
intersection
 {sphere
   {0, 0.045
    scale <1, .75, 1>
   }
  box
   {<-.1, -.005, -.008>, <.1, -.1, .008>
    rotate y*30  inverse
   }
  texture {Metall}
  translate Org + <xA+RWidth/2, .4, 5>
 }

union{
intersection                //Knopp till vridgrejen
 {union
   {cone
     {<0, 0, 0>, .07, <0, 0, .3>, .055}
    torus
     {.05, .02
      rotate x*90
     }
    sphere
     {<0, 0, 0>, .055
      scale <1, 1, .4>
      translate <0, 0, .3>
     }
    torus
     {.1, .075
      rotate x*90
      clipped_by {cylinder {-z, 0, .05} }
      translate <0, 0, .365>
     }
   }
  #declare varv = 0
  #while (varv < 6)
   superellipsoid
    {<1, .2>
     scale <.02, .02, .14>
     translate z*.14
     //rotate -y*5
     translate x*.07
     rotate varv*z*60
     inverse
    }
   #declare varv = varv + 1
  #end
  texture {VitPlast}
 }
//--
cylinder
 {<0, 0, .3>, <0, 0, .9>, .015
  texture {VitPlast}
 }
//--
cylinder
 {<0, 0, .9>, <0, 0, 1.05>, .019
  texture {Metall}
 }
cylinder
 {<0, 0, .9>, <0, 0, .95>, .027
  texture {Metall}
 }
cylinder
 {<0, 0, 1>, <0, 0, 1.05>, .027
  texture {Metall}
 }
//--
box
 {<-.07, .2, .95>, <.07, 0, .99> texture {VitPlast}  }
box
 {<-.07, .2, .95>, <.07, .16, 1.03> texture {VitPlast}  }
cylinder
 {<-.055, 0, .95>, <-.055, 0, .99>, .015 texture {VitPlast}  }
cylinder
 {<.055, 0, .95>, <.055, 0, .99>, .015 texture {VitPlast}  }
cylinder
 {<0, .2, 1.03>, <0, .16, 1.03>, .07
  clipped_by {box {<-1, 0, 1.03>, <1, 3, 2>} }
  texture {VitPlast}
 }
cylinder
 {<0, .2, 1.03>, <0, .15, 1.03>, .015  texture {Metall} }
//--
cylinder
 {<0, 0, 1.05>, <0, .1, 5>, .02
  texture {VitPlast}
 }
//--
union
 {#include "persienngrejs.pov"
  translate <-.1, .05, -1.2>
 }
translate Org + <xA+RWidth/1.5, .3, FHeight/2>
    } //slut p persiennprylsunionen

#end // ifdef Persienn

//--GARDINEN----------------------------------------------------------------

union                       //Gardinstng
{cylinder
  {Org + <-.4, -.5, FHeight+.4>, Org + <FWidth+.4, -.5, FHeight+.4>, .15}
 sphere
  {Org + <-.4, -.5, FHeight+.4>, .3}
 sphere
  {Org + <FWidth+.4, -.5, FHeight+.4>, .3}
 texture {FWood}
}

object
 {#include "gardin.pov"       //Gardinen
  translate Org + <-.3, -.5, FHeight+.25>
 }

//--SKP--------------------------------------------------------------------

#ifdef (Skap)

union
{

superellipsoid
 {<.025, .025>
  scale <2.5, 2.5, 3.4>
  translate <6.5, -2.7, 3.4>
  //pigment {White}
  pigment
   {wrinkles
    //scale .7
    color_map
     {[0 rgb 1]
      [.5 rgb 1]
      [1 rgb <0.65416, 0.606759, 0.54584>+.6*(1-<0.65416, 0.606759, 0.54584>)]
     }
   }
 }
superellipsoid
 {<.025, .025>
  scale <2.3, 2.5, 3.1>
  translate <6.6, -2.8, 3.5>
  pigment {White}
 }

#declare GJarn=         //Gngjarn
union
 {cylinder
   {<-2.3, -2.6, 2.15>, <-2.3, -2.6, 2>, 0.035}
  sphere
   {<-2.3, -2.6, 2.15>, .035}
  cylinder
   {<-2.3, -2.6, 1.99>, <-2.3, -2.6, 1.84>, 0.035}
 sphere
   {<-2.3, -2.6, 1.84>, .035}
  pigment {rgb .8}
  finish {specular 1 roughness .001 metallic reflection .2}
  translate <6.6, -2.70, 3.5>
 }

object {GJarn}
object {GJarn translate <0, 0, -3>}

union                   //Handtag
 {cylinder
   {<2.4, -3, 3.3>, <2.4, -3.02, 3.3>, .06}
  cylinder
   {<2.4, -3, 2.4>, <2.4, -3.02, 2.4>, .06}
  cylinder
   {<2.4, -3, 3.3>, <2.4, -3.2, 3.3>, .035}
  cylinder
   {<2.4, -3, 2.4>, <2.4, -3.2, 2.4>, .035}
  torus
   {.1, .035
    clipped_by
     {box {<0, -1, 1>, <1, 1, 0>}}
    rotate -z*90
    translate <2.4, -3.2, 3.2>
   }
  torus
   {.1, .035
    clipped_by
     {box {<0, -1, -1>, <1, 1, 0>}}
    rotate -z*90
    translate <2.4, -3.2, 2.5>
   }
  cylinder
   {<2.4, -3.3, 2.5>, <2.4, -3.3, 3.2>, .035}
  translate <5.9, -2.7+.5, 3.4-.5>
  pigment {rgb .6}
  finish {specular 1 roughness .001 metallic reflection .2}
 }

#ifdef (Duk)
                     //Duk
height_field
 {//gif "dukhf.gif"
  png "dukhf2.png"
  //smooth
  rotate -x*90
  texture {DukTex}
  scale <3*.6, 3*.6, -.012*.75>
  translate <-2, -2, 0>
  rotate z*42
  translate <6.5, -2.0,  6.8-0.001>   //y:-2
 }

#end //ifdef Duk

rotate z*2
translate <-.2, -.6, 0.1> //OBS
}

#end //ifdef Skap

//--SKRIVBORD---------------------------------------------------------------

union{

superellipsoid          //Skivan
 {<.01, .01>
  scale <6, 3, 0.1>
  pigment{White}
  translate <15.2, -3.2, 6.9>
 }
box                     //Faner
 {<-5.99, -2.99, 0>, <5.99, 2.99, 0.11>
  texture {EMBWood1  scale 0.1  rotate y*87  translate y*15}
  //pigment {checker Black, White  scale .2}
  /*pigment { image_map
     {gif "skrivbordbump.gif"}
    //scale <.34, .24, 1>
    //rotate x*90
    //bump_size 15
   }*/
  translate <15.2, -3.2, 6.9>
  normal
   {bump_map
     {gif "skrivbordbump.gif"}
    scale <.34, .24, 1>*2
    bump_size -200
   }
 }

box                     //Vnstra "benet"
 {<-5, 2.5, 0>, <-4.8, -2.5, -7.1>
  pigment {White}
  translate <15.2, -3.2, 6.9>
 }

union                   //Lddorna
 {box
   {<5.9, 2.5, 0>, <5.75, -2.5, -8.1>}
  box
   {<1.9, 2.5, 0>, <1.75, -2.5, -8.1>}
  box
   {<1.9, 2.5, -.12>, <5.72, -2.49, -.27>}
  box                  //sjlva ldorna
   {<1.92, 2.5, -.29>, <5.71, -2.47, -1.49>}
  box
   {<1.92, 2.5, -1.51>, <5.71, -2.49, -2.81> rotate z*.5}
  box
   {<1.92, 2.5, -2.83>, <5.71, -2.54, -4.63>}
  box
   {<1.92, 2.5, -4.65>, <5.73, -2.49, -6>}
  box
   {<1.91, 2.5, -6.03>, <5.74, -2.49, -6.18>}
  box
   {<1.9, 2.5, -6.18>, <5.75, -2.3, -7>}
  pigment {White}
  translate <15.2, -3.2, 6.9>
 }

#declare Handtag=
union                   //Handtag
 {cylinder
   {<3.1, -2, -.9>, <3.1, -2.7, -.9>, .05}
  cylinder
   {<4.5, -2, -.9>, <4.5, -2.7, -.9>, .05}
  torus
   {.1, .05
    clipped_by
     {box {<0, -1, -1>, <-1, 1, 0>}}
    rotate -x*90
    //pigment {Green}
    translate <3.2, -2.7, -.9>
   }
  torus
   {.1, .05
    clipped_by
     {box {<0, -1, -1>, <1, 1, 0>}}
    rotate -x*90
    translate <4.4, -2.7, -.9>
   }
  cylinder
   {<3.2, -2.8, -.9>, <4.4, -2.8, -.9>, .05}
  translate <15.2, -3.2, 6.9>
 }

object {Handtag texture {HandtagsTex}}
object {Handtag translate -z*1.2 texture {HandtagsTex}}
object {Handtag translate <0, -.05, -2.5> texture {HandtagsTex}}
object {Handtag translate -z*4.3 texture {HandtagsTex}}

//--PENNSTLLET-------------------------------------------------------------

union
 {#include "pennstall.pov"
  rotate z*6
  translate <10.5, -1.25, 7>
 }

//--SKRIVBORDSLAMPA---------------------------------------------------------

#ifdef (SLampa)

union
 {#include "slampa.pov"
  translate <9.2, -1.9, 7>
 }

#end

//--SKRIVBORDSUNDERLGG--------------------

union
 {superellipsoid
   {<.05, .1>
    scale <2.5, 1.9, .05>
    texture
     {bozo
      scale .1
      texture_map
       {[0  pigment {image_map {png "under.png"} scale <5, 3.8, 1>*10 translate <-2.5, -1.9, 0>*10}
            normal  {crackle .05  scale .075  turbulence 1}    ]
        [.75 pigment {image_map {png "under.png"} scale <5, 3.8, 1>*10 translate <-2.5, -1.9, 0>*10}
            normal  {crackle .05  scale .075  turbulence 1}    ]
        [1  pigment {image_map {png "under.png"} scale <5, 3.8, 1>*10 translate <-2.5, -1.9, 0>*10}
            normal  {crackle .05  scale .075  turbulence 1}
            finish  {specular 1}                              ]
       }
     }
   }
  superellipsoid
   {<.05, .1>
    scale <2.501, 1.901, .051>
    clipped_by
     {box {<-3, -2, -.1>, <-1.5, 2, .1>} }
    pigment {rgbf .9}
    finish {specular 1}
   }
  rotate z*3
  translate <15.5, -4, 7>
 }

//--LINJAL---------------------------------

intersection
 {//box
  // {<0, 0, 0>, <.28, 3, .035>}
  superellipsoid
   {<.1, .06>
    scale <.14, 1.5, .0175>
    translate <.14, 1.5, .0175>
   }
  box
   {<-.5, -.1, -.5>, <.5, 3.1, .035>  //pigment {rgb<0,2,0>}
    rotate -y*10  translate x*.105
   }
  pigment
   {image_map
     {gif "linjal.gif"}
    scale <.28*1.02, 3*1.0, 1>
    translate <-.0, -.0, 0>
   }
  finish {specular .15 roughness .03}
  rotate -z*70
  translate <12, -4.7, 7.051>
 }


translate <0, -.5, 0>
} //Slut p Skrivbordsunionen

//--VNSTERHANDEN-----------------------------------------------------------

#ifdef (VHand)

#declare VHandTrans = <0, 0, -10>
#declare ArmR=<0,0,0>  #declare HandR=<0,0,0>  #declare PekR1=<0,0,0>  #declare PekR2=<0,0,0>  #declare PekR3=<0,0,0>
#declare LangR1=<0,0,0>  #declare LangR2=<0,0,0>  #declare LangR3=<0,0,0>  #declare RingR1=<0,0,0>  #declare RingR2=<0,0,0>
#declare RingR3=<0,0,0>  #declare LillR1=<0,0,0>  #declare LillR2=<0,0,0>  #declare LillR3=<0,0,0>  #declare TumExtraRot=<0,0,0>
#declare TumR1=<0,0,0>  #declare TumR2=<0,0,0>  #declare TumR3=<0,0,0>

 //Passar polisbilen:

#switch (CarClock)
 #range (0, 4)
   #declare ArmR = <-CarClock*5, 5, 10-CarClock*12.5> //CarRot.z>

   #declare HandR = /*ArmR +*/ <-25, 5, 0>

   #declare PekR1 = HandR + <-20, 0, -3-0>
   #declare PekR2 = PekR1 + <-34, 0, 4>
   #declare PekR3 = PekR2 + <-15, 0, 4>

   #declare LangR1 = HandR + <-22, 0, 0-0>
   #declare LangR2 = LangR1 + <-35, 0, 0>
   #declare LangR3 = LangR2 + <-20, 0, 2>

   #declare RingR1 = HandR + <-15, 0, 0+0>
   #declare RingR2 = RingR1 + <-30-CarClock*1, 0, -1>
   #declare RingR3 = RingR2 + <-15-CarClock*1, 0, -2>

   #declare LillR1 = HandR + <-15, 0, -1+0>
   #declare LillR2 = LillR1 + <-10-CarClock*2, 0, -1>
   #declare LillR3 = LillR2 + <-15, 0, -2>

   #declare TumExtraRot = y*12 //y*25
   #declare TumR1 = HandR + <-34, -5, -10>
   #declare TumR2 = TumR1 + <0, 0, 5>
   #declare TumR3 = TumR2 + <0, 0, -0>

   #declare VHandTrans = CarTrans + <.1, -.58, 1.342>   //<5.9 + pi*2*(.09*1.2)*2*clock, -5.73, 8.2>
 #break
 #range (4, 4.5)
   #declare ArmR = <-4*5, 5, -40> //CarRot.z>

   #declare HandR = /*ArmR +*/ <-25, 5, 0>

   #declare PekR1 = HandR + <-20+(CarClock-4)*60*1.5, 0, -3-0>
   #declare PekR2 = PekR1 + <-34+(CarClock-4)*60*1.5, 0, 4>
   #declare PekR3 = PekR2 + <-15, 0, 4>

   #declare LangR1 = HandR + <-22+(CarClock-4)*60*2, 0, 0-0>
   #declare LangR2 = LangR1 + <-35+(CarClock-4)*60*2, 0, 0>
   #declare LangR3 = LangR2 + <-20, 0, 2>

   #declare RingR1 = HandR + <-15+(CarClock-4)*15*1.5, 0, 0+0>
   #declare RingR2 = RingR1 + <-30+(CarClock-4)*15*1.5, 0, -1>
   #declare RingR3 = RingR2 + <-15, 0, -2>

   #declare LillR1 = HandR + <-15+(CarClock-4)*15*1.5, 0, -1+0>
   #declare LillR2 = LillR1 + <-10+(CarClock-4)*15*1.5, 0, -1>
   #declare LillR3 = LillR2 + <-15, 0, -2>

   #declare TumExtraRot = y*12 //y*25
   #declare TumR1 = HandR + <-34+(25-25*sin((5-CarClock)*pi/2))*3, -5, -10>
   #declare TumR2 = TumR1 + <0, 0, 5>
   #declare TumR3 = TumR2 + <0, 0, -0>

   #declare VHandTrans = CarTrans + <.1, -.58-(CarClock-4)*2, 1.342+(CarClock-4)*2>
 #break
 #range (4.5, 5)
  #declare ArmR = <0, 5, -0>

  #declare HandR = ArmR + <-22, 0, 0>

  #declare PekR1 = HandR + <-60+(.5)*60*3-(CarClock-4.5)*60*3, 0, -3-9>
  #declare PekR2 = PekR1 + <-20+(.5)*30*3-(CarClock-4.5)*30*3, 0, 4>
  #declare PekR3 = PekR2 + <-20, 0, 4>

  #declare LangR1 = HandR + <-40+(.5)*40*3-(CarClock-4.5)*40*3, 0, 0-0>
  #declare LangR2 = LangR1 + <-50+(.5)*50*3-(CarClock-4.5)*50*3, 0, 0>
  #declare LangR3 = LangR2 + <-20+(.5)*20*3-(CarClock-4.5)*20*3, 0, 2>

  #declare RingR1 = HandR + <-30+(.5)*15*3-(CarClock-4.5)*15*3, 0, 0+0>
  #declare RingR2 = RingR1 + <-10, 0, -1>
  #declare RingR3 = RingR2 + <-10, 0, -2>

  #declare LillR1 = HandR + <-30-20+(.5)*25*3+(CarClock-4.5)*25*3, 0, -1+0>
  #declare LillR2 = LillR1 + <-10, 0, -1>
  #declare LillR3 = LillR2 + <-15-8, 0, -2>

  #declare TumExtraRot = y*12
  #declare TumR1 = HandR + <-40-15+15*(CarClock-4.5)*2, -5, 10>  //<-40+(25-25*sin((2-.5)*pi/2))*3-(25-25*sin((2.5-CarClock+4.5)*pi/2))*3, -5, 10>
  #declare TumR2 = TumR1 + <0, 0, 5>
  #declare TumR3 = TumR2 + <0, 20, -15>

  #declare VHandTrans = TrikeTrans + vrotate(<-.02, -.65, 1.282>, TrikeTravelRot) + z*(.5)*3 - z*(CarClock-4.5)*3
 #break
#end




 //Passar triken

#switch (TrikeClock)
 #range (0, 1)
  #declare ArmR = <0, 5, -0>

  #declare HandR = ArmR + <-22, 0, 0>

  #declare PekR1 = HandR + <-60, 0, -3-9>
  #declare PekR2 = PekR1 + <-20, 0, 4>
  #declare PekR3 = PekR2 + <-20, 0, 4>

  #declare LangR1 = HandR + <-40, 0, 0-0>
  #declare LangR2 = LangR1 + <-50, 0, 0>
  #declare LangR3 = LangR2 + <-20, 0, 2>

  #declare RingR1 = HandR + <-30, 0, 0+0>
  #declare RingR2 = RingR1 + <-10, 0, -1>
  #declare RingR3 = RingR2 + <-10, 0, -2>

  #declare LillR1 = HandR + <-30-TrikeClock*20, 0, -1+0>
  #declare LillR2 = LillR1 + <-10, 0, -1>
  #declare LillR3 = LillR2 + <-15-TrikeClock*8, 0, -2>

  #declare TumR1 = HandR + <-40, -5, 10>
  #declare TumR2 = TumR1 + <0, 0, 5>
  #declare TumR3 = TumR2 + <0, 20, -15>

  #declare VHandTrans = TrikeTrans + vrotate(<-.02, -.65, 1.282>, TrikeTravelRot) //<4.2+.75-.75*sin((TrikeClock*2-1)*pi/2), -5.65, 8.3>
 #break
 #range (1, 999)    //Handen rtar ut sig och lyfts upp
  #declare ArmR = <0, 5, -0>

  #declare HandR = ArmR + <-22, 0, 0>

  #declare PekR1 = HandR + <-60+(TrikeClock-1)*60*3, 0, -3-9>
  #declare PekR2 = PekR1 + <-20+(TrikeClock-1)*30*3, 0, 4>
  #declare PekR3 = PekR2 + <-20, 0, 4>

  #declare LangR1 = HandR + <-40+(TrikeClock-1)*40*3, 0, 0-0>
  #declare LangR2 = LangR1 + <-50+(TrikeClock-1)*50*3, 0, 0>
  #declare LangR3 = LangR2 + <-20+(TrikeClock-1)*20*3, 0, 2>

  #declare RingR1 = HandR + <-30+(TrikeClock-1)*15*3, 0, 0+0>
  #declare RingR2 = RingR1 + <-10, 0, -1>
  #declare RingR3 = RingR2 + <-10, 0, -2>

  #declare LillR1 = HandR + <-30-20+(TrikeClock-1)*25*3, 0, -1+0>
  #declare LillR2 = LillR1 + <-10, 0, -1>
  #declare LillR3 = LillR2 + <-15-8, 0, -2>

  #declare TumR1 = HandR + <-40+(25-25*sin((2-TrikeClock)*pi/2))*3, -5, 10>
  #declare TumR2 = TumR1 + <0, 0, 5>
  #declare TumR3 = TumR2 + <0, 20, -15>

  #declare VHandTrans = TrikeTrans + vrotate(<-.02, -.65, 1.282>, TrikeTravelRot) + z*(TrikeClock-1)*3 //nja...<4.1+.75-.75*sin((1*2-1)*pi/2), -5.6+(TrikeClock-1)*.1, 8.3+(TrikeClock-1)*3>
 #break
#end




 //Passar polismannen
#if ((PolisClock >= 0) & (PolisClock < 15))
  #declare ArmR = <max(-30, 15-PolisClock*10), 5, -0>

  #declare HandR = /*ArmR +*/ <-22, 0, 0>

  #declare PekR1 = HandR + <-48, 0, -3-9>
  #declare PekR2 = PekR1 + <-20, 0, 4>
  #declare PekR3 = PekR2 + <-20, 0, 4>

  #declare LangR1 = HandR + <-40, 0, 0-0>
  #declare LangR2 = LangR1 + <-50, 0, 0>
  #declare LangR3 = LangR2 + <-20, 0, 2>

  #declare RingR1 = HandR + <-30, 0, 0+0>
  #declare RingR2 = RingR1 + <-10, 0, -1>
  #declare RingR3 = RingR2 + <-10, 0, -2>

  #declare LillR1 = HandR + <-30, 0, 0>
  #declare LillR2 = LillR1 + <-10, 0, -1>
  #declare LillR3 = LillR2 + <-15, 0, -2>

  #declare TumExtraRot = y*25
  #declare TumR1 = HandR + <-40, 5, 10> //<-20, +15, -30>
  #declare TumR2 = TumR1 + <0, 0, 5>
  #declare TumR3 = TumR2 + <0, 20, 0>
 #end

 #switch (PolisClock)
  #range (0, 3)
   #declare VHandTrans = PolisTrans + <-1.1, -.68, .40>
  #break
  #range (3, 7)
   #if (PolisClock*2-int(PolisClock*2) > 1/1.3)       //Handen ker ner i nedsttningarna
    #declare VHandTrans = <4.1+PolisClock2*.45+int((PolisClock-3)*2)*.45, -5.68, 7.33-sin(((PolisClock-3)*2-int((PolisClock-3)*2)-1/1.3)*4.1*pi)*.05>
   #else                                              //Annars
    #declare VHandTrans = <4.1+PolisClock2*.45+int((PolisClock-3)*2)*.45, -5.68, 7.33+sin(PolisClock2*pi)*(.2+testest*.3)>
   #end
  #break
  #range (7, 14)
   #declare VHandTrans = PolisTrans + <-1.1, -.68, .40> //<4.1+(PolisClock-3)*.90, -5.68, 7.38+sin((PolisClock-7)*(2-asin(.1))*pi)*.5>
  #break
 #end
 #switch (DrakClock)
  #range (3, 4)
   #declare VHandTrans = PolisTrans + <-1.1, -.68, .40>
  #break
  #range (4, 5.2)
   #declare VHandTrans = <5.2+(7.5-3)*.9 + cos(pi/4)*(8.5-7.7)/.8*1.0, -5 + sin(pi/4)*(8.5-7.7)/.8*1.0, 7+0> // <- PolisTrans
                       + <-1.1, -.68, .40>
                       //+ <-1+cos((min(5.5, DrakClock)-4)*pi)*1, -1+cos((min(5.5, DrakClock)-4)*pi)*1, sin((min(5.5, DrakClock)-4)*pi)*1>
                       //+ <-.75+cos((min(5.0, DrakClock)-4)*pi)*.75, -1.2+cos((min(5.0, DrakClock)-4)*1.1*pi)*1, (DrakClock-4)*3.5-3.5*(DrakClock-4)*(DrakClock-4)>
                       + <-2*(DrakClock-4)/.72, -2*(DrakClock-4)/.72, (DrakClock-4)*7.0-9.75*(DrakClock-4)*(DrakClock-4)>
                       * <.5, 1.5, .75>
                       //* <-cos(radians(135)), sin(radians(135)), 1>
  #break
 #end


#declare PekT1 = vrotate (<.35, .90, 0>, HandR)   //+y*.05
#declare PekT2 = vrotate (<0, .37, 0>, PekR1) + PekT1
#declare PekT3 = vrotate (<0, .23, 0>, PekR2) + PekT2
#declare LangT1 = vrotate (<.17, .90, .04>, HandR)
#declare LangT2 = vrotate (<0, .46, 0>, LangR1) + LangT1
#declare LangT3 = vrotate (<0, .27, 0>, LangR2) + LangT2
#declare RingT1 = vrotate (<-.02, .85, .01>, HandR)
#declare RingT2 = vrotate (<0, .43, 0>, RingR1) + RingT1
#declare RingT3 = vrotate (<0, .27, 0>, RingR2) + RingT2
#declare LillT1 = vrotate (<-.19, .78, -.01>, HandR)
#declare LillT2 = vrotate (<0, .37, 0>, LillR1) + LillT1
#declare LillT3 = vrotate (<0, .20, 0>, LillR2) + LillT2
#declare TumT1 = vrotate (<.42, .2, -.29>, HandR)
#declare TumT2 = vrotate (<0+.06, .37, 0>, TumR1) + TumT1
#declare TumT3 = vrotate (<0, .27, 0>, TumR2) + TumT2

//--

union
{

intersection                              //Pekfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .12  scale <.9, 1, 1.1>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .11  scale <.9, 1, 1.1>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .12}
  cylinder
   {<0, .15, .3>, <0, .15, -.3>, .10
    scale <.5, 1, 1>
   }
  texture {NagelTex}
  //pigment{Red}
  scale <.98, 1, 1.04>
  rotate -x*1  //-x*7
  translate <0, .01, -.066>         //z:-.064
  rotate PekR3
  translate PekT3
 }

intersection                              //Lngfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .12  scale <.9, 1, 1>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .11  scale <.9, 1, 1> inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  //box
  // {<-.05, .04, .6>, <.05, .6, -.6>}
  cylinder
   {<0, .14, .3>, <0, .14, -.3>, .10
    scale <.5, .9, 1>
   }
  texture {NagelTex}
 // pigment{Red}
  rotate -x*6  //-12
  translate <0, .0, -.044>       //z:-.044
  rotate LangR3
  translate LangT3
 }

intersection                              //Ringfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .11  scale <.9, 1, 1.2>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .10  scale <.9, 1, 1.2>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  cylinder
   {<0, .14, .3>, <0, .14, -.3>, .10
    scale <.5, 1, 1>
   }
  texture {NagelTex}
  //pigment{Red}
  rotate -x*9
  translate <0, .02, -.053>
  rotate RingR3
  translate RingT3
 }

intersection                              //Lillfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .11  scale <.9, 1, 1.2>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .10  scale <.9, 1, 1.2>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  cylinder
   {<0, .12, .3>, <0, .12, -.3>, .08
    scale <.5, 1, 1>
   }
  //box
  // {<-.04, .04, .6>, <.04, .6, -.6>}
  texture {NagelTex}
  rotate -x*4
  translate <0, .03, -.074>
  rotate LillR3
  translate LillT3
 }

#if (CarClock <= 4.5)
    intersection                              //Tumnagel
     {cylinder
       {<0, .0, 0>, <0, .2, 0>, .12  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}
      cylinder
       {<0, .0, 0>, <0, .25, 0>, .115  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>} //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>inverse}
      cylinder
       {<0, .03, .2>, <0, .03, .05>, .14
	scale <1, .9, 1>
       }
      cylinder
       {<0, .14, .3>, <0, .14, .10>, .13
	scale <.5, .59, 1> //<.5, .7, 1>
       }
    texture {NagelTex scale <1.5, 1.75, 1> translate <0, -.14, 0>}// scale <1.3, 1.3, 1>  translate <0, -.15, 0>}
    scale <1.35, 1.05, 1>
    translate <0, 0, +.007>
    scale <.83, 1, 1>
    rotate x*7
    rotate TumExtraRot+y*15
    //rotate x*6   //2
    rotate y*85       //85
    //rotate -x*4
    rotate -z*0
    //scale <.8, 1, 1>
    translate <-.064, .155, +.015>  //<-.064, .175, .0>
    rotate TumR3
    translate TumT3
   }
#else
#if (TrikeClock < 3)
   intersection                              //Tumnagel
    {cylinder
      {<0, .0, 0>, <0, .2, 0>, .12  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}
     cylinder
      {<0, .0, 0>, <0, .25, 0>, .115  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>inverse}
     cylinder
      {<0, .03, .2>, <0, .03, .05>, .14
       scale <1, .9, 1>
      }
     cylinder
      {<0, .14, .3>, <0, .14, .10>, .13
       scale <.5, .59, 1> //<.5, .7, 1>
      }
     texture {NagelTex scale <1, 1.75, 1> translate <0, -.10, 0>}// scale <1.3, 1.3, 1>  translate <0, -.15, 0>}
     scale <1.35, 1.05, 1>
     translate <0, 0, -.0>
     rotate TumExtraRot
     rotate x*4   //2
     rotate y*85       //85
     //rotate -x*4
     rotate -z*0
     translate <-.064, .155, -.0>  //<-.064, .175, .0>
     rotate TumR3
     translate TumT3
    }
#else
   intersection                              //Tumnagel
    {cylinder
      {<0, .0, 0>, <0, .2, 0>, .12  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}
     cylinder
      {<0, .0, 0>, <0, .25, 0>, .115  scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(TumExtraRot.y-12)*.023, 1, 1.3>inverse}
     cylinder
      {<0, .03, .2>, <0, .03, .05>, .14
       scale <1, .9, 1>
      }
     cylinder
      {<0, .14, .3>, <0, .14, .10>, .13
       scale <.5, .59, 1> //<.5, .7, 1>
      }
     texture {NagelTex scale <1, 1.75, 1> translate <0, -.10, 0>}// scale <1.3, 1.3, 1>  translate <0, -.15, 0>}
     scale  <1.75, 1.05, .95> //<1.35, 1.05, 1>
     translate <0, 0, .025>
     rotate TumExtraRot
     rotate x*3   //2
     rotate y*85       //85
     //rotate -x*4
     rotate -z*0
     translate <-.07, .155, .03>  //<-.064, .155, .0>
     rotate TumR3
     translate TumT3
    }
#end    #end

blob
 {threshold .5
  cylinder                                  //Pekfinger
   {<0, 0, 0>, <0, .37, 0>, .17, 1          //y:.43
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {FingerTex  translate PekT3}
    scale <1, 1, 14/17>
    rotate PekR1
    translate PekT1
   }
  cylinder
   {<0, 0, 0>, <0, .23, 0>, .16, 1          //y:.27
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {FingerTex  translate PekT2}
    scale <1, 1, 14/17>
    rotate PekR2
    translate PekT2
   }
  cylinder
   {<0, 0, 0>, <0, .15, 0>, .12, 1
    //pigment{color rgb <0.820,0.682,0.616>}
    //texture {FingerTex  translate PekT3}
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate PekR3
    translate PekT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {LedTex}
    //scale <1, 1, 14/17>
    rotate PekR2
    translate PekT2
   }
  sphere
   {<0, 0, 0>, .14, -.5
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {LedTex}
    scale <1, 1, 14/17>
    rotate PekR3
    translate PekT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //Lngfinger
   {<0, 0, 0>, <0, .46, 0>, .17, 1          //y:.50
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate LangR1
    translate LangT1
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .16, 1          //y:.30
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate LangR2
    translate LangT2
   }
  cylinder
   {<0, 0, 0>, <0, .14, 0>, .12, 1          //y:.16
    //texture {FingerTex}
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate LangR3
    translate LangT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    texture {LedTex}
    //scale <1, 1, 14/17>
    rotate LangR2
    translate LangT2
   }
  sphere
   {<0, 0, 0>, .14, -.65
    texture {LedTex}
    scale <1, 1, 14/17>
    rotate LangR3
    translate LangT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //Ringfinger
   {<0, 0, 0>, <0, .43, 0>, .17, 1          //y:.50
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate RingR1
    translate RingT1
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .16, 1          //y:.30
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate RingR2
    translate RingT2
   }
  cylinder
   {<0, 0, 0>, <0, .16, 0>, .12, 1
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate RingR3
    translate RingT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate RingR2
    translate RingT2
   }
  sphere
   {<0, 0, 0>, .14, -.6        //!!!
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate RingR3
    translate RingT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //Lillfinger
   {<0, 0, 0>, <0, .37, 0>, .15, 1
    texture {FingerTex}
    scale <1, 1, 15/17>
    rotate LillR1
    translate LillT1
   }
  cylinder
   {<0, 0, 0>, <0, .20, 0>, .14, 1
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate LillR2
    translate LillT2
   }
  cylinder
   {<0, 0, 0>, <0, .16, 0>, .11, 1
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate LillR3
    translate LillT3
   }
  sphere
   {<0, 0, 0>, .14, -.9
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate LillR2
    translate LillT2
   }
  sphere
   {<0, 0, 0>, .11, -.75        //!!!
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate LillR3
    translate LillT3// + <0, 0.02, 0>
   }
 }

//blob                            //Tummen
// {threshold .5

//  texture {FingerTex}
// }

blob                            //Handloven + Armen
 {threshold .5

  cylinder                //Ben
   {vrotate (<.1, 0, 0>, HandR), vrotate(<.35, .90, 0>+<0, 0, .03>, HandR), .075, 1}         //PekT1=<.35, .90, 0>
  cylinder
   {vrotate (<.033, 0, 0>, HandR), vrotate(<.17, .90, .04>+<0, 0, .03>, HandR), .075, 1}      //LangT1=<.17, .90, .04>
  cylinder
   {vrotate (<-.033, 0, 0>, HandR), vrotate(<-.02, .85, .01>+<0, 0, .03>, HandR), .075, 1}    //RingT1=<-.02, .85, .01>
  cylinder
   {vrotate (<-.1, 0, 0>, HandR), vrotate(<-.19, .78, -.01>+<0, 0, .03>, HandR), .075, 1}     //LillT1=<-.19, .78, -.01>

  cylinder              //Utfyllnad
   {vrotate (<.066, 0, -.02>, HandR), vrotate((<.35, .90, 0>+<.17, .90, .04>)/2+<0, -.06, .02>, HandR), .075, 1} //PekT1=<.35, .90, 0>
  cylinder
   {vrotate (<.0, 0, -.02>, HandR), vrotate((<.17, .90, .04>+<-.02, .85, .01>)/2+<0, -.06, .02>, HandR), .075, 1} //LangT1=<.17, .90, .04>
  cylinder
   {vrotate (<-.066, 0, -.02>, HandR), vrotate((<-.02, .85, .01>+<-.19, .78, -.01>)/2+<0, -.06, .02>, HandR), .075, 1} //RingT1=<-.02, .85, .01>

  sphere                                    //Vnsterkant
   {<0, 0, 0>, .78, 1
    scale <.35, 1, .15> //<.35, 1, .3>//
    rotate y*4
    rotate z*7 //-z*degrees(asin(LillT1.x/LillT1.y))
    translate <-.175, .38, -.02> //<-.175, .34, -.11> //
    //pigment {rgb <0, 1, 0>}
    rotate HandR
   }
  sphere
   {<0, 0, 0>, .78, .9
    scale <.35, .5, .35>
    rotate -x*5  //rotate y*4  rotate z*7
    translate <-.175, .15, -.14>
    //pigment {rgb 1}
    rotate HandR
   }
  sphere
   {<0, 0, 0>, .55, 5  //r:.55
    //scale .5
    scale <.35*1, .7*1.55, .45*.5>*1  //Z:.35
    rotate -x*5  rotate y*4  rotate z*7
    translate <-.225, .62, -.05>  //<-.175, .38, -.10>
    //pigment {rgb <1, 0, .5>*1}
    rotate HandR
   }

  sphere                                    //Hgerkant
   {<0, 0, 0>, .95, .85 // .9, 1 //
    scale  <.34, 1.0, .25> // <.34, 1, .35> //
    rotate -y*4
    rotate -z*16
    translate <.25, .46, -.07> // <.26, .42, -.05> //
    rotate HandR
   }
  /*sphere
   {<0, 0, 0>, .8, .45
    scale <1, 1, 1>
    translate <.5, .8, .5> //pigment{rgb<0,1,0>}
    rotate HandR
   }*/


  cylinder                                  //'Bakkant'
   {<-.18, 0, -.22>, <.20, 0, -.22>, .17, .9
    //pigment {rgb <.5, .7, .9>}
    rotate HandR
   }

  /*cylinder                                  //Pekfingerstump
   {<0, 0, 0>, <0, .05, 0>, .17, .3
    pigment {rgb <2, 0, 0>}
    scale <1, 1, 14/17>
    rotate PekR1
    translate PekT1
   }*/
  cylinder                                  //Pekfingerstump
   {<0, 0, 0>, <0, .2, 0>, .17/1.5, 1
    scale <1, 1, 14/17>
    rotate PekR1
    translate PekT1
   }
  cylinder                                  //Lngfingerstump
   {<0, 0, 0>, <0, .1, 0>, .17, .6
    scale <1, 1, 14/17>
    rotate LangR1
    translate LangT1
   }
  cylinder                                  //Ringfingerstump
   {<0, 0, 0>, <0, .1, 0>, .17, .4
    scale <1, 1, 14/17>
    rotate RingR1
    translate RingT1
   }
  cylinder                                  //Lillfingerstump
   {<0, 0, 0>, <0, .1, 0>, .15, 1
    scale <1, 1, 14/17>
    rotate LillR1
    translate LillT1
    //pigment {rgb<1,0,0>}
   }

  cylinder                                  //Tum-bas
   {<.24, -.1, -.2>, <.42, .2, -.29>+<-.01, -.06, -.07>, .075, .7 //.9   //<.42, .2, -.29>=TumT1  //+<.03, -.06, -.05>
    rotate HandR
    //pigment {rgb<1,.5,0>}
   }
  cylinder
   {vrotate(<.21, 0, 0>, HandR), TumT2, .075, .9
    //rotate HandR
    //pigment{rgb<0,.5,1>*10}
   }
  sphere
   {<.3, .03, -.16>, .2, .6
    rotate HandR
   }
  cylinder
   {<0, 0, 0>, <0, .37, 0>, .26, .95 //pigment{rgb<0,1,0>}
    scale <.95, 1, 1>
    rotate TumExtraRot
    rotate TumR1
    translate TumT1
   }
  /*cylinder
   {<0, 0, 0>, <0, .2, 0>, .20, .3 //.3
    scale <.9, 1, 1>
    rotate TumR2
    translate TumT2
   }*/
  cylinder      //pekfinger-"TumT2"
   {vrotate(<.06, .37-.1, .0>, TumR1) + TumT1, PekT1, .1, .125 //.07, .2   //<.42, .2, -.29>=TumT1
    //pigment {rgb <0, 0, 1>}
   }
  sphere //mellan..
   {<0, 0, 0>, .3, .5
    scale <.65, 1.5, .6> //pigment{rgb<1,0,0>}
    rotate TumR1 / 2
    translate ( vrotate (<.06-.0, .37, 0>, TumR1) + TumT1  +  vrotate ((<.1, 0, .3>+PekT1)/2, HandR) ) / 2
   }
  cylinder      //"TumT2"-pekbens"mitt"
   {vrotate (<.06, .37+.1, 0>, TumR1) + TumT1, vrotate ((<.2, 0, 0>+PekT1)/1.5, HandR), .1, .5 //vrotate ((<.1, 0, 0>+PekT1)/1.3, HandR), .1, .35
    //pigment{rgb<0,0,1>}
   } //.4
  sphere
   {<0,0,0>, .26, -.7
    scale .75 //<.95, 1.1, 1>
    rotate TumR2
    translate TumT2
   }


  sphere                            //"Bula" vid tummen
   {<0, 0, 0>, .25, .5
    scale <1, 2, 1>
    translate <-.14, .07, -.2>
    rotate TumExtraRot
    rotate TumR1
    translate TumT1
   }
  cylinder                          //Tummen
   {<0, 0, 0>, <0, .27, 0>, .20, .95 //1
    scale <.95, 1, 1>  //pigment {rgb<0,1,1>}
    rotate TumExtraRot
    rotate TumR2
    translate TumT2
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .20, .95
    scale <.8, 1, 1>
    rotate TumExtraRot
    texture {ToppTex}
    rotate TumR3
    translate TumT3
   }
  sphere
   {<0, 0, 0>, .20*.9, -1
    scale <1, 1, 1>
    rotate TumExtraRot
    texture {LedTex}
    rotate TumR3
    translate TumT3
   }
  sphere
   {<0, 0, 0>, 10, -1000
    rotate TumExtraRot
    texture {ToppTex}
    translate vrotate(<-7.15, 7.23, 0>, TumR3) + TumT3
   }

  cylinder                                  //Armen
   {<0, -.3, 0>, <0, -2.4, 0>, .6, 1
    scale <1, 1, .37/.6>
    translate <.07, 0, -.1> //<0, 0, -.1>
    rotate ArmR
   }

  //sturm                  //!!!!!!!!!!!!!!!
  texture {FingerTex}
  }

#if ((CarClock > 4.5) & (TrikeClock < 3))
 rotate TrikeTravelRot   //!!!!!!!!!!!!!!
#end

#switch (CarClock)
 #range (3, 4)
  translate  <0, -.58+.095,0>
  rotate CarRot
  translate -<0, -.58+.095, 0>
 #break
 #range (4, 4.5)
  translate  <0, -.58+.095,0>
  rotate CarRot
  translate -<0, -.58+.095, 0>
 #break
#end

#switch (DrakClock)
 #range (3, 4)
  rotate <0, -80, 0>
  translate  <-1.1, -.68, 0>
  rotate <0, 0, PolisRot.z-90>
  translate  -<-1.1, -.68, 0>
  rotate <8+sin(-pi/2+(DrakClock-3)*6*pi)*8, 0, 0>

 #break
 #range (4, 4+1/6)
  rotate <0, -80, 0>
  rotate <8+sin(-pi/2+(DrakClock-4)*6*pi)*8, 0, 0>
  translate  <-1.1, -.68, 0>
  rotate <0, 0, PolisRot.z-90>
  translate  -<-1.1, -.68, 0>
 #break
 #range (4+1/6, 999)
  rotate <0, -80, 0>
  rotate <8*2, 0, 0>
  translate  <-1.1, -.68, 0>
  rotate <0, 0, PolisRot.z-90>
  translate  -<-1.1, -.68, 0>
 #break
 #else
  #if (PolisClock >= 0)
   rotate <0, -80, 0>
   translate  <-1.1, -.68, 0>
   rotate <0, 0, PolisRot.z-90>
   translate  -<-1.1, -.68, 0>
  #end
#end

translate VHandTrans+z*.0
//translate <10.4, -4.7, 7.8>
} //slut p Hand-union


#end //ifdef



//--HGERHANDEN-------------------------------------------------------------

#ifdef (HHand)
                            //scale -x !

#declare HHandTrans = <0, 0, -10>
#declare HArmR=<0,0,0>   #declare HHandR=<0,0,0>  #declare HPekR1=<0,0,0>  #declare HPekR2=<0,0,0>  #declare HPekR3=<0,0,0>
#declare HLangR1=<0,0,0>  #declare HLangR2=<0,0,0>  #declare HLangR3=<0,0,0>  #declare HRingR1=<0,0,0>  #declare HRingR2=<0,0,0>
#declare HRingR3=<0,0,0>  #declare HLillR1=<0,0,0>  #declare HLillR2=<0,0,0>  #declare HLillR3=<0,0,0>  #declare HTumExtraRot=<0,0,0>
#declare HTumR1=<0,0,0>  #declare HTumR2=<0,0,0>  #declare HTumR3=<0,0,0>


 //Passar draken
#switch (DrakClock)
 #range (0, 5)
  #declare HArmR = <-10, 5, -0>

  #declare HHandR = /*HArmR +*/ <-22, 0, 0>

  #declare HPekR1 = HHandR + <-50, 0, -3-9>
  #declare HPekR2 = HPekR1 + <-30, 0, 4> //<-20, 0, 4>
  #declare HPekR3 = HPekR2 + <-20, 0, 4>

  #declare HLangR1 = HHandR + <-40, 0, 0-0>
  #declare HLangR2 = HLangR1 + <-32, 0, 0> //<-50, 0, 0>
  #declare HLangR3 = HLangR2 + <-20, 0, 2>

  #declare HRingR1 = HHandR + <-30, 0, 0+0>
  #declare HRingR2 = HRingR1 + <-20, 0, -1> //<-10, 0, -1>
  #declare HRingR3 = HRingR2 + <-15, 0, -2> //<-10, 0, -2>

  #declare HLillR1 = HHandR + <-30, 0, 0>
  #declare HLillR2 = HLillR1 + <-10, 0, -1>
  #declare HLillR3 = HLillR2 + <-15, 0, -2>

  #declare HTumExtraRot = <0,0,0>//y*25
  #declare HTumR1 = HHandR + <-40, 5, 10> //<-20, +15, -30>
  #declare HTumR2 = HTumR1 + <0, 0, 5>
  #declare HTumR3 = HTumR2 + <0, 20, 0>

 #break
#end



#declare HPekT1 = vrotate (<.35, .90, 0>, HHandR)   //+y*.05
#declare HPekT2 = vrotate (<0, .37, 0>, HPekR1) + HPekT1
#declare HPekT3 = vrotate (<0, .23, 0>, HPekR2) + HPekT2
#declare HLangT1 = vrotate (<.17, .90, .04>, HHandR)
#declare HLangT2 = vrotate (<0, .46, 0>, HLangR1) + HLangT1
#declare HLangT3 = vrotate (<0, .27, 0>, HLangR2) + HLangT2
#declare HRingT1 = vrotate (<-.02, .85, .01>, HHandR)
#declare HRingT2 = vrotate (<0, .43, 0>, HRingR1) + HRingT1
#declare HRingT3 = vrotate (<0, .27, 0>, HRingR2) + HRingT2
#declare HLillT1 = vrotate (<-.19, .78, -.01>, HHandR)
#declare HLillT2 = vrotate (<0, .37, 0>, HLillR1) + HLillT1
#declare HLillT3 = vrotate (<0, .20, 0>, HLillR2) + HLillT2
#declare HTumT1 = vrotate (<.42, .2, -.29>, HHandR)
#declare HTumT2 = vrotate (<0+.06, .37, 0>, HTumR1) + HTumT1
#declare HTumT3 = vrotate (<0, .27, 0>, HTumR2) + HTumT2

//--

union
{

intersection                              //HPekfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .12  scale <.9, 1, 1.1>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .11  scale <.9, 1, 1.1>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .12}
  cylinder
   {<0, .15, .3>, <0, .15, -.3>, .10
    scale <.5, 1, 1>
   }
  texture {NagelTex}
  //pigment{Red}
  scale <.98, 1, 1.04>
  rotate -x*1  //-x*7
  translate <0, .01, -.056>         //z:-.064
  rotate HPekR3
  translate HPekT3
 }

intersection                              //HLngfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .12  scale <.9, 1, 1>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .11  scale <.9, 1, 1> inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  //box
  // {<-.05, .04, .6>, <.05, .6, -.6>}
  cylinder
   {<0, .14, .3>, <0, .14, -.3>, .10
    scale <.5, .9, 1>
   }
  texture {NagelTex}
 // pigment{Red}
  rotate -x*6  //-12
  translate <0, .0, -.036>       //z:-.044
  rotate HLangR3
  translate HLangT3
 }

intersection                              //HRingfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .11  scale <.9, 1, 1.2>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .10  scale <.9, 1, 1.2>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  cylinder
   {<0, .14, .3>, <0, .14, -.3>, .10
    scale <.5, 1, 1>
   }
  texture {NagelTex}
  //pigment{Red}
  rotate -x*9
  translate <0, .02, -.053>
  rotate HRingR3
  translate HRingT3
 }

intersection                              //HLillfingernagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .11  scale <.9, 1, 1.2>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .10  scale <.9, 1, 1.2>  inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .0>, .14}
  cylinder
   {<0, .12, .3>, <0, .12, -.3>, .08
    scale <.5, 1, 1>
   }
  //box
  // {<-.04, .04, .6>, <.04, .6, -.6>}
  texture {NagelTex}
  rotate -x*4
  translate <0, .03, -.074>
  rotate HLillR3
  translate HLillT3
 }


intersection                              //HTumnagel
 {cylinder
   {<0, .0, 0>, <0, .2, 0>, .12  scale <.5+.3-(HTumExtraRot.y-12)*.023, 1, 1.3>}  //scale <.5+.3-(HTumExtraRot.y-12)*.023, 1, 1.3>}
  cylinder
   {<0, .0, 0>, <0, .25, 0>, .115  scale <.5+.3-(HTumExtraRot.y-12)*.023, 1, 1.3>} //scale <.5+.3-(HTumExtraRot.y-12)*.023, 1, 1.3>inverse}
  cylinder
   {<0, .03, .2>, <0, .03, .05>, .14
    scale <1, .9, 1>
   }
  cylinder
   {<0, .14, .3>, <0, .14, .10>, .13
    scale <.5, .59, 1> //<.5, .7, 1>
   }
  texture {NagelTex scale <1.75, 1.75, 1> translate <-.035, -.14, 0>}// scale <1.5, 1.75, 1>  translate <0, -.14, 0>}
  scale <1.35, 1.05, 1>
  translate <0, 0.01, -.003>
  scale <.75, 1, 1>
  rotate x*5  //7
  rotate HTumExtraRot+y*15
  //rotate x*6   //2
  rotate y*80       //85
  //rotate -x*4
  rotate -z*0
  //scale <.8, 1, 1>
  translate <-.064, .155, +.015>  //<-.064, .175, .0>
  rotate HTumR3
  translate HTumT3
 }

blob
 {threshold .5
  cylinder                                  //HPekfinger
   {<0, 0, 0>, <0, .37, 0>, .17, 1          //y:.43
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {FingerTex  translate HPekT3}
    scale <1, 1, 14/17>
    rotate HPekR1
    translate HPekT1
   }
  cylinder
   {<0, 0, 0>, <0, .23, 0>, .16, 1          //y:.27
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {FingerTex  translate HPekT2}
    scale <1, 1, 14/17>
    rotate HPekR2
    translate HPekT2
   }
  cylinder
   {<0, 0, 0>, <0, .15, 0>, .12, 1
    //pigment{color rgb <0.820,0.682,0.616>}
    //texture {FingerTex  translate HPekT3}
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate HPekR3
    translate HPekT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {LedTex}
    //scale <1, 1, 14/17>
    rotate HPekR2
    translate HPekT2
   }
  sphere
   {<0, 0, 0>, .14, -.5
    //pigment{color rgb <0.820,0.682,0.616>}
    texture {LedTex}
    scale <1, 1, 14/17>
    rotate HPekR3
    translate HPekT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //HLngfinger
   {<0, 0, 0>, <0, .46, 0>, .17, 1          //y:.50
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HLangR1
    translate HLangT1
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .16, 1          //y:.30
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HLangR2
    translate HLangT2
   }
  cylinder
   {<0, 0, 0>, <0, .14, 0>, .12, 1          //y:.16
    //texture {FingerTex}
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate HLangR3
    translate HLangT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    texture {LedTex}
    //scale <1, 1, 14/17>
    rotate HLangR2
    translate HLangT2
   }
  sphere
   {<0, 0, 0>, .14, -.65
    texture {LedTex}
    scale <1, 1, 14/17>
    rotate HLangR3
    translate HLangT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //HRingfinger
   {<0, 0, 0>, <0, .43, 0>, .17, 1          //y:.50
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HRingR1
    translate HRingT1
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .16, 1          //y:.30
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HRingR2
    translate HRingT2
   }
  cylinder
   {<0, 0, 0>, <0, .16, 0>, .12, 1
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate HRingR3
    translate HRingT3
   }
  sphere
   {<0, 0, 0>, .16, -.9
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate HRingR2
    translate HRingT2
   }
  sphere
   {<0, 0, 0>, .14, -.6        //!!!
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HRingR3
    translate HRingT3// + <0, 0.02, 0>
   }
 }

blob
 {threshold .5
  cylinder                                  //HLillfinger
   {<0, 0, 0>, <0, .37, 0>, .15, 1
    texture {FingerTex}
    scale <1, 1, 15/17>
    rotate HLillR1
    translate HLillT1
   }
  cylinder
   {<0, 0, 0>, <0, .20, 0>, .14, 1
    texture {FingerTex}
    scale <1, 1, 14/17>
    rotate HLillR2
    translate HLillT2
   }
  cylinder
   {<0, 0, 0>, <0, .16, 0>, .11, 1
    texture {ToppTex}
    scale <1, 1, 14/17>
    rotate HLillR3
    translate HLillT3
   }
  sphere
   {<0, 0, 0>, .14, -.9
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate HLillR2
    translate HLillT2
   }
  sphere
   {<0, 0, 0>, .11, -.75        //!!!
    texture {FingerTex}
    //scale <1, 1, 14/17>
    rotate HLillR3
    translate HLillT3// + <0, 0.02, 0>
   }
 }

//blob                            //HTummen
// {threshold .5

//  texture {FingerTex}
// }

blob                            //HHandloven + Armen
 {threshold .5

  cylinder                //Ben
   {vrotate (<.1, 0, 0>, HHandR), vrotate(<.35, .90, 0>+<0, 0, .03>, HHandR), .075, 1}         //PekT1=<.35, .90, 0>
  cylinder
   {vrotate (<.033, 0, 0>, HHandR), vrotate(<.17, .90, .04>+<0, 0, .03>, HHandR), .075, 1}      //LangT1=<.17, .90, .04>
  cylinder
   {vrotate (<-.033, 0, 0>, HHandR), vrotate(<-.02, .85, .01>+<0, 0, .03>, HHandR), .075, 1}    //RingT1=<-.02, .85, .01>
  cylinder
   {vrotate (<-.1, 0, 0>, HHandR), vrotate(<-.19, .78, -.01>+<0, 0, .03>, HHandR), .075, 1}     //LillT1=<-.19, .78, -.01>

  cylinder              //Utfyllnad
   {vrotate (<.066, 0, -.02>, HHandR), vrotate((<.35, .90, 0>+<.17, .90, .04>)/2+<0, -.06, .02>, HHandR), .075, 1} //PekT1=<.35, .90, 0>
  cylinder
   {vrotate (<.0, 0, -.02>, HHandR), vrotate((<.17, .90, .04>+<-.02, .85, .01>)/2+<0, -.06, .02>, HHandR), .075, 1} //LangT1=<.17, .90, .04>
  cylinder
   {vrotate (<-.066, 0, -.02>, HHandR), vrotate((<-.02, .85, .01>+<-.19, .78, -.01>)/2+<0, -.06, .02>, HHandR), .075, 1} //RingT1=<-.02, .85, .01>

  sphere                                    //Vnsterkant
   {<0, 0, 0>, .78, 1
    scale <.35, 1, .15> //<.35, 1, .3>//
    rotate y*4
    rotate z*7 //-z*degrees(asin(LillT1.x/LillT1.y))
    translate <-.175, .38, -.02> //<-.175, .34, -.11> //
    //pigment {rgb <0, 1, 0>}
    rotate HHandR
   }
  sphere
   {<0, 0, 0>, .78, .9
    scale <.35, .5, .35>
    rotate -x*5  //rotate y*4  rotate z*7
    translate <-.175, .15, -.14>
    //pigment {rgb 1}
    rotate HHandR
   }
  sphere
   {<0, 0, 0>, .55, 5  //r:.55
    //scale .5
    scale <.35*1, .7*1.55, .45*.5>*1  //Z:.35
    rotate -x*5  rotate y*4  rotate z*7
    translate <-.225, .62, -.05>  //<-.175, .38, -.10>
    //pigment {rgb <1, 0, .5>*1}
    rotate HHandR
   }

  sphere                                    //Hgerkant
   {<0, 0, 0>, .95, .85 // .9, 1 //
    scale  <.34, 1.0, .25> // <.34, 1, .35> //
    rotate -y*4
    rotate -z*16
    translate <.25, .46, -.07> // <.26, .42, -.05> //
    rotate HHandR
   }
  /*sphere
   {<0, 0, 0>, .8, .45
    scale <1, 1, 1>
    translate <.5, .8, .5> //pigment{rgb<0,1,0>}
    rotate HHandR
   }*/


  cylinder                                  //'Bakkant'
   {<-.18, 0, -.22>, <.20, 0, -.22>, .17, .9
    //pigment {rgb <.5, .7, .9>}
    rotate HHandR
   }

  /*cylinder                                  //HPekfingerstump
   {<0, 0, 0>, <0, .05, 0>, .17, .3
    pigment {rgb <2, 0, 0>}
    scale <1, 1, 14/17>
    rotate HPekR1
    translate HPekT1
   }*/
  cylinder                                  //HPekfingerstump
   {<0, 0, 0>, <0, .2, 0>, .17/1.5, 1
    scale <1, 1, 14/17>
    rotate HPekR1
    translate HPekT1
   }
  cylinder                                  //Lngfingerstump
   {<0, 0, 0>, <0, .1, 0>, .17, .6
    scale <1, 1, 14/17>
    rotate HLangR1
    translate HLangT1
   }
  cylinder                                  //HRingfingerstump
   {<0, 0, 0>, <0, .1, 0>, .17, .4
    scale <1, 1, 14/17>
    rotate HRingR1
    translate HRingT1
   }
  cylinder                                  //HLillfingerstump
   {<0, 0, 0>, <0, .1, 0>, .15, 1
    scale <1, 1, 14/17>
    rotate HLillR1
    translate HLillT1
    //pigment {rgb<1,0,0>}
   }

  cylinder                                  //HTum-bas
   {<.24, -.1, -.2>, <.42, .2, -.29>+<-.01, -.06, -.07>, .075, .7 //.9   //<.42, .2, -.29>=TumT1  //+<.03, -.06, -.05>
    rotate HHandR
    //pigment {rgb<1,.5,0>}
   }
  cylinder
   {vrotate(<.21, 0, 0>, HHandR), HTumT2, .075, .9
    //rotate HHandR
    //pigment{rgb<0,.5,1>*10}
   }
  sphere
   {<.3, .03, -.16>, .2, .6
    rotate HHandR
   }
  cylinder
   {<0, 0, 0>, <0, .37, 0>, .26, .95 //pigment{rgb<0,1,0>}
    scale <.95, 1, 1>
    rotate HTumExtraRot
    rotate HTumR1
    translate HTumT1
   }
  /*cylinder
   {<0, 0, 0>, <0, .2, 0>, .20, .3 //.3
    scale <.9, 1, 1>
    rotate HTumR2
    translate HTumT2
   }*/
  cylinder      //HPekfinger-"HTumT2"
   {vrotate(<.06, .37-.1, .0>, HTumR1) + HTumT1, HPekT1, .1, .125 //.07, .2   //<.42, .2, -.29>=HTumT1
    //pigment {rgb <0, 0, 1>}
   }
  sphere //mellan..
   {<0, 0, 0>, .3, .5
    scale <.65, 1.5, .6> //pigment{rgb<1,0,0>}
    rotate HTumR1 / 2
    translate ( vrotate (<.06-.0, .37, 0>, HTumR1) + HTumT1  +  vrotate ((<.1, 0, .3>+HPekT1)/2, HHandR) ) / 2
   }
  cylinder      //"HTumT2"-HPekbens"mitt"
   {vrotate (<.06, .37+.1, 0>, HTumR1) + HTumT1, vrotate ((<.2, 0, 0>+HPekT1)/1.5, HHandR), .1, .5 //vrotate ((<.1, 0, 0>+HPekT1)/1.3, HHandR), .1, .35
    //pigment{rgb<0,0,1>}
   } //.4
  sphere
   {<0,0,0>, .26, -.7
    scale .75 //<.95, 1.1, 1>
    rotate HTumR2
    translate HTumT2
   }


  sphere                            //"Bula" vid HTummen
   {<0, 0, 0>, .25, .5
    scale <1, 2, 1>
    translate <-.14, .07, -.2>
    rotate HTumExtraRot
    rotate HTumR1
    translate HTumT1
   }
  cylinder                          //HTummen
   {<0, 0, 0>, <0, .27, 0>, .20, .95 //1
    scale <.95, 1, 1>  //pigment {rgb<0,1,1>}
    rotate HTumExtraRot
    rotate HTumR2
    translate HTumT2
   }
  cylinder
   {<0, 0, 0>, <0, .27, 0>, .20, .95
    scale <.8, 1, 1>
    rotate HTumExtraRot
    texture {ToppTex}
    rotate HTumR3
    translate HTumT3
   }
  sphere
   {<0, 0, 0>, .20*.9, -1
    scale <1, 1, 1>
    rotate HTumExtraRot
    texture {LedTex}
    rotate HTumR3
    translate HTumT3
   }
  sphere
   {<0, 0, 0>, 10, -1000
    rotate HTumExtraRot
    texture {ToppTex}
    translate vrotate(<-7.15, 7.23, 0>, HTumR3) + HTumT3
   }

  cylinder                                  //HArmen
   {<0, -.3, 0>, <0, -2.4, 0>, .6, 1
    scale <1, 1, .37/.6>
    translate <.07, 0, -.1> //<0, 0, -.1>
    rotate HArmR
   }

  //sturm                  //!!!!!!!!!!!!!!!
  texture {FingerTex}
  }


scale <-1, 1, 1>                                    //!!!!!! !!!! !!!! !!!! !!!!

#switch (DrakClock)
 #range (0, 4.5)
  #declare HHandTrans = DrakTrans + <1.1, -.68, .75>
 #break
#end  

rotate y*67
translate <1.1, -.68, .75>
rotate <0, 0, DrakRot>
//rotate
translate -<1.1, -.68, .75>

//rotate y*60
translate HHandTrans

//translate <10.4, -4.7, 7.8>
}  //slut p HHand-union?

#end //ifdef


//--DRAKEN------------------------------------------------------------------
union
 {intersection{
  blob
   {threshold .5
    sphere              //Kroppen...
     {<0, 0, 0>, .55, 1
      scale <1.1, 1, 1.1>
      translate <.05, 0, .1>
     }
    sphere
     {<.1, 0, .4>, .35, .9}
    sphere
     {<.2, 0, .7>, .3, .8}
    sphere                //Kken..
     {<0, 0, 0>, .5, .5
      scale <.9, .55, .55>
      rotate -y*8
      translate <-.04, 0, .85>
     }
    sphere
     {<0, 0, 0>, .5, .5
      scale <.9, .55, .55>
      rotate y*8
      translate <-.04, 0, .9>
     }
    sphere              //Huvudet...
     {<.15, 0, 1>, .35, .8}
    /*cylinder
     {<-.07, -1, 1.1>, <-.07, 1, 1.1>, .13, -.2
      scale <.8, 1, 1>
     }*/
    sphere
     {0, .14*1.25, -.4/1.75
      //scale <1.1, 1, 1>
      translate <-.04, -.11, 1.1>
     }
    sphere
     {0, .14*1.25, -.4/1.75
      //scale <1.1, 1, 1>
      translate <-.04, +.11, 1.1>
     }
    sphere              //gon(bas)..
     {<.010, -.09, 1.06>, .05, .1}
    sphere
     {<.010, +.09, 1.06>, .05, .1  pigment {rgb 2} }
    sphere              //Nsborrar....
     {<-.12, -.075, .97>, .04, 1}
    sphere
     {<-.14, -.075, .97>, .03, -.6}
    sphere
     {<-.12, +.075, .97>, .04, 1}
    sphere
     {<-.14, +.075, .97>, .03, -.6}

    cylinder                   //Vnsterben
     {<.1, -.22, .45>, <.03, -.24, .32>, .14, 1}
    cylinder
     {<.04, -.24, .32>, <.1, -.24, 0>, .14, .8}
    sphere
     {0, .14, 1
      scale <1.85, 1.1, 1>
      rotate <0, 3, 12>
      translate <0, -.29, 0>
     }
    cylinder
     {<0, 0, 0>, <0, 0, .2>, .025, -.5
      scale <1, .5, 1>  rotate z*5
      translate <-.17, -.27, 0>
      //pigment {rgb<1,0,0>}
     }
    cylinder
     {<0, 0, 0>, <0, 0, .2>, .025, -.5
      scale <1, .5, 1>  rotate z*15
      translate <-.17, -.32, 0>
      //pigment {rgb<1,0,0>}
     }
    cylinder                   //Hgerben
     {<.1, +.22, .45>, <.03, +.24, .32>, .14, 1}
    cylinder
     {<.04, +.24, .32>, <.1, +.24, 0>, .14, .8}
    sphere
     {0, .14, 1
      scale <1.85, 1.1, 1>
      rotate <0, 3, -12>
      translate <0, +.29, 0>
     }
    cylinder
     {<0, 0, 0>, <0, 0, .2>, .025, -.5
      scale <1, .5, 1>  rotate -z*5
      translate <-.17, +.27, 0>
      pigment {rgb<1,0,0>}
     }
    cylinder
     {<0, 0, 0>, <0, 0, .2>, .025, -.5
      scale <1, .5, 1>  rotate -z*15
      translate <-.17, +.32, 0>
      pigment {rgb<1,0,0>}
     }

    sphere                   //Svans
     {0, .3, 1
      scale <1, .5, 1>
      translate <.3, 0, 0>
     }
    sphere
     {0, .5, .8
      scale <2.0, .3, .45> //<2.5, .3, .5>
      translate <.55, 0, 0> //.4...
     }
    sphere                   //Taggar
     {0, .2, 1
      scale <1, .14, .4>*.4
      rotate -y*108
      translate <.12, 0, 1.15>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.5
      rotate -y*80
      translate <.2, 0, 1.15>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.6
      rotate -y*42
      translate <.28, 0, 1.10>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.6
      rotate -y*31
      translate <.33, 0, 1.02>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.65
      rotate -y*17
      translate <.35, 0, .92>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.70
      rotate -y*12
      translate <.37, 0, .82>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.75
      rotate -y*5
      translate <.37, 0, .705>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.80
      rotate -y*3
      translate <.37, 0, .58>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.85
      rotate -y*7
      translate <.37, 0, .46>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.90
      rotate -y*40
      translate <.40, 0, .33>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.90
      rotate -y*57
      translate <.47, 0, .22>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.80
      rotate -y*67
      translate <.57, 0, .17>
     }
    sphere
     {0, .2, 1
      scale <1, .12, .4>*.70
      rotate -y*70
      translate <.67, 0, .14>
     }
    sphere
     {0, .2, 1
      scale <1, .14, .4>*.60
      rotate -y*80
      translate <.76, 0, .11>
     }
    sphere
     {0, .2, 1
      scale <1, .14, .4>*.50
      rotate -y*80
      translate <.85, 0, .07>
     }
    sphere
     {0, .2, 1
      scale <1, .14, .4>*.50
      rotate -y*70
      translate <.92, 0, .05>
     }

    sphere          //Gjutskgg
     {0, 2, .04
      scale <.004, 1, 1>
      translate <.16, 0, 0>
     }

    clipped_by
     {box {<-1, .0035, 0>, <1, .000, 2>  inverse}   //skra
      cylinder {<0, -1, 0>, <0, 1, 0>, .1  scale <1.5, 1, .52>  translate <-.3, 0, .87>  inverse}  //min
      //box {-.03, .03  rotate <0,45,40>  scale <1,1,.5>  translate <.010, -.09, 1.06>  inverse}
      //sphere {<.01-.02, -.09-.02, 1.06>, .03  inverse}
     }

    //sturm

    scale <1, .9, 1>
    texture {DrakTex}
   }

  box
   {<-.8, -.5, .01>, <1.2, .5, 1.25>
    texture {DrakTex}
   }
 }  //Slut p drakkroppsintersection

   sphere       //ga
    {<.0, -.09+.02, 1.06>, .02
     texture {DrakTex}
     pigment {rgb .25}
    }
   sphere       //ga
    {<.0, +.09-.02, 1.06>, .02
     texture {DrakTex}
     pigment {rgb .25}
    }

/*  cylinder
   {<.17, -.15, .7>, <.17, .15, .7>, .07
    texture {DrakTex}
   }

  blob                      //Vnsterarm
   {threshold .5
    cylinder
     {<0, -.05, 0>, <-.05, -.25, 0>, .15, 1
     }
    sphere
     {<-.05, -.25, 0>, .125, -.75}
    cylinder
     {<-.05, -.25, 0>, <-.25, -.35, 0>, .125, 1
     }
    sphere
     {0, 1, .05
      scale <1, 1, .008>
      translate <-.05, -.25, 0>
     }
 /*    sphere
     {0, .1, -.8
      translate <-.25, -.35, 0>
     }
    cylinder
     {<-.29, -.36, .08>, <-.40, -.38, -.01>, .07, .7}

    cylinder
     {<-.25, -.34, 0>, <-.35, -.29, .05>, .08, .6}
    sphere
     {<-.35, -.29, .05>, .07, -.7}
    cylinder
     {<-.35, -.29, .05>, <-.43, -.29, -.03>, .07, .7}

   // sphere
   //  {<-.35, -.35, .05>, .4, -.3}
 */
    clipped_by
     {box {<-1, 0, -1>, <1, -2, 1>}
     }
    translate <.17, -.15, .7>
    texture {DrakTex}
    translate -<.17, -.15, .7>
    rotate <0, -35, 0>
    translate <.17, -.15, .7>
   }

  blob                      //Hgerarm
   {threshold .5
    cylinder
     {<0, +.05, 0>, <-.05, +.25, 0>, .15, 1
     }
    sphere
     {<-.05, +.25, 0>, .125, -.75}
    cylinder
     {<-.05, +.25, 0>, <-.25, +.35, 0>, .125, 1
     }
    sphere
     {0, 1, .05
      scale <1, 1, .008>
      translate <-.05, +.25, 0>
     }
    clipped_by
     {box {<-1, 0, -1>, <1, +2, 1>}
     }
    translate <.17, +.15, .6>
    texture {DrakTex}
    translate -<.17, +.15, .6>
    rotate <0, 5, 0>
    translate <.17, +.15, .6>
   }
*/

#ifdef (Gnistor)
  #debug concat("Gnistor: ", str(Gnistor, 0, 3), "\n")
  #declare varv = 0
  #while (varv <= Gnistor)  // <15
   #debug concat("varv: ", str(varv,0,3), "\n")
   cylinder                      //Gnistor!
    {<0, 0, 0>, <-1, 0, 0>, .008
     texture {GnistTex}  no_shadow
     scale .05+rand(R2)*.2
     translate <-.2-rand(R2)*.2, 0, 0>
     rotate y*(-15+rand(R2)*30)
     rotate x*rand(R2)*360
     translate <0, 0, .85>
     //rotate <0, -20+rand(R2)*40, -20+rand(R2)*40>
     //translate <-.2-rand(R2)*.1, -.1+rand(R2)*.1, .85+rand(R2)*.05>
    }
   #declare varv=varv+1
  #end
/*  #declare rrr=rand(R2)
  light_source
   {<0, 0, .85> rgb <.5, .5, .3>*rrr
    fade_distance .06
    //fade_power 3
   }
*/
#end

  cylinder     //Hjul 1
   {<0, .15, .1-.03>, <0, .23, .1-.03>, .1
    pigment {rgb <.2, .15, .1>}
   }

  cylinder     //Hjul 2
   {<0, -.15, .1-.03>, <0, -.23, .1-.03>, .1
    pigment {rgb <.2, .15, .1>}
   }

   cylinder            //gnist-hjul
    {<.0, -.015, .94>, <.0, .015, .94>, .06
     pigment {rgb 1.5}
    }
   box                  //pln
    {<-.02, -.01, .87>, <.02, .01, .67>
     pigment {rgb <.2, .15, .1>}
    }

translate <0, 0, .03>
rotate <0, 1.5, 0>



rotate <0, 0, DrakRot>
translate DrakTrans

 }



//--POLISBIL----------------------------------------------------------------

#ifdef (Polisbil)

#declare PHjul =
union
 {height_field
   {png "navkapsel.png"
    scale <.12, .05, .12>
    translate <-.06, 0, -.06>
    smooth
    translate y*.05
   }
  superellipsoid
   {<1, .3>
    scale <.09, .09, .05>
    rotate x*90
    texture {WindowTex}
    normal {bumps 0}
    translate y*.04
   }
  scale <1.2, 1, 1.2>
 }

union
 {#include "polisbil.pov"
  object
   {PHjul
    texture {NavTex}
    rotate y*rand(R3)*360
    rotate y*min(3, CarClock)*1*360
    translate <1.15 , .45, .04>
   }
  object
   {PHjul
    texture {NavTex} //translate x*rand(R3)*20}
    rotate y*rand(R3)*360
    rotate y*min(3, CarClock)*1*360
    translate <.3 , .44, .04>
   }
  object
   {PHjul
    texture {NavTex translate x*rand(R3)*20}
    rotate z*180
    rotate y*rand(R3)*360
    rotate y*min(3, CarClock)*1*360
    translate <1.15 , .07, .04>
   }
  object
   {PHjul
    texture {NavTex translate x*rand(R3)*20}
    rotate z*180
    rotate y*rand(R3)*360
    rotate y*min(3, CarClock)*1*360
    translate <.3 , .09, .04>
   }

  //translate <pi*2*(.09*1.2)*2*clock, 0, 0>
  //rotate z*80

  rotate CarRot
  translate CarTrans

  #ifdef (CarCollisionTime)
    //rotate -z*80              //centrera..
    //translate <-.7, -.25, 0>
    translate -CarTrans
    rotate -CarRot
    translate <-.7, -.25, 0>
     rotate -z*sin(min(.5, (TrikeClock-CarCollisionTime))*pi)*60 //snurrar i .5 s, glider i .7 s
    //translate -<-.7, -.25, 0>
    //rotate z*80
    translate -<-.7, -.25, 0>
    rotate CarRot
    translate CarTrans
   translate TrikeRotFactor * sin(min(.7, (TrikeClock-CarCollisionTime))*pi*.5/.7)*.4
  #end

  //translate <7.6, -4.55, 6.89+.068>
  ///translate <5.3+pi*2*(.09*1.2)*2*clock, -5, 6.79+.068>
 }

#end // ifdef Polisbil


//--POLISDOCKA--------------------------------------------------------------

#ifdef (Polis)

union {

intersection
 {blob			//Vnster-stvel
   {threshold .5
    sphere
     {<0, 0, 0>, .25, 1
      scale <.5, .9, .5>
      translate <0, -.1, .01>
     }
    sphere
     {<0, 0, 0>, .15, -.2
      scale <1, 1, .25>
      rotate -x*40
      translate <0, -.03, .05>
     }
    sphere
     {<0, .1, -.1>, .3, -.2}
    cylinder
     {<0, 0, 0>, <0, -.02, .6>, .12, 1
      scale <1, 1, .4>
     }
   }
  plane
   {z, 0  inverse}
  translate <+.1, 0, 0>
  pigment {rgb <.2, .2, .2>}
  finish {specular .25  roughness .05}
  normal {bumps .12 scale .010}
 }

intersection
 {blob			//Hger-stvel
   {threshold .5
    sphere
     {<0, 0, 0>, .25, 1
      scale <.5, .9, .5>
      translate <0, -.1, .01>
     }
    sphere
     {<0, 0, 0>, .15, -.3
      scale <.65, 1, .2>
      rotate -x*40
      translate <0,  -.04, .066>
     }
    sphere
     {<0, .1, -.1>, .3, -.25}
    cylinder
     {<0, 0, 0>, <0, -.02, .6>, .12, 1
      scale <1, 1, .4>
     }
   }
  plane
   {z, 0  inverse}
  translate <-.1, 0, 0>
  pigment {rgb <.2, .2, .2>}
  finish {specular .25  roughness .05}
  normal {bumps .12 scale .010}
 }


blob            //Ben
 {threshold .5
  cylinder  //V Smalben..
   {<+.1, -.02, .6*.4>, <+.1, -.04, .4>, .11, 1}
  sphere
   {<0, 0, 0>, .11, .4
    scale <.9, 1, 1>
    translate <+.1, -.02, .35>
   }
  sphere    //anti
   {<+.1, -.04, .4>, .11, -1}
  cylinder  //V Lr...
   {<+.1, -.04, .4>, <+.05, 0, .72>, .14, 1}
  sphere
   {<0, 0, 0>, .18, .5  //pigment{rgb<.2, .3, .6>}
    scale <1, 1, 1>
    translate <+.1, .02, .65>
   }
  sphere
   {<0, 0,0>, .13, .5
    scale <1, 1, 1.5>
    rotate <-10, -5, 0>
    translate <+.075, -.02, .55>
   }
  sphere    //Skinka
   {<0, 0, 0>, .15, .6
    scale <1.5, 1, 1>
    translate <+.05, .04, .75>
   }

  sphere  //anti
   {<0, 0, 0>, .75, -.5
    scale <.05, .5, .4>
    translate <0, 0.04, .4>
   }

  cylinder  //H Smalben..
   {<-.1, -.02, .6*.4>, <-.1, -.04, .4>, .11, 1}
  sphere
   {<0, 0, 0>, .11, .4
    scale <.9, 1, 1>
    translate <-.08, -.0, .35>
   }
  sphere    //anti
   {<-.1, -.04, .4>, .11, -1}
  cylinder  //H Lr...
   {<-.1, -.04, .4>, <-.05, 0, .7>, .13, 1}
  sphere
   {<0, 0, 0>, .18, .5  pigment{rgb<.5, .25, .2>}
    scale <1, 1, 1>
    translate <-.1, .02, .65>
   }
  sphere
   {<0, 0,0>, .13, .5
    scale <1, 1, 1.5>
    rotate <-10, 5, 0>
    translate <-.075, -.02, .55>
   }
  sphere    //Skinka
   {<0, 0, 0>, .15, .6
    scale <1.5, 1, 1>
    translate <-.05, .04, .75>
   }

  sphere   //V Hft
   {<0, 0, 0>, .15, .1
    scale <1, 1, 1>
    translate <+.1, -.04, .75>
   }
  sphere
   {<0, 0, 0>, .1, .9     //pigment {rgb 1}
    scale <.6, .5, 1.2>
    translate <0, -.07, .64>
   }
  sphere   //H Hft
   {<0, 0, 0>, .15, .1
    scale <1, 1, 1>
    translate <-.1, -.04, .8>
   }

  pigment {rgb <.2, .2, .25>}
  finish {specular .25  roughness .05}
 }


cylinder                           //Blte
 {<0, .03, .76>, <0, .03, .82>, .17
  scale <1.0, .68, 1>
  pigment {rgb <.2, .2, .2>}
  finish {specular .25  roughness .03}
 }
union       //Spnne
 {cylinder
   {<.04, 0, -.035>, <.04, 0, .035>, .005}
  cylinder
   {<-.04, 0, -.035>, <-.04, 0, .035>, .005}
  cylinder
   {<.04, 0, .035>, <-.04, 0, .035>, .005}
  cylinder
   {<.04, 0, -.035>, <-.04, 0, -.035>, .005}
  translate <0, -.09, .79>
  pigment {rgb <.2, .2, .2>}
  finish {specular .25  roughness .03}
 }
intersection
 {cylinder
   {<.183, -.02, .76>, <.183, -.02, .82>, .025
    pigment {rgb <.2, .2, .2>}
    finish {specular .25  roughness .03}
   }
  box
   {<.183, -.035, .75>, <.25, -.005, .83>  inverse}
 }
blob    //Batong
 {threshold .5
  cylinder
   {<.185, -.02, .82>, <.185, -.02, .6>, .03, 1}
  sphere
   {<0, 0, 0>, .05, .6
    scale <1, 1, 2>
    translate <.185, -.02, .62>
   }
  sphere
   {<0, 0, 0>, .04, 1
    scale <1, 1, .5>
    translate <.185, -.02, .84>
   }
  pigment {rgb <1, 1, .95>}
  finish {specular .25  roughness .05}
 }


union{
intersection{
blob                        //Skjorta
 {threshold .5
  cylinder
   {<0, 0, 0>, <0, 0, .8>, .29, 1
    scale <1, .68, .5>
   }
  #declare varv = 0
  #while (varv<25)
   sphere
    {<0, 0, 0>, .05, .02
     scale <1, .35+rand(R1)*.35, .9+rand(R1)*.4>
     translate <.15+rand(R1)*.07, 0, rand(R1)*.02>
     rotate z*rand(R1)*360
     scale <1, .68, 1>
    }
   #declare varv = varv+1
  #end
  sphere        //Brstkorg
   {0, .4, .2
    scale <.7, .75, .7>
    translate <0, -.07, .3>
   }
  sphere    //Skuldror..
   {<0, 0, 0>, .09*2, .04*3
    scale <.8, 1, 1>  //pigment {rgb <1, 0, 0>*10}
    rotate <-25, 10, 0>
    translate <+.10, .1, .33>
   }
  sphere
   {<0, 0, 0>, .09*2, .04*3
    scale <.8, 1, 1>
    rotate <-25, -10, 0>
    translate <-.10, .1, .33>
   }
  cylinder  //Knappsm....
   {<0, 0, 0>, <0, 0, .5>, .02, .03
    scale <1, 3, 1>
    translate <0, -.1, 0>
   }
  #declare varv = 0 //Knappar
  #while (varv<15)
   #if (varv != 9 & varv != 10)
   cylinder
    {<0, 0, 0>, <0, -.5, 0>, .01, +.01
     translate <0, 0, varv*.03>
    }
   #end
   #declare varv = varv+1
  #end
  sphere       //Annan sm
   {<0, 0, 0>, .55, .015
    scale <1, .02, 1.1>
    translate <0, 0, .2>
   }
  cylinder   //"ryggrad"
   {<0, 0, 0>, <0, 0, .5>, .02, -.05
    scale <3, 3, 1>
    translate <0, +.1, 0>
   }

  cylinder      //Vitt blte
   {<0, 0, -5>, <0, 0, 5>, .6, .1
    scale <1, 1, .0044>
    rotate y*53
    translate <0.0, 0, .28>
    pigment {rgb <1, 1, .8>*2.85}
   }

  #declare VpArmTrans = <+.17, 0, .4>
  #declare VpArmRot = <-25, 0, 0>
  #declare HpArmTrans = <-.17, 0, .4>
  #declare HpArmRot = <-10, 0, 0>
  sphere
   {<0, 0, 0>, .15, .4
    translate VpArmTrans
   }
  sphere
   {<0, 0, 0>, .15, .4
    translate HpArmTrans
   }

  clipped_by
   {box
     {<-1, 1, .45>, <1, -1, 1>   inverse
      rotate z*45
      scale <.08, 1, 1>
      translate <0, -1.33, 0>
     }
   }

  //rotate <3, 0, 0>
  //translate <0, .03, .82>
 }
box
 {<-.17, -.4, -.1>, <.17, .4, .6>}
pigment {rgb <.5, .55, .8>}
finish {specular .25  roughness .05}
     }//slut p intersection

blob
 {threshold .5
  sphere                    //Vnster Arm...
   {0, .08, 1
    scale <1, 1.3, 3>
    rotate -y*30
    rotate VpArmRot
    translate VpArmTrans //+<0, 0, -.02>
   }
  cylinder
   {0, <.03, 0, -.25>, .09, 1
    scale <1, 1.3, 1>
    rotate VpArmRot
    translate VpArmTrans+<.04, 0, 0>
   }
  sphere
   {<.03, 0, -.25>, .09, -.7 //.085, -1
    scale <1, 1.3, 1>
    rotate VpArmRot
    translate VpArmTrans+<.04, 0, 0>
   }
  cylinder
   {<.03, 0, -.25>, <.03, -.03, -.19-.25>, .09, 1
    scale <1, 1.1, 1>
    rotate VpArmRot
    translate VpArmTrans+<.04, 0, 0>
   }
  #declare VpHandTrans = <.03, -.04, -.19-.25>
  #declare VpHandRot = <0, 0, 60>
  #declare HpHandTrans = <-.03, -.04, -.19-.25>
  #declare HpHandRot = <0, 0, -60>

   cylinder
   {<0, 0, 0>, <0, 0, -.05>, .04, 1
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }//_

  sphere
   {<0, 0, 0>, .1, 1
    scale <.9, .8, 1.25>
    translate <0, 0, -.11>
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder
   {<-.1, 0, 0>, <.1, 0, 0> .035, -.75
    translate <0, .015, -.13>
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder   //Tumme
   {<-.020, .0, -.075>, <-.025, .050, -.13>, .025, 1
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
/*  cylinder
   {<-.02, -.05, -.11>, <-.02, 0, -.21>, .005, -1
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder
   {<+.0, -.05, -.11>, <+.0, 0, -.21>, .005, -1
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder
   {<+.02, -.05, -.11>, <+.02, 0, -.21>, .005, -1
    rotate VpHandRot  translate VpHandTrans  rotate VpArmRot  translate VpArmTrans+<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
 */

  sphere                    //Hger Arm...
   {0, .08, 1
    scale <1, 1.3, 3>
    rotate +y*30
    rotate HpArmRot
    translate HpArmTrans //+<0, 0, -.02>
   }
  cylinder
   {0, <-.03, 0, -.25>, .09, 1
    scale <1, 1.3, 1>
    rotate HpArmRot
    translate HpArmTrans+<-.04, 0, 0>
   }
  sphere
   {<-.03, 0, -.25>, .09, -.7
    scale <1, 1.3, 1>
    rotate HpArmRot
    translate HpArmTrans+<-.04, 0, 0>
   }
  cylinder
   {<-.03, 0, -.25>, <-.03, -.03, -.19-.25>, .09, 1
    scale <1, 1.1, 1>
    rotate HpArmRot
    translate HpArmTrans+<-.04, 0, 0>
   }

  sphere
   {<0, 0, 0>, .1, 1
    scale <.9, .8, 1.25>
    translate <0, 0, -.11>
    rotate HpHandRot  translate HpHandTrans  rotate HpArmRot  translate HpArmTrans-<.04, 0, 0>
    pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder
   {<-.1, 0, 0>, <.1, 0, 0> .035, -.75
     translate <0, .015, -.13>
     rotate HpHandRot  translate HpHandTrans  rotate HpArmRot  translate HpArmTrans-<.04, 0, 0>
     pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }
  cylinder   //Tumme
   {<+.020, .0, -.075>, <+.025, .050, -.13>, .025, 1
     rotate HpHandRot  translate HpHandTrans  rotate HpArmRot  translate HpArmTrans-<.04, 0, 0>
     pigment {rgb <0.820, 0.682, 0.616>*1.25}
   }

  clipped_by {box {<-.176, -.4, -.1>, <.176, .4, .6>  inverse} }
  pigment {rgb <.5, .55, .8>}
  finish {specular .25  roughness .05}
  }

superellipsoid //V ArmKant
 {<1, .1>
  scale <.054, .058, .023>
  rotate -x*10
  translate <.03, -.03, -.19-.25>+vnormalize(<.03, -.03, -.19-.25>)*.03
  rotate VpArmRot
  translate VpArmTrans+<.04, 0, 0>
 }

superellipsoid //H ArmKant
 {<1, .1>
  scale <.0554 .058, .024>
  rotate -x*10
  translate <-.03, -.03, -.19-.25>+vnormalize(<-.03, -.03, -.19-.25>)*.03
  rotate HpArmRot
  translate HpArmTrans-<.04, 0, 0>
 }


superellipsoid  //Brstficka.. +bricka
 {<.5, .1>
  scale <.05, .04, .04>
  rotate <3, 0, 20>
  pigment {rgb <.5, .55, .8>}
  finish {specular .25  roughness .05}
  translate <.07, -.081, .3> //+ <0, .03, .82>
 }
superellipsoid
 {<.5, .1>
  scale <.051, .04, .01>
  rotate <3, 0, 20>
  pigment {rgb <.5, .55, .8>}
  finish {specular .25  roughness .05}
  translate <.07, -.087, .34> //+ <0, .03, .82>
 }
superellipsoid
 {<.1, .1>
  scale <.048, .04, .01>
  rotate <3, 0, 21>
  pigment {rgb .1}
  finish {specular .25  roughness .05}
  translate <.07, -.075, .37> //+ <0, .03, .82>
 }

intersection
 {superellipsoid        //Krage
   {<1, .3>
    scale <.10, .09, .10>
   }
  box
   {<-1, -1, 0>, <1, 1, 1>}
  box
   {<-1, 1, 0>, <1, -1, 1>
    inverse
    rotate z*45
    scale <.08, 1, 1>
    translate <0, -1.3, 0>
   }
  translate <0, 0, .40>
 }

blob
 {threshold .5
  cylinder	//Hals
   {<0, 0, .38>, <0, 0, .45>, .1, 1}
  cylinder //Huvud
   {<0, 0, 0>, <0, 0, .75/2>, .18, 1
    //scale <.8, 1, .5>
    scale <.8, 1, .45>
    translate <0, -.05, .54>
   }
  cylinder //Nsa..
   {<0, 0, .0>, <0, 0, -.05>, .015, .8
    scale <1, 2, 1>
    rotate -x*20
    translate <0, -.145+.015, .64>
   }
  sphere
   {<0, 0, -.04>, .03, .8
    rotate -x*22
    translate <0, -.12, .64>
   }
  sphere    //ga
   {<0, 0, 0>, .03, -.1
    scale <2, 1, .8>
    translate <-.03, -.13, .635>
   }
  sphere    //ga
   {<0, 0, 0>, .03, -.1
    scale <2, 1, .8>
    translate <.03, -.13, .635>
   }
  cylinder
   {<-.5, 0, 0>, <.5, 0, 0>, .06, -.1
    scale <1, 1, .75>
    translate <0, -.13, .63>
   }
  sphere    //Mun..
   {<0, 0, 0>, .03, .2
    scale <1, .9, .3>
    translate <0, -.143, .57>
   }
  sphere
   {<0, 0, 0>, .03, .2
    scale <1, .9, .2>
    translate <0, -.145, .56>
   }
  sphere    //Kindgrejs
   {<0, 0, 0>, .1, -.2
    translate <-.1, -.1, .5> //pigment {rgb 10}
   }
  sphere    //Kindgrejs
   {<0, 0, 0>, .1, -.2
    translate <.1, -.1, .5> //pigment {rgb 10}
   }
  pigment {rgb <0.820, 0.682, 0.616>*1.25}
  finish {specular .20  roughness .05}
 }

blob      //Hr
 {threshold .5
  sphere
   {<0, 0, 0>, .065*2, 1
    scale <1.15, 1.35, .85>
    translate <0, -.05, .725>
   }
  sphere
   {<0, 0, 0>, .1, 1
    scale <1.6, 1.3, 1.6>
    //rotate -x*15
    translate <0, .01, .605>
   }
  sphere
   {<0, 0, 0>, .1, .5
    scale <1.75, 1, 1>
    translate <0, .02, .675>
   }
  sphere
   {<0, 0, 0>, .04, .5
    translate <0, -.12, .725>
   }
  pigment {rgb <.65, .5, .4>*.75}
  finish {specular .20  roughness .05}
  normal
   {radial
    rotate +x*55
    //scale .035
    translate <0, 0, .65>
    bump_size .05
    frequency 20
    slope_map
     {[0   <0, .5>]
      [.25 <.5, .5>]
      [.5  <1, 0>]
      [.75 <.5, .5>]
      [1   <0, .5>]
     }
   }
 }

intersection		//Glasgon
 {cylinder
   {<0, 0, .5>, <0, 0, .7>, .11
    translate <0, -.04, 0>
   }
  superellipsoid
   {<.1, .5>
    //rotate <90, 90, 90>
    scale <.065, .041, .035>
    translate <0, -.11, .636>
   }
  pigment {rgb<.1, .2, .3>}
  finish {specular .20  roughness .05}
 }

  pigment {rgb <.5, .55, .8>}
  finish {specular .20  roughness .05}
  rotate <2, 0, 0>
  translate <0, .03, .82>
    }//slute p Skjort-union

//rotate z*180*2*0.05
//translate <5.2, -5, 6.9>

#switch (DrakClock)
 #range (3, 4)
  rotate z*180
  translate -<-1.1, -.68, .65>  //-<-1.1, -.68, .07>
  rotate <8+sin(-pi/2+(DrakClock-3)*6*pi)*8, 0, 0>
  translate <-1.1, -.68, .65>
  rotate-z*180
 #break
 #range (4, 6)
  //translate -<-1.1, -.68, .07>
  //rotate -<(DrakClock-4)*10, (DrakClock-4)*2, 0>
  //translate <-1.1, -.68, .07>
 #break
#end

rotate PolisRot
translate PolisTrans

//transform PolisTransf
     }

#end //ifdef Polis


//--TRIKE-ny----------------------------------------------------------------
#ifdef (Trike)

// sphere {FrontRotPointReal, .05  pigment {radial}}

union
 {#include "trike.pov"
//#if (TrikeClock < 3.275)
  rotate TrikeStegraRot
  #ifndef (TableCollisionTime)
   translate -y*.18
  #else
   translate -y*.18  //translate -TableCollisionPoint
  #end
   rotate TrikeSnurraRot
  #ifndef (TableCollisionTime)
   translate y*.18
  #else
   translate y*.18  //translate TableCollisionPoint
  #end
  rotate <0, 0, TrikeTravelRot>
  #ifdef (TrikeSnurraRot2) rotate TrikeSnurraRot2 #end
  #ifdef (TrikeSnurraRot3)
   translate -(FrontRotPointReal)
   rotate TrikeSnurraRot3
   translate (FrontRotPointReal)
  #end
  translate TrikeTrans
 #if (TrikeClock > 3.275)  translate z*.02  #end
/*#else
  translate -y*.18
  rotate <-90, 0, 0>
  translate y*.18
  rotate <0, 0, -15>

   #declare TrikeStegraRot  = <0, 20+(min(3.275,TrikeClock)-2.949)*45, 0>
  #declare TrikeSnurraRot  = <-90, 0, 0>
  #declare TrikeSnurraRot3 = <0, 10, 0>      */
 }

union
{
  union     //Hgerdck
   {torus
     {.15, .08
      scale <.5, .08/.11, .5>
      clipped_by
       {cylinder
         {<0, .05, 0>, <0, -.06, 0>, .06  inverse}
       }
     }
    cylinder
     {<0, .006, 0>, <0, -.006, 0>, .118
      clipped_by
       {cylinder
         {<0, .05, 0>, <0, -.06, 0>, .06  inverse}
       }
     }
    #declare varv1=0
    #declare varv2=0
    #while (varv1<8)
     #while (varv2<20)
      box
       {<-.010, -.010, -.005>, <.010, .010, .005>
        translate <0, 0, .08>
        rotate <-90+varv1*25.71, 0, 0>
        translate <0, 0, .15>
        rotate <0, varv2*18, 0>
        scale <.5, .08/.11, .5>
       }
      #declare varv2 = varv2+1
     #end
     #declare varv2 = 0
     #declare varv1 = varv1+1
    #end
    intersection
     {cylinder
       {<0, .025, 0>, <0, -.06, 0>, .06}
      cylinder
       {<0, -.04, 0>, <0, -.075, 0>, .058  inverse}
      cylinder
       {<0, -.01, 0>, <0, -.080, 0>, .054  inverse}
      cylinder
       {<0, .02, 0>, <0, -.085, 0>, .046  inverse}
      texture {Metallic}
     }
    cylinder
     {<0, .02, 0>, <0, .01, 0>, .015
      texture {Metallic}
     }
    #declare varv=0
    #while (varv<6)
     sphere
      {<0, .02, .035>, .005
       texture {Metallic}
       rotate y*60*varv
      }
     #declare varv = varv+1
    #end

    pigment {rgb .2}
    finish {specular .1  roughness .2}

    rotate TrikeBackWheelRot
    rotate TWExtraRot
    translate <0, -.18, 0>
   }          //slut p Hgerdck

  union     //Vnsterdck
   {torus
     {.15, .08
      scale <.5, .08/.11, .5>
      clipped_by
       {cylinder
         {<0, .05, 0>, <0, -.06, 0>, .06  inverse}
       }
     }
    cylinder
     {<0, .006, 0>, <0, -.006, 0>, .118
      clipped_by
       {cylinder
         {<0, .05, 0>, <0, -.06, 0>, .06  inverse}
       }
     }
    #declare varv1=0
    #declare varv2=0
    #while (varv1<8)
     #while (varv2<20)
      box
       {<-.010, -.010, -.005>, <.010, .010, .005>
        translate <0, 0, .08>
        rotate <-90+varv1*25.71, 0, 0>
        translate <0, 0, .15>
        rotate <0, varv2*18, 0>
        scale <.5, .08/.11, .5>
       }
      #declare varv2 = varv2+1
     #end
     #declare varv2 = 0
     #declare varv1 = varv1+1
    #end
    intersection
     {cylinder
       {<0, .025, 0>, <0, -.06, 0>, .06}
      cylinder
       {<0, -.04, 0>, <0, -.075, 0>, .058  inverse}
      cylinder
       {<0, -.01, 0>, <0, -.080, 0>, .054  inverse}
      cylinder
       {<0, .02, 0>, <0, -.085, 0>, .046  inverse}
      texture {Metallic}
     }
    cylinder
     {<0, .02, 0>, <0, .01, 0>, .015
      texture {Metallic}
     }
    #declare varv=0
    #while (varv<6)
     sphere
      {<0, .02, .035>, .005
       texture {Metallic}
       rotate y*60*varv
      }
     #declare varv = varv+1
    #end

    pigment {rgb .2}
    finish {specular .1  roughness .2}

    translate <0, -.18, 0>
    scale <1, -1, 1>

    rotate TrikeBackWheelRot
   }          //slut p Vnsterdck

  union     //Framdck
   {torus
     {.15, .08
      scale <.4576, .55, .4576>
      clipped_by
       {cylinder
         {<0, .08, 0>, <0, -.08, 0>, .06  inverse}
       }
     }
    cylinder
     {<0, .006, 0>, <0, -.006, 0>, .108
      clipped_by
       {cylinder
         {<0, .08, 0>, <0, -.08, 0>, .06  inverse}
       }
     }
    /*#declare varv1=0
    #declare varv2=0
    #while (varv1<8)
     #while (varv2<20)
      box
       {<-.010, -.010, -.005>, <.010, .010, .005>
        translate <0, 0, .08>
        rotate <-90+varv1*25.71, 0, 0>
        translate <0, 0, .15>
        rotate <0, varv2*18, 0>
        scale <.5, .55, .5>
       }
      #declare varv2 = varv2+1
     #end
     #declare varv2 = 0
     #declare varv1 = varv1+1
    #end*/
    intersection
     {cylinder
       {<0, .05, 0>, <0, -.05, 0>, .06}
      cylinder
       {<0, .06, 0>, <0, -.06, 0>, .058  inverse}
      cylinder
       {<0, .065, 0>, <0, -.065, 0>, .054  inverse}
      texture {Metallic}
     }
    cylinder
     {<0, .02, 0>, <0, -.02, 0>, .06
      texture {Metallic}
     }
    cylinder
     {<0, .03, 0>, <0, -.03, 0>, .015
      texture {Metallic}
     }
    cylinder //axel
     {<0, .075, 0>, <0, -.075, 0>, .011
      texture {Metallic}
     }
    #declare varv=0
    #while (varv<6)
     sphere
      {<0, .02, .035>, .005
       texture {Metallic}
       rotate y*60*varv
      }
     #declare varv = varv+1
    #end

    pigment {rgb .2}
    finish {specular .1  roughness .2}

    rotate TrikeFrontWheelRot
    translate <.34047, 0, -.01>
    rotate TrikeStegraRot
   }          //slut p Framdck

translate -y*.18  //translate -TableCollisionPoint
 rotate TrikeSnurraRot
translate y*.18  //translate TableCollisionPoint
rotate <0, 0, TrikeTravelRot>
#ifdef (TrikeSnurraRot2) rotate TrikeSnurraRot2 #end
#ifdef (TrikeSnurraRot3)
 translate -(FrontRotPointReal/*-TrikeTrans*/)
 rotate TrikeSnurraRot3
 translate (FrontRotPointReal/*-TrikeTrans*/)
#end
translate TrikeTrans
 #if (TrikeClock > 3.275)  translate z*.02  #end

} //slut p dcken

#end //ifdef Trike
