// most textures for scene except for the textures in "dtexture.inc"

// remember the sky texture changes with the clock value

// ******* CAR TEXTURES *********

#declare red_body =
texture {
    pigment {
    gradient y
    color_map
        {   [0.0 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <1, 0, 0>]
            [1.0 color rgb <1, 0, 0>]
            }
        scale 2}
	finish { phong 0.9 reflection 0.1}
    }

#declare red_parts =
texture {
    pigment {colour rgb <1,0,0>}
	finish { phong 0.9 reflection 0.1}
    }

#declare black_parts =
texture {
    pigment {colour rgb <0,0,0>}
	finish { phong 0.9 reflection 0.1}
    }

#declare dull_black =
texture {
    pigment {colour rgb <0,0,0>}
    }

#declare white_helmet =
texture {
    pigment {colour rgb <1,1,1>}
	finish { phong 0.9 reflection 0.1}
    }

#declare dark_metal =
texture {
    pigment {colour rgb <0.2,0.2,0.2>}
    finish { phong 1 phong_size 50 metallic reflection 0.3}
    }

#declare wheel_rubber =
texture{
    pigment {colour rgb <0.05,0.05,0.05>}
    finish { phong 0.8 phong_size 5}
    }

#declare wheel_gold =
texture{
    pigment {colour rgb <0.8,0.6,0.2> }
    finish {
        brilliance 2
        diffuse 0.392
        reflection <0.4,0.35,0.25>
        metallic 1
        specular 0.20
        roughness 0.05
        }
}





#declare yellow_body =
texture {
    pigment {
    gradient y
    color_map
        {   [0.0 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <1, 1, 0>]
            [1.0 color rgb <1, 1, 0>]
            }
        scale 2}
	finish { phong 0.9 reflection 0.1}
    }

#declare yellow_parts =
texture {
    pigment {colour rgb <1,1,0>}
	finish { phong 0.9 reflection 0.1}
    }

#declare blue_helmet =
texture {
    pigment {colour rgb <0,0,1>}
	finish { phong 0.9 reflection 0.1}
    }

#declare wheel_black =
texture{
    pigment {colour rgb <0.05,0.05,0.05> }
    finish {
        brilliance 2
        diffuse 0.392
        reflection 0.35
        metallic 1
        specular 0.20
        roughness 0.05
        }
}

#declare blue_body =
texture {
    pigment {
    gradient y
    color_map
        {   [0.0 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <0.0, 0.0, 0.0>]
            [0.12 color rgb <0, 0, 1>]
            [1.0 color rgb <0, 0, 1>]
            }
        scale 2}
	finish { phong 0.9 reflection 0.1}
    }

#declare blue_parts =
texture {
    pigment {colour rgb <0,0,1>}
	finish { phong 0.9 reflection 0.1}
    }

#declare green_helmet =
texture {
    pigment {colour rgb <0,1,0>}
	finish { phong 0.9 reflection 0.1}
    }


// ******** TRACK TEXTURES *********

#declare track_black = rgb<0.1,0.1,0.1>

#declare track_yellow = rgb<0.9,0.75,0.1>


#declare shiny_metal =
texture {
pigment { colour red 0.0 green 0.0 blue 0.0 }
 normal {  bumps 0.1 scale 100 }
finish {diffuse 0 reflection 0.95}
}

#declare smooth_black_plastic =
texture {
  pigment { colour track_black }

  finish {
    phong 0.3
    phong_size 40
  }
}


#declare rough_plastic =
texture {
  normal {
  bumps 0.9
  scale 2.0
  }
  finish {
    phong 0.3
    phong_size 40
  }
}

#declare rough_black_plastic =
texture { rough_plastic
    pigment { colour track_black }
    }

#declare dark_black_plastic =
texture {
  pigment { colour rgb <0.0,0.0,0.0> }
}




#declare grid_stipes =
  pigment
  {
  radial frequency 48 phase 0.5
    color_map
    {
      [0.00 colour track_black]
      [0.4 colour track_black]
      [0.4 colour track_yellow]
      [1.00 colour track_yellow]
   }
    rotate z*90

    scale <30.0, 20.0, 1.4>
    translate <0.0, 0.0, -0.01>


    scale <1/0.35,1,1/5>
    translate <0,0,1.0>
    rotate y*-45

  }

#declare grid_checker =
pigment {   checker
            pigment {grid_stipes},
            pigment {colour track_black}

            rotate y*45
            translate <0,0,-1.0>
            scale <0.35,1,5>
            }

#declare start_grid =
texture {
    rough_plastic
    pigment {
        gradient x
        pigment_map {
            [0.0  grid_checker]
            [0.49  grid_checker]
            [0.49 color track_black]
            [1.0 color track_black]
            }
        scale <t_width*2,1,Length_C+Length_B>
        }
    }

#declare arrows_checker =
pigment {   checker
            color track_yellow,
            color track_black
            rotate y*45
            scale <0.35,100,1.25>
            translate z*-0.05
            }

#declare start_arrows_texture =
texture {rough_plastic
    pigment {
        gradient z
        pigment_map
    {
      [0.00 arrows_checker]
      [0.8 arrows_checker]
      [0.8 color track_black]
      [1.00 color track_black]

        }
        scale <t_width*2,1,Length_B>
    }
    }






#declare xpigment_corner
=     pigment {
        gradient z
        colour_map
    {
      [0.00 color track_yellow]
      [0.2 color track_yellow]
      [0.2 color track_black]
      [0.25 color track_black]
      [0.25 color track_yellow]
      [0.45 color track_yellow]
      [0.45 color track_black]
      [0.5 color track_black]
      [0.5 color track_yellow]
      [0.8 color track_yellow]
      [0.8 color track_black]
      [1.00 color track_black]
        }
        scale <1,1,0.5>
    }


#declare xpigment_middle
=     pigment {
        gradient x
        colour_map
    {
      [0.0 color track_yellow]
      [0.5 color track_yellow]
      [0.5 color track_black]
      [1.0 color track_black]

        }
    }

#declare xpigment_m1
=  pigment{
        xpigment_middle
        translate x*-1.0
        rotate y*26.56
        translate <0.2,0.0,0.32>
        }

#declare xpigment_m2
=  pigment{
        xpigment_middle
        translate x*-1.0
        rotate y*-26.56
        translate <0.2,0.0,0.68>
        }


#declare xpigment_m3
=  pigment{
        xpigment_middle
        translate x*1.0
        rotate y*-26.56
        translate <0.8,0.0,0.32>
        }

#declare xpigment_m4
=  pigment{
        xpigment_middle
        translate x*1.0
        rotate y*26.56
        translate <0.8,0.0,0.68>
        }

#declare xpigment_c1
=  pigment{
        xpigment_corner
        translate z*-0.5
        rotate y*-10
        translate x*0.3
        }

#declare xpigment_c2
=  pigment{
        xpigment_corner
        translate z*1.475
        rotate y*10
        translate x*0.3

        }

#declare xpigment_c3
=  pigment{
        xpigment_corner
        translate z*-0.5
        rotate y*10
        translate x*0.7
        }

#declare xpigment_c4
=  pigment{
        xpigment_corner
        translate z*1.475
        rotate y*-10
        translate x*0.7
        }

#declare xpigment_left
=     pigment {
        gradient z
        pigment_map
    {
      [0.00 xpigment_c1]
      [0.32 xpigment_c1]
      [0.32 xpigment_m1]
      [0.5 xpigment_m1]
      [0.5 xpigment_m2]
      [0.68 xpigment_m2]
      [0.68 xpigment_c2]
      [1.00 xpigment_c2]

        }
        scale <1,1,Length_D>
    }

#declare xpigment_right
=     pigment {
        gradient z
        pigment_map
    {
      [0.00 xpigment_c3]
      [0.32 xpigment_c3]
      [0.32 xpigment_m3]
      [0.5 xpigment_m3]
      [0.5 xpigment_m4]
      [0.68 xpigment_m4]
      [0.68 xpigment_c4]
      [1.00 xpigment_c4]

        }
        scale <1,1,Length_D>
    }

#declare xover_texture =
texture {rough_plastic
    pigment {
        gradient x
        pigment_map
        {
            [0.00 colour track_black]
            [0.20 colour track_black]
            [0.20 xpigment_left]
            [0.50 xpigment_left]
            [0.50 xpigment_right]
            [0.80 xpigment_right]
            [0.80 colour track_black]
            [1.00 colour track_black]
            }
        scale <t_width*2,1,1>
        translate <-t_width,1,1>
        }
    }

// SOME TEXTURES HAVE BEEN MOVED TO "Dtexture.inc" as they need to be defined more than once.
// ic_kerb_plastic
// oc_kerb_plastic


//NEXT ONE IS OK
#declare s_kerb_plastic =
texture {
  pigment
  {
  gradient z frequency 6.0 phase 0.0
    color_map
    {
      [0.00 color rgb<0.9, 0.0, 0>]
      [0.5 color rgb<0.9, 0.0, 0>]
      [0.5 color rgb<0.9, 0.9, 0.9>]
      [1.00 color rgb<0.9, 0.9, 0.9>]
    }
    scale Length_D
    }
    normal {
  dents 0.9
  scale 2.0
  }
}


#declare white_barrier_plastic =
texture {
    pigment {colour rgb <1,1,1>}
	finish { phong 0.9}
    }

#declare yellow_white_barrier_plastic =  //scaled later
texture {
    pigment {
        gradient z
        color_map {
            [0.00 color rgb<1, 1, 1>]
            [0.5 color rgb<1, 1, 1>]
            [0.5 color rgb<1.0, 0.75, 0.05>]
            [1.00 color rgb<1.0, 0.75, 0.05>]
            }
        }
    finish { phong 0.9}
    }

#declare red_white_barrier_plastic =  //scaled later
texture {
    pigment {
        gradient z
        color_map {
            [0.00 color rgb<1, 1, 1>]
            [0.5 color rgb<1, 1, 1>]
            [0.5 color rgb<1.0, 0.15, 0.05>]
            [1.00 color rgb<1.0, 0.15, 0.05>]
            }
        }
    finish { phong 0.9}
    }

#declare gantry_plastic =
texture {
  pigment { colour track_black }

  finish {
    reflection 0.025
    phong 0.8
    phong_size 40
  }
}


// ******** WOOD TEXTURES *********

#declare Pine1 =

texture {
    pigment {
        wood
        turbulence 0.1
        octaves 3
        omega 0.1
        lambda 5
        color_map {
            [0.00 color rgb<0.92, 0.69, 0.29>]
            [0.64 color rgb<0.92, 0.69, 0.29>]
            [1.00 color rgb<0.72, 0.37, 0.0>]
            }
        translate <1.0, 0.0, 0.0>
        scale 6.0
        }
    finish {
        diffuse 1.0
        brilliance 1.9
        phong 0.35    phong_size 48
        }
    }
texture {
    pigment {
        wood
        turbulence 0.01
        color_map {
            [0.00 color rgbf<0.92, 0.71, 0.29, 0.73>]
            [1.00 color rgbf<0.91, 0.49, 0.11, 0.41>]
            }
        translate <1.0, 0.0, 0.0>
        scale 30.0
        }
    }


// ******** ROOM TEXTURES *********

#declare Carpet =
texture {
    pigment {
        granite
        turbulence 0.7
        color_map {
            [0.00 color rgb<0.25, 0.26, 0.3>]
            [1.00 color rgb<0.57, 0.69, 0.69>]
            }
        }
    normal {
        bumps 0.6
        scale 0.2
        }
    finish {
        ambient 0.05
        }
    scale 25
    }

#declare White_Paint =

texture {
pigment{colour rgb<1,1,1>}
finish { brilliance 0.9 }
}

#declare Wallpaper =

texture {
    pigment{
        checker
        colour rgb<0.68,0.68,0.68>
        colour rgb<0.7,0.74,0.74>
        }
    scale <10.0*inches,10*feet,10.0*inches>
    }

// ******MISC OBJECT TEXTURES********//

// ***bed textures

#declare Red_duvet =

texture {
pigment {colour rgb<1,0,0>}
normal {bumps 0.5 turbulence 1 scale <100,300,300>}
}

#declare Blue_duvet =

texture {
pigment {colour rgb<0,0,1>}
normal {bumps 1 turbulence 1 scale <100,300,300> translate <50,50,50>}
}

#declare Mattress =

texture {
pigment {colour rgb<1,1,1>}
}



// ***mug textures

#declare mug_blue =
texture { pigment { colour rgb<0.0,0.02,0.24>} finish { phong 0.8 phong_size 50 reflection 0.03}}

#declare tea_brown =
texture { pigment { colour rgb<0.7,0.5,0.1>} finish {reflection 0.2}}

// ***keyboard textures

#declare keyboard_plastic =
texture {
  pigment { colour rgb<0.15,0.15,0.15> }
  finish {
    phong 0.5
    phong_size 10
  }
}

#declare speaker_plastic =
texture {
    gradient z
    texture_map {
        [ 0.0 keyboard_plastic]
        [ 0.5 keyboard_plastic]
        [ 0.5 pigment { colour rgb <0,0,0>}]
        [ 1.0 pigment { colour rgb <0,0,0>}]
        }
    scale <1.0,1.0,1.0>
    translate z*100
    }

#declare keyboard_ivory =
texture {
    pigment { colour rgb<1.0,1.0,1.0>}
    finish {
        phong 0.9
        phong_size 50
        }
    }

#declare keyboard_ebony =
texture {
    pigment { colour rgb<0.02,0.02,0.02>}
    finish {
        phong 0.9
        phong_size 55
        reflection 0.05
        }
    }

#declare keyboard_screen =
texture {
    pigment { colour rgb<0.0,0.0,0.0>}
    finish {
        diffuse 0.2
        phong 1.0
        phong_size 60
        reflection 0.05
        }
    }

#declare keyboard_button_grey =
texture {
    pigment { colour rgb<0.5,0.5,0.5>}
    }

#declare keyboard_button_black =
texture {
    pigment { colour rgb<0.0,0.0,0.0>}
    }

#declare keyboard_button_red =
texture {
    pigment { colour rgb<1.0,0.2,0.2>}
    }

#declare keyboard_button_yellow =
texture {
    pigment { colour rgb<1.0,1.0,0.2>}
    }

// *** chair textures

#declare chair_surface =
texture {
    pigment { colour rgb <0.0,0.0,0.5> }
    finish {
        phong 0.3
        phong_size 30
        }
    }

#declare chair_wheels =
texture {
  pigment { colour rgb<0.05,0.05,0.05> }
  finish {
    phong 0.3
    phong_size 10
  }
}




// ********SKY***********



#declare High_Cloud_Layer =
pigment {
    bozo
    turbulence 0.5
    color_map {
        [0.0, 0.15   color red 0.8 green 0.8 blue 0.95
                    color red 0.6 green 0.6 blue 0.8]
        [0.15, 0.5   color red 0.6 green 0.6 blue 0.8
                    color rgb <0.05, 0.05, 0.3> ]
        [0.5, 1.001 color rgb <0.05, 0.05, 0.3>
                    color rgb <0.0, 0.0, 0.15>]
    }
    rotate x*0.03*clock
    scale <1.0, 0.4, 1.0>
}


#declare Mid_Cloud_Layer =
pigment {
    bozo
    turbulence 0.5
    color_map {
        [0.0, 0.1   color red 0.8 green 0.8 blue 0.95
                    color red 0.6 green 0.6 blue 0.8]
        [0.1, 0.4   color red 0.6 green 0.6 blue 0.8
                    color rgb <0.2, 0.2, 0.4>  ]
        [0.4, 1.0 color rgb <0.2, 0.2, 0.4>
                    color rgb <0.2, 0.2, 0.4> ]
    }
    rotate x*0.03*clock
    scale <1, 0.1, 1>
}

#declare Clouds =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.8, 0.8, 0.95> ]
            [0.01 rgb <0.8, 0.8, 0.95> ]
            [0.2 Mid_Cloud_Layer scale 0.25]
            [0.5 High_Cloud_Layer scale <0.25, 0.15, 0.25>]
        }
    }
}
