#if (RunOnce != on)
    #if (Trackplot = on)
#declare c_strength = abs(c_strength)*(c_angle / abs(c_angle)) //make c_strength same sign as c_angle

// THE TEXTURE INCLUDE IS TO GENERATE THE CORRECT RADIAL FREQ FOR THE KERB MAP
#include "Dtexture.inc"

#declare oc_kerb =
intersection {
    cylinder {<c_strength, 0.0, 0.0> <c_strength, 1*seg_high, 0.0> (abs(c_strength) + t_width*1.5)}
    cylinder {<c_strength, -seg_high, 0.0> <c_strength, 1.1*seg_high, 0.0> (abs(c_strength) + t_width*1.01) inverse}
    plane {z 0 translate <0, 0, seg_gap*0.5> inverse}
    plane {z 0 translate <0, 0, -seg_gap*0.5> rotate <0,c_angle,0> translate <c_strength, 0, 0>}
    texture {oc_kerb_plastic translate x*c_strength}

        bounded_by {   //optimised

        #declare b_width = -t_width*(c_angle / abs(c_angle))
        box {   < min( b_width*1.5  ,  (vrotate(<b_width-c_strength,seg_high,0>,<0,c_angle,0>)+<c_strength,0,0>).x  ),-0.1,-0.1>
                < max( b_width*1.5  ,  (vrotate(<b_width-c_strength,seg_high,0>,<0,c_angle,0>)+<c_strength,0,0>).x  ),1.1*seg_high, (vrotate(<-c_strength,0,0>,<0,c_angle,0>)).z + t_width*1.5  >}
        }
    }


        object{
            oc_kerb
            rotate T_ANG

            translate T_POS
            }
        #end

    #end
