//MAIN FILE

#include "S_DEF.INC"

#include "STEXTURE.INC"

#include "cars.pov"

#declare MAX_SPEED = 80   // mm per frame

#declare RACE_CLOCK = clock-200

#declare INPUT_CLOCK = RACE_CLOCK

#declare TRACKFILE = "track2.inc"

#declare L_OFF = -t_width/2

#if (INPUT_CLOCK >= 0)
    #declare TIME_LOCATE = on
    #include TRACKFILE
    #declare TIME_LOCATE = off
#else
    #declare L_POS = <L_OFF,seg_high,-Length_B>
    #declare CALCULATED_CLOCK_DISTANCE = 0
    #declare CURRENT_SPEED = 0
#end

#debug concat("\n yellow car distance is ",str(CALCULATED_CLOCK_DISTANCE,0,3))
#debug concat("\n yellow car speed is ",str(CURRENT_SPEED,0,3))
#debug concat("\n yellow car location is \n x: ",str(L_POS.x,0,0),"\n z: ",str(L_POS.z,0,0))

#declare YELLOW_CAR_POS = L_POS
#declare YELLOW_CAR_ANG = L_ANG
#declare YELLOW_CAR_DISTANCE = CALCULATED_CLOCK_DISTANCE
#declare YELLOW_CAR_SPEED = CURRENT_SPEED

#declare INPUT_DISTANCE = YELLOW_CAR_DISTANCE - (  ( 3.6*inches *  (1-   (YELLOW_CAR_SPEED/MAX_SPEED)    )    ) + 0.55*inches)
#declare L_OFF = -t_width/2

#if (INPUT_CLOCK >= 0)
    #declare DIST_LOCATE = on
    #include TRACKFILE
    #declare DIST_LOCATE = off
#else
    #declare L_POS = <L_OFF,seg_high,-Length_B*2>  //behind first one
#end

#declare YELLOW_CAR_TARGET = L_POS

#declare YELLOW_CAR_DIRECTION = y*degrees( atan2( YELLOW_CAR_POS.x - YELLOW_CAR_TARGET.x , YELLOW_CAR_POS.z - YELLOW_CAR_TARGET.z))


#declare INPUT_CLOCK = RACE_CLOCK

#declare L_OFF = t_width/2

#if (INPUT_CLOCK >= 0)
    #declare TIME_LOCATE = on
    #include TRACKFILE
    #declare TIME_LOCATE = off
#else
    #declare L_POS = <L_OFF,seg_high,-Length_B>
    #declare CALCULATED_CLOCK_DISTANCE = 0
    #declare CURRENT_SPEED = 0
#end


#debug concat("\n red car distance is ",str(CALCULATED_CLOCK_DISTANCE,0,3))
#debug concat("\n red car speed is ",str(CURRENT_SPEED,0,3))
#debug concat("\n red car location is \n x: ",str(L_POS.x,0,0),"\n z: ",str(L_POS.z,0,0))
#declare RED_CAR_POS = L_POS
#declare RED_CAR_ANG = L_ANG
#declare RED_CAR_DISTANCE = CALCULATED_CLOCK_DISTANCE
#declare RED_CAR_SPEED = CURRENT_SPEED

#declare INPUT_DISTANCE = RED_CAR_DISTANCE - (  ( 3.6*inches *  (1-   (RED_CAR_SPEED/MAX_SPEED)    )    ) + 0.55*inches)
#declare L_OFF = t_width/2

#if (INPUT_CLOCK >= 0)
    #declare DIST_LOCATE = on
    #include TRACKFILE
    #declare DIST_LOCATE = off
#else
    #declare L_POS = <L_OFF,seg_high,-Length_B*2>  //behind first one
#end

#declare RED_CAR_TARGET = L_POS

#declare RED_CAR_DIRECTION = y*degrees( atan2( RED_CAR_POS.x - RED_CAR_TARGET.x , RED_CAR_POS.z - RED_CAR_TARGET.z))










object {Yellow_car
   rotate YELLOW_CAR_DIRECTION
  translate YELLOW_CAR_POS
  }

object {Red_car
  rotate RED_CAR_DIRECTION
  translate RED_CAR_POS
}




sky_sphere
{
Clouds
}


//floor...
object{ plane {y, 0}
    texture {
//LEAVE IN: USEFUL FOR POSITIONING
//pigment { checker colour rgb<1,1,0>, colour rgb<0,0,1> scale 12*inches }
        Carpet
        }
    }


//roof...
object{ box {<-1*feet,8*feet,-8*feet><15*feet,9*feet,8*feet>}
texture {White_Paint}
}

//walls...
union {

box {<-2.0*feet,0,-8*feet><-1.0*feet,8*feet,8*feet>}

intersection {
    box {<-1.0*feet,0,8*feet><15*feet,8*feet,9*feet>}
    box {<1.5*feet,2.5*feet,7.9*feet><12.5*feet,7*feet,9.1*feet >inverse}
    }

intersection {
    box {<15*feet,0,-8*feet><16*feet,8*feet,8*feet>}
    box {<14.1*feet,0,-7.75*feet><16.1*feet,6.5*feet,-5.25*feet> inverse }
    }

plane {z, -8*feet}

texture {Wallpaper}
}

//window inner_frame
object{
    intersection {
        box {<1.8*feet,2.85*feet,8.8*feet><12.2*feet,6.7*feet,8.85*feet >}
        box {<1.85*feet,2.9*feet,8.7*feet><9.15*feet,6.65*feet,8.95*feet >inverse}
        box {<9.65*feet,2.9*feet,8.7*feet><12.15*feet,5.35*feet,8.95*feet >inverse}
        box {<9.65*feet,5.75*feet,8.7*feet><12.15*feet,6.65*feet,8.95*feet >inverse}
        }
    texture {smooth_black_plastic}
    }

//window outer_frame
object{
    intersection {
        box {<1.55*feet,2.6*feet,8.7*feet><12.45*feet,6.95*feet,8.95*feet >}
        box {<1.8*feet,2.85*feet,8.65*feet><9.2*feet,6.7*feet,9.0*feet >inverse}
        box {<9.6*feet,2.85*feet,8.65*feet><12.2*feet,5.4*feet,9.0*feet >inverse}
        box {<9.6*feet,5.7*feet,8.65*feet><12.2*feet,6.7*feet,9.0*feet >inverse}
        }
    texture {White_Paint}
    }

//window borders

object{
    intersection {
        box {<1.5*feet,2.5*feet,8*feet><12.5*feet,7*feet,9*feet >}
        box {<1.55*feet,2.4*feet,7.95*feet><12.45*feet,6.95*feet,9.05*feet> inverse}
        }
    texture {White_Paint}
    }

//window ledge

object{
    box {<1.25*feet,2.5*feet,7.9*feet><12.75*feet,2.6*feet,9*feet>}
    texture {White_Paint}
    }


//borders (note: cylinders height coordinates are double then scaled down)

union{
    box {<-1.0*feet,0,-8*feet><-1.0*feet+0.5*inches,4*inches,8*feet>}
    cylinder {<-1.0*feet,8*inches,-8*feet><-1.0*feet,8*inches,8*feet> 0.5*inches scale <1,0.5,1>}
    box {<-1.0*feet,0,8*feet-0.5*inches><15*feet,4*inches,8*feet>}
    cylinder {<-1.0*feet,8*inches,8*feet><15*feet,8*inches,8*feet> 0.5*inches scale <1,0.5,1>}
    box {<15*feet-0.5*inches,0,-5*feet><15*feet,4*inches,8*feet>}
    cylinder {<15*feet,8*inches,-5*feet><15*feet,8*inches,8*feet> 0.5*inches scale <1,0.5,1>}
    box {<-1.0*feet,0,-8*feet><15*feet,4*inches,-8*feet+0.5*inches>}
    cylinder {<-1.0*feet,8*inches,-8*feet><15*feet,8*inches,-8*feet> 0.5*inches scale <1,0.5,1>}
    texture {White_Paint}
    }






//door and frame...
union{
    box {<15*feet-0.5*inches,6.5*feet,-8*feet><15*feet,6.75*feet,-5*feet>}
    box {<15*feet-0.5*inches,0.0*feet,-8*feet><15*feet,6.5*feet,-7.75*feet>}
    box {<15*feet-0.5*inches,0.0*feet,-5.25*feet><15*feet,6.5*feet,-5*feet>}

    box {<15*feet,0,-7.75*feet><15.2*feet,6.5*feet,-5.25*feet>}
texture {White_Paint}
}





#include "bed.pov"

object {bed
 rotate <0,180,0>
 translate <11.3*feet,0,2.0*feet>
 }

#include "chest.pov"
object {chest
 rotate <0,90,0>
 translate <14.0*feet,0.0, 6.2*feet>
 }

#include "mug.pov"

object {mug
    rotate y*-83
    translate <3.75*feet,0.0,-6.8*feet>
    }

#include "desk.pov"

object {desk
    rotate y*180
    translate <7.0*feet,0.0,-7.5*feet>
    }

#include "keyboard.pov"

object {keyboard
    rotate y*-11
    translate <1.2*feet,0.0,3.6*feet>
    }

#include "plug.pov"

object {plug
    translate <-1*feet,0,4*feet>
    }

#include "chair.pov"

object {chair
    rotate y*138
    translate <9*feet,0.0,-4*feet>
    }

object { Blue_car
    rotate y*44
    translate <0.75*feet,0.0,-1.6*feet>
    }



#include "cameras.inc"


#ifndef (LIGHTVALUE) #declare LIGHTVALUE = 1 #end

#if (LIGHTVALUE > 1) #declare LIGHTVALUE = 1 #end
#if (LIGHTVALUE < 0) #declare LIGHTVALUE = 0 #end

#debug concat("\n LIGHTVALUE is ",str(LIGHTVALUE,0,3))



#declare TRACKFILE = "trackplt.inc"

#declare Trackplot = on
#include TRACKFILE
#declare Trackplot = off


#include "gantry.pov" //file displays gantry as well as declaring it




global_settings {
    ambient_light rgb<1,1,1>*LIGHTVALUE

    max_trace_level 30

    }


light_source        // light from outside
{
  <0,0,0> //translated below
  color rgb <1.0,1.0,1.0>*LIGHTVALUE
  translate <7*feet, 6*feet, 9*feet>
 }


light_source       //area light
{
  <7*feet, 7.9*feet, 0*feet>
  color rgb <0.5,0.5,0.5>*LIGHTVALUE
  area_light <14*feet, 0, 0>, <0, 0, 14*feet>, 4, 5
  adaptive 1
 }


/*
light_source       //light reflecting off back wall
{
  <0,0,0> //translated below
  color rgb <0.3,0.3,0.3>*LIGHTVALUE
  translate <7*feet, 6*feet, -7.9*feet>
 }


light_source       //light reflecting off side wall
{
  <0,0,0> //translated below
  color rgb <0.2,0.2,0.2>*LIGHTVALUE
  translate <-0.9*feet, 6*feet, 0*feet>
 }

light_source       //light reflecting off ceiling
{
  <0,0,0> //translated below
  color rgb <0.2,0.2,0.2>*LIGHTVALUE
  translate <7*feet, 7.9*feet, 0*feet>
 }

*/
