// File Copyright (C) Aaron Gage.  Please see README file for details.

#declare Cannon = union {
	union {
	difference {
		cone { <0, 0, -2>, 0.6, <0, 0, 3>, 1 }
		cylinder { <0, 0, -2.1>, <0, 0, 2>, 0.5 }
		}
	difference {
		sphere { <0, 0, 3>, 1 }
		plane { z*1, 3 }
		}


	difference 
		{
		cylinder { <0, 0.8, 2.9>, <0, 1.05, 2.9>, 0.1 }
		cylinder { <0, 0.79, 2.9>, <0, 1.1, 2.9>, 0.075 }
		}
	pigment { color White*0.05 }
	finish { Shiny reflection 0.2 ambient 0.4 }
	}

	union {
	cylinder { <1.25, 0, 2.5>, <-1.25, 0, 2.5>, 0.25
		pigment { color White*0.05 }
		finish { Shiny reflection 0.2 ambient 0.4 }
		}
	difference {
		cylinder { <-1.5, -0.5 + 0.1 + 0.25, 2.5>, <-1.1, -0.5 + 0.1 + 0.25, 2.5>, 0.5 }
		cylinder { <-1.51, -0.5 + 0.1 + 0.25, 2.5>, <-1.09, -0.5 + 0.1 + 0.25, 2.5>, 0.4 }
		plane { y*1, -0.5 + 0.25  }
		pigment { color Silver*0.5 }
		finish { Shiny reflection 0.6 ambient 0.4 }
		}

	difference {
		cylinder { <1.5, -0.5 + 0.1 + 0.25, 2.5>, <1.1, -0.5 + 0.1 + 0.25, 2.5>, 0.5 }
		cylinder { <1.51, -0.5 + 0.1 + 0.25, 2.5>, <1.09, -0.5 + 0.1 + 0.25, 2.5>, 0.4 }
		plane { y*1, -0.5 + 0.25 }
		}

	difference {
		box { <-1.7, -0.25, 3>, <1.7, -1.25, 2> }
		cylinder { z*-3, z*3, 1.05 }
		}

	box { <-1.7, -1.25, 3.5>, <1.7, -1.6, 1.25> }
	cylinder { <-1.7, -1.4, 2.5>, <1.7, -1.4, 2.5>, 0.35 }

	difference {
		box { <-0.25, -1.25, 3.5>, <0.25, -1.6, 10> }
		cylinder { <0, 0, 9.5>, <0, -2, 9.5>, 0.125 }
	}

	pigment { color DarkOliveGreen }
	finish { Dull ambient 0.4 }

	translate z*-1
	}

	cylinder { <-2.01, -1.4, 1.5>, <2.01, -1.4, 1.5>, 0.1
		pigment { color Gold } }
	union {
		cylinder { <-2.0, -1.4, 1.5>, <-1.8, -1.4, 1.5>, 0.35 }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1 }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*30
			translate <0, -1.4, 1.5> }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*60
			translate <0, -1.4, 1.5> }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*90
			translate <0, -1.4, 1.5> }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*120
			translate <0, -1.4, 1.5> }
		cylinder { <-1.9, 0, 1.5>, <-1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*150
			translate <0, -1.4, 1.5> }
		difference {
			cylinder { <-2.0, -1.4, 1.5>, <-1.8, -1.4, 1.5>, 1.45 }
			cylinder { <-2.1, -1.4, 1.5>, <-1.7, -1.4, 1.5>, 1.35 }
			}
		#if (ActiveCannon = 1)
			translate y*1.4
			rotate x*CannonDist/15*2*2.744*pi
			translate y*-1.4
		#end
		pigment { color Brown*0.8 }
		finish { Shiny ambient 0.4 }
		}
	union {
		cylinder { <2.0, -1.4, 1.5>, <1.8, -1.4, 1.5>, 0.35 }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1 }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*30
			translate <0, -1.4, 1.5> }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*60
			translate <0, -1.4, 1.5> }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*90
			translate <0, -1.4, 1.5> }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*120
			translate <0, -1.4, 1.5> }
		cylinder { <1.9, 0, 1.5>, <1.9, -2.8, 1.5>, 0.1
			translate <0, 1.4, -1.5> rotate x*150
			translate <0, -1.4, 1.5> }
		difference {
			cylinder { <2.0, -1.4, 1.5>, <1.8, -1.4, 1.5>, 1.45 }
			cylinder { <2.1, -1.4, 1.5>, <1.7, -1.4, 1.5>, 1.35 }
			}
		pigment { color Brown*0.8 }
		finish { Shiny ambient 0.4 }
		}
	translate <0, 1.4 , -1.5> rotate x*9 translate <0, 1.4, -1.5>
	finish { ambient 0.4 }
}
