// File Copyright (C) Aaron Gage.  Please see README file for details.

#declare Fillet = difference
{
	box { <-20, 1, 1>, <20, -1, -1> }
	cylinder { <-21, -1, -1>, <21, -1, -1>, 0.75 }
}

#declare Door =
union
	{
	difference
		{
		box { <-24, 0.0625, 0>, <24, 84, 3> }
		box { <-15, 50, -1>, <15, 74, 1> }
		box { <-15, 42, -1>, <15, 12, 1> }
		}
	object { Fillet
		translate <0, 73, 1.5> }

	object { Fillet
		translate <0, 41, 1.5> }

	object { Fillet rotate z*180
		translate <0, 51, 1.5> }

	object { Fillet rotate z*180
		translate <0, 13, 1.5> }

	object { Fillet rotate z*90
		translate <-14, 61, 1.5> }

	object { Fillet rotate z*-90
		translate <14, 61, 1.5> }

	object { Fillet rotate z*90
		translate <-14, 31, 1.5> }

	object { Fillet rotate z*-90
		translate <14, 31, 1.5> }

	texture { T_Wood8 rotate x*92 rotate z*2}
	}

#declare DoorFrame =
union
	{
	box { <-28, 84, -1.5>, <28, 87, 1>
		texture { T_Wood15 rotate y*90 }
		}
	box { <-28, 0, -1.5>, <-24, 84, 1>
		texture { T_Wood15 rotate x*90 }
		}
	box { <28, 0, -1.5>, <24, 84, 1>
		texture { T_Wood15 rotate x*90 }
		}
	box { <-28, 0.1, -1.5>, <28, -1, 3>
		texture { T_Wood15 rotate y*90 }
		}
	}
