// File Copyright (C) Aaron Gage.  Please see README file for details.

#include "colors.inc"

#declare LegoHead = union
{
	cylinder { <0, 1, 0>, <0, 1.125, 0>, 0.35
		pigment { color rgb <0.85, 0.8, 0.2> }
		translate y*-0.25 }
	superellipsoid
		{
		<1, 0.2>
		rotate x*90
		scale 0.75
		pigment { color rgb <0.85, 0.8, 0.2> }
		}

/* face */
	cylinder {
		<0, 0, 0>, <0, 0.05, 0>, 0.125
		rotate x*-90
		translate <0, 0.4, -0.7>
		rotate y*15
		pigment { color White*0.15 }
		no_shadow
		}

	cylinder {
		<0, 0, 0>, <0, 0.05, 0>, 0.125
		rotate x*-90
		translate <0, 0.4, -0.7>
		rotate y*-15
		pigment { color White*0.15 }
		no_shadow
		}
	difference {
		cylinder
			{
			<0, 0, 0>, <0, 0.05, 0>, 0.395
			}
		cylinder
			{
			<0, -0, 0>, <0, 0.06, 0.05>, 0.42
			}
		plane { z*-1, 0 }
		rotate x*-90
		translate <0, -0.1, -0.7>
		pigment { color White*0.15 }
		no_shadow
		}
	finish { specular 0.35 roughness 0.001 }
	}

#declare LegoBody = union
{
	cylinder { <0, 2.5, 0>, <0, 3, 0>, 0.25 }
	difference {
		box { <-1.9, 0, -0.5>, <1.9, 2.5, 0.5> }
		plane { x*-1, -1.875 rotate z*20 }
		plane { x*1, -1.875 rotate z*-20 }
		}
	cylinder { <-2.5, 2.15, 0>, <2.25, 2.15, 0>, 0.35 } 

	box { <-1.9, -0.01, -0.5>, <1.9, -0.3, 0.5> }
	box { <-0.75, -0.55, -0.5>, <0.75, 0.2, 0.5> }
	cylinder { <-0.75, -0.55, 0>, <0.75, -0.55, 0>, 0.5 }
	pigment { color White*0.9 }
}

#declare LegoLArm = 
union {  /* left arm */
	cylinder { <-2.5, 2.15, 0>, <-2, 2.15, 0>, 0.4 }
	cylinder { <-2.25, 2.15, 0>, <-2.25, 0, 0>, 0.249
		pigment { color rgb <0.85, 0.8, 0.2> } }
	cylinder { <-2.25, 0, 0>, <-2.25, -0.2, 0>, 0.26 }
	pigment { color White*0.9 }
}

#declare LegoRArm =
union { /* right arm */
	cylinder { <2.5, 2.15, 0>, <2, 2.15, 0>, 0.4 }
	cylinder { <2.25, 2.15, 0>, <2.25, 0, 0>, 0.249
		pigment { color rgb <0.85, 0.8, 0.2> } }
	cylinder { <2.25, 0, 0>, <2.25, -0.2, 0>, 0.26 }
	pigment { color White*0.9 }
}

#declare LegoLLeg =
difference {
	union { /* left leg */
		box { <-1.9, -0.55, -0.5>, <-0.8, -3, 0.5> }
		cylinder { <-1.9, -0.55, 0>, <-0.8, -0.55, 0>, 0.5 }
		box { <-1.9, -2.95, -0.85>, <-0.8, -3, 0.5> }
	}
	cylinder { <-1.35, -2.76, 0>, <-1.35, -3.01, 0>, 0.35 }
	pigment { color White*0.9 }
}

#declare LegoRLeg =
difference {
	union { /* right leg */
		box { <1.9, -0.55, -0.5>, <0.8, -3, 0.5> }
		cylinder { <1.9, -0.55, 0>, <0.8, -0.55, 0>, 0.5 }
		box { <1.9, -2.95, -0.85>, <0.8, -3, 0.5> }
	}
	cylinder { <1.35, -2.76, 0>, <1.35, -3.01, 0>, 0.35 }
	pigment { color White*0.9 }
}

#declare LegoGuy = union {
	object { LegoHead translate y*3.5 }
	object { LegoBody }
	object { LegoRArm }
	object { LegoLArm }
	object { LegoRLeg }
	object { LegoLLeg }
	finish { Dull ambient 0.4 }
	scale 0.5
}

#declare LegoGuy2 = union {
        object { LegoHead translate y*3.5 rotate y*-15 }
        object { LegoBody }
        object { LegoRArm }
        object { LegoLArm }
        object { LegoRLeg }
        object { LegoLLeg }
	finish { Dull ambient 0.4 }
        scale 0.5
}

#declare LegoGuy3 = union {
        object { LegoHead translate y*3.5 rotate y*(-15) }
        object { LegoBody }
        object { LegoRArm }
        object { LegoLArm }
        object { LegoRLeg }
        object { LegoLLeg }
	finish { Dull ambient 0.4 }
        scale 0.5
}
