// File Copyright (C) Aaron Gage.  Please see README file for details.

#include "outlet.inc"
#include "frame.inc"
#include "glass.inc"
#include "lights.inc"
#include "door.inc"

#declare S1 = seed(27)

#declare RailWood = 
	texture { T_Wood19
		finish { ambient 0.3 roughness 0.0001 specular 0.95
			reflection 0.2 } }

#declare RailPost = 
intersection {
	sor {
		27,
		<3, -4>, <3, -3>, <3, -1.5>, <3, 0>, <2, 0.5>,
		<1, 0.75>, <1.5, 1>, <1, 1.25>,
		<2, 1.5>, <3, 2>,
		<3, 3.25>, <2, 3.5>, <1.25, 4>,
		<2, 5>, <1.25, 6>, <2, 6.5>, <3, 6.75>,
		<3, 8>,
		<2, 8.5>, <1, 8.75>, <1.5, 9>, <1, 9.25>, <2, 9.5>,
		<3, 10>, <3, 11.5>, <3, 13>, <3, 14>
		translate y*-5
		}
	box { <-1.75, -8, -1.75>, <1.75, 8, 1.75> }
	scale <1, 2, 1>
}

#declare HandRail =
prism
	{
	cubic_spline
	linear_sweep
	-108, 108,
	13,
	<-0.9, 0.75>, <0, 1>, <0.9, 0.75>, <0.75, 0.5>,
	<1, 0.25>, <1, 0.05>, <0, 0>, <-1, 0.05>,
	<-1, 0.25>, <-0.75, 0.5>, <-0.9, 0.75>,
	<0, 1>, <0.9, 0.75>
	sturm
	}
#declare EndPost =
union
	{
	box { <-4, 0, -4>, <4, 58, 4>
			texture { RailWood }
		}
	box { <-8, 45, -8>, <8, 58, 8>
			texture { RailWood }
		}
	box { <-6, 6, -6>, <6, 4, 6>
			texture { RailWood }
		}
	box { <-8, 4, -8>, <8, 0, 8>
			texture { RailWood }
		}
	sor
		{
		8,
		<0, 57.9998>, <0, 57.9999>, <6, 58>,
		<5.2, 59.5>, <6, 61>, <4.2, 64>, <0, 65>,
		<0, 65.0001>
		texture { RailWood }
		}
	object { 
		box { <- 8, 0, -8>, <8, -12, 8> }
		texture {
			pigment { color White*0.8 }
			finish { specular 0.5 roughness 0.15 ambient 0.3 }
			normal { bumps scale <1, 0.1, 1> }
			}
		}
	}

#declare Railing = 
	union {
		object { HandRail scale <6, 1, 6> rotate x*-90 rotate y*-90
			texture { RailWood rotate y*-90}
			}
		#declare Loop = -96
		#while (Loop < 100) //50
		object { RailPost scale 0.5 translate y*-8 scale 3 translate x*Loop
			texture { RailWood rotate x*90}
			}
		#declare Loop = Loop + 24
		#end
	}

#declare RailBase =
	box { <-100, 0, -5>, <100, 2, 5> texture { RailWood rotate y*90} }

/*
#declare T_Wood4X = texture { T_Wood4
		finish { ambient 0.3 roughness 0.0001 specular 0.95
			reflection 0.2 } }
*/

#declare T_Wood4X = texture { T_Wood1
		finish { ambient 0.3 roughness 0.0001 specular 0.95
			reflection 0.2 } }

#declare FloorTileProto =
union
	{
	box { <-5.99, 0.01*rand(S1), -5.99>, <-5.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1)} }
	box { <-4.99, 0.01*rand(S1), -5.99>, <-4.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1)} }
	box { <-3.99, 0.01*rand(S1), -5.99>, <-3.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1)} }
	box { <-2.99, 0.01*rand(S1), -6>, <-2.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1)} }
	box { <-1.99, 0.01*rand(S1), -6>, <-1.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1)} }
	box { <-0.99, 0.01*rand(S1), -6>, <0.01, -0.25, 0>
		texture { T_Wood4X translate x*rand(S1)*5
				scale 1.5-rand(S1) } }
	}

#declare FloorTile =
union
	{
	object { FloorTileProto }
	object { FloorTileProto rotate y*90 }
	object { FloorTileProto rotate y*180 }
	object { FloorTileProto rotate y*-90 }
	normal { dents scale <4, 1, 4> }
	}

#declare Wallpaper =
	texture {
		//pigment { color White*0.8 }
		pigment {
			image_map
				{
				tga "wallpaper.tga"
				map_type 0  //planar
				}
			}
		scale 10
		finish { specular 0.2 roughness 0.15 ambient 0.3 }
		//normal { bumps scale <1, 0.1, 1> }
		}

#declare Walls =
union
	{
	difference {
		box { <-180, -5-103, -59>, <174, 96, -60> }
		box { <-24.1, 0.0625, 3>, <24.1, 84.1, -3>
			rotate y*180
			translate <-108, 0, -60> }
		texture { Wallpaper }
		}

	difference {
		box { <174-0.01, -5-103, -60>, <176-0.01, 96, 216>
			texture { Wallpaper rotate y*-90 } }
		box { <173, 40, 2>, <177, 86, 102>
			texture {
				pigment { White*0.7 }
				finish { specular 0.25 roughness 0.01
					ambient 0.3 }
				normal { bozo scale <2, 0.25, 2> }
				}
			}
		}
	box { <175-0.1, 39, 3>, <175+0.1, 87, 103>
		texture {
			T_Glass3
			}
		}
	object { FrameEdge1 rotate x*-90 rotate y*90 translate <174, 63, 102-3> }
	object { FrameEdge1 rotate x*-90 rotate y*90 rotate x*180 translate <174, 63, 2+3> }

	object { FrameEdge2 rotate x*-90 rotate y*90
		rotate x*-90
		translate <174, 86-3, 52> }
	object { FrameEdge2 rotate x*-90 rotate y*90 rotate x*180
		rotate x*-90
		translate <174, 40+3, 52> }

	difference {
		box { <-180, -0.01, -59.01>, <174, 4, -59+0.25> }
		box { <-28.1, 0.0625, 3>, <28.1, 84.1, -3>
			rotate y*180
			translate <-108, 0, -60> }
		texture
			{
			pigment { White*0.9 }
			finish { specular 0.5 roughness 0.001 ambient 0.3 }
			normal { marble scale <2, 0.5, 2> turbulence 1.5 }
			}
		}
	box { <174+0.01, -0.01, -59.01>, <174-0.25, 4, 216>
		texture
			{
			pigment { White*0.9 }
			finish { specular 0.5 roughness 0.001 ambient 0.3 }
			normal { marble scale <2, 0.5, 2> turbulence 1.5 }
			}
		}
        //box { <-156, -108, -60>, <180, -109, 220>
        box { <-185, -109, -60>, <-185, 96, 220>
		pigment { color White*0.8 }
		finish { ambient 0.3 } }
	}

#declare Floors = 
union {
	union
		{
		box { <-156, -0.251, 0+5>, <174, -12, -60> }
		box { <108 - 5, -0.251, -0.01>, <174, -12, 216> }
		box { <108 - 8, -0.251, 5-0.01>, <108, -12, 8> }
		texture {
			pigment { color White*0.8 }
			finish { specular 0.5 roughness 0.15 ambient 0.3 }
			normal { bumps scale <1, 0.1, 1> }
			}
		}
	box { <-185, 0, 5>, <-180, -0.25, -60>
		texture { T_Wood4X } }

	box { <-185, -108, -60>, <180, -109, 220>
		texture { T_Wood4X rotate y*90 } }
}

#declare Ceiling =
difference
{
	box { <-174, 96-0.01, 216>, <174, 98, -60> }
	object { LightShape
		translate <-80, 95.5, -30> }
	object { LightShape
		translate <40, 95.5, -30> }
	texture {
		pigment { color White*0.8 }
		finish { specular 0.5 roughness 0.15 ambient 0.3 }
		//normal { bumps scale <1, 0.01, 1> }
		normal { crackle scale <1, 0.01, 1> }
		}
}

#declare House = 
union {
	object { Railing translate y*48 }
	object { EndPost translate x*108 }
	object { EndPost translate x*-108 }
	object { RailBase }
	object { Railing rotate y*90 translate <108, 48, 108> }
	object { RailBase rotate y*90 translate <108, 0, 108> }

//diagonal down
	object { HandRail scale <6, 1, 6> rotate x*-90 rotate y*-90
		texture { RailWood rotate y*-90}
		rotate y*90
		rotate x*30
		translate <-108, 48, 108>
		//translate -y*sin(30)*108
		translate y*-54 + 3 //3.75
		translate z*-14.472
		}

	difference {
		object { RailPost scale 0.5 translate y*-8 scale 3
			translate <-108, -6+48, 24 > }
		plane { y*-1, 0
			rotate x*30
			translate <0, 41, 24>
			}
			texture { RailWood rotate x*90 }
		}

	#declare Loop = -108 - 48
	#while (Loop <= 108 + 60)
		object { FloorTile translate <Loop-2, 0, -5> }
		object { FloorTile translate <Loop-2, 0, -17> }
		object { FloorTile translate <Loop-2, 0, -29> }
		object { FloorTile translate <Loop-2, 0, -41> }
		object { FloorTile translate <Loop-2, 0, -53> }
	#declare Loop = Loop + 12
	#end
	#declare Loop = 7
	#while (Loop <= 108*2)
		object { FloorTile translate <120-2, 0, Loop> }
		object { FloorTile translate <132-2, 0, Loop> }
		object { FloorTile translate <144-2, 0, Loop> }
		object { FloorTile translate <156-2, 0, Loop> }
		object { FloorTile translate <168-2, 0, Loop> }
	#declare Loop = Loop + 12
	#end
	merge {
		box { <-36 - 108, 0, 0>, <-108, -0.25, 10> }
		cylinder { <-36 - 108, -0.125, 10>, <-108, -0.125, 10>, 0.125 }
		texture { RailWood rotate y*90 }
		}
	object { Walls }
	object { Floors }
	object { Ceiling }

	object { Light
		translate <-80, 95.5, -30> }
	object { Light
		translate <40, 95.5, -30> }

	object { Door rotate y*180
                      translate <-108, 0, -60> }

	object { DoorFrame
                        rotate y*180
                        translate <-108, 0, -60> }

	object { Outlet scale 2 rotate y*180 translate <0, 12, -59> }
	}
