// File Copyright (C) Aaron Gage.  Please see README file for details.

#include "dart.inc"

#declare GreenLight = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <0, 1, 0, 0.3> } no_shadow
		finish { ambient 1 } hollow }
//light_source { y*0.26 color Green*0.1 }
}

#declare GreenLightOff = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <0, 1, 0, 0.3> } no_shadow
		finish { ambient 0.1 } hollow }
}

#declare RedLight = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <1, 0, 0, 0.3> } no_shadow
		finish { ambient 1 } hollow }
//light_source { y*0.26 color Red*0.1 }
}

#declare RedLightOff = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <1, 0, 0, 0.3> } no_shadow
		finish { ambient 0.1 } hollow }
}

#declare BlueLight = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <0, 0, 1, 0.3> } no_shadow
		finish { ambient 1 } hollow }
//light_source { y*0.26 color Blue*0.1 }
}

#declare BlueLightOff = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <0, 0, 1, 0.3> } no_shadow
		finish { ambient 0.1 } hollow }
}

#declare YellowLight = union
{
cylinder { 0, y*0.25, 0.25 pigment { color White*0.1 } finish { Dull } }
sphere { y*0.25, 0.15 pigment { color rgbf <1, 1, 0, 0.3> } no_shadow
		finish { ambient 1 } hollow }
//light_source { y*0.26 color Yellow*0.2 }
}

#declare RobotBody = union {
	difference {
		box { <-4, 0.25, -5>, <4, 2, 5> }
		plane { z*-1, -4.5 rotate x*-20 }
		plane { z*1, -4.5 rotate x*20 }
		box { <-3.5, 0, -4.6>, <-3.1, 1.1, -3.4> }
		box { <3.5, 0, -4.6>, <3.1, 1.1, -3.4> }

		box { <-3.5, 0, 4.6>, <-3.1, 1.1, 3.4> }
		box { <3.5, 0, 4.6>, <3.1, 1.1, 3.4> }
		pigment { color <0.16, 0, 0.75> }
		finish { Glossy ambient 0.4 }
		}
	union {
	cylinder { <-3.45, 0.5, -4>, <-3.2, 0.5, -4>, 0.5 }
	cylinder { <-3.5, 0.5, -4>, <-3.1, 0.5, -4>, 0.15 }
	cylinder { <3.45, 0.5, -4>, <3.2, 0.5, -4>, 0.5 }
	cylinder { <3.5, 0.5, -4>, <3.1, 0.5, -4>, 0.15 }

	cylinder { <-3.45, 0.5, 4>, <-3.2, 0.5, 4>, 0.5 }
	cylinder { <-3.5, 0.5, 4>, <-3.1, 0.5, 4>, 0.15 }
	cylinder { <3.45, 0.5, 4>, <3.2, 0.5, 4>, 0.5 }
	cylinder { <-3.5, 0.5, 4>, <-3.1, 0.5, 4>, 0.15 }
	pigment { color Yellow*0.3 }
	finish { Dull ambient 0.3 }
	}

	union {
#declare Loop5 = 0
#while (Loop5 < 12)
	torus { 2.5 + 0.25*(Loop5-12)/12, 0.5 translate <1.125, 2.025 + Loop5, 0> }
	torus { 2.5 + 0.25*(Loop5-12)/12, 0.5 translate <-1.125, 2.025 + Loop5, 0>}
	#declare Loop5 = Loop5 + 1
#end
	pigment { color White*0.1 }
	finish { Dull ambient 0.1 }
	}

	union {
	superellipsoid { <0.15, 0.15>
		scale <5, 8/3, 4> translate y*15.5
		pigment { color rgb <0.75, 0, 0.16> }
	finish { Glossy ambient 0.4 } }
	//box { <-5, 14, -4>, <5, 17, 4> }

	cylinder { <-7.5, 15.5, 0>, <7.5, 15.5, 0>, 2
		pigment { color White*0.15 }
		finish { Dull ambient 0.1 }
		}
	}

	union {
	box { <-6.5, 3, -3>, <-9, -3, 3>
		rotate x*30
		//rotate x*-10*sin(clock*6*pi)
		translate y*15.5}

	box { <6.5, 3, -3>, <9, -3, 3>
		rotate x*30
		//rotate x*10*sin(clock*6*pi)
		translate y*15.5}
		pigment { color rgb <0.75, 0, 0.16> }
	finish { Glossy ambient 0.4 }
	}


	union { // begin of arms
		union {
		cylinder { <-7.725, 0, 0>, <-7.725, -7, 0>, 1
			pigment { color White*0.15 }
			finish { Dull ambient 0.1 }
			}
		sphere { <-7.725, -7, 0>, 1.25
			pigment { color <0.16, 0, 0.75> }
			finish { Glossy ambient 0.4 }
			}
		//rotate x*-10*sin(clock*6*pi)
		}

	difference {
	union {
		cylinder { <-7.725, -7, 0>, <-7.725, -10, -4>, 1
			pigment { color White*0.15 }
			finish { Dull ambient 0.1 }
			}
		sphere { <-7.725, -10, -4>, 1.125 }
	}
		cylinder { <-7.725, 2, 0>, <-7.725, -2, 0>, 0.5
			rotate x*-45
			translate <0, -10, -4>
			}
		//rotate x*-10*sin(clock*6*pi)
		}
	union {
		cylinder { <7.725, 0, 0>, <7.725, -7, 0>, 1
			pigment { color White*0.15 }
			finish { Dull ambient 0.1 }
			}
		sphere { <7.725, -7, 0>, 1.25
			pigment { color <0.16, 0, 0.75> }
			finish { Glossy ambient 0.4 }
			}
		//rotate x*10*sin(clock*6*pi)
		}

	difference {
	union {
		cylinder { <7.725, -7, 0>, <7.725, -10, -4>, 1
			pigment { color White*0.15 }
			finish { Dull ambient 0.1 }
			}
		sphere { <7.725, -10, -4>, 1.125 }
	}
		cylinder { <7.725, 2, 0>, <7.725, -2, 0>, 0.5
			rotate x*-45
			translate <0, -10, -4>
			}

		}
		rotate x*30
		//rotate x*10*sin(clock*6*pi)
		translate y*15.5
	} // end of arms

#if (clock < 0.1 | (clock > 0.4 & clock < 0.5) | (clock > 0.9))
	object { GreenLightOff rotate x*-90
		translate <-3, 16, -4>
		}
#else 
	object { GreenLight rotate x*-90
		translate <-3, 16, -4>
		}
#end

#if (clock < 0.05 | (clock > 0.3 & clock < 0.6) | (clock > 0.85 & clock < 0.9))
	object { BlueLightOff rotate x*-90
		translate <3, 16, -4>
		}
#else 
	object { BlueLight rotate x*-90
		translate <3, 16, -4>
		}
#end

#if ((clock > 0.15 & clock < 0.2) | (clock > 0.5 & clock < 0.75) | (clock > 0.925 & clock < 0.975))
	object { RedLightOff rotate x*-90
		translate <0, 15, -4>
		}
#else 
	object { RedLight rotate x*-90
		translate <0, 15, -4>
		}
#end

	// Head

	cylinder { <0, 15.5, 0>, <0, 20, 0>, 1
		pigment { color White*0.15 }
		finish { Dull ambient 0.1 }
		}

	intersection {
		plane { z*-1, 1.5 }
		plane { y*1, 19 }
		plane { z*1, 1.5 }
		plane { x*1, 1.25 rotate y*-25 }
		plane { x*-1, 1.25 rotate y*25 }
		plane { y*-1, -1 rotate x*-10 translate y*25 }
		}

	pigment { color White*0.8 }
	finish { ambient 0.4 }
}

/*
	intersection {
		plane { z*-1, 1.5 }
		plane { y*1, 19 }
		plane { z*1, 1.5 }
		plane { x*1, 1.25 rotate y*-25 }
		plane { x*-1, 1.25 rotate y*25 }
		plane { y*-1, -1 rotate x*-10 translate y*25 }
		pigment { color Red } finish { ambient 1 }
		}
*/

#declare Head = union {
	difference {
		intersection {
			plane { z, 1 }
			plane { -z, 1 }
			plane { x, 1 rotate y*25}
			plane { -x, 1 rotate y*-25}
			plane { y, 1 }
			plane { -y, 1 rotate x*-15}
		}
		plane { y, -1 rotate x*20 }
		plane { -x, -1 rotate y*-60}
		plane { x, -1 rotate y*60}
		pigment { color rgb <0.75, 0, 0.16> }
		finish { Glossy ambient 0.4 }

	}
	object { YellowLight scale 2/3 rotate x*-90 translate <-0.45, 0.25, -1> }
	object { YellowLight scale 2/3 rotate x*-90 translate <0.45, 0.25, -1> }
	scale 1.5
}

#declare Gun = union {
	difference
	{
		cylinder { z*-3, z*3, 1 }
		cylinder { z*-3.3, z*2, 0.75 }
		box { <-0.25, 0.9, 2.5>, <0.25, 1.1, 1.75> }
		pigment { color rgb <0.75, 0, 0.16> }
		finish { Glossy ambient 0.4 }
	}
	box { <-0.2, 0.9, 2.2>, <0.2, 1.1, 1.9> }
	box { <-0.5, -0.8, 2.5>, <0.5, -1.25, -2.5> }
	pigment { color White*0.15 }
	finish { Dull ambient 0.1 }
}

#declare Robot = union {
object { RobotBody }
object { Head translate y*20 }
object { Gun translate <-3.5, 19.25, 0> }

object { Dart translate <-3.5, 19.25, -0.15> }
}
