#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SkyFractal = "warp2280.gif"
#declare ShipPosition = 0.0

#declare CameraY = 3*(1-ShipPosition/36)
#declare MandelScale = ShipPosition-5
#if (MandelScale<1) #declare MandelScale=1 #end

camera {
        //location  <0, 12, -12>
        location <0, CameraY, -12>
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <0, 0, 0>
        angle 45
}


light_source {<0, 5, -12> color White}
light_source {<5, 0, -12> color White}
light_source {<-5, 0, -12> color White}

#declare _ExtremeS = texture { Soft_Silver }
#include "phiefer.inc"
object { Phiefer
         rotate <-90, 0, 0>
         scale .01
         translate <0, 0, ShipPosition>
       }
                      
//Sky
// /*  Sky Temp Out  <---------
difference {
height_field { gif SkyFractal 
                 texture { Soft_Silver }
                 texture { pigment { image_map { gif SkyFractal once interpolate 2 }
                 rotate x*90 }
                 finish { ambient .5 }
                }
                translate <-.5, 0, -.5>
                rotate <-90, 0, 0>
                scale <10, 10, 20>
                rotate <0, 180, 0>
             }
sphere { 0, 1 scale <1.5, 1.5, 15> texture { pigment { color Clear } } }
           }
// <-------- End Sky Out */

//Mandel
// /*  Mandel Temp Out  <---------
height_field { gif "warpmand.gif" 
                 texture { Soft_Silver }
                 texture { pigment { image_map { gif "warpmand.gif" once interpolate 2 }
                 rotate x*90 }
                 finish { ambient .5 }
                }
                translate <-.5, 0, -.5>
                rotate <-90, 0, 0>
                scale <2*(1+MandelScale/20), 2*(1+MandelScale/20), MandelScale>
                translate <0, 0, 20>
             }
// <-------- End Mandel Out */


                                           
