
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera // LOOK AT TABLE (UNDER SIDE)
{
  location  <0 , 5, -2.5>/3
  look_at   <0 , 0, 0>
}

light_source { <0,5,-5> color White }

//-----------------------------------------------------------------------------------------------------------------------------

#declare CSLOGO = union {

height_field {
  gif "CS-HGT.gif"
  texture {T_Gold_3A normal {dents .5 scale .1 frequency .5}}
  texture   {
    pigment {
      image_map { gif "CS-PIG.gif" map_type 0 interpolate 2 once filter .5 1 }
      rotate x*90
    }
    finish {
     reflection .25
     metallic
    }
  }
smooth
translate <-.5,0,-.5>
scale <2,.05,1>
}

#declare I=.0125
union {
sphere { <-1,0, .5> I }
sphere { < 1,0, .5> I }
sphere { <-1,0,-.5> I }
sphere { < 1,0,-.5> I }
cylinder { <-1,0,-.5><-1,0, .5> I }
cylinder { <-1,0, .5>< 1,0, .5> I }
cylinder { < 1,0, .5>< 1,0,-.5> I }
cylinder { < 1,0,-.5><-1,0,-.5> I }
  texture   {
   pigment {White}
   finish {reflection .25 metallic }
  }
scale <1,.025/I,1>
}

} //CSLOGO

CSLOGO
