#declare Tr = .1 // LETTER THICKNESS (radius of tubes)

#declare U05=difference { torus {.5 Tr rotate <90,0,0>} box {<Tr+.5,Tr+.5,Tr><0,-(Tr+.5),-Tr>} }

#declare NEON_B=merge {
sphere { <0, 1,0> Tr}
cylinder { <0, 1, 0> <0, -1, 0> Tr }
sphere { <0, -1,0> Tr}
cylinder { <0,-1, 0> <.5,-1, 0> Tr }
cylinder { <0, 0, 0> <.5, 0, 0> Tr }
cylinder { <0, 1, 0> <.5, 1, 0> Tr }
object {U05 rotate z*180 translate <.5, .5,0>}
object {U05 rotate z*180 translate <.5,-.5,0>}
}

#declare NEON_E=merge {
sphere { <0, 1,0> Tr}
cylinder { <0, 1, 0> <0, -1, 0> Tr }
sphere { <0, -1,0> Tr}
cylinder { <0,-1, 0> <  1,-1, 0> Tr }
cylinder { <0, 0, 0> <.75, 0, 0> Tr }
cylinder { <0, 1, 0> <  1, 1, 0> Tr }
sphere { <  1,-1, 0> Tr }
sphere { <.75, 0, 0> Tr }
sphere { <  1, 1, 0> Tr }
}

#declare NEON_R=merge {
sphere { <0, 1,0> Tr}
cylinder { <0, 1, 0> <0, -1, 0> Tr }
sphere { <0, -1,0> Tr}
cylinder { <0, 1, 0> <.5, 1, 0> Tr }
object {U05 rotate z*180 translate <.5, .5,0>}
cylinder { <0, 0, 0> <.5, 0, 0> Tr }
cylinder { <1,-1, 0> <.5, 0, 0> Tr }
sphere { <1,-1, 0> Tr }
}

#declare NEON_FRAME=merge {
sphere { <-(2+2*Tr), (1+2*Tr), 0> Tr }
sphere { <-(2+2*Tr),-(1+2*Tr), 0> Tr }
sphere { < (2+2*Tr),-(1+2*Tr), 0> Tr }
sphere { < (2+2*Tr), (1+2*Tr), 0> Tr }
cylinder { <-(2+2*Tr),-(1+2*Tr), 0> < (2+2*Tr),-(1+2*Tr), 0> Tr }
cylinder { < (2+2*Tr),-(1+2*Tr), 0> < (2+2*Tr), (1+2*Tr), 0> Tr }
cylinder { < (2+2*Tr), (1+2*Tr), 0> <-(2+2*Tr), (1+2*Tr), 0> Tr }
cylinder { <-(2+2*Tr), (1+2*Tr), 0> <-(2+2*Tr),-(1+2*Tr), 0> Tr }
}

#declare NEONCOLOR = color (Red*rand(R2)*2)
#declare NEONTEX1=texture {
 pigment {NEONCOLOR}
 finish {
  ambient .9
  phong 1
 }
}

#declare BEERSIGN= light_source { <0,0,Tr> color NEONCOLOR fade_distance 120 fade_power 2
 looks_like {
 #union {
  object {NEON_B scale 1-Tr*2 translate <-2+Tr,0,0>}
  object {NEON_E scale 1-Tr*2 translate <-1+Tr,0,0>}
  object {NEON_E scale 1-Tr*2 translate <0+Tr,0,0>}
  object {NEON_R scale 1-Tr*2 translate <1+Tr,0,0>}
  object {NEON_FRAME}
  box {<-(2+2*Tr),-(1+2*Tr), Tr>< 2+2*Tr, 1+2*Tr, Tr*.999> pigment {Black} }
  translate <0,0,-Tr>
  scale 6
  texture {NEONTEX1}
  }
 }
}
