
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera {
  location  <0 , 2 , 5>
  look_at   <0 , .5 , -12>
    blur_samples 64
    aperture .15
    focal_point <0 , .5 , -12>
}

light_source { <10,20,30> color White }

//-----------------------------------------------------------------------------------------------------------------------------

#include "TITLETEXT1.INC"

#declare TITLETEXT1=
#object {TITLETEXT1 rotate <0,180,0> translate <0,-FONT3D_OBJECT_YMin,0> scale (15/FONT3D_OBJECT_Width) scale <1,1,.25>
texture {
pigment {White}
finish {phong 1 metallic specular 1 metallic reflection .8}
}
}

#object {TITLETEXT1 translate <0,0,-12>}

// TABLE

#include "TABLE.INC"
#object {TABLE translate <0,0,0>}

#include "Chalk.inc"
#object {CHALK translate <0,1.075,0> scale .5 rotate <0,rand(R1)*360,0> translate <-32,2,25>}
#object {CHALK translate <0,1.075,0> scale .5 rotate <0,rand(R1)*360,0> translate <25,2,62>}
#object {CHALK rotate <90,0,0> translate <0,1.075,0> scale .5 rotate <0,rand(R1)*360,0> translate <1,0,0>}
//----------------------------------------------------------------------

// BALLS ON MAIN TABLE

#declare RANDBALLROT=0
#declare RANDBALLROT=1

#include "PoolBalls.inc"

#declare RACK = union {
/* Row #1 */
object { BALL1 }
/* Row #2 */
object { BALL10 translate <1, 0, 1.732>*1.125 }
object { BALL3 translate <-1, 0, 1.732>*1.125 }
/* Row #3 */
object { BALL9 translate <2, 0, 3.464>*1.125 }
object { BALL8 translate <0, 0, 3.464>*1.125 }
object { BALL11 translate <-2, 0, 3.464>*1.125 }
/* Row #4 */
object { BALL7 translate <-3, 0, 5.196>*1.125 }
object { BALL12 translate <-1, 0, 5.196>*1.125 }
object { BALL2 translate <1, 0, 5.196>*1.125 }
object { BALL13 translate <3, 0, 5.196>*1.125 }
/* Row #5 */
object { BALL4 translate <-4.0, 0.0, 6.928>*1.125 }
object { BALL15 translate <-2.0, 0.0, 6.928>*1.125 }
object { BALL6 translate <0.0, 0.0, 6.928>*1.125 }
object { BALL14 translate <2.0, 0.0, 6.928>*1.125 }
object { BALL5 translate <4, 0, 6.928>*1.125 }
}

#object {BALL0 rotate y*rand(R1)*360 translate <-4.5, 0, -2.5> }

#object {RACK rotate <0,180,0> translate < 0, 0,-30>}

//----------------------------------------------------------------------

#include "TITLETEXT2.INC"

#declare TITLETEXT2=
#object {TITLETEXT2 rotate <0,180,0> translate <0,-FONT3D_OBJECT_YMin,0> scale (15/FONT3D_OBJECT_Width/1.5) scale <1,1,.25>
texture {T_Gold_3E}
}

#object {TITLETEXT2 translate <0,4,-12>}
