#ifndef (TLITEON)
 #declare TLITEON=0
#end

#ifndef (TLITECOLOR)
 #declare TABLELITECOLOR=White
#end

#ifndef (NUMLITES)
 #declare NUMLITES=20
#end

// TABLE LIGHT

#declare LAMPTEX = texture {
  pigment {
    colour rgb<0.898,0.910,0.976>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    brilliance 6.0
    phong 0.75    phong_size 80    metallic
    reflection 0.2
  }
  normal {
    dents .5
    scale 5
    frequency .25
  }
rotate <rand(R1)*360,rand(R1)*360,rand(R1)*360>
}

//#declare LAMPTEX=texture {pigment{Red} } //QUICK TEX

#if (TLITEON=1)
 #declare BULBTEX =texture {
   pigment { colour rgbf<1.000,0.973,0.875,0.698> }
   finish {
     ambient 0.25
     diffuse 0.0
     brilliance 1.5
     specular 1.0    metallic
     reflection 0.85
     refraction 1.0    ior 1.5
   }
 }
#else
 #declare BULBTEX = texture {
   pigment { colour rgbf<0.875,0.847,0.765,0.800> }
   finish {
     ambient 0.05
     diffuse 0.0
     specular 1.0    metallic
     reflection 0.05
   }
 }
#end
#declare TLITE= union {

difference {
box {<21,23.001,31><-21,25,-31> }
box {<20,23,30><-20,25,-30> }
texture {LAMPTEX}
}

difference {
prism {
  conic_sweep
  linear_spline // linear_spline | quadratic_spline | cubic_spline
0
1
  5,          // number of points
  // the <u,v> points
< 21, 31><-21, 31><-21,-31>< 21,-31>< 21, 31>
sturm
scale <1,-24,1>
translate <0,24,0>
}
box {<22,8,32><-22,25,-32> }
translate <0,25,0>
texture {LAMPTEX}
}

union {
sphere {<-10,24,15> .75}
sphere {<-10,24,-15> .75}
cylinder {
<-10,24,15><-10,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

union {
sphere {<0,24,15> .75}
sphere {<0,24,-15> .75}
cylinder {
<0,24,15><0,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

union {
sphere {<10,24,15> .75}
sphere {<10,24,-15> .75}
cylinder {
<10,24,15><10,24,-15>
.75
}
texture {BULBTEX}
hollow
no_shadow
}

#ifndef (CHAINTEX) #declare CHAINTEX=texture {LAMPTEX scale .1} #end
#ifndef (CHAINTOP) #declare CHAINTOP=50 #end
#ifndef (CHAINBOTTOM) #declare CHAINBOTTOM=33.25 #end
#include "chain.inc"
object {CHAIN translate <0,0,15>}
box {<-1,33,17><1,33.25,13> texture {CHAINTEX} }
object {CHAIN translate <0,0,-15>}
box {<-1,33,-17><1,33.25,-13> texture {CHAINTEX} }

#if (TLITEON=1)
 #if (TLITEFLICKER*rand(R1)>.75)
   #declare Iz=-15
   #while (Iz<=15)
   light_source { < 10,24,Iz> color (TABLELITECOLOR-<rand(R1),rand(R1),rand(R1)>/4)/NUMLITES fade_distance 84 fade_power 2 }
   light_source { <-10,24,Iz> color (TABLELITECOLOR-<rand(R1),rand(R1),rand(R1)>/4)/NUMLITES fade_distance 84 fade_power 2 }
   #declare Iz=Iz+30/(NUMLITES/2)
   #end
 #else
   #declare Iz=-15
   #while (Iz<=15)
   light_source { < 10,24,Iz> color TABLELITECOLOR/NUMLITES fade_distance 84 fade_power 2 }
   light_source { <-10,24,Iz> color TABLELITECOLOR/NUMLITES fade_distance 84 fade_power 2 }
   #declare Iz=Iz+30/(NUMLITES/2)
   #end
 #end
#end

}

// TABLE LITE
