
// POV file by Andrew Cherry

#declare c=clock
#declare QUICK=0

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,1)," x E-TIME\n\n") #end

#declare R1=seed(666)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CONSTS.INC"
#include "GLASS.INC"
#include "SKIES.INC"
#include "METALS.INC"
#include "SHAPES.INC"   // These aren't normally necessary
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

camera
{
  location  <5 , 5 , 5>/2
  look_at   <0 , 0 , 0>
}

light_source { <10,20,30> color White }

//-----------------------------------------------------------------------------------------------------------------------------

#declare CueChalk = texture
{
  pigment
  {
    bozo
    turbulence 0.4
    color_map
    {
      [0.00 color rgb<0.135, 0.250, 0.500>]
      [0.50 color rgb<0.135, 0.250, 0.500>]
      [0.90 color rgb<0.750, 0.750, 1.000>]
      [1.00 color rgb<0.750, 0.750, 1.000>]
    }
    scale <0.1, 0.1, 0.1>
  }
scale .25
}

#declare ChalkBoxTex =
texture {pigment {Brown} }
texture {
 pigment {
 image_map { gif "ChalkLogo.gif" map_type 0 interpolate 4 filter 1/255 1 }
   scale <-2,2,2>
   translate <-1,-1,0>
 }
}

#declare ChalkSide=
difference {
superellipsoid {
  0.1
scale 1.1
}
box {<2,2,1><-2,-1,-2>}
texture {ChalkBoxTex}
}

#declare CHALK = union {
difference {
box {<1,1.05,1><-1,-1,-1> }
sphere {0 .75 scale <1,1.05,1> translate <0,1.05,0> }
torus {.75 .01 scale <1,1.05,1> translate <0,1.05,0> }
bounded_by {box {-1.25 1.25}}
texture {CueChalk}
}
torus {.75+.01 .01 scale <1,1.5,1> translate <0,1.05-.01,0> texture {CueChalk} }
#object {ChalkSide rotate <0,0,0> }
#object {ChalkSide rotate <0,90,0> }
#object {ChalkSide rotate <0,180,0> }
#object {ChalkSide rotate <0,270,0> }
}

CHALK
