
// POV file by Andrew Cherry

#declare c=clock

#debug "\n+----------------------------------------------+\n"
#debug concat("| ANIMATION SEQUENCE IS",str((clock*100),6,2)," PERCENT FINISHED |                 <-- AC")
#debug "\n+----------------------------------------------+\n"
#if (clock>0) #debug concat("\nTIME REMAINING: ",str(((1/clock)-1),6,3)," x E-TIME\n\n") #end

#declare R1=seed(666)
#declare R2=seed(c*123456789.987654321)

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "SKIES.INC"
#include "METALS.INC"

#declare Maroon=rgb <140/255,34/255,34/255>

camera // PLAYER'S HAND
{
  location  <-20 , 5 , 60>*(c+1)
  look_at   <0 , 4 , 60>
}
camera // LOOK AT PLAYER ACROSS TABLE
{
  location  <0 , 20 , -30>/2
  look_at   <0 , 15 , 0>/2
}
camera // LOOK AT PLAYER ACROSS TABLE
{
  location  <0 , 10 ,-60>
  look_at   <0 , 3, 0>
}
camera // LOOK AT TABLE (TOP)
{
  location  <15 , 20 ,-40>
  look_at   <0 , 0, -30>
}
camera // LOOK AT TABLE (UNDER SIDE)
{
  location  <50 , -10 ,-40>
  look_at   <0 , -4, 0>
}
camera // LOOK AT LEG
{
  location  <-32 , -42 ,-62>
  look_at   <-28 , -36, -58>
}
camera // SIDE VIEW OF SCENE
{
  location  <100,50,0>
  look_at   <0,10,0>
}
camera // LOOK AT TABLE (SIDE)
{
  location  <50 , 7 ,-40>
  look_at   <0 , 2, 0>
}

camera {
#declare start_location = <0,5,-63>
#declare end_location = <50,7,-40>
  location start_location+(end_location-start_location)*c*c
#declare start_look_at = <0,0,-61>
#declare end_look_at = <0,2,0>
  look_at start_look_at+(end_look_at-start_look_at)*c*c
}

light_source { start_location+(end_location-start_location)*c*c color rgb .1 }

sky_sphere {S_Cloud1}  //NEEDS SKIES.INC

//----------------------------------------------------------------------

// PLAYER
#declare PlayerClock=0
#declare StickClock=0
#include "PLAYER.INC"

//----------------------------------------------------------------------

// TABLE LIGHT

#declare CHAINTOP=50
#declare CHAINBOTTOM=33.25
#declare TLITEFLICKER=1
#declare TLITEON=1
#include "TLITE.INC"
#ifndef (TLITE) light_source {<0,24,0> color White}
#else object {TLITE translate <0,0,0>}
#end

//----------------------------------------------------------------------

// TABLE

#include "TABLE.INC"
#object {TABLE translate <0,0,0>}

#include "Chalk.inc"
#object {CHALK translate <0,1.075,0> scale .5 rotate <0,rand(R1)*360,0> translate <-32,2,25>}
#object {CHALK translate <0,1.075,0> scale .5 rotate <0,rand(R1)*360,0> translate <25,2,62>}
//----------------------------------------------------------------------

// BALLS ON MAIN TABLE

#declare RANDBALLROT=0
#declare RANDBALLROT=1

#include "PoolBalls.inc"

#declare RACK = union {
/* Row #1 */
object { BALL1 }
/* Row #2 */
object { BALL10 translate <1, 0, 1.732>*1.125 }
object { BALL3 translate <-1, 0, 1.732>*1.125 }
/* Row #3 */
object { BALL9 translate <2, 0, 3.464>*1.125 }
object { BALL8 translate <0, 0, 3.464>*1.125 }
object { BALL11 translate <-2, 0, 3.464>*1.125 }
/* Row #4 */
object { BALL7 translate <-3, 0, 5.196>*1.125 }
object { BALL12 translate <-1, 0, 5.196>*1.125 }
object { BALL2 translate <1, 0, 5.196>*1.125 }
object { BALL13 translate <3, 0, 5.196>*1.125 }
/* Row #5 */
object { BALL4 translate <-4.0, 0.0, 6.928>*1.125 }
object { BALL15 translate <-2.0, 0.0, 6.928>*1.125 }
object { BALL6 translate <0.0, 0.0, 6.928>*1.125 }
object { BALL14 translate <2.0, 0.0, 6.928>*1.125 }
object { BALL5 translate <4, 0, 6.928>*1.125 }
}
//#object {BALL0 translate < 0, 0, 30> }
#object {RACK rotate <0,180,0> translate < 0, 0,-30>}

//----------------------------------------------------------------------

// EXPLODING CUE BALL ON MAIN TABLE

      #declare explode_clock = ((c - .25) * 4 / 3)*2
      #declare explode_clock = 0
      #declare explode_object = object {BALL0 translate < 0, 0, 30> }
      #declare object_centre = <0, 1.125, 30>
      #declare object_size = <3, 3, 3>
      #declare object_hollow = false
      #declare particle_object = sphere {<0,0,0>, .75}
      #declare particle_res = <4, 4, 4>
      #declare particle_texture = texture {
         pigment {color White}
         finish {BALLFIN}
         normal {bumps 2 scale .1}
         }
      #declare exp_location = <0, 0, 31.125>
      #declare exp_strength = 8
      #declare exp_spin = 1
      #declare exp_seed = 87632
      #declare exp_turb = 1
      #declare exp_gravity = 9.8
      #declare scale_turb = .5
      #declare rotate_turb = 1
      #declare vel_turb = .3
      #declare dir_turb = .4
      #declare spin_turb = .3

      #declare ground_plane = true
      #declare ground_dist = 0
      #declare ground_reflection = .25
      #declare max_bounces = 3

      #include "Explode.inc"

//----------------------------------------------------------------------

// SURROUNDING ROOM
#include "ROOM.INC"

//----------------------------------------------------------------------

// OTHER STUFF
#include "SIGN-BEER.INC"
#object {BEERSIGN rotate -90*y translate <-209.75,24,96>}

//----------------------------------------------------------------------
// (c) 1998 Andrew W Cherry
// END
