
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
background { color red 0.1 green 0.3 blue 0.8 }
#declare suuauki=clock*7;
camera
{
  location  <23.0 , 5.0 ,-33>
  look_at   <0.0 , -5.0 , -4>
rotate <0,sin(clock*pi/180)*45,0>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-10, 0, -20>
}
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <50, 40, -20>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 0, 20>
}


#declare mtak=texture {pigment {Gray10} finish {phong 10}}
plane {y,-30 pigment {Green}}
union {
#difference {
cone {<0,0,0>,2,<0,-29,0>,3}
#declare kulmm=0;
#while (kulmm<360)
cone {<0,0,2>,0,<0,-29,0>,1 scale <1,1,.5> translate <0,0,-3> rotate <0,kulmm,0>}
#declare kulmm=kulmm+60;
#end
}
#declare kulmm=30;
#while (kulmm<370)
cone {<0,0,2>,0,<0,-29,0>,1 scale <1,1,.5> translate <0,0,-3> rotate <0,kulmm,0>}
#declare kulmm=kulmm+60;
#end
sphere {<0,0,0>,2 scale <1,1,1>}
scale <2.5,1,1>
texture {mtak}
}
#declare nap=-3;
#while (nap>-28)
sphere {<0,nap,nap/29-2>,.5 texture {Gold_Metal}}
#declare nap=nap-4;
#end


union{
#declare liskoiho=texture {pigment {rgb <0,.5,0>} normal {hexagon 1 scale .1} finish {phong 1 phong_size 60}}
#declare liskoiho2=texture {pigment {rgb <0,.2,0>} normal {hexagon 1 scale .1} finish {phong 1 phong_size 60}}
#declare hammas=texture {pigment {rgb <1,1,.6>} }
blob {
threshold 1.5
cylinder {<0,0,-.5>,<0,1,-.5>,1,3 texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.2,.8> translate <0,1.5,-.4> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,1.5> translate <0,1.8,-1.6> texture {hammas}}

cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,1.5> translate <0,2,-1.6> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,1.4> translate <0,2.2,-1.55> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,1.3> translate <0,2.4,-1.5> texture {liskoiho}}

sphere {<-.3,0,-2>,.3,-5 scale <1,.25,1> translate <0,3,0> texture {liskoiho}}
sphere {<.3,0,-2>,.3,-5 scale <1,.25,1> translate <0,3,0> texture {liskoiho}}
sphere {<-.3,0,-2>,.2,2 scale <1,.25,.5> translate <0,3.2,0> texture {liskoiho2}}
sphere {<.3,0,-2>,.2,2 scale <1,.25,.5> translate <0,3.2,0> texture {liskoiho2}}
sphere {<-.4,2.4,-3.2>,.3,10 texture {hammas}}
sphere {<.4,2.4,-3.2>,.3,10 texture {hammas}}
cylinder {<-.4,2.4,-3>,<-.4,2.4,-3.4>,.15,-8 texture {hammas}}
cylinder {<.4,2.4,-3>,<.4,2.4,-3.4>,.15,-8 texture {hammas}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,1.1> translate <0,2.6,-1> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,.9> translate <0,2.8,-.95> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,.87> translate <0,3,-.85> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,.82> translate <0,3.2,-.8> texture {liskoiho}}
cylinder {<0,0,0>,<0,1,0>,2,3 scale <.8,.15,.8> translate <0,3.4,-.75> texture {liskoiho}}

cylinder {<-.3,1.9,-3.5>,<-.3,1.4,-3.55>,.1,10 texture {hammas}}
cylinder {<.3,1.9,-3.5>,<.3,1.4,-3.55>,.1,10 texture {hammas}}
cylinder {<-.55,1.9,-3.3>,<-.65,1.4,-3.3>,.1,10 texture {hammas}}
cylinder {<.55,1.9,-3.3>,<.65,1.4,-3.3>,.1,10 texture {hammas}}
cylinder {<-.8,1.9,-2.75>,<-.9,1.4,-2.75>,.1,10 texture {hammas}}
cylinder {<.8,1.9,-2.75>,<.9,1.4,-2.75>,.1,10 texture {hammas}}
cylinder {<-.9,1.9,-2.25>,<-1,1.4,-2.25>,.1,10 texture {hammas}}
cylinder {<.9,1.9,-2.25>,<1,1.4,-2.25>,.1,10 texture {hammas}}
cylinder {<-.9,1.9,-1.75>,<-1,1.4,-1.75>,.1,10 texture {hammas}}
cylinder {<.9,1.9,-1.75>,<1,1.4,-1.75>,.1,10 texture {hammas}}
}
union {
blob {
threshold 1.5
cylinder {<0,0,0>,<0,1,0>,2,3 scale <1,.3,2> translate <0,.8,-1.5> texture {liskoiho}}
cylinder {<-.1,1.1,-3.5>,<-.1,1.4,-3.5>,.1,10 texture {hammas}}
cylinder {<.1,1.1,-3.5>,<.1,1.4,-3.5>,.1,10 texture {hammas}}
cylinder {<-.7,1.1,-3>,<-.8,1.4,-3>,.1,10 texture {hammas}}
cylinder {<.7,1.1,-3>,<.8,1.4,-3>,.1,10 texture {hammas}}
cylinder {<-.9,1.1,-2.5>,<-1,1.4,-2.5>,.1,10 texture {hammas}}
cylinder {<.9,1.1,-2.5>,<1,1.4,-2.5>,.1,10 texture {hammas}}
cylinder {<-.9,1.1,-2>,<-1,1.4,-2>,.1,10 texture {hammas}}
cylinder {<.9,1.1,-2>,<1,1.4,-2>,.1,10 texture {hammas}}
cylinder {<-.4,1.1,-3.4>,<-.5,1.3,-3.5>,.2,6 texture {hammas}}
cylinder {<.4,1.1,-3.4>,<.5,1.3,-3.5>,.2,6 texture {hammas}}
cylinder {<-.6,1.5,-3.6>,<-.5,1.3,-3.5>,.15,6 texture {hammas}}
cylinder {<.6,1.5,-3.6>,<.5,1.3,-3.5>,.15,6 texture {hammas}}
cylinder {<-.6,1.5,-3.6>,<-.7,1.7,-3.7>,.1,6 texture {hammas}}
cylinder {<.6,1.5,-3.6>,<.7,1.7,-3.7>,.1,6 texture {hammas}}
cylinder {<-.8,1.9,-3.8>,<-.7,1.7,-3.7>,.05,6 texture {hammas}}
cylinder {<.8,1.9,-3.8>,<.7,1.7,-3.7>,.05,6 texture {hammas}}
}
#declare kul=cos(suuauki*pi/180)*6-4;

bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 4 // # of triangles to subdivide (1-5)
  v_steps 4 // # of triangles to subdivide (1-5)
  <-1, .2, 1> <-.6, .2, 1> <.6, .2, 1> <1, .2, 1>
  <-1, .1, 1> <-.1, .4, -2> <.1, .4, -2> <1, .1, 1>
  <-.8, -.1, 1> <-.1, 0, -5> <.1, 0, -5> <.8, -.1, 1>
  <-.8, -.2, 1> <-.6, -.2, 1> <.6, -.2, 1> <.8, -.2, 1>
pigment {Red}
finish {phong 1 ambient .3}
normal {bumps 1 scale .1}
scale <.7,1,1.4>
translate <0,1.4,-1.3>
}
translate <0,-1,0>
rotate <kul,0,0>
translate <0,1.2,0>
}

#declare silm=texture {
pigment {gradient z color_map {
[0 color <1,0,0>]
[0.005 color <0,0,0>]
[0.01 color <1,1,1>]
[0.6 color <1,1,1>]
}}
finish {phong 3 phong_size 100}
}
sphere {<0,0,.3>,.3 texture {silm scale <1,.5,1> rotate <0,0,0>}  translate <-.3,3,-2>}
sphere {<0,0,.3>,.3 texture {silm scale <1,.5,1> rotate <0,0,0>}  translate <.3,3,-2>}
scale 2.5
#declare suurki=(cos(clock*pi/180*2)-1)*10;
rotate <suurki,0,0>
translate <0,1.5,1>
}




#declare vkasi=blob
{
cylinder {<0,0,0>,<0,0,1>,3,1 scale <1.7,.6,2> texture {liskoiho}}
cylinder {<0,0,0>,<0,0,1>,3,1 scale <1.7,.6,2> translate <0,-.2,0> texture {hammas}}

#local ekke=(sin((clock+120)*pi/180*4)+1)*45*pi/180;
#local ekke2=(sin(clock*pi/180*4)+1)*45*pi/180;
#local ekke3=(sin(clock*pi/180*4)+1)*45*pi/180;
cylinder {<0,0,5>,<0,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<0,sin(ekke)*2,cos(ekke)*2+5>,<0,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<0,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<0,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=(sin((clock+120)*pi/180*4)+1)*45*pi/180;
#local ekke2=(sin((clock)*pi/180*4)+1)*45*pi/180;
#local ekke3=(sin((clock)*pi/180*4)+1)*45*pi/180;
cylinder {<-2,0,5>,<-2,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<-2,sin(ekke)*2,cos(ekke)*2+5>,<-2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<-2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<-2,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=(sin((clock+240)*pi/180*4)+1)*45*pi/180;
#local ekke2=(sin((clock+240)*pi/180*4)+1)*45*pi/180;
#local ekke3=(sin((clock+240)*pi/180*4)+1)*45*pi/180;
cylinder {<2,0,5>,<2,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<2,sin(ekke)*2,cos(ekke)*2+5>,<2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<2,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=-50+cos(clock*pi/180)*20;
cylinder {<-2,0,0>,<-3-cos(ekke)*3,0,2+sin(ekke)*3>,1,2 texture {liskoiho translate <0,0,-1>}}

}


#declare okasi=blob
{
cylinder {<0,0,0>,<0,0,1>,3,1 scale <1.7,.6,2> texture {liskoiho}}
cylinder {<0,0,0>,<0,0,1>,3,1 scale <1.7,.6,2> translate <0,-.2,0> texture {hammas}}

#local ekke=(sin(clock*pi/180*4)+1)*45*pi/180;
#local ekke2=(sin(clock*pi/180*4)+1)*45*pi/180;
#local ekke3=(sin(clock*pi/180*4)+1)*45*pi/180;
cylinder {<0,0,5>,<0,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<0,sin(ekke)*2,cos(ekke)*2+5>,<0,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<0,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<0,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=0;
#local ekke2=0;
#local ekke3=0;
cylinder {<-2,0,5>,<-2,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<-2,sin(ekke)*2,cos(ekke)*2+5>,<-2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<-2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<-2,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=(sin(clock*pi/180*4)+1)*45*pi/180;
#local ekke2=(sin(clock*pi/180*4)+1)*45*pi/180;
#local ekke3=(sin(clock*pi/180*4)+1)*45*pi/180;
cylinder {<2,0,5>,<2,sin(ekke)*2,cos(ekke)*2+5>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<2,sin(ekke)*2,cos(ekke)*2+5>,<2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,1,2 texture {liskoiho translate <0,0,-1>}}
cylinder {<2,sin(ekke)*2+sin(ekke2+ekke)*2,cos(ekke)*2+5+cos(ekke2+ekke)>,<2,sin(ekke)*2+sin(ekke2+ekke)*2+sin(ekke2+ekke+ekke3)*1,cos(ekke)*2+5+cos(ekke2+ekke)+cos(ekke2+ekke+ekke3)*1>,.7,2 texture {liskoiho translate <0,0,-1>}}

#local ekke=-50;
cylinder {<2,0,0>,<3+cos(ekke)*3,0,2+sin(ekke)*3>,1,2 texture {liskoiho translate <0,0,-1>}}
}



#declare vkas=array [3]
#declare vkas[1]=sin((clock*pi/180))*90*pi/180;
#declare vkas[2]=-sin((clock*pi/180))*90*pi/180;
sphere {<1.7,0,0>,2 scale <2,.8,.8> texture {mtak}}
sphere {<-1.7,0,0>,2 scale <2,.8,.8> texture {mtak}}
union {
cylinder {<0,0,0>,<0,sin(vkas[1])*-9,cos(vkas[1])*-9>,1.2 texture {mtak}}
sphere {<0,sin(vkas[1])*-9,cos(vkas[1])*-9>,1.2 texture {mtak}}
cylinder {<0,sin(vkas[1])*-9,cos(vkas[1])*-9>,<0,sin(vkas[1])*-9+sin(vkas[2]+vkas[1])*-6,cos(vkas[1])*-9+cos(vkas[2]+vkas[1])*-6>,1.2 texture {mtak}}
object {vkasi scale <1,1.4,1> rotate <90,-90,5> rotate <-(vkas[1]+vkas[2])*180/pi+90,0,0> scale .5 translate <0,sin(vkas[1])*-9+sin(vkas[2]+vkas[1])*-6.5,cos(vkas[1])*-9+cos(vkas[2]+vkas[1])*-6.5>}
rotate <0,0,(sin((clock+150)*pi/180)+1)*50+10>
translate <6,0,0>
}
#declare okas=array [3]
#declare okas[1]=sin((clock*pi/180*2))*90*pi/180;
#declare okas[2]=-sin((clock*pi/180*3))*90*pi/180;
union {
cylinder {<0,0,0>,<0,sin(okas[1])*-9,cos(okas[1])*-9>,1.2 texture {mtak}}
sphere {<0,sin(okas[1])*-9,cos(okas[1])*-9>,1.2 texture {mtak}}
cylinder {<0,sin(okas[1])*-9,cos(okas[1])*-9>,<0,sin(okas[1])*-9+sin(okas[2]+okas[1])*-6,cos(okas[1])*-9+cos(okas[2]+okas[1])*-6>,1.2 texture {mtak}}
object {okasi scale <1,1.4,1> rotate <90,90,-5> rotate <-(okas[1]+okas[2])*180/pi+90,0,0> scale .5 translate <0,sin(okas[1])*-9+sin(okas[2]+okas[1])*-6.5,cos(okas[1])*-9+cos(okas[2]+okas[1])*-6.5>}
rotate <0,0,(sin((clock+250)*pi/180)-1)*30-10>
translate <-6,0,0>
}
