
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shaknap.inc"
#include "stones.inc"
#include "aukuk.inc"
#include "skies.inc"

#declare clocka=clock;
#switch (clocka)
#range (-180,-75)
#declare kirk=(clocka+90)/15;
#break
#range (-75,75)
#declare kirk=1;
#break
#range (75,180)
#declare kirk=-(clocka-90)/15;
#break
#end
global_settings {ambient_light kirk}
#declare aur=clocka;

#declare taiv=pigment {gradient y color_map {[0.0 rgb <0,0,.7>*kirk] [0.7 rgb <0,0,.3>*kirk]} scale 10}
sky_sphere {pigment {bozo pigment_map {
[0.2 taiv]
[0.7 taiv]
[.8 rgb <.9,.9,1>*kirk]
[1 White*kirk]
}}
scale .1
rotate <0,clocka*4,0>
}

camera
{
  location  <-13.0 , 4.0 ,2.0>
  look_at   <0.0 , 2.1 , 0.0>
}


light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>*kirk
  translate <-10, 10, -10>
}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,1>*kirk
looks_like {sphere {<0,0,0>,5 pigment {Yellow} finish {ambient 1}}}
translate <300, 0, 0>
rotate <0,aur,0>
rotate <0,0,30>
}


box {<-4,0,-4>,<4,-1,4> texture {ruutu}}
difference {
union {
cylinder {<-4,-1,-4>,<4,-1,-4>,1}
cylinder {<-4,-1,4>,<4,-1,4>,1}
cylinder {<-4,-1,4>,<-4,-1,-4>,1}
cylinder {<4,-1,4>,<4,-1,-4>,1}
sphere {<-4,-1,-4>,1}
sphere {<4,-1,-4>,1}
sphere {<-4,-1,4>,1}
sphere {<4,-1,4>,1}
}
plane {y,-1}
texture {T_Stone23}
}

#switch (clocka)
#range (-180,-40)
#declare esp=0;
#break
#range (-40,-20)
#declare esp=(clocka+40)/20;
#break
#range (-30,180)
#declare esp=1;
#break
#end
object {vsotilas translate <3.5,0,1.5>}
object {vsotilas translate <2.5,0,2.5>}
object {vsotilas translate <1.5,0,0.5>}
object {vsotilas translate <0.5,0,1.5>}
object {vsotilas translate <-0.5,0,2.5>}
object {vsotilas translate <-1.5,0,2.5>}
object {vsotilas translate <-2.5,0,1.5>}
object {vsotilas translate <-3.5,0,2.5>}

object {msotilas translate <3.5,0,-.5>}
object {msotilas translate <2.5,0,-1.5>}
object {msotilas translate <1.5,0,-2.5>}
object {msotilas translate <0.5,0,-2.5>}
object {msotilas translate <-2.5,0,-2.5>}
object {msotilas translate <-3.5,0,-2.5>}


object {msotilas translate <-4,-.5,6>}
object {msotilas translate <-5,-.5,6.3>}
object {vhevonen translate <-3,-.5,-6.2>}

object {vtorni translate <-3.5,0,3.5>}
object {vtorni translate <3.5,0,3.5>}
object {vhevonen translate <1.5,0,1.5>}
object {vlahetti translate <-1.5+esp,0,-.5+esp>}
object {vlahetti translate <1.5,0,3.5>}
object {vkuningatar translate <.5,0,3.5>}
object {vkuningas translate <-.5,0,3.5>}
object {mtorni translate <-.5,0,-.5>}
object {mtorni translate <-3.5,0,-3.5>}
object {mhevonen translate <-2.5,0,-3.5>}
object {mhevonen translate <2.5,0,-3.5>}
object {mlahetti translate <-1.5,0,-3.5>}
object {mlahetti translate <1.5,0,-3.5>}
object {mkuningatar translate <.5,0,-3.5>}
object {mkuningas translate <-.5,0,-3.5>}


difference {
union {
box {<8,-10,-50>,<8.1,100,50> texture {lautapuu}}
box {<7.85,-10,-50>,<8.2,100,50> texture {lautapuu2}}
}
box {<7,2,-10>,<9,16,10> texture {lautapuu2}}
}
box {<8,1.9,-10.5>,<7.7,2.3,10.5> pigment {White}}
box {<8,15.9,-10.5>,<7.7,16.3,10.5> pigment {White}}
box {<8,16.3,-10.5>,<7.7,1.9,-10> pigment {White}}
box {<8,16.3,10.5>,<7.7,1.9,10> pigment {White}}
box {<7.9,2,-10>,<8,16,10> texture {
    pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
normal {bozo .25 scale 1.2}
    finish  {
        ambient 0.1
        diffuse 0.1
        reflection 0
        refraction 0.9
        ior 1.45
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400
     }
}}


box {<-800,-10,-50>,<8.1,100,-50> texture {lautapuu}}
box {<-800,-10,50>,<8.1,100,50> texture {lautapuu}}
box {<-7,-.5,-7>,<7,-2,7> texture {poyt}}
box {<8,-10,-500>,<-10,-11,500> texture {vpuu scale 2}}
plane {y,-11 pigment {rgb <0,.5,0>} normal {granite 1}}
box {<8,7,-12>,<7.8,6,-16> pigment {Gray40}}
box {<8,6,-12>,<7.8,3,-16> pigment {White} normal {waves 1}}

text
{
  ttf             // font type (only TrueType format for now)
  "c:\windows\fonts\ariblk.ttf",  // Microsoft Windows-format TrueType font file name
  "7.10",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
scale 1.6
rotate <0,90,0>
translate <7.78,4,-12.3>
pigment {Black}
}
/*
#declare ekkl=seed(320);
#declare xx=10;
#while (xx<22)
#declare yy=-15;
#while (yy<15)
object {kukka rotate <0,270,0> rotate <0,aur,0> scale .3 translate <xx+rand(ekkl)*3,6,yy+rand(ekkl)*3>}
#declare yy=yy+7;
#end
#declare xx=xx+5;
#end
*/
#declare ekkl=seed(100);
#declare xx=0;
#while (xx<200)
mesh {
triangle {<0,0,0>,<0,0,3>,<-1,.2,1.5>}
triangle {<0,0,0>,<0,0,3>,<1,.2,1.5>}
triangle {<0.1,0,4>,<0,0,3>,<-.1,.2,4>}
pigment {rgb <rand(ekkl),rand(ekkl),0>}
finish {ambient .5}
scale .4
rotate <rand(ekkl)*360+clocka,rand(ekkl)*360+clocka,rand(ekkl)*360+clocka>
#declare ccs=(rand(ekkl)-.5)*25+clocka+90;
#while (ccs>13)
#declare ccs=ccs-25;
#end
translate <10+rand(ekkl)*5,rand(ekkl)*20,ccs>
}
#declare xx=xx+1;
#end



union {

cylinder {<0,-10,0>,<0,5,0>,2 pigment {Brown}}

sphere {<0,7.5,0>,9 pigment {agate pigment_map {
[0.0 rgbf <1,1,1,1>]
[0.8 rgbf <1,1,1,1>]
[0.9 rgbf <1,1,0,0>]
[1.0 rgbf <1,0,0,0>]
}}}

sphere {<0,7.5,0>,7 pigment {agate pigment_map {
[0.0 rgbf <1,1,1,1>]
[0.7 rgbf <1,1,1,1>]
[0.8 rgbf <1,.6,0,0>]
[1.0 rgbf <1,.6,0,0>]
}
scale 2
}}

translate <45,0,4>
}
